// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated code. DO NOT EDIT!

namespace Google.Apis.MyBusiness.v4
{
    /// <summary>The MyBusiness Service.</summary>
    public class MyBusinessService : Google.Apis.Services.BaseClientService
    {
        /// <summary>The API version.</summary>
        public const string Version = "v4";

        /// <summary>The discovery version used to generate this service.</summary>
        public static Google.Apis.Discovery.DiscoveryVersion DiscoveryVersionUsed = Google.Apis.Discovery.DiscoveryVersion.Version_1_0;

        /// <summary>Constructs a new service.</summary>
        public MyBusinessService() : this(new Google.Apis.Services.BaseClientService.Initializer())
        {
        }

        /// <summary>Constructs a new service.</summary>
        /// <param name="initializer">The service initializer.</param>
        public MyBusinessService(Google.Apis.Services.BaseClientService.Initializer initializer) : base(initializer)
        {
            Accounts = new AccountsResource(this);
            Categories = new CategoriesResource(this);
            GoogleLocations = new GoogleLocationsResource(this);
            Chains = new ChainsResource(this);
            Attributes = new AttributesResource(this);
        }

        /// <summary>Gets the service supported features.</summary>
        public override System.Collections.Generic.IList<string> Features => new string[0];

        /// <summary>Gets the service name.</summary>
        public override string Name => "mybusiness";

        /// <summary>Gets the service base URI.</summary>
        public override string BaseUri =>
        #if NETSTANDARD1_3 || NETSTANDARD2_0 || NET45
            BaseUriOverride ?? "https://mybusiness.googleapis.com/";
        #else
            "https://mybusiness.googleapis.com/";
        #endif

        /// <summary>Gets the service base path.</summary>
        public override string BasePath => "";

        #if !NET40
        /// <summary>Gets the batch base URI; <c>null</c> if unspecified.</summary>
        public override string BatchUri => "https://mybusiness.googleapis.com/batch";

        /// <summary>Gets the batch base path; <c>null</c> if unspecified.</summary>
        public override string BatchPath => "batch";
        #endif

        /// <summary>Gets the Accounts resource.</summary>
        public virtual AccountsResource Accounts { get; }

        /// <summary>Gets the Categories resource.</summary>
        public virtual CategoriesResource Categories { get; }

        /// <summary>Gets the GoogleLocations resource.</summary>
        public virtual GoogleLocationsResource GoogleLocations { get; }

        /// <summary>Gets the Chains resource.</summary>
        public virtual ChainsResource Chains { get; }

        /// <summary>Gets the Attributes resource.</summary>
        public virtual AttributesResource Attributes { get; }
    }

    /// <summary>A base abstract class for MyBusiness requests.</summary>
    public abstract class MyBusinessBaseServiceRequest<TResponse> : Google.Apis.Requests.ClientServiceRequest<TResponse>
    {
        /// <summary>Constructs a new MyBusinessBaseServiceRequest instance.</summary>
        protected MyBusinessBaseServiceRequest(Google.Apis.Services.IClientService service) : base(service)
        {
        }

        /// <summary>V1 error format.</summary>
        [Google.Apis.Util.RequestParameterAttribute("$.xgafv", Google.Apis.Util.RequestParameterType.Query)]
        public virtual System.Nullable<XgafvEnum> Xgafv { get; set; }

        /// <summary>V1 error format.</summary>
        public enum XgafvEnum
        {
            /// <summary>v1 error format</summary>
            [Google.Apis.Util.StringValueAttribute("1")]
            Value1 = 0,

            /// <summary>v2 error format</summary>
            [Google.Apis.Util.StringValueAttribute("2")]
            Value2 = 1,
        }

        /// <summary>OAuth access token.</summary>
        [Google.Apis.Util.RequestParameterAttribute("access_token", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string AccessToken { get; set; }

        /// <summary>Data format for response.</summary>
        [Google.Apis.Util.RequestParameterAttribute("alt", Google.Apis.Util.RequestParameterType.Query)]
        public virtual System.Nullable<AltEnum> Alt { get; set; }

        /// <summary>Data format for response.</summary>
        public enum AltEnum
        {
            /// <summary>Responses with Content-Type of application/json</summary>
            [Google.Apis.Util.StringValueAttribute("json")]
            Json = 0,

            /// <summary>Media download with context-dependent Content-Type</summary>
            [Google.Apis.Util.StringValueAttribute("media")]
            Media = 1,

            /// <summary>Responses with Content-Type of application/x-protobuf</summary>
            [Google.Apis.Util.StringValueAttribute("proto")]
            Proto = 2,
        }

        /// <summary>JSONP</summary>
        [Google.Apis.Util.RequestParameterAttribute("callback", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string Callback { get; set; }

        /// <summary>Selector specifying which fields to include in a partial response.</summary>
        [Google.Apis.Util.RequestParameterAttribute("fields", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string Fields { get; set; }

        /// <summary>
        /// API key. Your API key identifies your project and provides you with API access, quota, and reports. Required
        /// unless you provide an OAuth 2.0 token.
        /// </summary>
        [Google.Apis.Util.RequestParameterAttribute("key", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string Key { get; set; }

        /// <summary>OAuth 2.0 token for the current user.</summary>
        [Google.Apis.Util.RequestParameterAttribute("oauth_token", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string OauthToken { get; set; }

        /// <summary>Returns response with indentations and line breaks.</summary>
        [Google.Apis.Util.RequestParameterAttribute("prettyPrint", Google.Apis.Util.RequestParameterType.Query)]
        public virtual System.Nullable<bool> PrettyPrint { get; set; }

        /// <summary>
        /// Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a
        /// user, but should not exceed 40 characters.
        /// </summary>
        [Google.Apis.Util.RequestParameterAttribute("quotaUser", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string QuotaUser { get; set; }

        /// <summary>Legacy upload protocol for media (e.g. "media", "multipart").</summary>
        [Google.Apis.Util.RequestParameterAttribute("uploadType", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string UploadType { get; set; }

        /// <summary>Upload protocol for media (e.g. "raw", "multipart").</summary>
        [Google.Apis.Util.RequestParameterAttribute("upload_protocol", Google.Apis.Util.RequestParameterType.Query)]
        public virtual string UploadProtocol { get; set; }

        /// <summary>Initializes MyBusiness parameter list.</summary>
        protected override void InitParameters()
        {
            base.InitParameters();
            RequestParameters.Add("$.xgafv", new Google.Apis.Discovery.Parameter
            {
                Name = "$.xgafv",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("access_token", new Google.Apis.Discovery.Parameter
            {
                Name = "access_token",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("alt", new Google.Apis.Discovery.Parameter
            {
                Name = "alt",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = "json",
                Pattern = null,
            });
            RequestParameters.Add("callback", new Google.Apis.Discovery.Parameter
            {
                Name = "callback",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("fields", new Google.Apis.Discovery.Parameter
            {
                Name = "fields",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("key", new Google.Apis.Discovery.Parameter
            {
                Name = "key",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("oauth_token", new Google.Apis.Discovery.Parameter
            {
                Name = "oauth_token",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("prettyPrint", new Google.Apis.Discovery.Parameter
            {
                Name = "prettyPrint",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = "true",
                Pattern = null,
            });
            RequestParameters.Add("quotaUser", new Google.Apis.Discovery.Parameter
            {
                Name = "quotaUser",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("uploadType", new Google.Apis.Discovery.Parameter
            {
                Name = "uploadType",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
            RequestParameters.Add("upload_protocol", new Google.Apis.Discovery.Parameter
            {
                Name = "upload_protocol",
                IsRequired = false,
                ParameterType = "query",
                DefaultValue = null,
                Pattern = null,
            });
        }
    }

    /// <summary>The "accounts" collection of methods.</summary>
    public class AccountsResource
    {
        private const string Resource = "accounts";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public AccountsResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;
            Invitations = new InvitationsResource(service);
            Admins = new AdminsResource(service);
            Locations = new LocationsResource(service);
        }

        /// <summary>Gets the Invitations resource.</summary>
        public virtual InvitationsResource Invitations { get; }

        /// <summary>The "invitations" collection of methods.</summary>
        public class InvitationsResource
        {
            private const string Resource = "invitations";

            /// <summary>The service which this resource belongs to.</summary>
            private readonly Google.Apis.Services.IClientService service;

            /// <summary>Constructs a new resource.</summary>
            public InvitationsResource(Google.Apis.Services.IClientService service)
            {
                this.service = service;
            }

            /// <summary>Accepts the specified invitation.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The name of the invitation that is being accepted.</param>
            public virtual AcceptRequest Accept(Google.Apis.MyBusiness.v4.Data.AcceptInvitationRequest body, string name)
            {
                return new AcceptRequest(service, body, name);
            }

            /// <summary>Accepts the specified invitation.</summary>
            public class AcceptRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
            {
                /// <summary>Constructs a new Accept request.</summary>
                public AcceptRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.AcceptInvitationRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The name of the invitation that is being accepted.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.AcceptInvitationRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "accept";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:accept";

                /// <summary>Initializes Accept parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/invitations/[^/]+$",
                    });
                }
            }

            /// <summary>Declines the specified invitation.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The name of the account invitation that is being declined.</param>
            public virtual DeclineRequest Decline(Google.Apis.MyBusiness.v4.Data.DeclineInvitationRequest body, string name)
            {
                return new DeclineRequest(service, body, name);
            }

            /// <summary>Declines the specified invitation.</summary>
            public class DeclineRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
            {
                /// <summary>Constructs a new Decline request.</summary>
                public DeclineRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.DeclineInvitationRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The name of the account invitation that is being declined.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.DeclineInvitationRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "decline";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:decline";

                /// <summary>Initializes Decline parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/invitations/[^/]+$",
                    });
                }
            }

            /// <summary>Lists pending invitations for the specified account.</summary>
            /// <param name="parent">
            /// The name of the account from which the list of invitations is being retrieved.
            /// </param>
            public virtual ListRequest List(string parent)
            {
                return new ListRequest(service, parent);
            }

            /// <summary>Lists pending invitations for the specified account.</summary>
            public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListInvitationsResponse>
            {
                /// <summary>Constructs a new List request.</summary>
                public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                {
                    Parent = parent;
                    InitParameters();
                }

                /// <summary>The name of the account from which the list of invitations is being retrieved.</summary>
                [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Parent { get; private set; }

                /// <summary>Specifies which target types should appear in the response.</summary>
                [Google.Apis.Util.RequestParameterAttribute("targetType", Google.Apis.Util.RequestParameterType.Query)]
                public virtual System.Nullable<TargetTypeEnum> TargetType { get; set; }

                /// <summary>Specifies which target types should appear in the response.</summary>
                public enum TargetTypeEnum
                {
                    /// <summary>List invitations for all target types. This is the default.</summary>
                    [Google.Apis.Util.StringValueAttribute("ALL")]
                    ALL = 0,

                    /// <summary>List invitations only for targets of type Account.</summary>
                    [Google.Apis.Util.StringValueAttribute("ACCOUNTS_ONLY")]
                    ACCOUNTSONLY = 1,

                    /// <summary>List invitations only for targets of type Location.</summary>
                    [Google.Apis.Util.StringValueAttribute("LOCATIONS_ONLY")]
                    LOCATIONSONLY = 2,
                }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "list";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+parent}/invitations";

                /// <summary>Initializes List parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                    {
                        Name = "parent",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                    RequestParameters.Add("targetType", new Google.Apis.Discovery.Parameter
                    {
                        Name = "targetType",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }
        }

        /// <summary>Gets the Admins resource.</summary>
        public virtual AdminsResource Admins { get; }

        /// <summary>The "admins" collection of methods.</summary>
        public class AdminsResource
        {
            private const string Resource = "admins";

            /// <summary>The service which this resource belongs to.</summary>
            private readonly Google.Apis.Services.IClientService service;

            /// <summary>Constructs a new resource.</summary>
            public AdminsResource(Google.Apis.Services.IClientService service)
            {
                this.service = service;
            }

            /// <summary>Lists the admins for the specified account.</summary>
            /// <param name="parent">The name of the account from which to retrieve a list of admins.</param>
            public virtual ListRequest List(string parent)
            {
                return new ListRequest(service, parent);
            }

            /// <summary>Lists the admins for the specified account.</summary>
            public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListAccountAdminsResponse>
            {
                /// <summary>Constructs a new List request.</summary>
                public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                {
                    Parent = parent;
                    InitParameters();
                }

                /// <summary>The name of the account from which to retrieve a list of admins.</summary>
                [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Parent { get; private set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "list";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+parent}/admins";

                /// <summary>Initializes List parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                    {
                        Name = "parent",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Invites the specified user to become an administrator for the specified account. The invitee must accept
            /// the invitation in order to be granted access to the account. See AcceptInvitation to programmatically
            /// accept an invitation.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="parent">The resource name of the account this admin is created for.</param>
            public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.Admin body, string parent)
            {
                return new CreateRequest(service, body, parent);
            }

            /// <summary>
            /// Invites the specified user to become an administrator for the specified account. The invitee must accept
            /// the invitation in order to be granted access to the account. See AcceptInvitation to programmatically
            /// accept an invitation.
            /// </summary>
            public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Admin>
            {
                /// <summary>Constructs a new Create request.</summary>
                public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Admin body, string parent) : base(service)
                {
                    Parent = parent;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The resource name of the account this admin is created for.</summary>
                [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Parent { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.Admin Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "create";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+parent}/admins";

                /// <summary>Initializes Create parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                    {
                        Name = "parent",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                }
            }

            /// <summary>Removes the specified admin from the specified account.</summary>
            /// <param name="name">The resource name of the admin to remove from the account.</param>
            public virtual DeleteRequest Delete(string name)
            {
                return new DeleteRequest(service, name);
            }

            /// <summary>Removes the specified admin from the specified account.</summary>
            public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
            {
                /// <summary>Constructs a new Delete request.</summary>
                public DeleteRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>The resource name of the admin to remove from the account.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "delete";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "DELETE";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes Delete parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/admins/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Updates the Admin for the specified Account Admin. Only the AdminRole of the Admin can be updated.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The resource name of the admin to update.</param>
            public virtual PatchRequest Patch(Google.Apis.MyBusiness.v4.Data.Admin body, string name)
            {
                return new PatchRequest(service, body, name);
            }

            /// <summary>
            /// Updates the Admin for the specified Account Admin. Only the AdminRole of the Admin can be updated.
            /// </summary>
            public class PatchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Admin>
            {
                /// <summary>Constructs a new Patch request.</summary>
                public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Admin body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The resource name of the admin to update.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.Admin Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "patch";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "PATCH";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes Patch parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/admins/[^/]+$",
                    });
                }
            }
        }

        /// <summary>Gets the Locations resource.</summary>
        public virtual LocationsResource Locations { get; }

        /// <summary>The "locations" collection of methods.</summary>
        public class LocationsResource
        {
            private const string Resource = "locations";

            /// <summary>The service which this resource belongs to.</summary>
            private readonly Google.Apis.Services.IClientService service;

            /// <summary>Constructs a new resource.</summary>
            public LocationsResource(Google.Apis.Services.IClientService service)
            {
                this.service = service;
                Admins = new AdminsResource(service);
                Followers = new FollowersResource(service);
                LocalPosts = new LocalPostsResource(service);
                InsuranceNetworks = new InsuranceNetworksResource(service);
                Lodging = new LodgingResource(service);
                Media = new MediaResource(service);
                Questions = new QuestionsResource(service);
                Reviews = new ReviewsResource(service);
                Verifications = new VerificationsResource(service);
            }

            /// <summary>Gets the Admins resource.</summary>
            public virtual AdminsResource Admins { get; }

            /// <summary>The "admins" collection of methods.</summary>
            public class AdminsResource
            {
                private const string Resource = "admins";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public AdminsResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>Lists all of the admins for the specified location.</summary>
                /// <param name="parent">The name of the location to list admins of.</param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>Lists all of the admins for the specified location.</summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListLocationAdminsResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>The name of the location to list admins of.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/admins";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>
                /// Invites the specified user to become an administrator for the specified location. The invitee must
                /// accept the invitation in order to be granted access to the location. See AcceptInvitation to
                /// programmatically accept an invitation.
                /// </summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="parent">The resource name of the location this admin is created for.</param>
                public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.Admin body, string parent)
                {
                    return new CreateRequest(service, body, parent);
                }

                /// <summary>
                /// Invites the specified user to become an administrator for the specified location. The invitee must
                /// accept the invitation in order to be granted access to the location. See AcceptInvitation to
                /// programmatically accept an invitation.
                /// </summary>
                public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Admin>
                {
                    /// <summary>Constructs a new Create request.</summary>
                    public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Admin body, string parent) : base(service)
                    {
                        Parent = parent;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The resource name of the location this admin is created for.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.Admin Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "create";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/admins";

                    /// <summary>Initializes Create parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>Removes the specified admin as a manager of the specified location.</summary>
                /// <param name="name">The resource name of the admin to remove from the location.</param>
                public virtual DeleteRequest Delete(string name)
                {
                    return new DeleteRequest(service, name);
                }

                /// <summary>Removes the specified admin as a manager of the specified location.</summary>
                public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
                {
                    /// <summary>Constructs a new Delete request.</summary>
                    public DeleteRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The resource name of the admin to remove from the location.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "delete";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "DELETE";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Delete parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/admins/[^/]+$",
                        });
                    }
                }

                /// <summary>
                /// Updates the Admin for the specified Location Admin. Only the AdminRole of the Admin can be updated.
                /// </summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">The resource name of the admin to update.</param>
                public virtual PatchRequest Patch(Google.Apis.MyBusiness.v4.Data.Admin body, string name)
                {
                    return new PatchRequest(service, body, name);
                }

                /// <summary>
                /// Updates the Admin for the specified Location Admin. Only the AdminRole of the Admin can be updated.
                /// </summary>
                public class PatchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Admin>
                {
                    /// <summary>Constructs a new Patch request.</summary>
                    public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Admin body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The resource name of the admin to update.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.Admin Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "patch";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "PATCH";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Patch parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/admins/[^/]+$",
                        });
                    }
                }
            }

            /// <summary>Gets the Followers resource.</summary>
            public virtual FollowersResource Followers { get; }

            /// <summary>The "followers" collection of methods.</summary>
            public class FollowersResource
            {
                private const string Resource = "followers";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public FollowersResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>
                /// Get the followers settings for a location. NOT_FOUND is returned if either the account or the
                /// location doesn't exist. PRECONDITION_FAILED is returned if the location is not verified nor
                /// connected to Maps.
                /// </summary>
                /// <param name="name">
                /// The resource name of the location's followers metadata.
                /// accounts/{account_id}/locations/{location_id}/followers/metadata
                /// </param>
                public virtual GetMetadataRequest GetMetadata(string name)
                {
                    return new GetMetadataRequest(service, name);
                }

                /// <summary>
                /// Get the followers settings for a location. NOT_FOUND is returned if either the account or the
                /// location doesn't exist. PRECONDITION_FAILED is returned if the location is not verified nor
                /// connected to Maps.
                /// </summary>
                public class GetMetadataRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.FollowersMetadata>
                {
                    /// <summary>Constructs a new GetMetadata request.</summary>
                    public GetMetadataRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>
                    /// The resource name of the location's followers metadata.
                    /// accounts/{account_id}/locations/{location_id}/followers/metadata
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "getMetadata";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes GetMetadata parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/followers/metadata$",
                        });
                    }
                }
            }

            /// <summary>Gets the LocalPosts resource.</summary>
            public virtual LocalPostsResource LocalPosts { get; }

            /// <summary>The "localPosts" collection of methods.</summary>
            public class LocalPostsResource
            {
                private const string Resource = "localPosts";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public LocalPostsResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>
                /// Returns insights for a set of local posts associated with a single listing. Which metrics and how
                /// they are reported are options specified in the request proto. *Note:* Insight reports are limited to
                /// 100 `local_post_names` per call.
                /// </summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">Required. The name of the location for which to fetch insights.</param>
                public virtual ReportInsightsRequest ReportInsights(Google.Apis.MyBusiness.v4.Data.ReportLocalPostInsightsRequest body, string name)
                {
                    return new ReportInsightsRequest(service, body, name);
                }

                /// <summary>
                /// Returns insights for a set of local posts associated with a single listing. Which metrics and how
                /// they are reported are options specified in the request proto. *Note:* Insight reports are limited to
                /// 100 `local_post_names` per call.
                /// </summary>
                public class ReportInsightsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ReportLocalPostInsightsResponse>
                {
                    /// <summary>Constructs a new ReportInsights request.</summary>
                    public ReportInsightsRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.ReportLocalPostInsightsRequest body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>Required. The name of the location for which to fetch insights.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.ReportLocalPostInsightsRequest Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "reportInsights";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}/localPosts:reportInsights";

                    /// <summary>Initializes ReportInsights parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>Creates a new local post associated with the specified location, and returns it.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="parent">The name of the location in which to create this local post.</param>
                public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.LocalPost body, string parent)
                {
                    return new CreateRequest(service, body, parent);
                }

                /// <summary>Creates a new local post associated with the specified location, and returns it.</summary>
                public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.LocalPost>
                {
                    /// <summary>Constructs a new Create request.</summary>
                    public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.LocalPost body, string parent) : base(service)
                    {
                        Parent = parent;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The name of the location in which to create this local post.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.LocalPost Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "create";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/localPosts";

                    /// <summary>Initializes Create parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>Deletes a local post. Returns `NOT_FOUND` if the local post does not exist.</summary>
                /// <param name="name">The name of the local post to delete.</param>
                public virtual DeleteRequest Delete(string name)
                {
                    return new DeleteRequest(service, name);
                }

                /// <summary>Deletes a local post. Returns `NOT_FOUND` if the local post does not exist.</summary>
                public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
                {
                    /// <summary>Constructs a new Delete request.</summary>
                    public DeleteRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the local post to delete.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "delete";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "DELETE";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Delete parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$",
                        });
                    }
                }

                /// <summary>
                /// Gets the specified local post. Returns `NOT_FOUND` if the local post does not exist.
                /// </summary>
                /// <param name="name">The name of the local post to fetch.</param>
                public virtual GetRequest Get(string name)
                {
                    return new GetRequest(service, name);
                }

                /// <summary>
                /// Gets the specified local post. Returns `NOT_FOUND` if the local post does not exist.
                /// </summary>
                public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.LocalPost>
                {
                    /// <summary>Constructs a new Get request.</summary>
                    public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the local post to fetch.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "get";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Get parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$",
                        });
                    }
                }

                /// <summary>Returns a list of local posts associated with a location.</summary>
                /// <param name="parent">The name of the location whose local posts will be listed.</param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>Returns a list of local posts associated with a location.</summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListLocalPostsResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>The name of the location whose local posts will be listed.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>
                    /// How many local posts to return per page. Default of 20. The minimum is 1, and maximum page size
                    /// is 100.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> PageSize { get; set; }

                    /// <summary>If specified, returns the next page of local posts.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string PageToken { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/localPosts";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                        RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageSize",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageToken",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }

                /// <summary>Updates the specified local post and returns the updated local post.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">The name of the local post to update.</param>
                public virtual PatchRequest Patch(Google.Apis.MyBusiness.v4.Data.LocalPost body, string name)
                {
                    return new PatchRequest(service, body, name);
                }

                /// <summary>Updates the specified local post and returns the updated local post.</summary>
                public class PatchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.LocalPost>
                {
                    /// <summary>Constructs a new Patch request.</summary>
                    public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.LocalPost body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The name of the local post to update.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>
                    /// The specific fields to update. You must specify each field that is being updated in the mask.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual object UpdateMask { get; set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.LocalPost Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "patch";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "PATCH";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Patch parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$",
                        });
                        RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                        {
                            Name = "updateMask",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }
            }

            /// <summary>Gets the InsuranceNetworks resource.</summary>
            public virtual InsuranceNetworksResource InsuranceNetworks { get; }

            /// <summary>The "insuranceNetworks" collection of methods.</summary>
            public class InsuranceNetworksResource
            {
                private const string Resource = "insuranceNetworks";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public InsuranceNetworksResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>Returns a list of all insurance networks supported by Google.</summary>
                /// <param name="parent">
                /// Required. The name of the location whose insurance networks will be listed. The name is in the form:
                /// accounts/{account_id}/locations/{location_id}
                /// </param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>Returns a list of all insurance networks supported by Google.</summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListInsuranceNetworksResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>
                    /// Required. The name of the location whose insurance networks will be listed. The name is in the
                    /// form: accounts/{account_id}/locations/{location_id}
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>
                    /// Optional. The BCP 47 code for the language. If a language code is not provided, it defaults to
                    /// English. Right now only 'en' is supported.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("languageCode", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string LanguageCode { get; set; }

                    /// <summary>
                    /// How many insurance networks to return per page. The default value is 5000. Maximum page size is
                    /// 10000.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> PageSize { get; set; }

                    /// <summary>If specified, returns the next page of insurance networks.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string PageToken { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/insuranceNetworks";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                        RequestParameters.Add("languageCode", new Google.Apis.Discovery.Parameter
                        {
                            Name = "languageCode",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageSize",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageToken",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }
            }

            /// <summary>Gets the Lodging resource.</summary>
            public virtual LodgingResource Lodging { get; }

            /// <summary>The "lodging" collection of methods.</summary>
            public class LodgingResource
            {
                private const string Resource = "lodging";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public LodgingResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>Returns the Google updated Lodging of a specific location.</summary>
                /// <param name="name">
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/lodging`
                /// </param>
                public virtual GetGoogleUpdatedRequest GetGoogleUpdated(string name)
                {
                    return new GetGoogleUpdatedRequest(service, name);
                }

                /// <summary>Returns the Google updated Lodging of a specific location.</summary>
                public class GetGoogleUpdatedRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.GetGoogleUpdatedLodgingResponse>
                {
                    /// <summary>Constructs a new GetGoogleUpdated request.</summary>
                    public GetGoogleUpdatedRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>
                    /// Required. Google identifier for this location in the form:
                    /// `accounts/{account_id}/locations/{location_id}/lodging`
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>
                    /// Optional. The specific fields to return. If no mask is specified, then it returns the full
                    /// Lodging (same as "*"). Repeated field items cannot be individually specified.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("readMask", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual object ReadMask { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "getGoogleUpdated";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}:getGoogleUpdated";

                    /// <summary>Initializes GetGoogleUpdated parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/lodging$",
                        });
                        RequestParameters.Add("readMask", new Google.Apis.Discovery.Parameter
                        {
                            Name = "readMask",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }
            }

            /// <summary>Gets the Media resource.</summary>
            public virtual MediaResource Media { get; }

            /// <summary>The "media" collection of methods.</summary>
            public class MediaResource
            {
                private const string Resource = "media";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public MediaResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                    Customers = new CustomersResource(service);
                }

                /// <summary>Gets the Customers resource.</summary>
                public virtual CustomersResource Customers { get; }

                /// <summary>The "customers" collection of methods.</summary>
                public class CustomersResource
                {
                    private const string Resource = "customers";

                    /// <summary>The service which this resource belongs to.</summary>
                    private readonly Google.Apis.Services.IClientService service;

                    /// <summary>Constructs a new resource.</summary>
                    public CustomersResource(Google.Apis.Services.IClientService service)
                    {
                        this.service = service;
                    }

                    /// <summary>
                    /// Returns a list of media items associated with a location that have been contributed by
                    /// customers.
                    /// </summary>
                    /// <param name="parent">The name of the location whose customer media items will be listed.</param>
                    public virtual ListRequest List(string parent)
                    {
                        return new ListRequest(service, parent);
                    }

                    /// <summary>
                    /// Returns a list of media items associated with a location that have been contributed by
                    /// customers.
                    /// </summary>
                    public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListCustomerMediaItemsResponse>
                    {
                        /// <summary>Constructs a new List request.</summary>
                        public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                        {
                            Parent = parent;
                            InitParameters();
                        }

                        /// <summary>The name of the location whose customer media items will be listed.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                        public virtual string Parent { get; private set; }

                        /// <summary>
                        /// How many media items to return per page. The default value is 100, the maximum supported
                        /// page size is 200.
                        /// </summary>
                        [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                        public virtual System.Nullable<int> PageSize { get; set; }

                        /// <summary>If specified, returns the next page of media items.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                        public virtual string PageToken { get; set; }

                        /// <summary>Gets the method name.</summary>
                        public override string MethodName => "list";

                        /// <summary>Gets the HTTP method.</summary>
                        public override string HttpMethod => "GET";

                        /// <summary>Gets the REST path.</summary>
                        public override string RestPath => "v4/{+parent}/media/customers";

                        /// <summary>Initializes List parameter list.</summary>
                        protected override void InitParameters()
                        {
                            base.InitParameters();
                            RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                            {
                                Name = "parent",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                            });
                            RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                            {
                                Name = "pageSize",
                                IsRequired = false,
                                ParameterType = "query",
                                DefaultValue = null,
                                Pattern = null,
                            });
                            RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                            {
                                Name = "pageToken",
                                IsRequired = false,
                                ParameterType = "query",
                                DefaultValue = null,
                                Pattern = null,
                            });
                        }
                    }

                    /// <summary>Returns metadata for the requested customer media item.</summary>
                    /// <param name="name">The resource name of the requested customer media item.</param>
                    public virtual GetRequest Get(string name)
                    {
                        return new GetRequest(service, name);
                    }

                    /// <summary>Returns metadata for the requested customer media item.</summary>
                    public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.MediaItem>
                    {
                        /// <summary>Constructs a new Get request.</summary>
                        public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                        {
                            Name = name;
                            InitParameters();
                        }

                        /// <summary>The resource name of the requested customer media item.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                        public virtual string Name { get; private set; }

                        /// <summary>Gets the method name.</summary>
                        public override string MethodName => "get";

                        /// <summary>Gets the HTTP method.</summary>
                        public override string HttpMethod => "GET";

                        /// <summary>Gets the REST path.</summary>
                        public override string RestPath => "v4/{+name}";

                        /// <summary>Initializes Get parameter list.</summary>
                        protected override void InitParameters()
                        {
                            base.InitParameters();
                            RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                            {
                                Name = "name",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = @"^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$",
                            });
                        }
                    }
                }

                /// <summary>Returns a list of media items associated with a location.</summary>
                /// <param name="parent">The name of the location whose media items will be listed.</param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>Returns a list of media items associated with a location.</summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListMediaItemsResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>The name of the location whose media items will be listed.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>
                    /// How many media items to return per page. The default value is 100, which is also the maximum
                    /// supported number of media items able to be added to a location with the My Business API. Maximum
                    /// page size is 2500.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> PageSize { get; set; }

                    /// <summary>If specified, returns the next page of media items.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string PageToken { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/media";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                        RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageSize",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageToken",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }

                /// <summary>Returns metadata for the requested media item.</summary>
                /// <param name="name">The name of the requested media item.</param>
                public virtual GetRequest Get(string name)
                {
                    return new GetRequest(service, name);
                }

                /// <summary>Returns metadata for the requested media item.</summary>
                public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.MediaItem>
                {
                    /// <summary>Constructs a new Get request.</summary>
                    public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the requested media item.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "get";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Get parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/media/[^/]+$",
                        });
                    }
                }

                /// <summary>Generates a `MediaItemDataRef` for media item uploading.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="parent">The resource name of the location this media item is to be added to.</param>
                public virtual StartUploadRequest StartUpload(Google.Apis.MyBusiness.v4.Data.StartUploadMediaItemDataRequest body, string parent)
                {
                    return new StartUploadRequest(service, body, parent);
                }

                /// <summary>Generates a `MediaItemDataRef` for media item uploading.</summary>
                public class StartUploadRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.MediaItemDataRef>
                {
                    /// <summary>Constructs a new StartUpload request.</summary>
                    public StartUploadRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.StartUploadMediaItemDataRequest body, string parent) : base(service)
                    {
                        Parent = parent;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The resource name of the location this media item is to be added to.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.StartUploadMediaItemDataRequest Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "startUpload";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/media:startUpload";

                    /// <summary>Initializes StartUpload parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>Creates a new media item for the location.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="parent">
                /// The resource name of the location where this media item will be created.
                /// </param>
                public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.MediaItem body, string parent)
                {
                    return new CreateRequest(service, body, parent);
                }

                /// <summary>Creates a new media item for the location.</summary>
                public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.MediaItem>
                {
                    /// <summary>Constructs a new Create request.</summary>
                    public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.MediaItem body, string parent) : base(service)
                    {
                        Parent = parent;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The resource name of the location where this media item will be created.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.MediaItem Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "create";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/media";

                    /// <summary>Initializes Create parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>Deletes the specified media item.</summary>
                /// <param name="name">The name of the media item to be deleted.</param>
                public virtual DeleteRequest Delete(string name)
                {
                    return new DeleteRequest(service, name);
                }

                /// <summary>Deletes the specified media item.</summary>
                public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
                {
                    /// <summary>Constructs a new Delete request.</summary>
                    public DeleteRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the media item to be deleted.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "delete";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "DELETE";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Delete parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/media/[^/]+$",
                        });
                    }
                }

                /// <summary>
                /// Updates metadata of the specified media item. This can only be used to update the Category of a
                /// media item, with the exception that the new category cannot be COVER or PROFILE.
                /// </summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">The name of the media item to be updated.</param>
                public virtual PatchRequest Patch(Google.Apis.MyBusiness.v4.Data.MediaItem body, string name)
                {
                    return new PatchRequest(service, body, name);
                }

                /// <summary>
                /// Updates metadata of the specified media item. This can only be used to update the Category of a
                /// media item, with the exception that the new category cannot be COVER or PROFILE.
                /// </summary>
                public class PatchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.MediaItem>
                {
                    /// <summary>Constructs a new Patch request.</summary>
                    public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.MediaItem body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The name of the media item to be updated.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>
                    /// The specific fields to update. If no mask is specified, then this is treated as a full update
                    /// and all editable fields are set to the values passed in.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual object UpdateMask { get; set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.MediaItem Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "patch";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "PATCH";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Patch parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/media/[^/]+$",
                        });
                        RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                        {
                            Name = "updateMask",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }
            }

            /// <summary>Gets the Questions resource.</summary>
            public virtual QuestionsResource Questions { get; }

            /// <summary>The "questions" collection of methods.</summary>
            public class QuestionsResource
            {
                private const string Resource = "questions";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public QuestionsResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                    Answers = new AnswersResource(service);
                }

                /// <summary>Gets the Answers resource.</summary>
                public virtual AnswersResource Answers { get; }

                /// <summary>The "answers" collection of methods.</summary>
                public class AnswersResource
                {
                    private const string Resource = "answers";

                    /// <summary>The service which this resource belongs to.</summary>
                    private readonly Google.Apis.Services.IClientService service;

                    /// <summary>Constructs a new resource.</summary>
                    public AnswersResource(Google.Apis.Services.IClientService service)
                    {
                        this.service = service;
                    }

                    /// <summary>Returns the paginated list of answers for a specified question.</summary>
                    /// <param name="parent">The name of the question to fetch answers for.</param>
                    public virtual ListRequest List(string parent)
                    {
                        return new ListRequest(service, parent);
                    }

                    /// <summary>Returns the paginated list of answers for a specified question.</summary>
                    public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListAnswersResponse>
                    {
                        /// <summary>Constructs a new List request.</summary>
                        public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                        {
                            Parent = parent;
                            InitParameters();
                        }

                        /// <summary>The name of the question to fetch answers for.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                        public virtual string Parent { get; private set; }

                        /// <summary>
                        /// How many answers to fetch per page. The default and maximum `page_size` values are 10.
                        /// </summary>
                        [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                        public virtual System.Nullable<int> PageSize { get; set; }

                        /// <summary>If specified, the next page of answers is retrieved.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                        public virtual string PageToken { get; set; }

                        /// <summary>
                        /// The order to return the answers. Valid options include 'update_time desc' and 'upvote_count
                        /// desc', which will return the answers sorted descendingly by the requested field. The default
                        /// sort order is 'update_time desc'.
                        /// </summary>
                        [Google.Apis.Util.RequestParameterAttribute("orderBy", Google.Apis.Util.RequestParameterType.Query)]
                        public virtual string OrderBy { get; set; }

                        /// <summary>Gets the method name.</summary>
                        public override string MethodName => "list";

                        /// <summary>Gets the HTTP method.</summary>
                        public override string HttpMethod => "GET";

                        /// <summary>Gets the REST path.</summary>
                        public override string RestPath => "v4/{+parent}/answers";

                        /// <summary>Initializes List parameter list.</summary>
                        protected override void InitParameters()
                        {
                            base.InitParameters();
                            RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                            {
                                Name = "parent",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = @"^accounts/[^/]+/locations/[^/]+/questions/[^/]+$",
                            });
                            RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                            {
                                Name = "pageSize",
                                IsRequired = false,
                                ParameterType = "query",
                                DefaultValue = null,
                                Pattern = null,
                            });
                            RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                            {
                                Name = "pageToken",
                                IsRequired = false,
                                ParameterType = "query",
                                DefaultValue = null,
                                Pattern = null,
                            });
                            RequestParameters.Add("orderBy", new Google.Apis.Discovery.Parameter
                            {
                                Name = "orderBy",
                                IsRequired = false,
                                ParameterType = "query",
                                DefaultValue = null,
                                Pattern = null,
                            });
                        }
                    }

                    /// <summary>
                    /// Creates an answer or updates the existing answer written by the user for the specified question.
                    /// A user can only create one answer per question.
                    /// </summary>
                    /// <param name="body">The body of the request.</param>
                    /// <param name="parent">The name of the question to write an answer for.</param>
                    public virtual UpsertRequest Upsert(Google.Apis.MyBusiness.v4.Data.UpsertAnswerRequest body, string parent)
                    {
                        return new UpsertRequest(service, body, parent);
                    }

                    /// <summary>
                    /// Creates an answer or updates the existing answer written by the user for the specified question.
                    /// A user can only create one answer per question.
                    /// </summary>
                    public class UpsertRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Answer>
                    {
                        /// <summary>Constructs a new Upsert request.</summary>
                        public UpsertRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.UpsertAnswerRequest body, string parent) : base(service)
                        {
                            Parent = parent;
                            Body = body;
                            InitParameters();
                        }

                        /// <summary>The name of the question to write an answer for.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                        public virtual string Parent { get; private set; }

                        /// <summary>Gets or sets the body of this request.</summary>
                        Google.Apis.MyBusiness.v4.Data.UpsertAnswerRequest Body { get; set; }

                        /// <summary>Returns the body of the request.</summary>
                        protected override object GetBody() => Body;

                        /// <summary>Gets the method name.</summary>
                        public override string MethodName => "upsert";

                        /// <summary>Gets the HTTP method.</summary>
                        public override string HttpMethod => "POST";

                        /// <summary>Gets the REST path.</summary>
                        public override string RestPath => "v4/{+parent}/answers:upsert";

                        /// <summary>Initializes Upsert parameter list.</summary>
                        protected override void InitParameters()
                        {
                            base.InitParameters();
                            RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                            {
                                Name = "parent",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = @"^accounts/[^/]+/locations/[^/]+/questions/[^/]+$",
                            });
                        }
                    }

                    /// <summary>Deletes the answer written by the current user to a question.</summary>
                    /// <param name="parent">The name of the question to delete an answer for.</param>
                    public virtual DeleteRequest Delete(string parent)
                    {
                        return new DeleteRequest(service, parent);
                    }

                    /// <summary>Deletes the answer written by the current user to a question.</summary>
                    public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
                    {
                        /// <summary>Constructs a new Delete request.</summary>
                        public DeleteRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                        {
                            Parent = parent;
                            InitParameters();
                        }

                        /// <summary>The name of the question to delete an answer for.</summary>
                        [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                        public virtual string Parent { get; private set; }

                        /// <summary>Gets the method name.</summary>
                        public override string MethodName => "delete";

                        /// <summary>Gets the HTTP method.</summary>
                        public override string HttpMethod => "DELETE";

                        /// <summary>Gets the REST path.</summary>
                        public override string RestPath => "v4/{+parent}/answers:delete";

                        /// <summary>Initializes Delete parameter list.</summary>
                        protected override void InitParameters()
                        {
                            base.InitParameters();
                            RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                            {
                                Name = "parent",
                                IsRequired = true,
                                ParameterType = "path",
                                DefaultValue = null,
                                Pattern = @"^accounts/[^/]+/locations/[^/]+/questions/[^/]+$",
                            });
                        }
                    }
                }

                /// <summary>
                /// Returns the paginated list of questions and some of its answers for a specified location.
                /// </summary>
                /// <param name="parent">The name of the location to fetch questions for.</param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>
                /// Returns the paginated list of questions and some of its answers for a specified location.
                /// </summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListQuestionsResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>The name of the location to fetch questions for.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>
                    /// How many questions to fetch per page. The default and maximum `page_size` values are 10.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> PageSize { get; set; }

                    /// <summary>If specified, the next page of questions is retrieved.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string PageToken { get; set; }

                    /// <summary>
                    /// How many answers to fetch per question. The default and maximum `answers_per_question` values
                    /// are 10.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("answersPerQuestion", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> AnswersPerQuestion { get; set; }

                    /// <summary>
                    /// A filter constraining the questions to return. The only filter currently supported is
                    /// "ignore_answered=true"
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("filter", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string Filter { get; set; }

                    /// <summary>
                    /// The order to return the questions. Valid options include 'update_time desc' and 'upvote_count
                    /// desc', which will return the questions sorted descendingly by the requested field. The default
                    /// sort order is 'update_time desc'.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("orderBy", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string OrderBy { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/questions";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                        RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageSize",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageToken",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("answersPerQuestion", new Google.Apis.Discovery.Parameter
                        {
                            Name = "answersPerQuestion",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("filter", new Google.Apis.Discovery.Parameter
                        {
                            Name = "filter",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("orderBy", new Google.Apis.Discovery.Parameter
                        {
                            Name = "orderBy",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }

                /// <summary>Adds a question for the specified location.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="parent">The name of the location to write a question for.</param>
                public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.Question body, string parent)
                {
                    return new CreateRequest(service, body, parent);
                }

                /// <summary>Adds a question for the specified location.</summary>
                public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Question>
                {
                    /// <summary>Constructs a new Create request.</summary>
                    public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Question body, string parent) : base(service)
                    {
                        Parent = parent;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The name of the location to write a question for.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.Question Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "create";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/questions";

                    /// <summary>Initializes Create parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                    }
                }

                /// <summary>Updates a specific question written by the current user.</summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">The name of the question to update.</param>
                public virtual PatchRequest Patch(Google.Apis.MyBusiness.v4.Data.Question body, string name)
                {
                    return new PatchRequest(service, body, name);
                }

                /// <summary>Updates a specific question written by the current user.</summary>
                public class PatchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Question>
                {
                    /// <summary>Constructs a new Patch request.</summary>
                    public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Question body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The name of the question to update.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.Question Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "patch";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "PATCH";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Patch parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/questions/[^/]+$",
                        });
                    }
                }

                /// <summary>Deletes a specific question written by the current user.</summary>
                /// <param name="name">The name of the question to delete.</param>
                public virtual DeleteRequest Delete(string name)
                {
                    return new DeleteRequest(service, name);
                }

                /// <summary>Deletes a specific question written by the current user.</summary>
                public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
                {
                    /// <summary>Constructs a new Delete request.</summary>
                    public DeleteRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the question to delete.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "delete";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "DELETE";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Delete parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/questions/[^/]+$",
                        });
                    }
                }
            }

            /// <summary>Gets the Reviews resource.</summary>
            public virtual ReviewsResource Reviews { get; }

            /// <summary>The "reviews" collection of methods.</summary>
            public class ReviewsResource
            {
                private const string Resource = "reviews";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public ReviewsResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>
                /// Deletes the response to the specified review. This operation is only valid if the specified location
                /// is verified.
                /// </summary>
                /// <param name="name">The name of the review reply to delete.</param>
                public virtual DeleteReplyRequest DeleteReply(string name)
                {
                    return new DeleteReplyRequest(service, name);
                }

                /// <summary>
                /// Deletes the response to the specified review. This operation is only valid if the specified location
                /// is verified.
                /// </summary>
                public class DeleteReplyRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
                {
                    /// <summary>Constructs a new DeleteReply request.</summary>
                    public DeleteReplyRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the review reply to delete.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "deleteReply";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "DELETE";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}/reply";

                    /// <summary>Initializes DeleteReply parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$",
                        });
                    }
                }

                /// <summary>
                /// Returns the specified review. This operation is only valid if the specified location is verified.
                /// Returns `NOT_FOUND` if the review does not exist, or has been deleted.
                /// </summary>
                /// <param name="name">The name of the review to fetch.</param>
                public virtual GetRequest Get(string name)
                {
                    return new GetRequest(service, name);
                }

                /// <summary>
                /// Returns the specified review. This operation is only valid if the specified location is verified.
                /// Returns `NOT_FOUND` if the review does not exist, or has been deleted.
                /// </summary>
                public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Review>
                {
                    /// <summary>Constructs a new Get request.</summary>
                    public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                    {
                        Name = name;
                        InitParameters();
                    }

                    /// <summary>The name of the review to fetch.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "get";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}";

                    /// <summary>Initializes Get parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$",
                        });
                    }
                }

                /// <summary>
                /// Returns the paginated list of reviews for the specified location. This operation is only valid if
                /// the specified location is verified.
                /// </summary>
                /// <param name="parent">The name of the location to fetch reviews for.</param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>
                /// Returns the paginated list of reviews for the specified location. This operation is only valid if
                /// the specified location is verified.
                /// </summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListReviewsResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>The name of the location to fetch reviews for.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>How many reviews to fetch per page. The maximum `page_size` is 50.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> PageSize { get; set; }

                    /// <summary>If specified, it fetches the next page of reviews.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string PageToken { get; set; }

                    /// <summary>
                    /// Specifies the field to sort reviews by. If unspecified, the order of reviews returned will
                    /// default to `update_time desc`. Valid orders to sort by are `rating`, `rating desc` and
                    /// `update_time desc`.
                    /// </summary>
                    [Google.Apis.Util.RequestParameterAttribute("orderBy", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string OrderBy { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/reviews";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                        RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageSize",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageToken",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("orderBy", new Google.Apis.Discovery.Parameter
                        {
                            Name = "orderBy",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }

                /// <summary>
                /// Updates the reply to the specified review. A reply is created if one does not exist. This operation
                /// is only valid if the specified location is verified.
                /// </summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">The name of the review to respond to.</param>
                public virtual UpdateReplyRequest UpdateReply(Google.Apis.MyBusiness.v4.Data.ReviewReply body, string name)
                {
                    return new UpdateReplyRequest(service, body, name);
                }

                /// <summary>
                /// Updates the reply to the specified review. A reply is created if one does not exist. This operation
                /// is only valid if the specified location is verified.
                /// </summary>
                public class UpdateReplyRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ReviewReply>
                {
                    /// <summary>Constructs a new UpdateReply request.</summary>
                    public UpdateReplyRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.ReviewReply body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>The name of the review to respond to.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.ReviewReply Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "updateReply";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "PUT";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}/reply";

                    /// <summary>Initializes UpdateReply parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$",
                        });
                    }
                }
            }

            /// <summary>Gets the Verifications resource.</summary>
            public virtual VerificationsResource Verifications { get; }

            /// <summary>The "verifications" collection of methods.</summary>
            public class VerificationsResource
            {
                private const string Resource = "verifications";

                /// <summary>The service which this resource belongs to.</summary>
                private readonly Google.Apis.Services.IClientService service;

                /// <summary>Constructs a new resource.</summary>
                public VerificationsResource(Google.Apis.Services.IClientService service)
                {
                    this.service = service;
                }

                /// <summary>
                /// Completes a `PENDING` verification. It is only necessary for non `AUTO` verification methods. `AUTO`
                /// verification request is instantly `VERIFIED` upon creation.
                /// </summary>
                /// <param name="body">The body of the request.</param>
                /// <param name="name">Resource name of the verification to complete.</param>
                public virtual CompleteRequest Complete(Google.Apis.MyBusiness.v4.Data.CompleteVerificationRequest body, string name)
                {
                    return new CompleteRequest(service, body, name);
                }

                /// <summary>
                /// Completes a `PENDING` verification. It is only necessary for non `AUTO` verification methods. `AUTO`
                /// verification request is instantly `VERIFIED` upon creation.
                /// </summary>
                public class CompleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.CompleteVerificationResponse>
                {
                    /// <summary>Constructs a new Complete request.</summary>
                    public CompleteRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.CompleteVerificationRequest body, string name) : base(service)
                    {
                        Name = name;
                        Body = body;
                        InitParameters();
                    }

                    /// <summary>Resource name of the verification to complete.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Name { get; private set; }

                    /// <summary>Gets or sets the body of this request.</summary>
                    Google.Apis.MyBusiness.v4.Data.CompleteVerificationRequest Body { get; set; }

                    /// <summary>Returns the body of the request.</summary>
                    protected override object GetBody() => Body;

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "complete";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "POST";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+name}:complete";

                    /// <summary>Initializes Complete parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                        {
                            Name = "name",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$",
                        });
                    }
                }

                /// <summary>List verifications of a location, ordered by create time.</summary>
                /// <param name="parent">Resource name of the location that verification requests belong to.</param>
                public virtual ListRequest List(string parent)
                {
                    return new ListRequest(service, parent);
                }

                /// <summary>List verifications of a location, ordered by create time.</summary>
                public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListVerificationsResponse>
                {
                    /// <summary>Constructs a new List request.</summary>
                    public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                    {
                        Parent = parent;
                        InitParameters();
                    }

                    /// <summary>Resource name of the location that verification requests belong to.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                    public virtual string Parent { get; private set; }

                    /// <summary>How many verification to include per page. If not set, return all.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual System.Nullable<int> PageSize { get; set; }

                    /// <summary>If specified, returns the next page of verifications.</summary>
                    [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                    public virtual string PageToken { get; set; }

                    /// <summary>Gets the method name.</summary>
                    public override string MethodName => "list";

                    /// <summary>Gets the HTTP method.</summary>
                    public override string HttpMethod => "GET";

                    /// <summary>Gets the REST path.</summary>
                    public override string RestPath => "v4/{+parent}/verifications";

                    /// <summary>Initializes List parameter list.</summary>
                    protected override void InitParameters()
                    {
                        base.InitParameters();
                        RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                        {
                            Name = "parent",
                            IsRequired = true,
                            ParameterType = "path",
                            DefaultValue = null,
                            Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                        });
                        RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageSize",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                        RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                        {
                            Name = "pageToken",
                            IsRequired = false,
                            ParameterType = "query",
                            DefaultValue = null,
                            Pattern = null,
                        });
                    }
                }
            }

            /// <summary>
            /// Returns the food menus of a specific location. Only call this if
            /// location.location_state.can_have_food_menu is true.
            /// </summary>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/foodMenus`
            /// </param>
            public virtual GetFoodMenusRequest GetFoodMenus(string name)
            {
                return new GetFoodMenusRequest(service, name);
            }

            /// <summary>
            /// Returns the food menus of a specific location. Only call this if
            /// location.location_state.can_have_food_menu is true.
            /// </summary>
            public class GetFoodMenusRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.FoodMenus>
            {
                /// <summary>Constructs a new GetFoodMenus request.</summary>
                public GetFoodMenusRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/foodMenus`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The specific fields to return. If no mask is specified, then it returns the full FoodMenu
                /// (same as "*"). Repeated field items can not be individually specified. For example: "name" and
                /// "menus" are valid masks, while "menus.sections" is invalid.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("readMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object ReadMask { get; set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "getFoodMenus";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes GetFoodMenus parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/foodMenus$",
                    });
                    RequestParameters.Add("readMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "readMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>
            /// Updates the food menus of a specific location. Only call this if
            /// location.location_state.can_have_food_menu is true.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/foodMenus`
            /// </param>
            public virtual UpdateFoodMenusRequest UpdateFoodMenus(Google.Apis.MyBusiness.v4.Data.FoodMenus body, string name)
            {
                return new UpdateFoodMenusRequest(service, body, name);
            }

            /// <summary>
            /// Updates the food menus of a specific location. Only call this if
            /// location.location_state.can_have_food_menu is true.
            /// </summary>
            public class UpdateFoodMenusRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.FoodMenus>
            {
                /// <summary>Constructs a new UpdateFoodMenus request.</summary>
                public UpdateFoodMenusRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.FoodMenus body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/foodMenus`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The specific fields to update. If no mask is specified, then this is treated as a full
                /// update and all fields are set to the values passed in, which may include unsetting empty fields in
                /// the request. Repeated field items can not be individually updated. Note: "name" of FoodMenus is the
                /// resource identifier which is not updatable.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object UpdateMask { get; set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.FoodMenus Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "updateFoodMenus";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "PATCH";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes UpdateFoodMenus parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/foodMenus$",
                    });
                    RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "updateMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>Returns the Health provider attributes of a specific location.</summary>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// accounts/{account_id}/locations/{location_id}/healthProviderAttributes
            /// </param>
            public virtual GetHealthProviderAttributesRequest GetHealthProviderAttributes(string name)
            {
                return new GetHealthProviderAttributesRequest(service, name);
            }

            /// <summary>Returns the Health provider attributes of a specific location.</summary>
            public class GetHealthProviderAttributesRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.HealthProviderAttributes>
            {
                /// <summary>Constructs a new GetHealthProviderAttributes request.</summary>
                public GetHealthProviderAttributesRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// accounts/{account_id}/locations/{location_id}/healthProviderAttributes
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The BCP 47 code for the language. If a language code is not provided, it defaults to
                /// English. Right now only 'en' is supported.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("languageCode", Google.Apis.Util.RequestParameterType.Query)]
                public virtual string LanguageCode { get; set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "getHealthProviderAttributes";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes GetHealthProviderAttributes parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$",
                    });
                    RequestParameters.Add("languageCode", new Google.Apis.Discovery.Parameter
                    {
                        Name = "languageCode",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>Updates the Health provider attributes of a specific location.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
            /// </param>
            public virtual UpdateHealthProviderAttributesRequest UpdateHealthProviderAttributes(Google.Apis.MyBusiness.v4.Data.HealthProviderAttributes body, string name)
            {
                return new UpdateHealthProviderAttributesRequest(service, body, name);
            }

            /// <summary>Updates the Health provider attributes of a specific location.</summary>
            public class UpdateHealthProviderAttributesRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.HealthProviderAttributes>
            {
                /// <summary>Constructs a new UpdateHealthProviderAttributes request.</summary>
                public UpdateHealthProviderAttributesRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.HealthProviderAttributes body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The specific fields to update. If no mask is specified, then this is treated as a full
                /// update and all fields are set to the values passed in, which may include unsetting empty fields in
                /// the request. In V1, there is only the insurance_networks field to update. More attributes will be
                /// supported later.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object UpdateMask { get; set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.HealthProviderAttributes Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "updateHealthProviderAttributes";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "PATCH";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes UpdateHealthProviderAttributes parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$",
                    });
                    RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "updateMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>
            /// Returns a report containing insights on one or more metrics by location. *Note:* Insight reports are
            /// limited to a batch size of 10 `location_names` per call.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The account resource name.</param>
            public virtual ReportInsightsRequest ReportInsights(Google.Apis.MyBusiness.v4.Data.ReportLocationInsightsRequest body, string name)
            {
                return new ReportInsightsRequest(service, body, name);
            }

            /// <summary>
            /// Returns a report containing insights on one or more metrics by location. *Note:* Insight reports are
            /// limited to a batch size of 10 `location_names` per call.
            /// </summary>
            public class ReportInsightsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ReportLocationInsightsResponse>
            {
                /// <summary>Constructs a new ReportInsights request.</summary>
                public ReportInsightsRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.ReportLocationInsightsRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The account resource name.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.ReportLocationInsightsRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "reportInsights";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}/locations:reportInsights";

                /// <summary>Initializes ReportInsights parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                }
            }

            /// <summary>Lists the locations for the specified account.</summary>
            /// <param name="parent">
            /// The name of the account to fetch locations from. If the Account is of AccountType PERSONAL, only
            /// Locations that are directly owned by the Account are returned, otherwise it will return all accessible
            /// locations from the Account, either directly or indirectly.
            /// </param>
            public virtual ListRequest List(string parent)
            {
                return new ListRequest(service, parent);
            }

            /// <summary>Lists the locations for the specified account.</summary>
            public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListLocationsResponse>
            {
                /// <summary>Constructs a new List request.</summary>
                public ListRequest(Google.Apis.Services.IClientService service, string parent) : base(service)
                {
                    Parent = parent;
                    InitParameters();
                }

                /// <summary>
                /// The name of the account to fetch locations from. If the Account is of AccountType PERSONAL, only
                /// Locations that are directly owned by the Account are returned, otherwise it will return all
                /// accessible locations from the Account, either directly or indirectly.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Parent { get; private set; }

                /// <summary>
                /// How many locations to fetch per page. Default is 100, minimum is 1, and maximum page size is 100.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
                public virtual System.Nullable<int> PageSize { get; set; }

                /// <summary>
                /// If specified, it fetches the next `page` of locations. The page token is returned by previous calls
                /// to `ListLocations` when there were more locations than could fit in the requested page size.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
                public virtual string PageToken { get; set; }

                /// <summary>
                /// A filter constraining the locations to return. The response includes only entries that match the
                /// filter. If `filter` is empty, then constraints are applied and all locations (paginated) are
                /// retrieved for the requested account. For more information about valid fields and example usage, see
                /// [Work with Location Data
                /// Guide](https://developers.google.com/my-business/content/location-data#filter_results_when_you_list_locations).
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("filter", Google.Apis.Util.RequestParameterType.Query)]
                public virtual string Filter { get; set; }

                /// <summary>
                /// The BCP 47 code of language to get display location properties in. If this language is not
                /// available, they will be provided in the language of the location. If neither is available, they will
                /// be provided in English. Deprecated. After August 15th, 2020, this field will no longer be applied.
                /// Instead, the language of the location will always be used.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("languageCode", Google.Apis.Util.RequestParameterType.Query)]
                public virtual string LanguageCode { get; set; }

                /// <summary>
                /// Sorting order for the request. Multiple fields should be comma-separated, following SQL syntax. The
                /// default sorting order is ascending. To specify descending order, a suffix " desc" should be added.
                /// Valid fields to order_by are location_name and store_code. For example: "location_name, store_code
                /// desc" or "location_name" or "store_code desc"
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("orderBy", Google.Apis.Util.RequestParameterType.Query)]
                public virtual string OrderBy { get; set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "list";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+parent}/locations";

                /// <summary>Initializes List parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                    {
                        Name = "parent",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                    RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                    {
                        Name = "pageSize",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                    {
                        Name = "pageToken",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("filter", new Google.Apis.Discovery.Parameter
                    {
                        Name = "filter",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("languageCode", new Google.Apis.Discovery.Parameter
                    {
                        Name = "languageCode",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("orderBy", new Google.Apis.Discovery.Parameter
                    {
                        Name = "orderBy",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>Gets the specified location. Returns `NOT_FOUND` if the location does not exist.</summary>
            /// <param name="name">The name of the location to fetch.</param>
            public virtual GetRequest Get(string name)
            {
                return new GetRequest(service, name);
            }

            /// <summary>Gets the specified location. Returns `NOT_FOUND` if the location does not exist.</summary>
            public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Location>
            {
                /// <summary>Constructs a new Get request.</summary>
                public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>The name of the location to fetch.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "get";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes Get parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>Gets all of the specified locations in the given account.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The name of the account from which to fetch locations.</param>
            public virtual BatchGetRequest BatchGet(Google.Apis.MyBusiness.v4.Data.BatchGetLocationsRequest body, string name)
            {
                return new BatchGetRequest(service, body, name);
            }

            /// <summary>Gets all of the specified locations in the given account.</summary>
            public class BatchGetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.BatchGetLocationsResponse>
            {
                /// <summary>Constructs a new BatchGet request.</summary>
                public BatchGetRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.BatchGetLocationsRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The name of the account from which to fetch locations.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.BatchGetLocationsRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "batchGet";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}/locations:batchGet";

                /// <summary>Initializes BatchGet parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Gets the Google-updated version of the specified location. Returns `NOT_FOUND` if the location does not
            /// exist.
            /// </summary>
            /// <param name="name">The name of the location to fetch.</param>
            public virtual GetGoogleUpdatedRequest GetGoogleUpdated(string name)
            {
                return new GetGoogleUpdatedRequest(service, name);
            }

            /// <summary>
            /// Gets the Google-updated version of the specified location. Returns `NOT_FOUND` if the location does not
            /// exist.
            /// </summary>
            public class GetGoogleUpdatedRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.GoogleUpdatedLocation>
            {
                /// <summary>Constructs a new GetGoogleUpdated request.</summary>
                public GetGoogleUpdatedRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>The name of the location to fetch.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "getGoogleUpdated";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:googleUpdated";

                /// <summary>Initializes GetGoogleUpdated parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>Creates a new location owned by the specified account, and returns it.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="parent">The name of the account in which to create this location.</param>
            public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.Location body, string parent)
            {
                return new CreateRequest(service, body, parent);
            }

            /// <summary>Creates a new location owned by the specified account, and returns it.</summary>
            public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Location>
            {
                /// <summary>Constructs a new Create request.</summary>
                public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Location body, string parent) : base(service)
                {
                    Parent = parent;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The name of the account in which to create this location.</summary>
                [Google.Apis.Util.RequestParameterAttribute("parent", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Parent { get; private set; }

                /// <summary>If true, the request is validated without actually creating the location.</summary>
                [Google.Apis.Util.RequestParameterAttribute("validateOnly", Google.Apis.Util.RequestParameterType.Query)]
                public virtual System.Nullable<bool> ValidateOnly { get; set; }

                /// <summary>
                /// A unique request ID for the server to detect duplicated requests. We recommend using UUIDs. Max
                /// length is 50 characters.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("requestId", Google.Apis.Util.RequestParameterType.Query)]
                public virtual string RequestId { get; set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.Location Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "create";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+parent}/locations";

                /// <summary>Initializes Create parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("parent", new Google.Apis.Discovery.Parameter
                    {
                        Name = "parent",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                    RequestParameters.Add("validateOnly", new Google.Apis.Discovery.Parameter
                    {
                        Name = "validateOnly",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("requestId", new Google.Apis.Discovery.Parameter
                    {
                        Name = "requestId",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>
            /// Updates the specified location. Photos are only allowed on a location that has a Google+ page. Returns
            /// `NOT_FOUND` if the location does not exist.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The name of the location to update.</param>
            public virtual PatchRequest Patch(Google.Apis.MyBusiness.v4.Data.Location body, string name)
            {
                return new PatchRequest(service, body, name);
            }

            /// <summary>
            /// Updates the specified location. Photos are only allowed on a location that has a Google+ page. Returns
            /// `NOT_FOUND` if the location does not exist.
            /// </summary>
            public class PatchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Location>
            {
                /// <summary>Constructs a new Patch request.</summary>
                public PatchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Location body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The name of the location to update.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// The specific fields to update. If no mask is specified, then this is treated as a full update and
                /// all fields are set to the values passed in, which may include unsetting empty fields in the request.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object UpdateMask { get; set; }

                /// <summary>If true, the request is validated without actually updating the location.</summary>
                [Google.Apis.Util.RequestParameterAttribute("validateOnly", Google.Apis.Util.RequestParameterType.Query)]
                public virtual System.Nullable<bool> ValidateOnly { get; set; }

                /// <summary>
                /// The IDs of the attributes to update. Only attributes noted in the mask will be updated. If an
                /// attribute is present in the mask and not in the location, it will be removed. An empty mask will
                /// update all attributes. Whenever this field is set, the update_mask should include attributes as one
                /// of the fields to update.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("attributeMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object AttributeMask { get; set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.Location Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "patch";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "PATCH";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes Patch parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                    RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "updateMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("validateOnly", new Google.Apis.Discovery.Parameter
                    {
                        Name = "validateOnly",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                    RequestParameters.Add("attributeMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "attributeMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>
            /// Deletes a location. *Note:* If this location cannot be deleted using the API as marked in the
            /// LocationState, use the [Google My Business](https://business.google.com/manage/) website. Returns
            /// `NOT_FOUND` if the location does not exist.
            /// </summary>
            /// <param name="name">The name of the location to delete.</param>
            public virtual DeleteRequest Delete(string name)
            {
                return new DeleteRequest(service, name);
            }

            /// <summary>
            /// Deletes a location. *Note:* If this location cannot be deleted using the API as marked in the
            /// LocationState, use the [Google My Business](https://business.google.com/manage/) website. Returns
            /// `NOT_FOUND` if the location does not exist.
            /// </summary>
            public class DeleteRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
            {
                /// <summary>Constructs a new Delete request.</summary>
                public DeleteRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>The name of the location to delete.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "delete";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "DELETE";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes Delete parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Finds all of the possible locations that are a match to the specified location. This operation is only
            /// valid if the location is unverified.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The resource name of the location to find matches for.</param>
            public virtual FindMatchesRequest FindMatches(Google.Apis.MyBusiness.v4.Data.FindMatchingLocationsRequest body, string name)
            {
                return new FindMatchesRequest(service, body, name);
            }

            /// <summary>
            /// Finds all of the possible locations that are a match to the specified location. This operation is only
            /// valid if the location is unverified.
            /// </summary>
            public class FindMatchesRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.FindMatchingLocationsResponse>
            {
                /// <summary>Constructs a new FindMatches request.</summary>
                public FindMatchesRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.FindMatchingLocationsRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The resource name of the location to find matches for.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.FindMatchingLocationsRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "findMatches";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:findMatches";

                /// <summary>Initializes FindMatches parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Associates a location to a place ID. Any previous association is overwritten. This operation is only
            /// valid if the location is unverified. The association must be valid, that is, it appears in the list of
            /// `FindMatchingLocations`.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The resource name of the location to associate.</param>
            public virtual AssociateRequest Associate(Google.Apis.MyBusiness.v4.Data.AssociateLocationRequest body, string name)
            {
                return new AssociateRequest(service, body, name);
            }

            /// <summary>
            /// Associates a location to a place ID. Any previous association is overwritten. This operation is only
            /// valid if the location is unverified. The association must be valid, that is, it appears in the list of
            /// `FindMatchingLocations`.
            /// </summary>
            public class AssociateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
            {
                /// <summary>Constructs a new Associate request.</summary>
                public AssociateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.AssociateLocationRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The resource name of the location to associate.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.AssociateLocationRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "associate";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:associate";

                /// <summary>Initializes Associate parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Clears an association between a location and its place ID. This operation is only valid if the location
            /// is unverified.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The resource name of the location to disassociate.</param>
            public virtual ClearAssociationRequest ClearAssociation(Google.Apis.MyBusiness.v4.Data.ClearLocationAssociationRequest body, string name)
            {
                return new ClearAssociationRequest(service, body, name);
            }

            /// <summary>
            /// Clears an association between a location and its place ID. This operation is only valid if the location
            /// is unverified.
            /// </summary>
            public class ClearAssociationRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
            {
                /// <summary>Constructs a new ClearAssociation request.</summary>
                public ClearAssociationRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.ClearLocationAssociationRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The resource name of the location to disassociate.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.ClearLocationAssociationRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "clearAssociation";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:clearAssociation";

                /// <summary>Initializes ClearAssociation parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>
            /// Moves a location from an account that the user owns to another account that the same user administers.
            /// The user must be an owner of the account the location is currently associated with and must also be at
            /// least a manager of the destination account. Returns the Location with its new resource name.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">The name of the location to transfer.</param>
            public virtual TransferRequest Transfer(Google.Apis.MyBusiness.v4.Data.TransferLocationRequest body, string name)
            {
                return new TransferRequest(service, body, name);
            }

            /// <summary>
            /// Moves a location from an account that the user owns to another account that the same user administers.
            /// The user must be an owner of the account the location is currently associated with and must also be at
            /// least a manager of the destination account. Returns the Location with its new resource name.
            /// </summary>
            public class TransferRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Location>
            {
                /// <summary>Constructs a new Transfer request.</summary>
                public TransferRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.TransferLocationRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>The name of the location to transfer.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.TransferLocationRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "transfer";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:transfer";

                /// <summary>Initializes Transfer parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>Returns the Lodging of a specific location.</summary>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/lodging`
            /// </param>
            public virtual GetLodgingRequest GetLodging(string name)
            {
                return new GetLodgingRequest(service, name);
            }

            /// <summary>Returns the Lodging of a specific location.</summary>
            public class GetLodgingRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Lodging>
            {
                /// <summary>Constructs a new GetLodging request.</summary>
                public GetLodgingRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/lodging`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The specific fields to return. If no mask is specified, then it returns the full Lodging
                /// (same as "*"). Repeated field items cannot be individually specified.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("readMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object ReadMask { get; set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "getLodging";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes GetLodging parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/lodging$",
                    });
                    RequestParameters.Add("readMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "readMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>Updates the Lodging of a specific location.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/lodging`
            /// </param>
            public virtual UpdateLodgingRequest UpdateLodging(Google.Apis.MyBusiness.v4.Data.Lodging body, string name)
            {
                return new UpdateLodgingRequest(service, body, name);
            }

            /// <summary>Updates the Lodging of a specific location.</summary>
            public class UpdateLodgingRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Lodging>
            {
                /// <summary>Constructs a new UpdateLodging request.</summary>
                public UpdateLodgingRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Lodging body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/lodging`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The specific fields to update. If no mask is specified, then this is treated as a full
                /// update (same as "*") and all fields are set to the values passed in, which may include unsetting
                /// empty fields in the request. Repeated field items cannot be individually updated.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object UpdateMask { get; set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.Lodging Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "updateLodging";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "PATCH";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes UpdateLodging parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/lodging$",
                    });
                    RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "updateMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>
            /// Returns the paginated list of reviews for all specified locations. This operation is only valid if the
            /// specified locations are verified. *Note:* Reviews are limited to a batch size of 200 `location_names`
            /// per call.
            /// </summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">
            /// The name of the account from which to retrieve a list of reviews across multiple locations.
            /// </param>
            public virtual BatchGetReviewsRequest BatchGetReviews(Google.Apis.MyBusiness.v4.Data.BatchGetReviewsRequest body, string name)
            {
                return new BatchGetReviewsRequest(service, body, name);
            }

            /// <summary>
            /// Returns the paginated list of reviews for all specified locations. This operation is only valid if the
            /// specified locations are verified. *Note:* Reviews are limited to a batch size of 200 `location_names`
            /// per call.
            /// </summary>
            public class BatchGetReviewsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.BatchGetReviewsResponse>
            {
                /// <summary>Constructs a new BatchGetReviews request.</summary>
                public BatchGetReviewsRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.BatchGetReviewsRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>
                /// The name of the account from which to retrieve a list of reviews across multiple locations.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.BatchGetReviewsRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "batchGetReviews";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}/locations:batchGetReviews";

                /// <summary>Initializes BatchGetReviews parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+$",
                    });
                }
            }

            /// <summary>Updates the specified service list of a location.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/serviceList`
            /// </param>
            public virtual UpdateServiceListRequest UpdateServiceList(Google.Apis.MyBusiness.v4.Data.ServiceList body, string name)
            {
                return new UpdateServiceListRequest(service, body, name);
            }

            /// <summary>Updates the specified service list of a location.</summary>
            public class UpdateServiceListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ServiceList>
            {
                /// <summary>Constructs a new UpdateServiceList request.</summary>
                public UpdateServiceListRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.ServiceList body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/serviceList`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>
                /// Optional. The specific fields to update. If no mask is specified, then this is treated as a full
                /// update and all fields are set to the values passed in, which may include unsetting empty fields in
                /// the request. Repeated field items can not be individually updated.
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("updateMask", Google.Apis.Util.RequestParameterType.Query)]
                public virtual object UpdateMask { get; set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.ServiceList Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "updateServiceList";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "PATCH";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes UpdateServiceList parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/serviceList$",
                    });
                    RequestParameters.Add("updateMask", new Google.Apis.Discovery.Parameter
                    {
                        Name = "updateMask",
                        IsRequired = false,
                        ParameterType = "query",
                        DefaultValue = null,
                        Pattern = null,
                    });
                }
            }

            /// <summary>Get the specified service list of a location.</summary>
            /// <param name="name">
            /// Required. Google identifier for this location in the form:
            /// `accounts/{account_id}/locations/{location_id}/servicelist`
            /// </param>
            public virtual GetServiceListRequest GetServiceList(string name)
            {
                return new GetServiceListRequest(service, name);
            }

            /// <summary>Get the specified service list of a location.</summary>
            public class GetServiceListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ServiceList>
            {
                /// <summary>Constructs a new GetServiceList request.</summary>
                public GetServiceListRequest(Google.Apis.Services.IClientService service, string name) : base(service)
                {
                    Name = name;
                    InitParameters();
                }

                /// <summary>
                /// Required. Google identifier for this location in the form:
                /// `accounts/{account_id}/locations/{location_id}/servicelist`
                /// </summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "getServiceList";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "GET";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}";

                /// <summary>Initializes GetServiceList parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+/serviceList$",
                    });
                }
            }

            /// <summary>Reports all eligible verification options for a location in a specific language.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">Resource name of the location to verify.</param>
            public virtual FetchVerificationOptionsRequest FetchVerificationOptions(Google.Apis.MyBusiness.v4.Data.FetchVerificationOptionsRequest body, string name)
            {
                return new FetchVerificationOptionsRequest(service, body, name);
            }

            /// <summary>Reports all eligible verification options for a location in a specific language.</summary>
            public class FetchVerificationOptionsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.FetchVerificationOptionsResponse>
            {
                /// <summary>Constructs a new FetchVerificationOptions request.</summary>
                public FetchVerificationOptionsRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.FetchVerificationOptionsRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>Resource name of the location to verify.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.FetchVerificationOptionsRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "fetchVerificationOptions";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:fetchVerificationOptions";

                /// <summary>Initializes FetchVerificationOptions parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }

            /// <summary>Starts the verification process for a location.</summary>
            /// <param name="body">The body of the request.</param>
            /// <param name="name">Resource name of the location to verify.</param>
            public virtual VerifyRequest Verify(Google.Apis.MyBusiness.v4.Data.VerifyLocationRequest body, string name)
            {
                return new VerifyRequest(service, body, name);
            }

            /// <summary>Starts the verification process for a location.</summary>
            public class VerifyRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.VerifyLocationResponse>
            {
                /// <summary>Constructs a new Verify request.</summary>
                public VerifyRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.VerifyLocationRequest body, string name) : base(service)
                {
                    Name = name;
                    Body = body;
                    InitParameters();
                }

                /// <summary>Resource name of the location to verify.</summary>
                [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
                public virtual string Name { get; private set; }

                /// <summary>Gets or sets the body of this request.</summary>
                Google.Apis.MyBusiness.v4.Data.VerifyLocationRequest Body { get; set; }

                /// <summary>Returns the body of the request.</summary>
                protected override object GetBody() => Body;

                /// <summary>Gets the method name.</summary>
                public override string MethodName => "verify";

                /// <summary>Gets the HTTP method.</summary>
                public override string HttpMethod => "POST";

                /// <summary>Gets the REST path.</summary>
                public override string RestPath => "v4/{+name}:verify";

                /// <summary>Initializes Verify parameter list.</summary>
                protected override void InitParameters()
                {
                    base.InitParameters();
                    RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                    {
                        Name = "name",
                        IsRequired = true,
                        ParameterType = "path",
                        DefaultValue = null,
                        Pattern = @"^accounts/[^/]+/locations/[^/]+$",
                    });
                }
            }
        }

        /// <summary>
        /// Lists all of the accounts for the authenticated user. This includes all accounts that the user owns, as well
        /// as any accounts for which the user has management rights.
        /// </summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>
        /// Lists all of the accounts for the authenticated user. This includes all accounts that the user owns, as well
        /// as any accounts for which the user has management rights.
        /// </summary>
        public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListAccountsResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service) : base(service)
            {
                InitParameters();
            }

            /// <summary>
            /// How many accounts to fetch per page. Default is 20, minimum is 2, and maximum page size is 20.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> PageSize { get; set; }

            /// <summary>
            /// If specified, the next page of accounts is retrieved. The `pageToken` is returned when a call to
            /// `accounts.list` returns more results than can fit into the requested page size.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string PageToken { get; set; }

            /// <summary>
            /// The resource name of the account for which the list of directly accessible accounts is to be retrieved.
            /// This only makes sense for Organizations and User Groups. If empty, will return `ListAccounts` for the
            /// authenticated user.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Name { get; set; }

            /// <summary>
            /// A filter constraining the accounts to return. The response includes only entries that match the filter.
            /// If `filter` is empty, then no constraints are applied and all accounts (paginated) are retrieved for the
            /// requested account. For example, a request with the filter `type=USER_GROUP` will only return user
            /// groups.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("filter", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Filter { get; set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "list";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/accounts";

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageSize",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageToken",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("filter", new Google.Apis.Discovery.Parameter
                {
                    Name = "filter",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }

        /// <summary>
        /// Gets the specified account. Returns `NOT_FOUND` if the account does not exist or if the caller does not have
        /// access rights to it.
        /// </summary>
        /// <param name="name">The name of the account to fetch.</param>
        public virtual GetRequest Get(string name)
        {
            return new GetRequest(service, name);
        }

        /// <summary>
        /// Gets the specified account. Returns `NOT_FOUND` if the account does not exist or if the caller does not have
        /// access rights to it.
        /// </summary>
        public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Account>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
            {
                Name = name;
                InitParameters();
            }

            /// <summary>The name of the account to fetch.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "get";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}";

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+$",
                });
            }
        }

        /// <summary>
        /// Creates an account with the specified name and type under the given parent. - Personal accounts and
        /// Organizations cannot be created. - User Groups cannot be created with a Personal account as primary owner. -
        /// Location Groups cannot be created with a primary owner of a Personal account if the Personal account is in
        /// an Organization. - Location Groups cannot own Location Groups.
        /// </summary>
        /// <param name="body">The body of the request.</param>
        public virtual CreateRequest Create(Google.Apis.MyBusiness.v4.Data.Account body)
        {
            return new CreateRequest(service, body);
        }

        /// <summary>
        /// Creates an account with the specified name and type under the given parent. - Personal accounts and
        /// Organizations cannot be created. - User Groups cannot be created with a Personal account as primary owner. -
        /// Location Groups cannot be created with a primary owner of a Personal account if the Personal account is in
        /// an Organization. - Location Groups cannot own Location Groups.
        /// </summary>
        public class CreateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Account>
        {
            /// <summary>Constructs a new Create request.</summary>
            public CreateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Account body) : base(service)
            {
                Body = body;
                InitParameters();
            }

            /// <summary>
            /// The resource name of the account which will be the primary owner of the account being created. It should
            /// be of the form `accounts/{account_id}/`.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("primaryOwner", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string PrimaryOwner { get; set; }

            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.MyBusiness.v4.Data.Account Body { get; set; }

            /// <summary>Returns the body of the request.</summary>
            protected override object GetBody() => Body;

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "create";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "POST";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/accounts";

            /// <summary>Initializes Create parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("primaryOwner", new Google.Apis.Discovery.Parameter
                {
                    Name = "primaryOwner",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }

        /// <summary>
        /// Updates the specified business account. Personal accounts cannot be updated using this method. *Note:* The
        /// only editable field for an account is `account_name`. Any other fields passed in (such as `type` or `role`)
        /// are ignored.
        /// </summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="name">The name of the account to update.</param>
        public virtual UpdateRequest Update(Google.Apis.MyBusiness.v4.Data.Account body, string name)
        {
            return new UpdateRequest(service, body, name);
        }

        /// <summary>
        /// Updates the specified business account. Personal accounts cannot be updated using this method. *Note:* The
        /// only editable field for an account is `account_name`. Any other fields passed in (such as `type` or `role`)
        /// are ignored.
        /// </summary>
        public class UpdateRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Account>
        {
            /// <summary>Constructs a new Update request.</summary>
            public UpdateRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Account body, string name) : base(service)
            {
                Name = name;
                Body = body;
                InitParameters();
            }

            /// <summary>The name of the account to update.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>If true, the request is validated without actually updating the account.</summary>
            [Google.Apis.Util.RequestParameterAttribute("validateOnly", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<bool> ValidateOnly { get; set; }

            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.MyBusiness.v4.Data.Account Body { get; set; }

            /// <summary>Returns the body of the request.</summary>
            protected override object GetBody() => Body;

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "update";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "PUT";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}";

            /// <summary>Initializes Update parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+$",
                });
                RequestParameters.Add("validateOnly", new Google.Apis.Discovery.Parameter
                {
                    Name = "validateOnly",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }

        /// <summary>
        /// Generates an account number for this account. The account number is not provisioned when an account is
        /// created. Use this request to create an account number when it is required.
        /// </summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="name">The name of the account to generate an account number for.</param>
        public virtual GenerateAccountNumberRequest GenerateAccountNumber(Google.Apis.MyBusiness.v4.Data.GenerateAccountNumberRequest body, string name)
        {
            return new GenerateAccountNumberRequest(service, body, name);
        }

        /// <summary>
        /// Generates an account number for this account. The account number is not provisioned when an account is
        /// created. Use this request to create an account number when it is required.
        /// </summary>
        public class GenerateAccountNumberRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Account>
        {
            /// <summary>Constructs a new GenerateAccountNumber request.</summary>
            public GenerateAccountNumberRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.GenerateAccountNumberRequest body, string name) : base(service)
            {
                Name = name;
                Body = body;
                InitParameters();
            }

            /// <summary>The name of the account to generate an account number for.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.MyBusiness.v4.Data.GenerateAccountNumberRequest Body { get; set; }

            /// <summary>Returns the body of the request.</summary>
            protected override object GetBody() => Body;

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "generateAccountNumber";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "POST";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}:generateAccountNumber";

            /// <summary>Initializes GenerateAccountNumber parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+$",
                });
            }
        }

        /// <summary>Returns the pubsub notification settings for the account.</summary>
        /// <param name="name">The notification settings resource name.</param>
        public virtual GetNotificationsRequest GetNotifications(string name)
        {
            return new GetNotificationsRequest(service, name);
        }

        /// <summary>Returns the pubsub notification settings for the account.</summary>
        public class GetNotificationsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Notifications>
        {
            /// <summary>Constructs a new GetNotifications request.</summary>
            public GetNotificationsRequest(Google.Apis.Services.IClientService service, string name) : base(service)
            {
                Name = name;
                InitParameters();
            }

            /// <summary>The notification settings resource name.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "getNotifications";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}";

            /// <summary>Initializes GetNotifications parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+/notifications$",
                });
            }
        }

        /// <summary>
        /// Sets the pubsub notification settings for the account informing My Business which topic to send pubsub
        /// notifications for: - New reviews for locations administered by the account. - Updated reviews for locations
        /// administered by the account. - New `GoogleUpdates` for locations administered by the account. An account
        /// will only have one notification settings resource, and only one pubsub topic can be set.
        /// </summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="name">The notification settings resource name.</param>
        public virtual UpdateNotificationsRequest UpdateNotifications(Google.Apis.MyBusiness.v4.Data.Notifications body, string name)
        {
            return new UpdateNotificationsRequest(service, body, name);
        }

        /// <summary>
        /// Sets the pubsub notification settings for the account informing My Business which topic to send pubsub
        /// notifications for: - New reviews for locations administered by the account. - Updated reviews for locations
        /// administered by the account. - New `GoogleUpdates` for locations administered by the account. An account
        /// will only have one notification settings resource, and only one pubsub topic can be set.
        /// </summary>
        public class UpdateNotificationsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Notifications>
        {
            /// <summary>Constructs a new UpdateNotifications request.</summary>
            public UpdateNotificationsRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.Notifications body, string name) : base(service)
            {
                Name = name;
                Body = body;
                InitParameters();
            }

            /// <summary>The notification settings resource name.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.MyBusiness.v4.Data.Notifications Body { get; set; }

            /// <summary>Returns the body of the request.</summary>
            protected override object GetBody() => Body;

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "updateNotifications";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "PUT";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}";

            /// <summary>Initializes UpdateNotifications parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+/notifications$",
                });
            }
        }

        /// <summary>Clears the pubsub notification settings for the account.</summary>
        /// <param name="name">The resource name for the notification settings to be cleared.</param>
        public virtual DeleteNotificationsRequest DeleteNotifications(string name)
        {
            return new DeleteNotificationsRequest(service, name);
        }

        /// <summary>Clears the pubsub notification settings for the account.</summary>
        public class DeleteNotificationsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
        {
            /// <summary>Constructs a new DeleteNotifications request.</summary>
            public DeleteNotificationsRequest(Google.Apis.Services.IClientService service, string name) : base(service)
            {
                Name = name;
                InitParameters();
            }

            /// <summary>The resource name for the notification settings to be cleared.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "deleteNotifications";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "DELETE";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}";

            /// <summary>Initializes DeleteNotifications parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+/notifications$",
                });
            }
        }

        /// <summary>
        /// List all the GoogleLocations that have been recommended to the specified GMB account. Recommendations are
        /// provided for personal accounts and location groups only, requests for all other account types will result in
        /// an error. The recommendations for location groups are based on the locations in that group. The
        /// recommendations for personal accounts are based on all of the locations that the user has access to on
        /// Google My Business (which includes locations they can access through location groups), and is a superset of
        /// all recommendations generated for the user.
        /// </summary>
        /// <param name="name">Name of the account resource to fetch recommended Google locations for.</param>
        public virtual ListRecommendGoogleLocationsRequest ListRecommendGoogleLocations(string name)
        {
            return new ListRecommendGoogleLocationsRequest(service, name);
        }

        /// <summary>
        /// List all the GoogleLocations that have been recommended to the specified GMB account. Recommendations are
        /// provided for personal accounts and location groups only, requests for all other account types will result in
        /// an error. The recommendations for location groups are based on the locations in that group. The
        /// recommendations for personal accounts are based on all of the locations that the user has access to on
        /// Google My Business (which includes locations they can access through location groups), and is a superset of
        /// all recommendations generated for the user.
        /// </summary>
        public class ListRecommendGoogleLocationsRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListRecommendedGoogleLocationsResponse>
        {
            /// <summary>Constructs a new ListRecommendGoogleLocations request.</summary>
            public ListRecommendGoogleLocationsRequest(Google.Apis.Services.IClientService service, string name) : base(service)
            {
                Name = name;
                InitParameters();
            }

            /// <summary>Name of the account resource to fetch recommended Google locations for.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>
            /// How many locations to fetch per page. Default is 25, minimum is 1, and maximum page size is 100.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> PageSize { get; set; }

            /// <summary>If specified, the next page of locations is retrieved.</summary>
            [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string PageToken { get; set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "listRecommendGoogleLocations";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}:recommendGoogleLocations";

            /// <summary>Initializes ListRecommendGoogleLocations parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^accounts/[^/]+$",
                });
                RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageSize",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageToken",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }
    }

    /// <summary>The "categories" collection of methods.</summary>
    public class CategoriesResource
    {
        private const string Resource = "categories";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public CategoriesResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;
        }

        /// <summary>
        /// Returns a list of business categories. Search will match the category name but not the category ID. *Note:*
        /// Search only matches the front of a category name (that is, 'food' may return 'Food Court' but not 'Fast Food
        /// Restaurant').
        /// </summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>
        /// Returns a list of business categories. Search will match the category name but not the category ID. *Note:*
        /// Search only matches the front of a category name (that is, 'food' may return 'Food Court' but not 'Fast Food
        /// Restaurant').
        /// </summary>
        public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListBusinessCategoriesResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service) : base(service)
            {
                InitParameters();
            }

            /// <summary>The ISO 3166-1 alpha-2 country code.</summary>
            [Google.Apis.Util.RequestParameterAttribute("regionCode", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string RegionCode { get; set; }

            /// <summary>
            /// The BCP 47 code of language. If the language is not available, it will default to English.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("languageCode", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string LanguageCode { get; set; }

            /// <summary>Optional filter string from user.</summary>
            [Google.Apis.Util.RequestParameterAttribute("searchTerm", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string SearchTerm { get; set; }

            /// <summary>
            /// How many categories to fetch per page. Default is 100, minimum is 1, and maximum page size is 100.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> PageSize { get; set; }

            /// <summary>If specified, the next page of categories will be fetched.</summary>
            [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string PageToken { get; set; }

            /// <summary>
            /// Optional. Specifies which parts to the Category resource should be returned in the response.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("view", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<ViewEnum> View { get; set; }

            /// <summary>
            /// Optional. Specifies which parts to the Category resource should be returned in the response.
            /// </summary>
            public enum ViewEnum
            {
                /// <summary>Not specified, equivalent to CATEGORY_METADATA_ONLY.</summary>
                [Google.Apis.Util.StringValueAttribute("CATEGORY_VIEW_UNSPECIFIED")]
                CATEGORYVIEWUNSPECIFIED = 0,

                /// <summary>
                /// The server response will only include Category fields display_name, category_id and language_code.
                /// It omits any service type metadata related fields.
                /// </summary>
                [Google.Apis.Util.StringValueAttribute("BASIC")]
                BASIC = 1,

                /// <summary>Returns all the fields in the response.</summary>
                [Google.Apis.Util.StringValueAttribute("FULL")]
                FULL = 2,
            }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "list";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/categories";

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("regionCode", new Google.Apis.Discovery.Parameter
                {
                    Name = "regionCode",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("languageCode", new Google.Apis.Discovery.Parameter
                {
                    Name = "languageCode",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("searchTerm", new Google.Apis.Discovery.Parameter
                {
                    Name = "searchTerm",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageSize",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageToken",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("view", new Google.Apis.Discovery.Parameter
                {
                    Name = "view",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }

        /// <summary>Returns a list of business categories for the provided language and GConcept ids.</summary>
        public virtual BatchGetRequest BatchGet()
        {
            return new BatchGetRequest(service);
        }

        /// <summary>Returns a list of business categories for the provided language and GConcept ids.</summary>
        public class BatchGetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.BatchGetBusinessCategoriesResponse>
        {
            /// <summary>Constructs a new BatchGet request.</summary>
            public BatchGetRequest(Google.Apis.Services.IClientService service) : base(service)
            {
                InitParameters();
            }

            /// <summary>Required. The BCP 47 code of language that the category names should be returned in.</summary>
            [Google.Apis.Util.RequestParameterAttribute("languageCode", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string LanguageCode { get; set; }

            /// <summary>
            /// Required. At least one name must be set. The GConcept ids the localized category names should be
            /// returned for.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("categoryIds", Google.Apis.Util.RequestParameterType.Query)]
            public virtual Google.Apis.Util.Repeatable<string> CategoryIds { get; set; }

            /// <summary>Optional. The ISO 3166-1 alpha-2 country code used to infer non-standard language.</summary>
            [Google.Apis.Util.RequestParameterAttribute("regionCode", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string RegionCode { get; set; }

            /// <summary>
            /// Required. Specifies which parts to the Category resource should be returned in the response.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("view", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<ViewEnum> View { get; set; }

            /// <summary>
            /// Required. Specifies which parts to the Category resource should be returned in the response.
            /// </summary>
            public enum ViewEnum
            {
                /// <summary>Not specified, equivalent to CATEGORY_METADATA_ONLY.</summary>
                [Google.Apis.Util.StringValueAttribute("CATEGORY_VIEW_UNSPECIFIED")]
                CATEGORYVIEWUNSPECIFIED = 0,

                /// <summary>
                /// The server response will only include Category fields display_name, category_id and language_code.
                /// It omits any service type metadata related fields.
                /// </summary>
                [Google.Apis.Util.StringValueAttribute("BASIC")]
                BASIC = 1,

                /// <summary>Returns all the fields in the response.</summary>
                [Google.Apis.Util.StringValueAttribute("FULL")]
                FULL = 2,
            }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "batchGet";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/categories:batchGet";

            /// <summary>Initializes BatchGet parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("languageCode", new Google.Apis.Discovery.Parameter
                {
                    Name = "languageCode",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("categoryIds", new Google.Apis.Discovery.Parameter
                {
                    Name = "categoryIds",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("regionCode", new Google.Apis.Discovery.Parameter
                {
                    Name = "regionCode",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("view", new Google.Apis.Discovery.Parameter
                {
                    Name = "view",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }
    }

    /// <summary>The "googleLocations" collection of methods.</summary>
    public class GoogleLocationsResource
    {
        private const string Resource = "googleLocations";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public GoogleLocationsResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;
        }

        /// <summary>Search all of the possible locations that are a match to the specified request.</summary>
        /// <param name="body">The body of the request.</param>
        public virtual SearchRequest Search(Google.Apis.MyBusiness.v4.Data.SearchGoogleLocationsRequest body)
        {
            return new SearchRequest(service, body);
        }

        /// <summary>Search all of the possible locations that are a match to the specified request.</summary>
        public class SearchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.SearchGoogleLocationsResponse>
        {
            /// <summary>Constructs a new Search request.</summary>
            public SearchRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.SearchGoogleLocationsRequest body) : base(service)
            {
                Body = body;
                InitParameters();
            }

            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.MyBusiness.v4.Data.SearchGoogleLocationsRequest Body { get; set; }

            /// <summary>Returns the body of the request.</summary>
            protected override object GetBody() => Body;

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "search";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "POST";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/googleLocations:search";

            /// <summary>Initializes Search parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
            }
        }

        /// <summary>Report a GoogleLocation.</summary>
        /// <param name="body">The body of the request.</param>
        /// <param name="name">
        /// Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
        /// </param>
        public virtual ReportRequest Report(Google.Apis.MyBusiness.v4.Data.ReportGoogleLocationRequest body, string name)
        {
            return new ReportRequest(service, body, name);
        }

        /// <summary>Report a GoogleLocation.</summary>
        public class ReportRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Empty>
        {
            /// <summary>Constructs a new Report request.</summary>
            public ReportRequest(Google.Apis.Services.IClientService service, Google.Apis.MyBusiness.v4.Data.ReportGoogleLocationRequest body, string name) : base(service)
            {
                Name = name;
                Body = body;
                InitParameters();
            }

            /// <summary>
            /// Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets or sets the body of this request.</summary>
            Google.Apis.MyBusiness.v4.Data.ReportGoogleLocationRequest Body { get; set; }

            /// <summary>Returns the body of the request.</summary>
            protected override object GetBody() => Body;

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "report";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "POST";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}:report";

            /// <summary>Initializes Report parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^googleLocations/[^/]+$",
                });
            }
        }
    }

    /// <summary>The "chains" collection of methods.</summary>
    public class ChainsResource
    {
        private const string Resource = "chains";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public ChainsResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;
        }

        /// <summary>Gets the specified chain. Returns `NOT_FOUND` if the chain does not exist.</summary>
        /// <param name="name">The chain's resource name, in the format `chains/{chain_place_id}`.</param>
        public virtual GetRequest Get(string name)
        {
            return new GetRequest(service, name);
        }

        /// <summary>Gets the specified chain. Returns `NOT_FOUND` if the chain does not exist.</summary>
        public class GetRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.Chain>
        {
            /// <summary>Constructs a new Get request.</summary>
            public GetRequest(Google.Apis.Services.IClientService service, string name) : base(service)
            {
                Name = name;
                InitParameters();
            }

            /// <summary>The chain's resource name, in the format `chains/{chain_place_id}`.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Path)]
            public virtual string Name { get; private set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "get";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/{+name}";

            /// <summary>Initializes Get parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = true,
                    ParameterType = "path",
                    DefaultValue = null,
                    Pattern = @"^chains/[^/]+$",
                });
            }
        }

        /// <summary>Searches the chain based on chain name.</summary>
        public virtual SearchRequest Search()
        {
            return new SearchRequest(service);
        }

        /// <summary>Searches the chain based on chain name.</summary>
        public class SearchRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.SearchChainsResponse>
        {
            /// <summary>Constructs a new Search request.</summary>
            public SearchRequest(Google.Apis.Services.IClientService service) : base(service)
            {
                InitParameters();
            }

            /// <summary>
            /// Search for a chain by its name. Exact/partial/fuzzy/related queries are supported. Examples: "walmart",
            /// "wal-mart", "walmmmart", "沃尔玛"
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("chainDisplayName", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string ChainDisplayName { get; set; }

            /// <summary>
            /// The maximum number of matched chains to return from this query. The default is 10. The maximum possible
            /// value is 500.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("resultCount", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> ResultCount { get; set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "search";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/chains:search";

            /// <summary>Initializes Search parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("chainDisplayName", new Google.Apis.Discovery.Parameter
                {
                    Name = "chainDisplayName",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("resultCount", new Google.Apis.Discovery.Parameter
                {
                    Name = "resultCount",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }
    }

    /// <summary>The "attributes" collection of methods.</summary>
    public class AttributesResource
    {
        private const string Resource = "attributes";

        /// <summary>The service which this resource belongs to.</summary>
        private readonly Google.Apis.Services.IClientService service;

        /// <summary>Constructs a new resource.</summary>
        public AttributesResource(Google.Apis.Services.IClientService service)
        {
            this.service = service;
        }

        /// <summary>
        /// Returns the list of available attributes that would be available for a location with the given primary
        /// category and country.
        /// </summary>
        public virtual ListRequest List()
        {
            return new ListRequest(service);
        }

        /// <summary>
        /// Returns the list of available attributes that would be available for a location with the given primary
        /// category and country.
        /// </summary>
        public class ListRequest : MyBusinessBaseServiceRequest<Google.Apis.MyBusiness.v4.Data.ListAttributeMetadataResponse>
        {
            /// <summary>Constructs a new List request.</summary>
            public ListRequest(Google.Apis.Services.IClientService service) : base(service)
            {
                InitParameters();
            }

            /// <summary>Resource name of the location to look up available attributes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("name", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Name { get; set; }

            /// <summary>The primary category stable ID to find available attributes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("categoryId", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string CategoryId { get; set; }

            /// <summary>The ISO 3166-1 alpha-2 country code to find available attributes.</summary>
            [Google.Apis.Util.RequestParameterAttribute("country", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string Country { get; set; }

            /// <summary>
            /// The BCP 47 code of language to get attribute display names in. If this language is not available, they
            /// will be provided in English.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("languageCode", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string LanguageCode { get; set; }

            /// <summary>How many attributes to include per page. Default is 200, minimum is 1.</summary>
            [Google.Apis.Util.RequestParameterAttribute("pageSize", Google.Apis.Util.RequestParameterType.Query)]
            public virtual System.Nullable<int> PageSize { get; set; }

            /// <summary>
            /// If specified, the next page of attribute metadata is retrieved. The `pageToken` is returned when a call
            /// to `attributes.list` returns more results than can fit into the requested page size.
            /// </summary>
            [Google.Apis.Util.RequestParameterAttribute("pageToken", Google.Apis.Util.RequestParameterType.Query)]
            public virtual string PageToken { get; set; }

            /// <summary>Gets the method name.</summary>
            public override string MethodName => "list";

            /// <summary>Gets the HTTP method.</summary>
            public override string HttpMethod => "GET";

            /// <summary>Gets the REST path.</summary>
            public override string RestPath => "v4/attributes";

            /// <summary>Initializes List parameter list.</summary>
            protected override void InitParameters()
            {
                base.InitParameters();
                RequestParameters.Add("name", new Google.Apis.Discovery.Parameter
                {
                    Name = "name",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("categoryId", new Google.Apis.Discovery.Parameter
                {
                    Name = "categoryId",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("country", new Google.Apis.Discovery.Parameter
                {
                    Name = "country",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("languageCode", new Google.Apis.Discovery.Parameter
                {
                    Name = "languageCode",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("pageSize", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageSize",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
                RequestParameters.Add("pageToken", new Google.Apis.Discovery.Parameter
                {
                    Name = "pageToken",
                    IsRequired = false,
                    ParameterType = "query",
                    DefaultValue = null,
                    Pattern = null,
                });
            }
        }
    }
}
namespace Google.Apis.MyBusiness.v4.Data
{
    /// <summary>Request message for AccessControl.AcceptInvitation.</summary>
    public class AcceptInvitationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Physical adaptations made to the property in consideration of varying levels of human physical ability.
    /// </summary>
    public class Accessibility : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Mobility accessible. Throughout the property there are physical adaptations to ease the stay of a person in
        /// a wheelchair, such as auto-opening doors, wide elevators, wide bathrooms or ramps.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessible")]
        public virtual System.Nullable<bool> MobilityAccessible { get; set; }

        /// <summary>Mobility accessible exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleException")]
        public virtual string MobilityAccessibleException { get; set; }

        /// <summary>
        /// Mobility accessible parking. The presence of a marked, designated area of prescribed size in which only
        /// registered, labeled vehicles transporting a person with physical challenges may park.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleParking")]
        public virtual System.Nullable<bool> MobilityAccessibleParking { get; set; }

        /// <summary>Mobility accessible parking exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleParkingException")]
        public virtual string MobilityAccessibleParkingException { get; set; }

        /// <summary>
        /// Mobility accessible elevator. A lift that transports people from one level to another and is built to
        /// accommodate a wheelchair-using passenger owing to the width of its doors and placement of call buttons.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleElevator")]
        public virtual System.Nullable<bool> MobilityAccessibleElevator { get; set; }

        /// <summary>Mobility accessible elevator exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleElevatorException")]
        public virtual string MobilityAccessibleElevatorException { get; set; }

        /// <summary>
        /// Mobility accessible pool. A swimming pool equipped with a mechanical chair that can be lowered and raised
        /// for the purpose of moving physically challenged guests into and out of the pool. May be powered by
        /// electricity or water. Also known as pool lift.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessiblePool")]
        public virtual System.Nullable<bool> MobilityAccessiblePool { get; set; }

        /// <summary>Mobility accessible pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessiblePoolException")]
        public virtual string MobilityAccessiblePoolException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// An account is a container for your business's locations. If you are the only user who manages locations for your
    /// business, you can use your personal Google Account. To share management of locations with multiple users,
    /// [create a business account] (https://support.google.com/business/answer/6085339?ref_topic=6085325).
    /// </summary>
    public class Account : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The resource name, in the format `accounts/{account_id}`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// The name of the account. *Note:* For an account with AccountType `PERSONAL`, this is the first and last name
        /// of the user account.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountName")]
        public virtual string AccountName { get; set; }

        /// <summary>Output only. Specifies the AccountType of this account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("type")]
        public virtual string Type { get; set; }

        /// <summary>Output only. Specifies the AccountRole the caller has for this account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("role")]
        public virtual string Role { get; set; }

        /// <summary>Output only. Indicates the AccountState of this account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual AccountState State { get; set; }

        /// <summary>Account reference number if provisioned.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accountNumber")]
        public virtual string AccountNumber { get; set; }

        /// <summary>Output only. Specifies the PermissionLevel the caller has for this account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("permissionLevel")]
        public virtual string PermissionLevel { get; set; }

        /// <summary>Additional info for an organization. This is populated only for an organization account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("organizationInfo")]
        public virtual OrganizationInfo OrganizationInfo { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Indicates status of the account, such as whether the account has been verified by Google.</summary>
    public class AccountState : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// If verified, future locations that are created are automatically connected to Google Maps, and have Google+
        /// pages created, without requiring moderation.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("status")]
        public virtual string Status { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Amenities and features related to leisure and play.</summary>
    public class Activities : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Game room. There is a room at the hotel containing electronic machines for play such as pinball, prize
        /// machines, driving simulators, and other items commonly found at a family fun center or arcade. May also
        /// include non-electronic games like pool, foosball, darts, and more. May or may not be designed for children.
        /// Also known as arcade, fun room, or family fun center.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gameRoom")]
        public virtual System.Nullable<bool> GameRoom { get; set; }

        /// <summary>Game room exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gameRoomException")]
        public virtual string GameRoomException { get; set; }

        /// <summary>
        /// Nightclub. There is a room at the hotel with a bar, a dance floor, and seating where designated staffers
        /// play dance music. There may also be a designated area for the performance of live music, singing and comedy
        /// acts.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nightclub")]
        public virtual System.Nullable<bool> Nightclub { get; set; }

        /// <summary>Nightclub exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nightclubException")]
        public virtual string NightclubException { get; set; }

        /// <summary>
        /// Casino. A space designated for gambling and gaming featuring croupier-run table and card games, as well as
        /// electronic slot machines. May be on hotel premises or located nearby.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("casino")]
        public virtual System.Nullable<bool> Casino { get; set; }

        /// <summary>Casino exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("casinoException")]
        public virtual string CasinoException { get; set; }

        /// <summary>
        /// Boutique stores. There are stores selling clothing, jewelry, art and decor either on hotel premises or very
        /// close by. Does not refer to the hotel gift shop or convenience store.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boutiqueStores")]
        public virtual System.Nullable<bool> BoutiqueStores { get; set; }

        /// <summary>Boutique stores exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("boutiqueStoresException")]
        public virtual string BoutiqueStoresException { get; set; }

        /// <summary>
        /// Tennis. The hotel has the requisite court(s) on site or has an affiliation with a nearby facility for the
        /// purpose of providing guests with the opportunity to play a two-sided court-based game in which players use a
        /// stringed racquet to hit a ball across a net to the side of the opposing player. The court can be indoors or
        /// outdoors. Instructors, racquets and balls may or may not be provided.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tennis")]
        public virtual System.Nullable<bool> Tennis { get; set; }

        /// <summary>Tennis exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tennisException")]
        public virtual string TennisException { get; set; }

        /// <summary>
        /// Golf. There is a golf course on hotel grounds or there is a nearby, independently run golf course that
        /// allows use by hotel guests. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("golf")]
        public virtual System.Nullable<bool> Golf { get; set; }

        /// <summary>Golf exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("golfException")]
        public virtual string GolfException { get; set; }

        /// <summary>
        /// Horseback riding. The hotel has a horse barn onsite or an affiliation with a nearby barn to allow for guests
        /// to sit astride a horse and direct it to walk, trot, cantor, gallop and/or jump. Can be in a riding ring, on
        /// designated paths, or in the wilderness. May or may not involve instruction.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("horsebackRiding")]
        public virtual System.Nullable<bool> HorsebackRiding { get; set; }

        /// <summary>Horseback riding exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("horsebackRidingException")]
        public virtual string HorsebackRidingException { get; set; }

        /// <summary>
        /// Snorkeling. The provision for guests to participate in a recreational water activity in which swimmers wear
        /// a diving mask, a simple, shaped breathing tube and flippers/swim fins for the purpose of exploring below the
        /// surface of an ocean, gulf or lake. Does not usually require user certification or professional supervision.
        /// Equipment may or may not be available for rent or purchase. Not scuba diving.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("snorkeling")]
        public virtual System.Nullable<bool> Snorkeling { get; set; }

        /// <summary>Snorkeling exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("snorkelingException")]
        public virtual string SnorkelingException { get; set; }

        /// <summary>
        /// Scuba. The provision for guests to dive under naturally occurring water fitted with a self-contained
        /// underwater breathing apparatus (SCUBA) for the purpose of exploring underwater life. Apparatus consists of a
        /// tank providing oxygen to the diver through a mask. Requires certification of the diver and supervision. The
        /// hotel may have the activity at its own waterfront or have an affiliation with a nearby facility. Required
        /// equipment is most often supplied to guests. Can be free or for a fee. Not snorkeling. Not done in a swimming
        /// pool.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("scuba")]
        public virtual System.Nullable<bool> Scuba { get; set; }

        /// <summary>Scuba exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("scubaException")]
        public virtual string ScubaException { get; set; }

        /// <summary>
        /// Water skiing. The provision of giving guests the opportunity to be pulled across naturally occurring water
        /// while standing on skis and holding a tow rope attached to a motorboat. Can occur on hotel premises or at a
        /// nearby waterfront. Most often performed in a lake or ocean.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("waterSkiing")]
        public virtual System.Nullable<bool> WaterSkiing { get; set; }

        /// <summary>Water skiing exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("waterSkiingException")]
        public virtual string WaterSkiingException { get; set; }

        /// <summary>
        /// Bicycle rental. The hotel owns bicycles that it permits guests to borrow and use. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bicycleRental")]
        public virtual System.Nullable<bool> BicycleRental { get; set; }

        /// <summary>Bicycle rental exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bicycleRentalException")]
        public virtual string BicycleRentalException { get; set; }

        /// <summary>
        /// Free bicycle rental. The hotel owns bicycles that it permits guests to borrow and use for free.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeBicycleRental")]
        public virtual System.Nullable<bool> FreeBicycleRental { get; set; }

        /// <summary>Free bicycle rental exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeBicycleRentalException")]
        public virtual string FreeBicycleRentalException { get; set; }

        /// <summary>
        /// Watercraft rental. The hotel owns water vessels that it permits guests to borrow and use. Can be free or for
        /// a fee. Watercraft may include boats, pedal boats, rowboats, sailboats, powerboats, canoes, kayaks, or
        /// personal watercraft (such as a Jet Ski).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("watercraftRental")]
        public virtual System.Nullable<bool> WatercraftRental { get; set; }

        /// <summary>Watercraft rental exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("watercraftRentalException")]
        public virtual string WatercraftRentalException { get; set; }

        /// <summary>
        /// Free watercraft rental. The hotel owns watercraft that it permits guests to borrow and use for free.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeWatercraftRental")]
        public virtual System.Nullable<bool> FreeWatercraftRental { get; set; }

        /// <summary>Free Watercraft rental exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeWatercraftRentalException")]
        public virtual string FreeWatercraftRentalException { get; set; }

        /// <summary>
        /// Beach access. The hotel property is in close proximity to a beach and offers a way to get to that beach.
        /// This can include a route to the beach such as stairs down if hotel is on a bluff, or a short trail. Not the
        /// same as beachfront (with beach access, the hotel's proximity is close to but not right on the beach).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("beachAccess")]
        public virtual System.Nullable<bool> BeachAccess { get; set; }

        /// <summary>Beach access exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("beachAccessException")]
        public virtual string BeachAccessException { get; set; }

        /// <summary>Private beach. The beach which is in close proximity to the hotel is open only to guests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateBeach")]
        public virtual System.Nullable<bool> PrivateBeach { get; set; }

        /// <summary>Private beach exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateBeachException")]
        public virtual string PrivateBeachException { get; set; }

        /// <summary>
        /// Breach front. The hotel property is physically located on the beach alongside an ocean, sea, gulf, or bay.
        /// It is not on a lake, river, stream, or pond. The hotel is not separated from the beach by a public road
        /// allowing vehicular, pedestrian, or bicycle traffic.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("beachFront")]
        public virtual System.Nullable<bool> BeachFront { get; set; }

        /// <summary>Beach front exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("beachFrontException")]
        public virtual string BeachFrontException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Additional information that is surfaced in AdWords.</summary>
    public class AdWordsLocationExtensions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// An alternate phone number to display on AdWords location extensions instead of the location's primary phone
        /// number.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adPhone")]
        public virtual string AdPhone { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Input for ADDRESS verification.</summary>
    public class AddressInput : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Contact name the mail should be sent to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mailerContactName")]
        public virtual string MailerContactName { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Display data for verifications through postcard.</summary>
    public class AddressVerificationData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Merchant's business name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("businessName")]
        public virtual string BusinessName { get; set; }

        /// <summary>Address that a postcard can be sent to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("address")]
        public virtual PostalAddress Address { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>An administrator of an Account or a Location.</summary>
    public class Admin : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The resource name. For account admins, this is in the form: `accounts/{account_id}/admins/{admin_id}` For
        /// location admins, this is in the form: `accounts/{account_id}/locations/{location_id}/admins/{admin_id}`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// The name of the admin. When making the initial invitation, this is the invitee's email address. On `GET`
        /// calls, the user's email address is returned if the invitation is still pending. Otherwise, it contains the
        /// user's first and last names.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adminName")]
        public virtual string AdminName { get; set; }

        /// <summary>
        /// Specifies the AdminRole that this admin uses with the specified Account or Location resource.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("role")]
        public virtual string Role { get; set; }

        /// <summary>
        /// Output only. Indicates whether this admin has a pending invitation for the specified resource.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pendingInvitation")]
        public virtual System.Nullable<bool> PendingInvitation { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents an answer to a question</summary>
    public class Answer : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. The unique name for the answer accounts/*/locations/*/questions/*/answers/*</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Output only. The author of the answer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("author")]
        public virtual Author Author { get; set; }

        /// <summary>Output only. The number of upvotes for the answer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("upvoteCount")]
        public virtual System.Nullable<int> UpvoteCount { get; set; }

        /// <summary>
        /// The text of the answer. It should contain at least one non-whitespace character. The maximum length is 4096
        /// characters.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("text")]
        public virtual string Text { get; set; }

        /// <summary>Output only. The timestamp for when the answer was written.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("createTime")]
        public virtual object CreateTime { get; set; }

        /// <summary>Output only. The timestamp for when the answer was last modified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateTime")]
        public virtual object UpdateTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Locations.AssociateLocationRequest.</summary>
    public class AssociateLocationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The association to establish. If not set, it indicates no match.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("placeId")]
        public virtual string PlaceId { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A location attribute. Attributes provide additional information about a location. The attributes that can be set
    /// on a location may vary based on the properties of that location (for example, category). Available attributes
    /// are determined by Google and may be added and removed without API changes.
    /// </summary>
    public class Attribute : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ID of the attribute. Attribute IDs are provided by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attributeId")]
        public virtual string AttributeId { get; set; }

        /// <summary>
        /// Output only. The type of value that this attribute contains. This should be used to determine how to
        /// interpret the value.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valueType")]
        public virtual string ValueType { get; set; }

        /// <summary>
        /// The values for this attribute. The type of the values supplied must match that expected for that attribute;
        /// see [AttributeValueType](/my-business/reference/rest/v4/AttributeValueType). This is a repeated field where
        /// multiple attribute values may be provided. Attribute types only support one value.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("values")]
        public virtual System.Collections.Generic.IList<object> Values { get; set; }

        /// <summary>
        /// When the attribute value type is REPEATED_ENUM, this contains the attribute value, and the other values
        /// fields must be empty.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("repeatedEnumValue")]
        public virtual RepeatedEnumAttributeValue RepeatedEnumValue { get; set; }

        /// <summary>
        /// When the attribute value type is URL, this field contains the value(s) for this attribute, and the other
        /// values fields must be empty.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("urlValues")]
        public virtual System.Collections.Generic.IList<UrlAttributeValue> UrlValues { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Metadata for an attribute. Contains display information for the attribute, including a localized name and a
    /// heading for grouping related attributes together.
    /// </summary>
    public class AttributeMetadata : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ID of the attribute.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attributeId")]
        public virtual string AttributeId { get; set; }

        /// <summary>
        /// The value type for the attribute. Values set and retrieved should be expected to be of this type.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valueType")]
        public virtual string ValueType { get; set; }

        /// <summary>
        /// The localized display name for the attribute, if available; otherwise, the English display name.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>
        /// The localized display name of the group that contains this attribute, if available; otherwise, the English
        /// group name. Related attributes are collected into a group and should be displayed together under the heading
        /// given here.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("groupDisplayName")]
        public virtual string GroupDisplayName { get; set; }

        /// <summary>
        /// If true, the attribute supports multiple values. If false, only a single value should be provided.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isRepeatable")]
        public virtual System.Nullable<bool> IsRepeatable { get; set; }

        /// <summary>
        /// For some types of attributes (for example, enums), a list of supported values and corresponding display
        /// names for those values is provided.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valueMetadata")]
        public virtual System.Collections.Generic.IList<AttributeValueMetadata> ValueMetadata { get; set; }

        /// <summary>
        /// If true, the attribute is deprecated and should no longer be used. If deprecated, updating this attribute
        /// will not result in an error, but updates will not be saved. At some point after being deprecated, the
        /// attribute will be removed entirely and it will become an error.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isDeprecated")]
        public virtual System.Nullable<bool> IsDeprecated { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Metadata for supported attribute values.</summary>
    public class AttributeValueMetadata : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The attribute value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual object Value { get; set; }

        /// <summary>
        /// The display name for this value, localized where available; otherwise, in English. The value display name is
        /// intended to be used in context with the attribute display name. For example, for a "WiFi" enum attribute,
        /// this could contain "Paid" to represent paid Wi-Fi.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Attribution information for customer media items, such as the contributor's name and profile picture.
    /// </summary>
    public class Attribution : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The user name to attribute the media item to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("profileName")]
        public virtual string ProfileName { get; set; }

        /// <summary>URL of the attributed user's profile photo thumbnail.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("profilePhotoUrl")]
        public virtual string ProfilePhotoUrl { get; set; }

        /// <summary>
        /// The URL of the takedown page, where the media item can be reported if it is inappropriate.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("takedownUrl")]
        public virtual string TakedownUrl { get; set; }

        /// <summary>The URL of the attributed user's Google Maps profile page.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("profileUrl")]
        public virtual string ProfileUrl { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents the author of a question or answer</summary>
    public class Author : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The display name of the user</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>The profile photo URL of the user.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("profilePhotoUrl")]
        public virtual string ProfilePhotoUrl { get; set; }

        /// <summary>The type of user the author is.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("type")]
        public virtual string Type { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A request for basic metric insights.</summary>
    public class BasicMetricsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// A collection of metrics to return values for including the options for how the data should be returned.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metricRequests")]
        public virtual System.Collections.Generic.IList<MetricRequest> MetricRequests { get; set; }

        /// <summary>
        /// The range to gather metrics for. The maximum range is 18 months from the request date. In some cases, the
        /// data may still be missing for days close to the request date. Missing data will be specified in the
        /// `metricValues` in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeRange")]
        public virtual TimeRange TimeRange { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for BusinessCategories.BatchGetBusinessCategories.</summary>
    public class BatchGetBusinessCategoriesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Categories that match the GConcept ids provided in the request. They will not come in the same order as
        /// category ids in the request.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("categories")]
        public virtual System.Collections.Generic.IList<Category> Categories { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Locations.BatchGetLocations.</summary>
    public class BatchGetLocationsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of locations to fetch, specified by their names.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationNames")]
        public virtual System.Collections.Generic.IList<string> LocationNames { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Locations.BatchGetLocations.</summary>
    public class BatchGetLocationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of locations.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<Location> Locations { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Reviews.BatchGetReviews.</summary>
    public class BatchGetReviewsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of locations to fetch reviews for, specified by their names.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationNames")]
        public virtual System.Collections.Generic.IList<string> LocationNames { get; set; }

        /// <summary>How many reviews to fetch per page. The default value is 200.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pageSize")]
        public virtual System.Nullable<int> PageSize { get; set; }

        /// <summary>If specified, it fetches the next page of reviews.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pageToken")]
        public virtual string PageToken { get; set; }

        /// <summary>
        /// Optional. Specifies the field to sort reviews by. If unspecified, the order of reviews returned will default
        /// to `update_time desc`. Valid orders to sort by are `rating`, `rating desc` and `update_time desc`. `rating`
        /// will return reviews in ascending order. `update_time`(i.e. ascending order) is not supported.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("orderBy")]
        public virtual string OrderBy { get; set; }

        /// <summary>Whether to ignore rating-only reviews.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ignoreRatingOnlyReviews")]
        public virtual System.Nullable<bool> IgnoreRatingOnlyReviews { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Reviews.BatchGetReviews.</summary>
    public class BatchGetReviewsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Reviews with location information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationReviews")]
        public virtual System.Collections.Generic.IList<LocationReview> LocationReviews { get; set; }

        /// <summary>
        /// If the number of reviews exceeded the requested page size, this field is populated with a token to fetch the
        /// next page of reviews on a subsequent calls. If there are no more reviews, this field will not be present in
        /// the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Features of the property of specific interest to the business traveler.</summary>
    public class Business : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Business center. A designated room at the hotel with one or more desks and equipped with guest-use
        /// computers, printers, fax machines and/or photocopiers. May or may not be open 24/7. May or may not require a
        /// key to access. Not a meeting room or conference room.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("businessCenter")]
        public virtual System.Nullable<bool> BusinessCenter { get; set; }

        /// <summary>Business center exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("businessCenterException")]
        public virtual string BusinessCenterException { get; set; }

        /// <summary>
        /// Meeting rooms. Rooms at the hotel designated for business-related gatherings. Rooms are usually equipped
        /// with tables or desks, office chairs and audio/visual facilities to allow for presentations and conference
        /// calls. Also known as conference rooms.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("meetingRooms")]
        public virtual System.Nullable<bool> MeetingRooms { get; set; }

        /// <summary>Meeting rooms exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("meetingRoomsException")]
        public virtual string MeetingRoomsException { get; set; }

        /// <summary>Meeting rooms count. The number of meeting rooms at the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("meetingRoomsCount")]
        public virtual System.Nullable<int> MeetingRoomsCount { get; set; }

        /// <summary>Meeting rooms count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("meetingRoomsCountException")]
        public virtual string MeetingRoomsCountException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents the time periods that this location is open for business. Holds a collection of TimePeriod instances.
    /// </summary>
    public class BusinessHours : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// A collection of times that this location is open for business. Each period represents a range of hours when
        /// the location is open during the week.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("periods")]
        public virtual System.Collections.Generic.IList<TimePeriod> Periods { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>An action that is performed when the user clicks through the post</summary>
    public class CallToAction : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The type of action that will be performed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("actionType")]
        public virtual string ActionType { get; set; }

        /// <summary>
        /// The URL the user will be directed to upon clicking. This field should be left unset for Call CTA.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("url")]
        public virtual string Url { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// This message denotes calories information with an upper bound and lower bound range. Lower amount must be
    /// specified. Both lower and upper amounts are non-negative numbers.
    /// </summary>
    public class CaloriesFact : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Lower amount of calories</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lowerAmount")]
        public virtual System.Nullable<int> LowerAmount { get; set; }

        /// <summary>Optional. Upper amount of calories</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("upperAmount")]
        public virtual System.Nullable<int> UpperAmount { get; set; }

        /// <summary>Required. Unit of the given calories information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("unit")]
        public virtual string Unit { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A category describing what this business is (not what it does). For a list of valid category IDs, and the
    /// mappings to their human-readable names, see
    /// [categories.list](https://developers.google.com/my-business/reference/rest/v4/categories/list).
    /// </summary>
    public class Category : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// @OutputOnly. The human-readable name of the category. This is set when reading the location. When modifying
        /// the location, `category_id` must be set.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>
        /// @OutputOnly. A stable ID (provided by Google) for this category. The `category_id` must be specified when
        /// modifying the category (when creating or updating a location).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("categoryId")]
        public virtual string CategoryId { get; set; }

        /// <summary>
        /// @OutputOnly. A list of all the service types that are available for this business category.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("serviceTypes")]
        public virtual System.Collections.Generic.IList<ServiceType> ServiceTypes { get; set; }

        /// <summary>Output only. More hours types that are available for this business category.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("moreHoursTypes")]
        public virtual System.Collections.Generic.IList<MoreHoursType> MoreHoursTypes { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A chain is a brand that your business's locations can be affiliated with.</summary>
    public class Chain : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The chain's resource name, in the format `chains/{chain_place_id}`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Names of the chain.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("chainNames")]
        public virtual System.Collections.Generic.IList<ChainName> ChainNames { get; set; }

        /// <summary>Websites of the chain.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("websites")]
        public virtual System.Collections.Generic.IList<ChainUrl> Websites { get; set; }

        /// <summary>Number of locations that are part of this chain.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationCount")]
        public virtual System.Nullable<int> LocationCount { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Name to be used when displaying the chain.</summary>
    public class ChainName : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The display name for this chain.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>The BCP 47 code of language of the name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Url to be used when displaying the chain.</summary>
    public class ChainUrl : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The url for this chain.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("url")]
        public virtual string Url { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Locations.ClearLocationAssociationRequest.</summary>
    public class ClearLocationAssociationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Verifications.CompleteVerificationAction.</summary>
    public class CompleteVerificationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>PIN code received by the merchant to complete the verification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pin")]
        public virtual string Pin { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Verifications.CompleteVerificationAction.</summary>
    public class CompleteVerificationResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The completed verification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("verification")]
        public virtual Verification Verification { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>The ways in which the property provides guests with the ability to access the internet.</summary>
    public class Connectivity : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Wifi available. The hotel provides the ability for guests to wirelessly connect to the internet. Can be in
        /// the public areas of the hotel and/or in the guest rooms. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wifiAvailable")]
        public virtual System.Nullable<bool> WifiAvailable { get; set; }

        /// <summary>Wifi available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wifiAvailableException")]
        public virtual string WifiAvailableException { get; set; }

        /// <summary>Free wifi. The hotel offers guests wifi for free.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeWifi")]
        public virtual System.Nullable<bool> FreeWifi { get; set; }

        /// <summary>Free wifi exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeWifiException")]
        public virtual string FreeWifiException { get; set; }

        /// <summary>
        /// Public area wifi available. Guests have the ability to wirelessly connect to the internet in the areas of
        /// the hotel accessible to anyone. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("publicAreaWifiAvailable")]
        public virtual System.Nullable<bool> PublicAreaWifiAvailable { get; set; }

        /// <summary>Public area wifi available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("publicAreaWifiAvailableException")]
        public virtual string PublicAreaWifiAvailableException { get; set; }

        /// <summary>
        /// Public internet terminal. An area of the hotel supplied with computers and designated for the purpose of
        /// providing guests with the ability to access the internet.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("publicInternetTerminal")]
        public virtual System.Nullable<bool> PublicInternetTerminal { get; set; }

        /// <summary>Public internet terminal exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("publicInternetTerminalException")]
        public virtual string PublicInternetTerminalException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a whole or partial calendar date, such as a birthday. The time of day and time zone are either
    /// specified elsewhere or are insignificant. The date is relative to the Gregorian Calendar. This can represent one
    /// of the following: * A full date, with non-zero year, month, and day values * A month and day value, with a zero
    /// year, such as an anniversary * A year on its own, with zero month and day values * A year and month value, with
    /// a zero day, such as a credit card expiration date Related types are google.type.TimeOfDay and
    /// `google.protobuf.Timestamp`.
    /// </summary>
    public class Date : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Year of the date. Must be from 1 to 9999, or 0 to specify a date without a year.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("year")]
        public virtual System.Nullable<int> Year { get; set; }

        /// <summary>Month of a year. Must be from 1 to 12, or 0 to specify a year without a month and day.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("month")]
        public virtual System.Nullable<int> Month { get; set; }

        /// <summary>
        /// Day of a month. Must be from 1 to 31 and valid for the year and month, or 0 to specify a year by itself or a
        /// year and month where the day isn't significant.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("day")]
        public virtual System.Nullable<int> Day { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for AccessControl.DeclineInvitation.</summary>
    public class DeclineInvitationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A value for a single metric with a given time dimension.</summary>
    public class DimensionalMetricValue : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The option that requested this dimensional value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metricOption")]
        public virtual string MetricOption { get; set; }

        /// <summary>The dimension for the value.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeDimension")]
        public virtual TimeDimension TimeDimension { get; set; }

        /// <summary>The value. If no value is set, then the requested data is missing.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("value")]
        public virtual System.Nullable<long> Value { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Dimensions of the media item.</summary>
    public class Dimensions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Width of the media item, in pixels.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("widthPixels")]
        public virtual System.Nullable<int> WidthPixels { get; set; }

        /// <summary>Height of the media item, in pixels.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heightPixels")]
        public virtual System.Nullable<int> HeightPixels { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A request for driving direction insights.</summary>
    public class DrivingDirectionMetricsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The number of days to aggregate data for. Results returned will be available data over the last number of
        /// requested days. Valid values are 7, 30, and 90.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("numDays")]
        public virtual string NumDays { get; set; }

        /// <summary>
        /// The BCP 47 code for the language. If a language code is not provided, it defaults to English.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Information about the location that this location duplicates.</summary>
    public class Duplicate : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The resource name of the location that this duplicates. Only populated if the authenticated user has access
        /// rights to that location and that location is not deleted.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationName")]
        public virtual string LocationName { get; set; }

        /// <summary>The place ID of the location that this duplicates.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("placeId")]
        public virtual string PlaceId { get; set; }

        /// <summary>Indicates whether the user has access to the location it duplicates.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("access")]
        public virtual string Access { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Input for EMAIL verification.</summary>
    public class EmailInput : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Email address where the PIN should be sent to. An email address is accepted only if it is one of the
        /// addresses provided by FetchVerificationOptions. If the EmailVerificationData has is_user_name_editable set
        /// to true, the client may specify a different user name (local-part) but must match the domain name.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("emailAddress")]
        public virtual string EmailAddress { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Display data for verifications through email.</summary>
    public class EmailVerificationData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Domain name in the email address. e.g. "gmail.com" in foo@gmail.com</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("domainName")]
        public virtual string DomainName { get; set; }

        /// <summary>User name in the email address. e.g. "foo" in foo@gmail.com</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("userName")]
        public virtual string UserName { get; set; }

        /// <summary>Whether client is allowed to provide a different user name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isUserNameEditable")]
        public virtual System.Nullable<bool> IsUserNameEditable { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A generic empty message that you can re-use to avoid defining duplicated empty messages in your APIs. A typical
    /// example is to use it as the request or the response type of an API method. For instance: service Foo { rpc
    /// Bar(google.protobuf.Empty) returns (google.protobuf.Empty); } The JSON representation for `Empty` is empty JSON
    /// object `{}`.
    /// </summary>
    public class Empty : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Enhanced cleaning measures implemented by the hotel during COVID-19.</summary>
    public class EnhancedCleaning : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Enhanced cleaning of common areas.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonAreasEnhancedCleaning")]
        public virtual System.Nullable<bool> CommonAreasEnhancedCleaning { get; set; }

        /// <summary>Common areas enhanced cleaning exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonAreasEnhancedCleaningException")]
        public virtual string CommonAreasEnhancedCleaningException { get; set; }

        /// <summary>Enhanced cleaning of guest rooms.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("guestRoomsEnhancedCleaning")]
        public virtual System.Nullable<bool> GuestRoomsEnhancedCleaning { get; set; }

        /// <summary>Guest rooms enhanced cleaning exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("guestRoomsEnhancedCleaningException")]
        public virtual string GuestRoomsEnhancedCleaningException { get; set; }

        /// <summary>Commercial-grade disinfectant used to clean the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commercialGradeDisinfectantCleaning")]
        public virtual System.Nullable<bool> CommercialGradeDisinfectantCleaning { get; set; }

        /// <summary>Commercial grade disinfectant cleaning exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commercialGradeDisinfectantCleaningException")]
        public virtual string CommercialGradeDisinfectantCleaningException { get; set; }

        /// <summary>Employees trained in COVID-19 cleaning procedures.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("employeesTrainedCleaningProcedures")]
        public virtual System.Nullable<bool> EmployeesTrainedCleaningProcedures { get; set; }

        /// <summary>Employees trained cleaning procedures exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("employeesTrainedCleaningProceduresException")]
        public virtual string EmployeesTrainedCleaningProceduresException { get; set; }

        /// <summary>Employees trained in thorough hand-washing.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("employeesTrainedThoroughHandWashing")]
        public virtual System.Nullable<bool> EmployeesTrainedThoroughHandWashing { get; set; }

        /// <summary>Employees trained thorough hand washing exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("employeesTrainedThoroughHandWashingException")]
        public virtual string EmployeesTrainedThoroughHandWashingException { get; set; }

        /// <summary>Employees wear masks, face shields, and/or gloves.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("employeesWearProtectiveEquipment")]
        public virtual System.Nullable<bool> EmployeesWearProtectiveEquipment { get; set; }

        /// <summary>Employees wear protective equipment exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("employeesWearProtectiveEquipmentException")]
        public virtual string EmployeesWearProtectiveEquipmentException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Services and amenities for families and young guests.</summary>
    public class Families : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Babysitting. Child care that is offered by hotel staffers or coordinated by hotel staffers with local child
        /// care professionals. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("babysitting")]
        public virtual System.Nullable<bool> Babysitting { get; set; }

        /// <summary>Babysitting exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("babysittingException")]
        public virtual string BabysittingException { get; set; }

        /// <summary>
        /// Kids activities. Recreational options such as sports, films, crafts and games designed for the enjoyment of
        /// children and offered at the hotel. May or may not be supervised. May or may not be at a designated time or
        /// place. Cab be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kidsActivities")]
        public virtual System.Nullable<bool> KidsActivities { get; set; }

        /// <summary>Kids activities exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kidsActivitiesException")]
        public virtual string KidsActivitiesException { get; set; }

        /// <summary>
        /// Kids club. An organized program of group activities held at the hotel and designed for the enjoyment of
        /// children. Facilitated by hotel staff (or staff procured by the hotel) in an area(s) designated for the
        /// purpose of entertaining children without their parents. May include games, outings, water sports, team
        /// sports, arts and crafts, and films. Usually has set hours. Can be free or for a fee. Also known as Kids Camp
        /// or Kids program.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kidsClub")]
        public virtual System.Nullable<bool> KidsClub { get; set; }

        /// <summary>Kids club exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kidsClubException")]
        public virtual string KidsClubException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Verifications.FetchVerificationOptions.</summary>
    public class FetchVerificationOptionsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The BCP 47 language code representing the language that is to be used for the verification process.
        /// Available options vary by language.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>
        /// Extra context information for the verification of service businesses. Required for the locations whose
        /// business type is CUSTOMER_LOCATION_ONLY. INVALID_ARGUMENT will be thrown if it is set for other business
        /// types of locations.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("context")]
        public virtual ServiceBusinessContext Context { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Verifications.FetchVerificationOptions.</summary>
    public class FetchVerificationOptionsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The available verification options.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("options")]
        public virtual System.Collections.Generic.IList<VerificationOption> Options { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Locations.FindMatchingLocations.</summary>
    public class FindMatchingLocationsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The preferred language for the matching location (in BCP-47 format).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>
        /// The number of matches to return. The default value is 3, with a maximum of 10. Note that latency may
        /// increase if more are requested. There is no pagination.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("numResults")]
        public virtual System.Nullable<int> NumResults { get; set; }

        /// <summary>Deprecated. This field is ignored for all requests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxCacheDuration")]
        public virtual object MaxCacheDuration { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Locations.FindMatchingLocations.</summary>
    public class FindMatchingLocationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// A collection of locations that are potential matches to the specified location, listed in order from best to
        /// least match. If there is an exact match, it will be in the first position.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("matchedLocations")]
        public virtual System.Collections.Generic.IList<MatchedLocation> MatchedLocations { get; set; }

        /// <summary>When the matching algorithm was last executed for this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("matchTime")]
        public virtual object MatchTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Follower metadata for a location.</summary>
    public class FollowersMetadata : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The resource name for this. accounts/{account_id}/locations/{location_id}/followers/metadata
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Total number of followers for the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("count")]
        public virtual System.Nullable<ulong> Count { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Meals, snacks, and beverages available at the property.</summary>
    public class FoodAndDrink : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Room service. A hotel staffer delivers meals prepared onsite to a guest's room as per their request. May or
        /// may not be available during specific hours. Services should be available to all guests (not based on
        /// rate/room booked/reward program, etc).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("roomService")]
        public virtual System.Nullable<bool> RoomService { get; set; }

        /// <summary>Room service exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("roomServiceException")]
        public virtual string RoomServiceException { get; set; }

        /// <summary>24hr room service. Room service is available 24 hours a day.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("twentyFourHourRoomService")]
        public virtual System.Nullable<bool> TwentyFourHourRoomService { get; set; }

        /// <summary>24hr room service exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("twentyFourHourRoomServiceException")]
        public virtual string TwentyFourHourRoomServiceException { get; set; }

        /// <summary>
        /// Restaurant. A business onsite at the hotel that is open to the public as well as guests, and offers meals
        /// and beverages to consume at tables or counters. May or may not include table service. Also known as cafe,
        /// buffet, eatery. A "breakfast room" where the hotel serves breakfast only to guests (not the general public)
        /// does not count as a restaurant.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("restaurant")]
        public virtual System.Nullable<bool> Restaurant { get; set; }

        /// <summary>Restaurant exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("restaurantException")]
        public virtual string RestaurantException { get; set; }

        /// <summary>Restaurants count. The number of restaurants at the hotel.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("restaurantsCount")]
        public virtual System.Nullable<int> RestaurantsCount { get; set; }

        /// <summary>Restaurants count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("restaurantsCountException")]
        public virtual string RestaurantsCountException { get; set; }

        /// <summary>
        /// Table service. A restaurant in which a staff member is assigned to a guest's table to take their order,
        /// deliver and clear away food, and deliver the bill, if applicable. Also known as sit-down restaurant.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tableService")]
        public virtual System.Nullable<bool> TableService { get; set; }

        /// <summary>Table service exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tableServiceException")]
        public virtual string TableServiceException { get; set; }

        /// <summary>
        /// Buffet. A type of meal where guests serve themselves from a variety of dishes/foods that are put out on a
        /// table. Includes lunch and/or dinner meals. A breakfast-only buffet is not sufficient.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("buffet")]
        public virtual System.Nullable<bool> Buffet { get; set; }

        /// <summary>Buffet exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("buffetException")]
        public virtual string BuffetException { get; set; }

        /// <summary>
        /// Dinner buffet. Dinner meal service where guests serve themselves from a variety of dishes/foods that are put
        /// out on a table.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dinnerBuffet")]
        public virtual System.Nullable<bool> DinnerBuffet { get; set; }

        /// <summary>Dinner buffet exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dinnerBuffetException")]
        public virtual string DinnerBuffetException { get; set; }

        /// <summary>
        /// Breakfast buffet. Breakfast meal service where guests serve themselves from a variety of dishes/foods that
        /// are put out on a table.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("breakfastBuffet")]
        public virtual System.Nullable<bool> BreakfastBuffet { get; set; }

        /// <summary>Breakfast buffet exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("breakfastBuffetException")]
        public virtual string BreakfastBuffetException { get; set; }

        /// <summary>Breakfast available. The morning meal is offered to all guests. Can be free or for a fee.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("breakfastAvailable")]
        public virtual System.Nullable<bool> BreakfastAvailable { get; set; }

        /// <summary>Breakfast available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("breakfastAvailableException")]
        public virtual string BreakfastAvailableException { get; set; }

        /// <summary>
        /// Free breakfast. Breakfast is offered for free to all guests. Does not apply if limited to certain room
        /// packages.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeBreakfast")]
        public virtual System.Nullable<bool> FreeBreakfast { get; set; }

        /// <summary>Free breakfast exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeBreakfastException")]
        public virtual string FreeBreakfastException { get; set; }

        /// <summary>
        /// Bar. A designated room, lounge or area of an on-site restaurant with seating at a counter behind which a
        /// hotel staffer takes the guest's order and provides the requested alcoholic drink. Can be indoors or
        /// outdoors. Also known as Pub.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bar")]
        public virtual System.Nullable<bool> Bar { get; set; }

        /// <summary>Bar exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("barException")]
        public virtual string BarException { get; set; }

        /// <summary>
        /// Vending machine. A glass-fronted mechanized cabinet displaying and dispensing snacks and beverages for
        /// purchase by coins, paper money and/or credit cards.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vendingMachine")]
        public virtual System.Nullable<bool> VendingMachine { get; set; }

        /// <summary>Vending machine exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vendingMachineException")]
        public virtual string VendingMachineException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Menu of a business that serves food dishes.</summary>
    public class FoodMenu : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Language-tagged labels for the menu. E.g. "menu", "lunch special". Display names should be 140
        /// characters or less, with descriptions 1,000 characters or less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<MenuLabel> Labels { get; set; }

        /// <summary>Optional. Source URL of menu if there is a webpage to go to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sourceUrl")]
        public virtual string SourceUrl { get; set; }

        /// <summary>Required. Sections of the menu.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sections")]
        public virtual System.Collections.Generic.IList<FoodMenuSection> Sections { get; set; }

        /// <summary>
        /// Optional. Cuisine information for the food menu. It is highly recommended to provide this field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cuisines")]
        public virtual System.Collections.Generic.IList<string> Cuisines { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Item of a Section. It can be the dish itself, or can contain multiple FoodMenuItemOption.</summary>
    public class FoodMenuItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Language tagged labels for this menu item. Display names should be 140 characters or less, with
        /// descriptions 1,000 characters or less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<MenuLabel> Labels { get; set; }

        /// <summary>
        /// Required. Detailed attributes of the item. When item options are specified, this is considered as the base
        /// attributes and populate to each options.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attributes")]
        public virtual FoodMenuItemAttributes Attributes { get; set; }

        /// <summary>
        /// Optional. This is for an item that comes in multiple different options, and users are required to make
        /// choices. E.g. "regular" vs. "large" pizza. When options are specified, labels and attributes at item level
        /// will automatically become the first option's labels and attributes. Clients only need to specify other
        /// additional food options in this field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("options")]
        public virtual System.Collections.Generic.IList<FoodMenuItemOption> Options { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Attributes of a food item/dish.</summary>
    public class FoodMenuItemAttributes : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Price of the food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("price")]
        public virtual Money Price { get; set; }

        /// <summary>Optional. Spiciness level of the food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("spiciness")]
        public virtual string Spiciness { get; set; }

        /// <summary>
        /// Optional. Allergens associated with the food dish. It is highly recommended to provide this field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allergen")]
        public virtual System.Collections.Generic.IList<string> Allergen { get; set; }

        /// <summary>
        /// Optional. Dietary information of the food dish. It is highly recommended to provide this field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dietaryRestriction")]
        public virtual System.Collections.Generic.IList<string> DietaryRestriction { get; set; }

        /// <summary>
        /// Optional. Nutrition facts of the food dish option. It is highly recommended to provide this field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nutritionFacts")]
        public virtual NutritionFacts NutritionFacts { get; set; }

        /// <summary>Optional. Ingredients of the food dish option.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ingredients")]
        public virtual System.Collections.Generic.IList<Ingredient> Ingredients { get; set; }

        /// <summary>Optional. Number of people can be served by this food dish option.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("servesNumPeople")]
        public virtual System.Nullable<int> ServesNumPeople { get; set; }

        /// <summary>Optional. Methods on how the food dish option is prepared.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("preparationMethods")]
        public virtual System.Collections.Generic.IList<string> PreparationMethods { get; set; }

        /// <summary>
        /// Optional. Size of the order, represented in units of items. (e.g. 4 "skewers", 6 "pieces")
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("portionSize")]
        public virtual PortionSize PortionSize { get; set; }

        /// <summary>
        /// Optional. The media keys of the media associated with the dish. Only photo media is supported. When there
        /// are multiple photos associated, the first photo is considered as the preferred photo.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaKeys")]
        public virtual System.Collections.Generic.IList<string> MediaKeys { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Option of an Item. It requires an explicit user selection.</summary>
    public class FoodMenuItemOption : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Language tagged labels for this menu item option. E.g.: "beef pad thai", "veggie pad thai", "small
        /// pizza", "large pizza". Display names should be 140 characters or less, with descriptions 1,000 characters or
        /// less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<MenuLabel> Labels { get; set; }

        /// <summary>
        /// Required. Detailed attributes of the item option. Individual unspecified attributes will be inherited from
        /// the item-level attibutes as the base.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attributes")]
        public virtual FoodMenuItemAttributes Attributes { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Section of a menu. It can contain multiple items/dishes.</summary>
    public class FoodMenuSection : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Language tagged labels for this menu section. Display names should be 140 characters or less, with
        /// descriptions 1,000 characters or less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<MenuLabel> Labels { get; set; }

        /// <summary>Required. Items of the section. Each Section must have at least an item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("items")]
        public virtual System.Collections.Generic.IList<FoodMenuItem> Items { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Menus of a business that serve food dishes.</summary>
    public class FoodMenus : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Google identifier for this location in the form:
        /// `accounts/{account_id}/locations/{location_id}/foodMenus`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Optional. A collection of food menus.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("menus")]
        public virtual System.Collections.Generic.IList<FoodMenu> Menus { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a free-form service offered by the merchant. These are services that are not exposed as part of our
    /// structure service data. The merchant manually enters the names for of such services via a geomerchant surface.
    /// </summary>
    public class FreeFormServiceItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. The `category_id` and `service_type_id` should match the possible combinations provided in the
        /// `Category` message.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("categoryId")]
        public virtual string CategoryId { get; set; }

        /// <summary>
        /// Required. Language-tagged labels for the item. We recommend that item names be 140 characters or less, and
        /// descriptions 250 characters or less. This field should only be set if the input is a custom service item.
        /// Standardized service types should be updated via service_type_id.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("label")]
        public virtual Label Label { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Accounts.GenerateAccountNumber.</summary>
    public class GenerateAccountNumberRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for LodgingService.GetGoogleUpdatedLodging</summary>
    public class GetGoogleUpdatedLodgingResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. The Google updated Lodging.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lodging")]
        public virtual Lodging Lodging { get; set; }

        /// <summary>
        /// Required. The fields in the Lodging that have been updated by Google. Repeated field items are not
        /// individually specified.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffMask")]
        public virtual object DiffMask { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a Location that is present on Google. This can be a location that has been claimed by the user,
    /// someone else, or could be unclaimed.
    /// </summary>
    public class GoogleLocation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Resource name of this GoogleLocation, in the format `googleLocations/{googleLocationId}`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// The sparsely populated Location information. This field can be re-used in CreateLocation if it is not
        /// currently claimed by a user.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("location")]
        public virtual Location Location { get; set; }

        /// <summary>
        /// A URL that will redirect the user to the request admin rights UI. This field is only present if the location
        /// has already been claimed by any user, including the current user.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("requestAdminRightsUrl")]
        public virtual string RequestAdminRightsUrl { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a location that was modified by Google.</summary>
    public class GoogleUpdatedLocation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The Google-updated version of this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("location")]
        public virtual Location Location { get; set; }

        /// <summary>The fields that Google updated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diffMask")]
        public virtual object DiffMask { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Features and available amenities in the guest unit.</summary>
    public class GuestUnitFeatures : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Tier. Classification of the unit based on available features/amenities. A non-standard tier is only
        /// permitted if at least one other unit type falls under the standard tier.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tier")]
        public virtual string Tier { get; set; }

        /// <summary>Tier exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tierException")]
        public virtual string TierException { get; set; }

        /// <summary>
        /// Max occupants count. The total number of guests allowed to stay overnight in the guestroom.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxOccupantsCount")]
        public virtual System.Nullable<int> MaxOccupantsCount { get; set; }

        /// <summary>Max occupants count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxOccupantsCountException")]
        public virtual string MaxOccupantsCountException { get; set; }

        /// <summary>
        /// Max adult occupants count. The total number of adult guests allowed to stay overnight in the guestroom.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxAdultOccupantsCount")]
        public virtual System.Nullable<int> MaxAdultOccupantsCount { get; set; }

        /// <summary>Max adult occupants count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxAdultOccupantsCountException")]
        public virtual string MaxAdultOccupantsCountException { get; set; }

        /// <summary>
        /// Max child occupants count. The total number of children allowed to stay overnight in the room.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxChildOccupantsCount")]
        public virtual System.Nullable<int> MaxChildOccupantsCount { get; set; }

        /// <summary>Max child occupants count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxChildOccupantsCountException")]
        public virtual string MaxChildOccupantsCountException { get; set; }

        /// <summary>
        /// Private home. A privately owned home (house, townhouse, apartment, cabin, bungalow etc) that may or not
        /// serve as the owner's residence, but is rented out in its entirety or by the room(s) to paying guest(s) for
        /// vacation stays. Not for lease-based, long-term residency.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateHome")]
        public virtual System.Nullable<bool> PrivateHome { get; set; }

        /// <summary>Private home exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateHomeException")]
        public virtual string PrivateHomeException { get; set; }

        /// <summary>
        /// Suite. A guestroom category that implies both a bedroom area and a separate living area. There may or may
        /// not be full walls and doors separating the two areas, but regardless, they are very distinct. Does not mean
        /// a couch or chair in a bedroom.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("suite")]
        public virtual System.Nullable<bool> Suite { get; set; }

        /// <summary>Suite exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("suiteException")]
        public virtual string SuiteException { get; set; }

        /// <summary>
        /// Bungalow or villa. An independent structure that is part of a hotel or resort that is rented to one party
        /// for a vacation stay. The hotel or resort may be completely comprised of bungalows or villas, or they may be
        /// one of several guestroom options. Guests in the bungalows or villas most often have the same, if not more,
        /// amenities and services offered to guests in other guestroom types.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bungalowOrVilla")]
        public virtual System.Nullable<bool> BungalowOrVilla { get; set; }

        /// <summary>Bungalow or villa exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bungalowOrVillaException")]
        public virtual string BungalowOrVillaException { get; set; }

        /// <summary>
        /// Executive floor. A floor of the hotel where the guestrooms are only bookable by members of the hotel's
        /// frequent guest membership program. Benefits of this room class include access to a designated lounge which
        /// may or may not feature free breakfast, cocktails or other perks specific to members of the program.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("executiveFloor")]
        public virtual System.Nullable<bool> ExecutiveFloor { get; set; }

        /// <summary>Executive floor exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("executiveFloorException")]
        public virtual string ExecutiveFloorException { get; set; }

        /// <summary>
        /// Connecting unit available. A guestroom type that features access to an adjacent guestroom for the purpose of
        /// booking both rooms. Most often used by families who need more than one room to accommodate the number of
        /// people in their group.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("connectingUnitAvailable")]
        public virtual System.Nullable<bool> ConnectingUnitAvailable { get; set; }

        /// <summary>Connecting unit available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("connectingUnitAvailableException")]
        public virtual string ConnectingUnitAvailableException { get; set; }

        /// <summary>Views available from the guest unit itself.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("views")]
        public virtual ViewsFromUnit Views { get; set; }

        /// <summary>Features available in the living areas in the guest unit.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalLivingAreas")]
        public virtual LivingArea TotalLivingAreas { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A specific type of unit primarily defined by its features.</summary>
    public class GuestUnitType : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Unit or room code identifiers for a single GuestUnitType. Each code must be unique within a
        /// Lodging instance.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("codes")]
        public virtual System.Collections.Generic.IList<string> Codes { get; set; }

        /// <summary>Required. Short, English label or name of the GuestUnitType. Target &lt;50 chars.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("label")]
        public virtual string Label { get; set; }

        /// <summary>Features and available amenities of the GuestUnitType.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("features")]
        public virtual GuestUnitFeatures Features { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Health and safety measures implemented by the hotel during COVID-19.</summary>
    public class HealthAndSafety : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Enhanced cleaning measures implemented by the hotel during COVID-19.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("enhancedCleaning")]
        public virtual EnhancedCleaning EnhancedCleaning { get; set; }

        /// <summary>Increased food safety measures implemented by the hotel during COVID-19.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("increasedFoodSafety")]
        public virtual IncreasedFoodSafety IncreasedFoodSafety { get; set; }

        /// <summary>Minimized contact measures implemented by the hotel during COVID-19.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("minimizedContact")]
        public virtual MinimizedContact MinimizedContact { get; set; }

        /// <summary>Personal protection measures implemented by the hotel during COVID-19.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("personalProtection")]
        public virtual PersonalProtection PersonalProtection { get; set; }

        /// <summary>Physical distancing measures implemented by the hotel during COVID-19.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("physicalDistancing")]
        public virtual PhysicalDistancing PhysicalDistancing { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>The Health provider attributes linked with this location.</summary>
    public class HealthProviderAttributes : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Google identifier for this location in the form:
        /// `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Optional. A list of insurance networks accpected by this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("insuranceNetworks")]
        public virtual System.Collections.Generic.IList<InsuranceNetwork> InsuranceNetworks { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Conveniences provided in guest units to facilitate an easier, more comfortable stay.</summary>
    public class Housekeeping : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Housekeeping available. Guest units are cleaned by hotel staff during guest's stay. Schedule may vary from
        /// daily, weekly, or specific days of the week.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("housekeepingAvailable")]
        public virtual System.Nullable<bool> HousekeepingAvailable { get; set; }

        /// <summary>Housekeeping available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("housekeepingAvailableException")]
        public virtual string HousekeepingAvailableException { get; set; }

        /// <summary>Daily housekeeping. Guest units are cleaned by hotel staff daily during guest's stay.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dailyHousekeeping")]
        public virtual System.Nullable<bool> DailyHousekeeping { get; set; }

        /// <summary>Daily housekeeping exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dailyHousekeepingException")]
        public virtual string DailyHousekeepingException { get; set; }

        /// <summary>
        /// Turndown service. Hotel staff enters guest units to prepare the bed for sleep use. May or may not include
        /// some light housekeeping. May or may not include an evening snack or candy. Also known as evening service.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("turndownService")]
        public virtual System.Nullable<bool> TurndownService { get; set; }

        /// <summary>Turndown service exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("turndownServiceException")]
        public virtual string TurndownServiceException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Increased food safety measures implemented by the hotel during COVID-19.</summary>
    public class IncreasedFoodSafety : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Additional safety measures during food prep and serving.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("foodPreparationAndServingAdditionalSafety")]
        public virtual System.Nullable<bool> FoodPreparationAndServingAdditionalSafety { get; set; }

        /// <summary>Food preparation and serving additional safety exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("foodPreparationAndServingAdditionalSafetyException")]
        public virtual string FoodPreparationAndServingAdditionalSafetyException { get; set; }

        /// <summary>Additional sanitation in dining areas.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diningAreasAdditionalSanitation")]
        public virtual System.Nullable<bool> DiningAreasAdditionalSanitation { get; set; }

        /// <summary>Dining areas additional sanitation exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("diningAreasAdditionalSanitationException")]
        public virtual string DiningAreasAdditionalSanitationException { get; set; }

        /// <summary>Individually-packaged meals.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("individualPackagedMeals")]
        public virtual System.Nullable<bool> IndividualPackagedMeals { get; set; }

        /// <summary>Individual packaged meals exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("individualPackagedMealsException")]
        public virtual string IndividualPackagedMealsException { get; set; }

        /// <summary>Disposable flatware.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disposableFlatware")]
        public virtual System.Nullable<bool> DisposableFlatware { get; set; }

        /// <summary>Disposable flatware exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("disposableFlatwareException")]
        public virtual string DisposableFlatwareException { get; set; }

        /// <summary>Single-use menus.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("singleUseFoodMenus")]
        public virtual System.Nullable<bool> SingleUseFoodMenus { get; set; }

        /// <summary>Single use food menus exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("singleUseFoodMenusException")]
        public virtual string SingleUseFoodMenusException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>This message denotes an ingredient information of a food dish.</summary>
    public class Ingredient : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Labels to describe ingredient. Display names should be 140 characters or less, with descriptions
        /// 1,000 characters or less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<MenuLabel> Labels { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A single insurance network. Next id: 5</summary>
    public class InsuranceNetwork : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. The id of this insurance network generated by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("networkId")]
        public virtual string NetworkId { get; set; }

        /// <summary>
        /// Output only. A map of network display names in requested languages where the language is the key and
        /// localized display name is the value. The display name in English is set by default.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("networkNames")]
        public virtual System.Collections.Generic.IDictionary<string, string> NetworkNames { get; set; }

        /// <summary>
        /// Output only. A map of payer display names in requested languages where the language is the key and localized
        /// display name is the value. The display name in English is set by default.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("payerNames")]
        public virtual System.Collections.Generic.IDictionary<string, string> PayerNames { get; set; }

        /// <summary>Output only. The state of this insurance network.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Output only. Represents a pending invitation.</summary>
    public class Invitation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The resource name for the invitation.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>The sparsely populated account this invitation is for.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("targetAccount")]
        public virtual Account TargetAccount { get; set; }

        /// <summary>The target location this invitation is for.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("targetLocation")]
        public virtual TargetLocation TargetLocation { get; set; }

        /// <summary>The invited role on the account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("role")]
        public virtual string Role { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A single list item. Each variation of an item in the price list should have its own Item with its own price
    /// data.
    /// </summary>
    public class Item : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. ID for the item. Price list, section, and item IDs cannot be duplicated within this Location.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("itemId")]
        public virtual string ItemId { get; set; }

        /// <summary>
        /// Required. Language-tagged labels for the item. We recommend that item names be 140 characters or less, and
        /// descriptions 250 characters or less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<Label> Labels { get; set; }

        /// <summary>Optional. Price of the item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("price")]
        public virtual Money Price { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Label to be used when displaying the price list, section, or item.</summary>
    public class Label : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Display name for the price list, section, or item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>Optional. Description of the price list, section, or item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; }

        /// <summary>
        /// Optional. The BCP-47 language code that these strings apply for. Only one set of labels may be set per
        /// language.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Languages spoken by at least one staff member.</summary>
    public class LanguagesSpoken : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Arabic. At least one staff member speaks Arabic.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("arabicSpoken")]
        public virtual System.Nullable<bool> ArabicSpoken { get; set; }

        /// <summary>Arabic exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("arabicSpokenException")]
        public virtual string ArabicSpokenException { get; set; }

        /// <summary>Cantonese. At least one staff member speaks Cantonese.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cantoneseSpoken")]
        public virtual System.Nullable<bool> CantoneseSpoken { get; set; }

        /// <summary>Cantonese exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cantoneseSpokenException")]
        public virtual string CantoneseSpokenException { get; set; }

        /// <summary>Dutch. At least one staff member speaks Dutch.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dutchSpoken")]
        public virtual System.Nullable<bool> DutchSpoken { get; set; }

        /// <summary>Dutch exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dutchSpokenException")]
        public virtual string DutchSpokenException { get; set; }

        /// <summary>English. At least one staff member speaks English.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("englishSpoken")]
        public virtual System.Nullable<bool> EnglishSpoken { get; set; }

        /// <summary>English exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("englishSpokenException")]
        public virtual string EnglishSpokenException { get; set; }

        /// <summary>Filipino. At least one staff member speaks Filipino.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("filipinoSpoken")]
        public virtual System.Nullable<bool> FilipinoSpoken { get; set; }

        /// <summary>Filipino exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("filipinoSpokenException")]
        public virtual string FilipinoSpokenException { get; set; }

        /// <summary>French. At least one staff member speaks French.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frenchSpoken")]
        public virtual System.Nullable<bool> FrenchSpoken { get; set; }

        /// <summary>French exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frenchSpokenException")]
        public virtual string FrenchSpokenException { get; set; }

        /// <summary>German. At least one staff member speaks German.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("germanSpoken")]
        public virtual System.Nullable<bool> GermanSpoken { get; set; }

        /// <summary>German exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("germanSpokenException")]
        public virtual string GermanSpokenException { get; set; }

        /// <summary>Hindi. At least one staff member speaks Hindi.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hindiSpoken")]
        public virtual System.Nullable<bool> HindiSpoken { get; set; }

        /// <summary>Hindi exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hindiSpokenException")]
        public virtual string HindiSpokenException { get; set; }

        /// <summary>Indonesian. At least one staff member speaks Indonesian.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indonesianSpoken")]
        public virtual System.Nullable<bool> IndonesianSpoken { get; set; }

        /// <summary>Indonesian exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indonesianSpokenException")]
        public virtual string IndonesianSpokenException { get; set; }

        /// <summary>Italian. At least one staff member speaks Italian.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("italianSpoken")]
        public virtual System.Nullable<bool> ItalianSpoken { get; set; }

        /// <summary>Italian exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("italianSpokenException")]
        public virtual string ItalianSpokenException { get; set; }

        /// <summary>Japanese. At least one staff member speaks Japanese.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("japaneseSpoken")]
        public virtual System.Nullable<bool> JapaneseSpoken { get; set; }

        /// <summary>Japanese exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("japaneseSpokenException")]
        public virtual string JapaneseSpokenException { get; set; }

        /// <summary>Korean. At least one staff member speaks Korean.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("koreanSpoken")]
        public virtual System.Nullable<bool> KoreanSpoken { get; set; }

        /// <summary>Korean exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("koreanSpokenException")]
        public virtual string KoreanSpokenException { get; set; }

        /// <summary>Mandarin. At least one staff member speaks Mandarin.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mandarinSpoken")]
        public virtual System.Nullable<bool> MandarinSpoken { get; set; }

        /// <summary>Mandarin exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mandarinSpokenException")]
        public virtual string MandarinSpokenException { get; set; }

        /// <summary>Portuguese. At least one staff member speaks Portuguese.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("portugueseSpoken")]
        public virtual System.Nullable<bool> PortugueseSpoken { get; set; }

        /// <summary>Portuguese exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("portugueseSpokenException")]
        public virtual string PortugueseSpokenException { get; set; }

        /// <summary>Russian. At least one staff member speaks Russian.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("russianSpoken")]
        public virtual System.Nullable<bool> RussianSpoken { get; set; }

        /// <summary>Russian exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("russianSpokenException")]
        public virtual string RussianSpokenException { get; set; }

        /// <summary>Spanish. At least one staff member speaks Spanish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("spanishSpoken")]
        public virtual System.Nullable<bool> SpanishSpoken { get; set; }

        /// <summary>Spanish exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("spanishSpokenException")]
        public virtual string SpanishSpokenException { get; set; }

        /// <summary>Vietnamese. At least one staff member speaks Vietnamese.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vietnameseSpoken")]
        public virtual System.Nullable<bool> VietnameseSpoken { get; set; }

        /// <summary>Vietnamese exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("vietnameseSpokenException")]
        public virtual string VietnameseSpokenException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// An object that represents a latitude/longitude pair. This is expressed as a pair of doubles to represent degrees
    /// latitude and degrees longitude. Unless specified otherwise, this must conform to the WGS84 standard. Values must
    /// be within normalized ranges.
    /// </summary>
    public class LatLng : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The latitude in degrees. It must be in the range [-90.0, +90.0].</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("latitude")]
        public virtual System.Nullable<double> Latitude { get; set; }

        /// <summary>The longitude in degrees. It must be in the range [-180.0, +180.0].</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("longitude")]
        public virtual System.Nullable<double> Longitude { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for AccessControl.ListAccountAdmins.</summary>
    public class ListAccountAdminsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of Admin instances.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("admins")]
        public virtual System.Collections.Generic.IList<Admin> Admins { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Accounts.ListAccounts.</summary>
    public class ListAccountsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// A collection of accounts to which the user has access. The personal account of the user doing the query will
        /// always be the first item of the result, unless it is filtered out.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accounts")]
        public virtual System.Collections.Generic.IList<Account> Accounts { get; set; }

        /// <summary>
        /// If the number of accounts exceeds the requested page size, this field is populated with a token to fetch the
        /// next page of accounts on a subsequent call to `accounts.list`. If there are no more accounts, this field is
        /// not present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for QuestionsAndAnswers.ListAnswers</summary>
    public class ListAnswersResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The requested answers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("answers")]
        public virtual System.Collections.Generic.IList<Answer> Answers { get; set; }

        /// <summary>The total number of answers posted for this question across all pages.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalSize")]
        public virtual System.Nullable<int> TotalSize { get; set; }

        /// <summary>
        /// If the number of answers exceeds the requested max page size, this field is populated with a token to fetch
        /// the next page of answers on a subsequent call. If there are no more answers, this field is not present in
        /// the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Locations.ListAttributeMetadata.</summary>
    public class ListAttributeMetadataResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of attribute metadata for the available attributes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attributes")]
        public virtual System.Collections.Generic.IList<AttributeMetadata> Attributes { get; set; }

        /// <summary>
        /// If the number of attributes exceeded the requested page size, this field will be populated with a token to
        /// fetch the next page of attributes on a subsequent call to `attributes.list`. If there are no more
        /// attributes, this field will not be present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    public class ListBusinessCategoriesResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The categories. Categories are BASIC view. They don't contain any ServiceType information.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("categories")]
        public virtual System.Collections.Generic.IList<Category> Categories { get; set; }

        /// <summary>The total number of categories for the request parameters.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalCategoryCount")]
        public virtual System.Nullable<int> TotalCategoryCount { get; set; }

        /// <summary>
        /// If the number of categories exceeded the requested page size, this field will be populated with a token to
        /// fetch the next page of categories on a subsequent call to `ListBusinessCategories`.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Media.ListCustomerMediaItems.</summary>
    public class ListCustomerMediaItemsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The returned list of media items.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaItems")]
        public virtual System.Collections.Generic.IList<MediaItem> MediaItems { get; set; }

        /// <summary>
        /// The total number of media items for this location, irrespective of pagination. This number is approximate,
        /// particularly when there are multiple pages of results.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalMediaItemCount")]
        public virtual System.Nullable<int> TotalMediaItemCount { get; set; }

        /// <summary>
        /// If there are more media items than the requested page size, then this field is populated with a token to
        /// fetch the next page of media items on a subsequent call to ListCustomerMediaItems.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for InsuranceNetworkService.ListInsuranceNetworks</summary>
    public class ListInsuranceNetworksResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A list of insurance networks that are supported by Google.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("networks")]
        public virtual System.Collections.Generic.IList<InsuranceNetwork> Networks { get; set; }

        /// <summary>
        /// If there are more insurance networks than the requested page size, then this field is populated with a token
        /// to fetch the next page of insurance networks on a subsequent call to ListInsuranceNetworks.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for AccessControl.ListInvitations.</summary>
    public class ListInvitationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// A collection of location invitations that are pending for the account. The number of invitations listed here
        /// cannot exceed 1000.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("invitations")]
        public virtual System.Collections.Generic.IList<Invitation> Invitations { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for ListLocalPosts</summary>
    public class ListLocalPostsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The returned list of local posts.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localPosts")]
        public virtual System.Collections.Generic.IList<LocalPost> LocalPosts { get; set; }

        /// <summary>
        /// If there are more local posts than the requested page size, then this field is populated with a token to
        /// fetch the next page of local posts on a subsequent call to `ListLocalPosts`.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for AccessControl.ListLocationAdmins.</summary>
    public class ListLocationAdminsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of Admin instances.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("admins")]
        public virtual System.Collections.Generic.IList<Admin> Admins { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Locations.ListLocations.</summary>
    public class ListLocationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The locations.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locations")]
        public virtual System.Collections.Generic.IList<Location> Locations { get; set; }

        /// <summary>
        /// If the number of locations exceeded the requested page size, this field is populated with a token to fetch
        /// the next page of locations on a subsequent call to `ListLocations`. If there are no more locations, this
        /// field is not present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The approximate number of Locations in the list irrespective of pagination.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalSize")]
        public virtual System.Nullable<int> TotalSize { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Media.ListMediaItems.</summary>
    public class ListMediaItemsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The returned list of media items.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaItems")]
        public virtual System.Collections.Generic.IList<MediaItem> MediaItems { get; set; }

        /// <summary>The total number of media items for this location, irrespective of pagination.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalMediaItemCount")]
        public virtual System.Nullable<int> TotalMediaItemCount { get; set; }

        /// <summary>
        /// If there are more media items than the requested page size, then this field is populated with a token to
        /// fetch the next page of media items on a subsequent call to ListMediaItems.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for QuestionsAndAnswers.ListQuestions</summary>
    public class ListQuestionsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The requested questions,</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("questions")]
        public virtual System.Collections.Generic.IList<Question> Questions { get; set; }

        /// <summary>The total number of questions posted for this location across all pages.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalSize")]
        public virtual System.Nullable<int> TotalSize { get; set; }

        /// <summary>
        /// If the number of questions exceeds the requested max page size, this field is populated with a token to
        /// fetch the next page of questions on a subsequent call. If there are no more questions, this field is not
        /// present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Response message for GoogleLocations.ListRecommendedGoogleLocations. It also contains some locations that have
    /// been claimed by other GMB users since the last time they were recommended to this GMB account.
    /// </summary>
    public class ListRecommendedGoogleLocationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The locations recommended to a GMB account. Each of these represents a GoogleLocation that is present on
        /// Maps. The locations are sorted in decreasing order of relevance to the GMB account.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("googleLocations")]
        public virtual System.Collections.Generic.IList<GoogleLocation> GoogleLocations { get; set; }

        /// <summary>
        /// The total number of recommended locations for this GMB account, irrespective of pagination.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalSize")]
        public virtual System.Nullable<int> TotalSize { get; set; }

        /// <summary>
        /// During pagination, if there are more locations available to be fetched in the next page, this field is
        /// populated with a token to fetch the next page of locations in a subsequent call. If there are no more
        /// locations to be fetched, this field is not present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Reviews.ListReviews.</summary>
    public class ListReviewsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The reviews.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviews")]
        public virtual System.Collections.Generic.IList<Review> Reviews { get; set; }

        /// <summary>
        /// The average star rating of all reviews for this location on a scale of 1 to 5, where 5 is the highest
        /// rating.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("averageRating")]
        public virtual System.Nullable<double> AverageRating { get; set; }

        /// <summary>The total number of reviews for this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalReviewCount")]
        public virtual System.Nullable<int> TotalReviewCount { get; set; }

        /// <summary>
        /// If the number of reviews exceeded the requested page size, this field is populated with a token to fetch the
        /// next page of reviews on a subsequent call to ListReviews. If there are no more reviews, this field is not
        /// present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Verifications.ListVerifications.</summary>
    public class ListVerificationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>List of the verifications.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("verifications")]
        public virtual System.Collections.Generic.IList<Verification> Verifications { get; set; }

        /// <summary>
        /// If the number of verifications exceeded the requested page size, this field will be populated with a token
        /// to fetch the next page of verification on a subsequent call. If there are no more attributes, this field
        /// will not be present in the response.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nextPageToken")]
        public virtual string NextPageToken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>An individual room, such as kitchen, bathroom, bedroom, within a bookable guest unit.</summary>
    public class LivingArea : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Information about the layout of the living area.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("layout")]
        public virtual LivingAreaLayout Layout { get; set; }

        /// <summary>Features in the living area.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("features")]
        public virtual LivingAreaFeatures Features { get; set; }

        /// <summary>Information about eating features in the living area.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("eating")]
        public virtual LivingAreaEating Eating { get; set; }

        /// <summary>Information about sleeping features in the living area.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sleeping")]
        public virtual LivingAreaSleeping Sleeping { get; set; }

        /// <summary>Accessibility features of the living area.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accessibility")]
        public virtual LivingAreaAccessibility Accessibility { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Accessibility features of the living area.</summary>
    public class LivingAreaAccessibility : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Mobility-accessible unit. A guestroom designed to accommodate the physical challenges of a guest with
        /// mobility and/or auditory and/or visual issues. Usually features enlarged doorways, roll-in showers with
        /// seats, bathroom grab bars, and communication equipment for the hearing and sight challenged.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleUnit")]
        public virtual System.Nullable<bool> MobilityAccessibleUnit { get; set; }

        /// <summary>Mobility-accessible unit exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleUnitException")]
        public virtual string MobilityAccessibleUnitException { get; set; }

        /// <summary>
        /// ADA compliant unit. A guestroom designed to accommodate the physical challenges of a guest with mobility
        /// and/or auditory and/or visual issues, as determined by legislative policy. Usually features enlarged
        /// doorways, roll-in showers with seats, bathroom grab bars, and communication equipment for the hearing and
        /// sight challenged.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adaCompliantUnit")]
        public virtual System.Nullable<bool> AdaCompliantUnit { get; set; }

        /// <summary>ADA compliant unit exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adaCompliantUnitException")]
        public virtual string AdaCompliantUnitException { get; set; }

        /// <summary>
        /// Hearing-accessible unit. A guestroom designed to accommodate the physical challenges of a guest with
        /// auditory issues.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hearingAccessibleUnit")]
        public virtual System.Nullable<bool> HearingAccessibleUnit { get; set; }

        /// <summary>Hearing-accessible unit exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hearingAccessibleUnitException")]
        public virtual string HearingAccessibleUnitException { get; set; }

        /// <summary>
        /// Mobility-accessible shower. A shower with an enlarged door or access point to accommodate a wheelchair or a
        /// waterproof seat for the physically challenged.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleShower")]
        public virtual System.Nullable<bool> MobilityAccessibleShower { get; set; }

        /// <summary>Mobility-accessible shower exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleShowerException")]
        public virtual string MobilityAccessibleShowerException { get; set; }

        /// <summary>
        /// Mobility-accessible bathtub. A bathtub that accomodates the physically challenged with additional railings
        /// or hand grips, a transfer seat or lift, and/or a door to enable walking into the tub.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleBathtub")]
        public virtual System.Nullable<bool> MobilityAccessibleBathtub { get; set; }

        /// <summary>Mobility-accessible bathtub exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleBathtubException")]
        public virtual string MobilityAccessibleBathtubException { get; set; }

        /// <summary>
        /// Mobility-accessible toilet. A toilet with a higher seat, grab bars, and/or a larger area around it to
        /// accommodate the physically challenged.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleToilet")]
        public virtual System.Nullable<bool> MobilityAccessibleToilet { get; set; }

        /// <summary>Mobility-accessible toilet exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobilityAccessibleToiletException")]
        public virtual string MobilityAccessibleToiletException { get; set; }

        /// <summary>Hearing-accessible doorbell. A visual indicator(s) of a knock or ring at the door.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hearingAccessibleDoorbell")]
        public virtual System.Nullable<bool> HearingAccessibleDoorbell { get; set; }

        /// <summary>Hearing-accessible doorbell exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hearingAccessibleDoorbellException")]
        public virtual string HearingAccessibleDoorbellException { get; set; }

        /// <summary>
        /// Hearing-accessible fire alarm. A device that gives warning of a fire through flashing lights.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hearingAccessibleFireAlarm")]
        public virtual System.Nullable<bool> HearingAccessibleFireAlarm { get; set; }

        /// <summary>Hearing-accessible fire alarm exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hearingAccessibleFireAlarmException")]
        public virtual string HearingAccessibleFireAlarmException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Information about eating features in the living area.</summary>
    public class LivingAreaEating : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Kitchen available. An area of the guestroom designated for the preparation and storage of food via the
        /// presence of a refrigerator, cook top, oven and sink, as well as cutlery, dishes and cookware. Usually
        /// includes small appliances such a coffee maker and a microwave. May or may not include an automatic
        /// dishwasher.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kitchenAvailable")]
        public virtual System.Nullable<bool> KitchenAvailable { get; set; }

        /// <summary>Kitchen available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kitchenAvailableException")]
        public virtual string KitchenAvailableException { get; set; }

        /// <summary>
        /// Refrigerator. A large, climate-controlled electrical cabinet with vertical doors. Built for the purpose of
        /// chilling and storing perishable foods.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("refrigerator")]
        public virtual System.Nullable<bool> Refrigerator { get; set; }

        /// <summary>Refrigerator exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("refrigeratorException")]
        public virtual string RefrigeratorException { get; set; }

        /// <summary>
        /// Dishwasher. A counter-height electrical cabinet containing racks for dirty dishware, cookware and cutlery,
        /// and a dispenser for soap built into the pull-down door. The cabinet is attached to the plumbing system to
        /// facilitate the automatic cleaning of its contents.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dishwasher")]
        public virtual System.Nullable<bool> Dishwasher { get; set; }

        /// <summary>Dishwasher exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dishwasherException")]
        public virtual string DishwasherException { get; set; }

        /// <summary>
        /// Stove. A kitchen appliance powered by gas or electricity for the purpose of creating a flame or hot surface
        /// on which pots of food can be cooked. Also known as cooktop or hob.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("stove")]
        public virtual System.Nullable<bool> Stove { get; set; }

        /// <summary>Stove exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("stoveException")]
        public virtual string StoveException { get; set; }

        /// <summary>
        /// Oven. A temperature controlled, heated metal cabinet powered by gas or electricity in which food is placed
        /// for the purpose of cooking or reheating.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("oven")]
        public virtual System.Nullable<bool> Oven { get; set; }

        /// <summary>Oven exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ovenException")]
        public virtual string OvenException { get; set; }

        /// <summary>
        /// Cookware. Kitchen pots, pans and utensils used in connection with the preparation of food.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cookware")]
        public virtual System.Nullable<bool> Cookware { get; set; }

        /// <summary>Cookware exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cookwareException")]
        public virtual string CookwareException { get; set; }

        /// <summary>
        /// Sink. A basin with a faucet attached to a water source and used for the purpose of washing and rinsing.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sink")]
        public virtual System.Nullable<bool> Sink { get; set; }

        /// <summary>Sink exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sinkException")]
        public virtual string SinkException { get; set; }

        /// <summary>
        /// Microwave. An electric oven that quickly cooks and heats food by microwave energy. Smaller than a standing
        /// or wall mounted oven. Usually placed on a kitchen counter, a shelf or tabletop or mounted above a cooktop.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("microwave")]
        public virtual System.Nullable<bool> Microwave { get; set; }

        /// <summary>Microwave exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("microwaveException")]
        public virtual string MicrowaveException { get; set; }

        /// <summary>
        /// Toaster. A small, temperature controlled electric appliance with rectangular slots at the top that are lined
        /// with heated coils for the purpose of browning slices of bread products.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("toaster")]
        public virtual System.Nullable<bool> Toaster { get; set; }

        /// <summary>Toaster exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("toasterException")]
        public virtual string ToasterException { get; set; }

        /// <summary>
        /// Indoor grill. Metal grates built into an indoor cooktop on which food is cooked over an open flame or
        /// electric heat source.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indoorGrill")]
        public virtual System.Nullable<bool> IndoorGrill { get; set; }

        /// <summary>Indoor grill exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indoorGrillException")]
        public virtual string IndoorGrillException { get; set; }

        /// <summary>
        /// Outdoor grill. Metal grates on which food is cooked over an open flame or electric heat source. Part of an
        /// outdoor apparatus that supports the grates. Also known as barbecue grill or barbecue.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("outdoorGrill")]
        public virtual System.Nullable<bool> OutdoorGrill { get; set; }

        /// <summary>Outdoor grill exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("outdoorGrillException")]
        public virtual string OutdoorGrillException { get; set; }

        /// <summary>
        /// Minibar. A small refrigerated cabinet in the guestroom containing bottles/cans of soft drinks, mini bottles
        /// of alcohol, and snacks. The items are most commonly available for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("minibar")]
        public virtual System.Nullable<bool> Minibar { get; set; }

        /// <summary>Minibar exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("minibarException")]
        public virtual string MinibarException { get; set; }

        /// <summary>
        /// Snackbar. A small cabinet in the guestroom containing snacks. The items are most commonly available for a
        /// fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("snackbar")]
        public virtual System.Nullable<bool> Snackbar { get; set; }

        /// <summary>Snackbar exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("snackbarException")]
        public virtual string SnackbarException { get; set; }

        /// <summary>
        /// Coffee maker. An electric appliance that brews coffee by heating and forcing water through ground coffee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("coffeeMaker")]
        public virtual System.Nullable<bool> CoffeeMaker { get; set; }

        /// <summary>Coffee maker exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("coffeeMakerException")]
        public virtual string CoffeeMakerException { get; set; }

        /// <summary>Kettle. A covered container with a handle and a spout used for boiling water.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kettle")]
        public virtual System.Nullable<bool> Kettle { get; set; }

        /// <summary>Kettle exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kettleException")]
        public virtual string KettleException { get; set; }

        /// <summary>Tea station. A small area with the supplies needed to heat water and make tea.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("teaStation")]
        public virtual System.Nullable<bool> TeaStation { get; set; }

        /// <summary>Tea station exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("teaStationException")]
        public virtual string TeaStationException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Features in the living area.</summary>
    public class LivingAreaFeatures : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Private bathroom. A bathroom designated for the express use of the guests staying in a specific guestroom.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateBathroom")]
        public virtual System.Nullable<bool> PrivateBathroom { get; set; }

        /// <summary>Private bathroom exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateBathroomException")]
        public virtual string PrivateBathroomException { get; set; }

        /// <summary>
        /// Toilet. A fixed bathroom feature connected to a sewer or septic system and consisting of a water-flushed
        /// bowl with a seat, as well as a device that elicites the water-flushing action. Used for the process and
        /// disposal of human waste.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("toilet")]
        public virtual System.Nullable<bool> Toilet { get; set; }

        /// <summary>Toilet exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("toiletException")]
        public virtual string ToiletException { get; set; }

        /// <summary>
        /// Bidet. A plumbing fixture attached to a toilet or a low, fixed sink designed for the purpose of washing
        /// after toilet use.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bidet")]
        public virtual System.Nullable<bool> Bidet { get; set; }

        /// <summary>Bidet exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bidetException")]
        public virtual string BidetException { get; set; }

        /// <summary>
        /// Shower. A fixed plumbing fixture for standing bathing that features a tall spray spout or faucet through
        /// which water flows, a knob or knobs that control the water's temperature, and a drain in the floor.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("shower")]
        public virtual System.Nullable<bool> Shower { get; set; }

        /// <summary>Shower exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("showerException")]
        public virtual string ShowerException { get; set; }

        /// <summary>
        /// Bathtub. A fixed plumbing feature set on the floor and consisting of a large container that accommodates the
        /// body of an adult for the purpose of seated bathing. Includes knobs or fixtures to control the temperature of
        /// the water, a faucet through which the water flows, and a drain that can be closed for filling and opened for
        /// draining.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bathtub")]
        public virtual System.Nullable<bool> Bathtub { get; set; }

        /// <summary>Bathtub exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bathtubException")]
        public virtual string BathtubException { get; set; }

        /// <summary>
        /// Hairdryer. A handheld electric appliance that blows temperature-controlled air for the purpose of drying wet
        /// hair. Can be mounted to a bathroom wall or a freestanding device stored in the guestroom's bathroom or
        /// closet.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hairdryer")]
        public virtual System.Nullable<bool> Hairdryer { get; set; }

        /// <summary>Hairdryer exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hairdryerException")]
        public virtual string HairdryerException { get; set; }

        /// <summary>
        /// Washer. An electrical machine connected to a running water source designed to launder clothing.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("washer")]
        public virtual System.Nullable<bool> Washer { get; set; }

        /// <summary>Washer exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("washerException")]
        public virtual string WasherException { get; set; }

        /// <summary>Dryer. An electrical machine designed to dry clothing.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dryer")]
        public virtual System.Nullable<bool> Dryer { get; set; }

        /// <summary>Dryer exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dryerException")]
        public virtual string DryerException { get; set; }

        /// <summary>
        /// Ironing equipment. A device, usually with a flat metal base, that is heated to smooth, finish, or press
        /// clothes and a flat, padded, cloth-covered surface on which the clothes are worked.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ironingEquipment")]
        public virtual System.Nullable<bool> IroningEquipment { get; set; }

        /// <summary>Ironing equipment exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ironingEquipmentException")]
        public virtual string IroningEquipmentException { get; set; }

        /// <summary>
        /// Universal power adapters. A power supply for electronic devices which plugs into a wall for the purpose of
        /// converting AC to a single DC voltage. Also know as AC adapter or charger.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("universalPowerAdapters")]
        public virtual System.Nullable<bool> UniversalPowerAdapters { get; set; }

        /// <summary>Universal power adapters exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("universalPowerAdaptersException")]
        public virtual string UniversalPowerAdaptersException { get; set; }

        /// <summary>Air conditioning. An electrical machine used to cool the temperature of the guestroom.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airConditioning")]
        public virtual System.Nullable<bool> AirConditioning { get; set; }

        /// <summary>Air conditioning exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airConditioningException")]
        public virtual string AirConditioningException { get; set; }

        /// <summary>Heating. An electrical machine used to warm the temperature of the guestroom.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heating")]
        public virtual System.Nullable<bool> Heating { get; set; }

        /// <summary>Heating exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("heatingException")]
        public virtual string HeatingException { get; set; }

        /// <summary>
        /// Fireplace. A framed opening (aka hearth) at the base of a chimney in which logs or an electrical fire
        /// feature are burned to provide a relaxing ambiance or to heat the room. Often made of bricks or stone.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fireplace")]
        public virtual System.Nullable<bool> Fireplace { get; set; }

        /// <summary>Fireplace exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fireplaceException")]
        public virtual string FireplaceException { get; set; }

        /// <summary>TV. A television is available in the guestroom.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tv")]
        public virtual System.Nullable<bool> Tv { get; set; }

        /// <summary>TV exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tvException")]
        public virtual string TvException { get; set; }

        /// <summary>
        /// TV casting. A television equipped with a device through which the video entertainment accessed on a personal
        /// computer, phone or tablet can be wirelessly delivered to and viewed on the guestroom's television.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tvCasting")]
        public virtual System.Nullable<bool> TvCasting { get; set; }

        /// <summary>TV exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tvCastingException")]
        public virtual string TvCastingException { get; set; }

        /// <summary>
        /// TV streaming. Televisions that embed a range of web-based apps to allow for watching media from those apps.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tvStreaming")]
        public virtual System.Nullable<bool> TvStreaming { get; set; }

        /// <summary>TV streaming exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("tvStreamingException")]
        public virtual string TvStreamingException { get; set; }

        /// <summary>
        /// Pay per view movies. Televisions with channels that offer films that can be viewed for a fee, and have an
        /// interface to allow the viewer to accept the terms and approve payment.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("payPerViewMovies")]
        public virtual System.Nullable<bool> PayPerViewMovies { get; set; }

        /// <summary>Pay per view movies exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("payPerViewMoviesException")]
        public virtual string PayPerViewMoviesException { get; set; }

        /// <summary>
        /// In-unit safe. A strong fireproof cabinet with a programmable lock, used for the protected storage of
        /// valuables in a guestroom. Often built into a closet.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inunitSafe")]
        public virtual System.Nullable<bool> InunitSafe { get; set; }

        /// <summary>In-unit safe exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inunitSafeException")]
        public virtual string InunitSafeException { get; set; }

        /// <summary>
        /// Electronic room key. A card coded by the check-in computer that is read by the lock on the hotel guestroom
        /// door to allow for entry.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("electronicRoomKey")]
        public virtual System.Nullable<bool> ElectronicRoomKey { get; set; }

        /// <summary>Electronic room key exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("electronicRoomKeyException")]
        public virtual string ElectronicRoomKeyException { get; set; }

        /// <summary>
        /// In-unit Wifi available. Guests can wirelessly connect to the Internet in the guestroom. Can be free or for a
        /// fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inunitWifiAvailable")]
        public virtual System.Nullable<bool> InunitWifiAvailable { get; set; }

        /// <summary>In-unit Wifi available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("inunitWifiAvailableException")]
        public virtual string InunitWifiAvailableException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Information about the layout of the living area.</summary>
    public class LivingAreaLayout : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Living area sq meters. The measurement in meters of the area of a guestroom's living space.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("livingAreaSqMeters")]
        public virtual System.Nullable<float> LivingAreaSqMeters { get; set; }

        /// <summary>Living area sq meters exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("livingAreaSqMetersException")]
        public virtual string LivingAreaSqMetersException { get; set; }

        /// <summary>Stairs. There are steps leading from one level or story to another in the unit.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("stairs")]
        public virtual System.Nullable<bool> Stairs { get; set; }

        /// <summary>Stairs exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("stairsException")]
        public virtual string StairsException { get; set; }

        /// <summary>
        /// Loft. A three-walled upper area accessed by stairs or a ladder that overlooks the lower area of a room.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("loft")]
        public virtual System.Nullable<bool> Loft { get; set; }

        /// <summary>Loft exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("loftException")]
        public virtual string LoftException { get; set; }

        /// <summary>
        /// Non smoking. A guestroom in which the smoking of cigarettes, cigars and pipes is prohibited.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nonSmoking")]
        public virtual System.Nullable<bool> NonSmoking { get; set; }

        /// <summary>Non smoking exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nonSmokingException")]
        public virtual string NonSmokingException { get; set; }

        /// <summary>
        /// Patio. A paved, outdoor area with seating attached to and accessed through a ground-floor guestroom for use
        /// by the occupants of the guestroom.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patio")]
        public virtual System.Nullable<bool> Patio { get; set; }

        /// <summary>Patio exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("patioException")]
        public virtual string PatioException { get; set; }

        /// <summary>
        /// Balcony. An outdoor platform attached to a building and surrounded by a short wall, fence or other safety
        /// railing. The balcony is accessed through a door in a guestroom or suite and is for use by the guest staying
        /// in that room. May or may not include seating or outdoor furniture. Is not located on the ground floor. Also
        /// lanai.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("balcony")]
        public virtual System.Nullable<bool> Balcony { get; set; }

        /// <summary>Balcony exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("balconyException")]
        public virtual string BalconyException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Information about sleeping features in the living area.</summary>
    public class LivingAreaSleeping : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Beds count. The number of permanent beds present in a guestroom. Does not include rollaway beds, cribs or
        /// sofabeds.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bedsCount")]
        public virtual System.Nullable<int> BedsCount { get; set; }

        /// <summary>Beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bedsCountException")]
        public virtual string BedsCountException { get; set; }

        /// <summary>
        /// King beds count. The number of large beds measuring 76"W x 80"L (193cm x 102cm). Most often meant to
        /// accompany two people. Includes California king and super king.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kingBedsCount")]
        public virtual System.Nullable<int> KingBedsCount { get; set; }

        /// <summary>King beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kingBedsCountException")]
        public virtual string KingBedsCountException { get; set; }

        /// <summary>Queen beds count. The number of medium-large beds measuring 60"W x 80"L (152cm x 102cm).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("queenBedsCount")]
        public virtual System.Nullable<int> QueenBedsCount { get; set; }

        /// <summary>Queen beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("queenBedsCountException")]
        public virtual string QueenBedsCountException { get; set; }

        /// <summary>
        /// Double beds count. The number of medium beds measuring 53"W x 75"L (135cm x 191cm). Also known as full size
        /// bed.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doubleBedsCount")]
        public virtual System.Nullable<int> DoubleBedsCount { get; set; }

        /// <summary>Double beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doubleBedsCountException")]
        public virtual string DoubleBedsCountException { get; set; }

        /// <summary>
        /// Single or twin count beds. The number of smaller beds measuring 38"W x 75"L (97cm x 191cm) that can
        /// accommodate one adult.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("singleOrTwinBedsCount")]
        public virtual System.Nullable<int> SingleOrTwinBedsCount { get; set; }

        /// <summary>Single or twin beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("singleOrTwinBedsCountException")]
        public virtual string SingleOrTwinBedsCountException { get; set; }

        /// <summary>
        /// Sofa beds count. The number of specially designed sofas that can be made to serve as a bed by lowering its
        /// hinged upholstered back to horizontal position or by pulling out a concealed mattress.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sofaBedsCount")]
        public virtual System.Nullable<int> SofaBedsCount { get; set; }

        /// <summary>Sofa beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sofaBedsCountException")]
        public virtual string SofaBedsCountException { get; set; }

        /// <summary>
        /// Bunk beds count. The number of furniture pieces in which one framed mattress is fixed directly above another
        /// by means of a physical frame. This allows one person(s) to sleep in the bottom bunk and one person(s) to
        /// sleep in the top bunk. Also known as double decker bed.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bunkBedsCount")]
        public virtual System.Nullable<int> BunkBedsCount { get; set; }

        /// <summary>Bunk beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("bunkBedsCountException")]
        public virtual string BunkBedsCountException { get; set; }

        /// <summary>
        /// Other beds count. The number of beds that are not standard mattress and boxspring setups such as Japanese
        /// tatami mats, trundle beds, air mattresses and cots.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("otherBedsCount")]
        public virtual System.Nullable<int> OtherBedsCount { get; set; }

        /// <summary>Other beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("otherBedsCountException")]
        public virtual string OtherBedsCountException { get; set; }

        /// <summary>
        /// Roll away beds count. The number of mattresses on wheeled frames that can be folded in half and rolled away
        /// for easy storage that the guestroom can obtain upon request.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rollAwayBedsCount")]
        public virtual System.Nullable<int> RollAwayBedsCount { get; set; }

        /// <summary>Roll away beds count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("rollAwayBedsCountException")]
        public virtual string RollAwayBedsCountException { get; set; }

        /// <summary>
        /// Cribs count. The number of small beds for an infant or toddler that the guestroom can obtain. The bed is
        /// surrounded by a high railing to prevent the child from falling or climbing out of the bed
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cribsCount")]
        public virtual System.Nullable<int> CribsCount { get; set; }

        /// <summary>Cribs count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cribsCountException")]
        public virtual string CribsCountException { get; set; }

        /// <summary>
        /// Hypoallergenic bedding. Bedding such as linens, pillows, mattress covers and/or mattresses that are made of
        /// materials known to be resistant to allergens such as mold, dust and dander.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hypoallergenicBedding")]
        public virtual System.Nullable<bool> HypoallergenicBedding { get; set; }

        /// <summary>Hypoallergenic bedding exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hypoallergenicBeddingException")]
        public virtual string HypoallergenicBeddingException { get; set; }

        /// <summary>
        /// Synthetic pillows. The option for guests to obtain bed pillows stuffed with polyester material crafted to
        /// reproduce the feel of a pillow stuffed with down and feathers.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("syntheticPillows")]
        public virtual System.Nullable<bool> SyntheticPillows { get; set; }

        /// <summary>Synthetic pillows exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("syntheticPillowsException")]
        public virtual string SyntheticPillowsException { get; set; }

        /// <summary>
        /// Memory foam pillows. The option for guests to obtain bed pillows that are stuffed with a man-made foam that
        /// responds to body heat by conforming to the body closely, and then recovers its shape when the pillow cools
        /// down.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("memoryFoamPillows")]
        public virtual System.Nullable<bool> MemoryFoamPillows { get; set; }

        /// <summary>Memory foam pillows exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("memoryFoamPillowsException")]
        public virtual string MemoryFoamPillowsException { get; set; }

        /// <summary>
        /// Feather pillows. The option for guests to obtain bed pillows that are stuffed with the feathers and down of
        /// ducks or geese.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("featherPillows")]
        public virtual System.Nullable<bool> FeatherPillows { get; set; }

        /// <summary>Feather pillows exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("featherPillowsException")]
        public virtual string FeatherPillowsException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a [local post](https://support.google.com/business/answer/7662907) for a location.</summary>
    public class LocalPost : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Output only. Google identifier for this local post in the form:
        /// `accounts/{account_id}/locations/{location_id}/localPosts/{local_post_id}`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>The language of the local post.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>Description/body of the local post.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("summary")]
        public virtual string Summary { get; set; }

        /// <summary>
        /// The URL that users are sent to when clicking through the promotion. Ignored for topic type `OFFER`.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("callToAction")]
        public virtual CallToAction CallToAction { get; set; }

        /// <summary>Output only. Time of the creation of the post.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("createTime")]
        public virtual object CreateTime { get; set; }

        /// <summary>Output only. Time of the last modification of the post made by the user.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateTime")]
        public virtual object UpdateTime { get; set; }

        /// <summary>Event information. Required for topic types `EVENT` and `OFFER`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("event")]
        public virtual LocalPostEvent Event__ { get; set; }

        /// <summary>Output only. The state of the post, indicating what part of its lifecycle it is in.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; }

        /// <summary>
        /// The media associated with the post. source_url is the only supported data field for a LocalPost MediaItem.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("media")]
        public virtual System.Collections.Generic.IList<MediaItem> Media { get; set; }

        /// <summary>
        /// Output only. The link to the local post in Google search. This link can be used to share the post via social
        /// media, email, text, etc.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("searchUrl")]
        public virtual string SearchUrl { get; set; }

        /// <summary>Required. The topic type of the post: standard, event, offer, or alert.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("topicType")]
        public virtual string TopicType { get; set; }

        /// <summary>
        /// The type of alert the post is created for. This field is only applicable for posts of topic_type Alert, and
        /// behaves as a sub-type of Alerts.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("alertType")]
        public virtual string AlertType { get; set; }

        /// <summary>Additional data for offer posts. This should only be set when the topic_type is OFFER.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("offer")]
        public virtual LocalPostOffer Offer { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>All the information pertaining to an event featured in a local post.</summary>
    public class LocalPostEvent : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Name of the event.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("title")]
        public virtual string Title { get; set; }

        /// <summary>Event start and end date/time.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("schedule")]
        public virtual TimeInterval Schedule { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>All the metrics requested for a Local Post.</summary>
    public class LocalPostMetrics : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("localPostName")]
        public virtual string LocalPostName { get; set; }

        /// <summary>A list of values for the requested metrics.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metricValues")]
        public virtual System.Collections.Generic.IList<MetricValue> MetricValues { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Specific fields for offer posts.</summary>
    public class LocalPostOffer : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. Offer code that is usable in store or online.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("couponCode")]
        public virtual string CouponCode { get; set; }

        /// <summary>Optional. Online link to redeem offer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("redeemOnlineUrl")]
        public virtual string RedeemOnlineUrl { get; set; }

        /// <summary>Optional. Offer terms and conditions.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("termsConditions")]
        public virtual string TermsConditions { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A location. See the [help center article] (https://support.google.com/business/answer/3038177) for a detailed
    /// description of these fields, or the [category endpoint](/my-business/reference/rest/v4/categories) for a list of
    /// valid business categories.
    /// </summary>
    public class Location : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Google identifier for this location in the form: `accounts/{account_id}/locations/{location_id}` In the
        /// context of matches, this field will not be populated.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>The language of the location. Set during creation and not updateable.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>
        /// External identifier for this location, which must be unique inside a given account. This is a means of
        /// associating the location with your own records.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("storeCode")]
        public virtual string StoreCode { get; set; }

        /// <summary>
        /// Location name should reflect your business's real-world name, as used consistently on your storefront,
        /// website, and stationery, and as known to customers. Any additional information, when relevant, can be
        /// included in other fields of the resource (for example, `Address`, `Categories`). Don't add unnecessary
        /// information to your name (for example, prefer "Google" over "Google Inc. - Mountain View Corporate
        /// Headquarters"). Don't include marketing taglines, store codes, special characters, hours or closed/open
        /// status, phone numbers, website URLs, service/product information, location/address or directions, or
        /// containment information (for example, "Chase ATM in Duane Reade").
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationName")]
        public virtual string LocationName { get; set; }

        /// <summary>
        /// A phone number that connects to your individual business location as directly as possible. Use a local phone
        /// number instead of a central, call center helpline number whenever possible.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("primaryPhone")]
        public virtual string PrimaryPhone { get; set; }

        /// <summary>
        /// Up to two phone numbers (mobile or landline, no fax) at which your business can be called, in addition to
        /// your primary phone number.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("additionalPhones")]
        public virtual System.Collections.Generic.IList<string> AdditionalPhones { get; set; }

        /// <summary>
        /// A precise, accurate address to describe your business location. PO boxes or mailboxes located at remote
        /// locations are not acceptable. At this time, you can specify a maximum of five `address_lines` values in the
        /// address.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("address")]
        public virtual PostalAddress Address { get; set; }

        /// <summary>Category that best describes the core business this location engages in.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("primaryCategory")]
        public virtual Category PrimaryCategory { get; set; }

        /// <summary>
        /// Additional categories to describe your business. Categories help your customers find accurate, specific
        /// results for services they're interested in. To keep your business information accurate and live, make sure
        /// that you use as few categories as possible to describe your overall core business. Choose categories that
        /// are as specific as possible, but representative of your main business.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("additionalCategories")]
        public virtual System.Collections.Generic.IList<Category> AdditionalCategories { get; set; }

        /// <summary>
        /// A URL for this business. If possible, use a URL that represents this individual business location instead of
        /// a generic website/URL that represents all locations, or the brand.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("websiteUrl")]
        public virtual string WebsiteUrl { get; set; }

        /// <summary>Operating hours for the business.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("regularHours")]
        public virtual BusinessHours RegularHours { get; set; }

        /// <summary>
        /// Special hours for the business. This typically includes holiday hours, and other times outside of regular
        /// operating hours. These override regular business hours.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("specialHours")]
        public virtual SpecialHours SpecialHours { get; set; }

        /// <summary>
        /// Service area businesses provide their service at the customer's location. If this business is a service area
        /// business, this field describes the area(s) serviced by the business.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("serviceArea")]
        public virtual ServiceAreaBusiness ServiceArea { get; set; }

        /// <summary>
        /// A collection of keys that link this business to other Google properties, such as a Google+ page and Google
        /// Maps Places.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationKey")]
        public virtual LocationKey LocationKey { get; set; }

        /// <summary>
        /// A collection of free-form strings to allow you to tag your business. These labels are NOT user facing; only
        /// you can see them. Limited to 255 characters (per label).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<string> Labels { get; set; }

        /// <summary>Additional information that is surfaced in AdWords.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adWordsLocationExtensions")]
        public virtual AdWordsLocationExtensions AdWordsLocationExtensions { get; set; }

        /// <summary>
        /// User-provided latitude and longitude. When creating a location, this field is ignored if the provided
        /// address geocodes successfully. This field is only returned on get requests if the user-provided `latlng`
        /// value was accepted during create, or the `latlng` value was updated through the Google My Business website.
        /// This field cannot be updated.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("latlng")]
        public virtual LatLng Latlng { get; set; }

        /// <summary>A flag that indicates whether the location is currently open for business.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("openInfo")]
        public virtual OpenInfo OpenInfo { get; set; }

        /// <summary>
        /// Output only. A set of booleans that reflects the [state of a
        /// location.](https://support.google.com/business/answer/3480862)
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationState")]
        public virtual LocationState LocationState { get; set; }

        /// <summary>Attributes for this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attributes")]
        public virtual System.Collections.Generic.IList<Attribute> Attributes { get; set; }

        /// <summary>Output Only. Additional non-user-editable information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metadata")]
        public virtual Metadata Metadata { get; set; }

        /// <summary>Price list information for this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("priceLists")]
        public virtual System.Collections.Generic.IList<PriceList> PriceLists { get; set; }

        /// <summary>
        /// Describes your business in your own voice and shares with users the unique story of your business and
        /// offerings.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("profile")]
        public virtual Profile Profile { get; set; }

        /// <summary>All locations and chain related to this one.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("relationshipData")]
        public virtual RelationshipData RelationshipData { get; set; }

        /// <summary>More hours for a business's different departments or specific customers.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("moreHours")]
        public virtual System.Collections.Generic.IList<MoreHours> MoreHours { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>How the media item is associated with its location.</summary>
    public class LocationAssociation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The category that this location photo belongs to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("category")]
        public virtual string Category { get; set; }

        /// <summary>The ID of a price list item that this location photo is associated with.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("priceListItemId")]
        public virtual string PriceListItemId { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A location indexed with the regions that people usually come from. This is captured by counting how many
    /// driving-direction requests to this location are from each region.
    /// </summary>
    public class LocationDrivingDirectionMetrics : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The location resource name this metric value belongs to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationName")]
        public virtual string LocationName { get; set; }

        /// <summary>
        /// Driving-direction requests by source region. By convention, these are sorted by count with at most 10
        /// results.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("topDirectionSources")]
        public virtual System.Collections.Generic.IList<TopDirectionSources> TopDirectionSources { get; set; }

        /// <summary>Time zone (IANA timezone IDs, for example, 'Europe/London') of the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeZone")]
        public virtual string TimeZone { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Alternate/surrogate key references for a location.</summary>
    public class LocationKey : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Output only. If this location has a Google+ page associated with it, this is populated with the Google+ page
        /// ID for this location.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("plusPageId")]
        public virtual string PlusPageId { get; set; }

        /// <summary>
        /// If this location has been verified and is connected to/appears on Google Maps, this field is populated with
        /// the place ID for the location. This ID can be used in various Places APIs. If this location is unverified,
        /// this field may be populated if the location has been associated with a place that appears on Google Maps.
        /// This field can be set during Create calls, but not for Update. The additional `explicit_no_place_id` bool
        /// qualifies whether an unset place ID is deliberate or not.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("placeId")]
        public virtual string PlaceId { get; set; }

        /// <summary>
        /// Output only. A value of true indicates that an unset place ID is deliberate, which is different from no
        /// association being made yet.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("explicitNoPlaceId")]
        public virtual System.Nullable<bool> ExplicitNoPlaceId { get; set; }

        /// <summary>
        /// Output only. The `request_id` used to create this location. May be empty if this location was created
        /// outside of the GMB API or Google My Business Locations.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("requestId")]
        public virtual string RequestId { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A series of Metrics and BreakdownMetrics associated with a Location over some time range.</summary>
    public class LocationMetrics : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The location resource name these values belong to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationName")]
        public virtual string LocationName { get; set; }

        /// <summary>IANA timezone for the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeZone")]
        public virtual string TimeZone { get; set; }

        /// <summary>A list of values for the requested metrics.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metricValues")]
        public virtual System.Collections.Generic.IList<MetricValue> MetricValues { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a review with location information.</summary>
    public class LocationReview : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Location resource name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>A review for the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("review")]
        public virtual Review Review { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Contains a set of booleans that reflect the [state of a
    /// Location.](https://support.google.com/business/answer/3480862)
    /// </summary>
    public class LocationState : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. Indicates whether the place ID associated with this location has updates.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isGoogleUpdated")]
        public virtual System.Nullable<bool> IsGoogleUpdated { get; set; }

        /// <summary>Output only. Indicates whether the location is a duplicate of another location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isDuplicate")]
        public virtual System.Nullable<bool> IsDuplicate { get; set; }

        /// <summary>
        /// Output only. Indicates whether the location is suspended. Suspended locations are not visible to end users
        /// in Google products. If you believe this was a mistake, see the [help center article]
        /// (https://support.google.com/business/answer/4569145).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isSuspended")]
        public virtual System.Nullable<bool> IsSuspended { get; set; }

        /// <summary>Output only. Indicates whether the location can be updated.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canUpdate")]
        public virtual System.Nullable<bool> CanUpdate { get; set; }

        /// <summary>
        /// Output only. Indicates whether the location can be deleted using the Google My Business API.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canDelete")]
        public virtual System.Nullable<bool> CanDelete { get; set; }

        /// <summary>Output only. Indicates whether the location is verified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isVerified")]
        public virtual System.Nullable<bool> IsVerified { get; set; }

        /// <summary>Output only. Indicates whether the location requires reverification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("needsReverification")]
        public virtual System.Nullable<bool> NeedsReverification { get; set; }

        /// <summary>Output only. Indicates whether the review of the location is pending.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isPendingReview")]
        public virtual System.Nullable<bool> IsPendingReview { get; set; }

        /// <summary>Output only. Indicates whether the location is disabled.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isDisabled")]
        public virtual System.Nullable<bool> IsDisabled { get; set; }

        /// <summary>Output only. Indicates whether the location is published.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isPublished")]
        public virtual System.Nullable<bool> IsPublished { get; set; }

        /// <summary>Output only. Indicates whether the location is disconnected from a place on Google Maps.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isDisconnected")]
        public virtual System.Nullable<bool> IsDisconnected { get; set; }

        /// <summary>
        /// Output only. Indicates whether
        /// [accounts.locations.localPosts](/my-business/reference/rest/v4/accounts.locations.localPosts) is disabled
        /// for this location.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isLocalPostApiDisabled")]
        public virtual System.Nullable<bool> IsLocalPostApiDisabled { get; set; }

        /// <summary>Output only. Indicates if the listing can modify a ServiceList.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canModifyServiceList")]
        public virtual System.Nullable<bool> CanModifyServiceList { get; set; }

        /// <summary>Output only. Indicates if the listing is eligible for food menu.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canHaveFoodMenus")]
        public virtual System.Nullable<bool> CanHaveFoodMenus { get; set; }

        /// <summary>
        /// Output only. Indicates whether any of this Location's properties are in the edit pending state.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasPendingEdits")]
        public virtual System.Nullable<bool> HasPendingEdits { get; set; }

        /// <summary>Output only. Indicates whether the location has pending verification requests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hasPendingVerification")]
        public virtual System.Nullable<bool> HasPendingVerification { get; set; }

        /// <summary>Output only. Indicates whether the location can operate on Health data.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canOperateHealthData")]
        public virtual System.Nullable<bool> CanOperateHealthData { get; set; }

        /// <summary>Output only. Indicates whether the location can operate on Lodging data.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canOperateLodgingData")]
        public virtual System.Nullable<bool> CanOperateLodgingData { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Lodging of a location that provides accomodations.</summary>
    public class Lodging : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Google identifier for this location in the form:
        /// `accounts/{account_id}/locations/{location_id}/lodging`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Required. Metadata for the lodging.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metadata")]
        public virtual LodgingMetadata Metadata { get; set; }

        /// <summary>General factual information about the property's physical structure and important dates.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("property")]
        public virtual Property Property { get; set; }

        /// <summary>
        /// Conveniences or help provided by the property to facilitate an easier, more comfortable stay.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("services")]
        public virtual Services Services { get; set; }

        /// <summary>Property rules that impact guests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("policies")]
        public virtual Policies Policies { get; set; }

        /// <summary>Meals, snacks, and beverages available at the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("foodAndDrink")]
        public virtual FoodAndDrink FoodAndDrink { get; set; }

        /// <summary>Swimming pool or recreational water facilities available at the hotel.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pools")]
        public virtual Pools Pools { get; set; }

        /// <summary>Guest facilities at the property to promote or maintain health, beauty, and fitness.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wellness")]
        public virtual Wellness Wellness { get; set; }

        /// <summary>Amenities and features related to leisure and play.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("activities")]
        public virtual Activities Activities { get; set; }

        /// <summary>Vehicles or vehicular services facilitated or owned by the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transportation")]
        public virtual Transportation Transportation { get; set; }

        /// <summary>Services and amenities for families and young guests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("families")]
        public virtual Families Families { get; set; }

        /// <summary>The ways in which the property provides guests with the ability to access the internet.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("connectivity")]
        public virtual Connectivity Connectivity { get; set; }

        /// <summary>Features of the property of specific interest to the business traveler.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("business")]
        public virtual Business Business { get; set; }

        /// <summary>
        /// Physical adaptations made to the property in consideration of varying levels of human physical ability.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("accessibility")]
        public virtual Accessibility Accessibility { get; set; }

        /// <summary>Policies regarding guest-owned animals.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pets")]
        public virtual Pets Pets { get; set; }

        /// <summary>Parking options at the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("parking")]
        public virtual Parking Parking { get; set; }

        /// <summary>Conveniences provided in guest units to facilitate an easier, more comfortable stay.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("housekeeping")]
        public virtual Housekeeping Housekeeping { get; set; }

        /// <summary>Health and safety measures implemented by the hotel during COVID-19.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("healthAndSafety")]
        public virtual HealthAndSafety HealthAndSafety { get; set; }

        /// <summary>Features of the shared living areas available in this Lodging.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonLivingArea")]
        public virtual LivingArea CommonLivingArea { get; set; }

        /// <summary>All units on the property have at least these attributes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allUnits")]
        public virtual GuestUnitFeatures AllUnits { get; set; }

        /// <summary>Some units on the property have as much as these attributes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("someUnits")]
        public virtual GuestUnitFeatures SomeUnits { get; set; }

        /// <summary>Individual GuestUnitTypes that are available in this Lodging.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("guestUnits")]
        public virtual System.Collections.Generic.IList<GuestUnitType> GuestUnits { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Metadata for the Lodging.</summary>
    public class LodgingMetadata : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. The latest time at which the Lodging data is asserted to be true in the real world. This is not
        /// necessarily the time at which the request is made.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateTime")]
        public virtual object UpdateTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a possible match to a location.</summary>
    public class MatchedLocation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The sparsely populated location that is a potential match. Unpopulated fields include, but may not be
        /// limited to: name (the matched location cannot be retrieved via `GetLocation` nor `BatchGetLocations`);
        /// `store_code`; `service_area` coverage area details; `labels`; `ad_words_location_extensions`; `photos`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("location")]
        public virtual Location Location { get; set; }

        /// <summary>Is this an exact match?</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isExactMatch")]
        public virtual System.Nullable<bool> IsExactMatch { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Insights and statistics for the media item.</summary>
    public class MediaInsights : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. The number of times the media item has been viewed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("viewCount")]
        public virtual System.Nullable<long> ViewCount { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A single media item.</summary>
    public class MediaItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The resource name for this media item. `accounts/{account_id}/locations/{location_id}/media/{media_key}`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// A publicly accessible URL where the media item can be retrieved from. When creating one of this or data_ref
        /// must be set to specify the source of the media item. If `source_url` was used when creating a media item, it
        /// will be populated with that source URL when the media item is retrieved. This field cannot be updated.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sourceUrl")]
        public virtual string SourceUrl { get; set; }

        /// <summary>
        /// Input only. A reference to media item binary data as obtained by the `StartUploadMediaItemData` method. When
        /// creating a media item, either sourceUrl or dataRef must be set.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dataRef")]
        public virtual MediaItemDataRef DataRef { get; set; }

        /// <summary>
        /// The format of this media item. Must be set when the media item is created, and is read-only on all other
        /// requests. Cannot be updated.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mediaFormat")]
        public virtual string MediaFormat { get; set; }

        /// <summary>
        /// Required when calling `CreatePhoto`. Describes how this media item is connected to its location. Must be
        /// either a category (for example, EXTERIOR) or the ID of a price list item. This is required when adding new
        /// media to a location with `CreateMediaItem`. For other types of media, for example, photos on local posts,
        /// this will not be present.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationAssociation")]
        public virtual LocationAssociation LocationAssociation { get; set; }

        /// <summary>
        /// Output only. Google-hosted URL for this media item. This URL is not static since it may change over time.
        /// For video this will be a preview image with an overlaid play icon.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("googleUrl")]
        public virtual string GoogleUrl { get; set; }

        /// <summary>Output only. Where provided, the URL of a thumbnail image for this media item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("thumbnailUrl")]
        public virtual string ThumbnailUrl { get; set; }

        /// <summary>Output only. Creation time of this media item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("createTime")]
        public virtual object CreateTime { get; set; }

        /// <summary>Output only. The dimensions (width and height) in pixels.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dimensions")]
        public virtual Dimensions Dimensions { get; set; }

        /// <summary>Output only. Statistics for this media item.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("insights")]
        public virtual MediaInsights Insights { get; set; }

        /// <summary>
        /// Output only. Attribution information for customer media items. You must display this attribution as provided
        /// to your users and must not delete or alter the attribution.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("attribution")]
        public virtual Attribution Attribution { get; set; }

        /// <summary>
        /// Description for this media item. Descriptions cannot be modified through the My Business API, but can be set
        /// when creating a new media item that is not a cover photo.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Reference to the photo binary data of a `MediaItem` uploaded through the My Business API. Create a data ref
    /// using StartUploadMediaItemData, and use this ref when uploading bytes to [UpdateMedia] and subsequently calling
    /// CreateMediaItem.
    /// </summary>
    public class MediaItemDataRef : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The unique ID for this media item's binary data. Used to upload the photo data with [UpdateMedia] and when
        /// creating a new media item from those bytes with CreateMediaItem. Example of uploading bytes: `curl -X POST
        /// -T{path_to_file} "http://mybusiness.googleapis.com/upload/v1/media/{resource_name}?upload_type=media"` For
        /// CreateMediaItem calls, set this as the `MediaItem` `data_ref`.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resourceName")]
        public virtual string ResourceName { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Label to be used when displaying the menu and its various sub-components.</summary>
    public class MenuLabel : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Display name of the component.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>Optional. Supplementary information of the component.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; }

        /// <summary>
        /// Optional. The BCP 47 code of language. If the language is not available, it will default to English.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Additional non-user-editable information about the location.</summary>
    public class Metadata : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Information about the location that this location duplicates. Only present when
        /// `location_state.is_duplicate` is true. Deprecated: We are no longer supporting detailed information for
        /// duplicates.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("duplicate")]
        public virtual Duplicate Duplicate { get; set; }

        /// <summary>A link to the location on Maps.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mapsUrl")]
        public virtual string MapsUrl { get; set; }

        /// <summary>A link to the page on Google Search where a customer can leave a review for the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("newReviewUrl")]
        public virtual string NewReviewUrl { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A request to return values for one metric and the options for how those values should be returned.
    /// </summary>
    public class MetricRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The requested metric.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metric")]
        public virtual string Metric { get; set; }

        /// <summary>How the values should appear when returned.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("options")]
        public virtual System.Collections.Generic.IList<string> Options { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A value for a single Metric from a starting time.</summary>
    public class MetricValue : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The metric for which the value applies.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("metric")]
        public virtual string Metric { get; set; }

        /// <summary>The total aggregated value for this metric. Set for the AGGREGATED_TOTAL option.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalValue")]
        public virtual DimensionalMetricValue TotalValue { get; set; }

        /// <summary>Dimensional values for this metric.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dimensionalValues")]
        public virtual System.Collections.Generic.IList<DimensionalMetricValue> DimensionalValues { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Minimized contact measures implemented by the hotel during COVID-19.</summary>
    public class MinimizedContact : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>High-touch items, such as magazines, removed from common areas.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("noHighTouchItemsCommonAreas")]
        public virtual System.Nullable<bool> NoHighTouchItemsCommonAreas { get; set; }

        /// <summary>No high touch items common areas exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("noHighTouchItemsCommonAreasException")]
        public virtual string NoHighTouchItemsCommonAreasException { get; set; }

        /// <summary>High-touch items, such as decorative pillows, removed from guest rooms.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("noHighTouchItemsGuestRooms")]
        public virtual System.Nullable<bool> NoHighTouchItemsGuestRooms { get; set; }

        /// <summary>No high touch items guest rooms exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("noHighTouchItemsGuestRoomsException")]
        public virtual string NoHighTouchItemsGuestRoomsException { get; set; }

        /// <summary>Keyless mobile entry to guest rooms.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("digitalGuestRoomKeys")]
        public virtual System.Nullable<bool> DigitalGuestRoomKeys { get; set; }

        /// <summary>Digital guest room keys exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("digitalGuestRoomKeysException")]
        public virtual string DigitalGuestRoomKeysException { get; set; }

        /// <summary>Plastic key cards are disinfected or discarded.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("plasticKeycardsDisinfected")]
        public virtual System.Nullable<bool> PlasticKeycardsDisinfected { get; set; }

        /// <summary>Plastic keycards disinfected exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("plasticKeycardsDisinfectedException")]
        public virtual string PlasticKeycardsDisinfectedException { get; set; }

        /// <summary>Buffer maintained between room bookings.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("roomBookingsBuffer")]
        public virtual System.Nullable<bool> RoomBookingsBuffer { get; set; }

        /// <summary>Room bookings buffer exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("roomBookingsBufferException")]
        public virtual string RoomBookingsBufferException { get; set; }

        /// <summary>Housekeeping scheduled by request only.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("housekeepingScheduledRequestOnly")]
        public virtual System.Nullable<bool> HousekeepingScheduledRequestOnly { get; set; }

        /// <summary>Housekeeping scheduled request only exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("housekeepingScheduledRequestOnlyException")]
        public virtual string HousekeepingScheduledRequestOnlyException { get; set; }

        /// <summary>No-contact check-in and check-out.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactlessCheckinCheckout")]
        public virtual System.Nullable<bool> ContactlessCheckinCheckout { get; set; }

        /// <summary>Contactless check-in check-out exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("contactlessCheckinCheckoutException")]
        public virtual string ContactlessCheckinCheckoutException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents an amount of money with its currency type.</summary>
    public class Money : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The three-letter currency code defined in ISO 4217.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("currencyCode")]
        public virtual string CurrencyCode { get; set; }

        /// <summary>
        /// The whole units of the amount. For example if `currencyCode` is `"USD"`, then 1 unit is one US dollar.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("units")]
        public virtual System.Nullable<long> Units { get; set; }

        /// <summary>
        /// Number of nano (10^-9) units of the amount. The value must be between -999,999,999 and +999,999,999
        /// inclusive. If `units` is positive, `nanos` must be positive or zero. If `units` is zero, `nanos` can be
        /// positive, zero, or negative. If `units` is negative, `nanos` must be negative or zero. For example $-1.75 is
        /// represented as `units`=-1 and `nanos`=-750,000,000.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nanos")]
        public virtual System.Nullable<int> Nanos { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>The time periods during which a location is open for certain types of business.</summary>
    public class MoreHours : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Type of hours. Clients should call {#link businessCategories:BatchGet} to get supported hours
        /// types for categories of their locations.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hoursTypeId")]
        public virtual string HoursTypeId { get; set; }

        /// <summary>
        /// Required. A collection of times that this location is open. Each period represents a range of hours when the
        /// location is open during the week.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("periods")]
        public virtual System.Collections.Generic.IList<TimePeriod> Periods { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>More hours types that a business can offers, in addition to its regular hours.</summary>
    public class MoreHoursType : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. A stable ID provided by Google for this hours type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hoursTypeId")]
        public virtual string HoursTypeId { get; set; }

        /// <summary>Output only. The human-readable English display name for the hours type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>Output only. The human-readable localized display name for the hours type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localizedDisplayName")]
        public virtual string LocalizedDisplayName { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A Google Cloud Pub/Sub topic where notifications can be published when a location is updated or has a new
    /// review. There will be only one notification settings resource per-account.
    /// </summary>
    public class Notifications : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. The notifications resource name.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// The Google Cloud Pub/Sub topic that will receive notifications when locations managed by this account are
        /// updated. If unset, no notifications will be posted. The account
        /// mybusiness-api-pubsub@system.gserviceaccount.com must have at least Publish permissions on the Cloud Pub/Sub
        /// topic.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("topicName")]
        public virtual string TopicName { get; set; }

        /// <summary>
        /// The types of notifications that will be sent to the Cloud Pub/Sub topic. At least one must be specified. To
        /// stop receiving notifications entirely, use DeleteNotifications.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("notificationTypes")]
        public virtual System.Collections.Generic.IList<string> NotificationTypes { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// This message denotes nutrition information with an upper bound and lower bound range and can be represented by
    /// mass unit. Lower amount must be specified. Both lower and upper amounts are non-negative numbers.
    /// </summary>
    public class NutritionFact : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Lower amount of nutrition</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lowerAmount")]
        public virtual System.Nullable<double> LowerAmount { get; set; }

        /// <summary>Optional. Upper amount of nutrition</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("upperAmount")]
        public virtual System.Nullable<double> UpperAmount { get; set; }

        /// <summary>Required. Unit of the given nutrition information.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("unit")]
        public virtual string Unit { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>This message represents nutrition facts for a food dish.</summary>
    public class NutritionFacts : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. Calories of the dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("calories")]
        public virtual CaloriesFact Calories { get; set; }

        /// <summary>Optional. Fat information for a given food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalFat")]
        public virtual NutritionFact TotalFat { get; set; }

        /// <summary>Optional. Cholesterol information for a given food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cholesterol")]
        public virtual NutritionFact Cholesterol { get; set; }

        /// <summary>Optional. Sodium information for a given food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sodium")]
        public virtual NutritionFact Sodium { get; set; }

        /// <summary>Optional. Carbohydrate information for a given food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalCarbohydrate")]
        public virtual NutritionFact TotalCarbohydrate { get; set; }

        /// <summary>Optional. Protein information for a given food dish.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("protein")]
        public virtual NutritionFact Protein { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Information related to the opening state of the business.</summary>
    public class OpenInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Indicates whether or not the Location is currently open for business. All locations are open by default,
        /// unless updated to be closed.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("status")]
        public virtual string Status { get; set; }

        /// <summary>Output only. Indicates whether this business is eligible for re-open.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("canReopen")]
        public virtual System.Nullable<bool> CanReopen { get; set; }

        /// <summary>
        /// The date on which the location first opened. If the exact day is not known, month and year only can be
        /// provided. The date must be in the past or be no more than one year in the future.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("openingDate")]
        public virtual Date OpeningDate { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Additional Info stored for an organization.</summary>
    public class OrganizationInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The registered domain for the account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("registeredDomain")]
        public virtual string RegisteredDomain { get; set; }

        /// <summary>The postal address for the account.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("postalAddress")]
        public virtual PostalAddress PostalAddress { get; set; }

        /// <summary>The contact number for the organization.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("phoneNumber")]
        public virtual string PhoneNumber { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Parking options at the property.</summary>
    public class Parking : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Parking available. The hotel allows the cars of guests to be parked. Can be free or for a fee. Parking
        /// facility may be an outdoor lot or an indoor garage, but must be onsite. Nearby parking does not apply.
        /// Parking may be performed by the guest or by hotel staff.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("parkingAvailable")]
        public virtual System.Nullable<bool> ParkingAvailable { get; set; }

        /// <summary>Parking available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("parkingAvailableException")]
        public virtual string ParkingAvailableException { get; set; }

        /// <summary>
        /// Free parking. The hotel allows the cars of guests to be parked for free. Parking facility may be an outdoor
        /// lot or an indoor garage, but must be onsite. Nearby parking does not apply. Parking may be performed by the
        /// guest or by hotel staff. Free parking must be available to all guests (limited conditions does not apply).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeParking")]
        public virtual System.Nullable<bool> FreeParking { get; set; }

        /// <summary>Free parking exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeParkingException")]
        public virtual string FreeParkingException { get; set; }

        /// <summary>
        /// Self parking available. Guests park their own cars. Parking facility may be an outdoor lot or an indoor
        /// garage, but must be onsite. Nearby parking does not apply. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("selfParkingAvailable")]
        public virtual System.Nullable<bool> SelfParkingAvailable { get; set; }

        /// <summary>Self parking available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("selfParkingAvailableException")]
        public virtual string SelfParkingAvailableException { get; set; }

        /// <summary>
        /// Free self parking. Guests park their own cars for free. Parking facility may be an outdoor lot or an indoor
        /// garage, but must be onsite. Nearby parking does not apply.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeSelfParking")]
        public virtual System.Nullable<bool> FreeSelfParking { get; set; }

        /// <summary>Free self parking exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeSelfParkingException")]
        public virtual string FreeSelfParkingException { get; set; }

        /// <summary>
        /// Valet parking available. Hotel staff member parks the cars of guests. Parking with this service can be free
        /// or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valetParkingAvailable")]
        public virtual System.Nullable<bool> ValetParkingAvailable { get; set; }

        /// <summary>Valet parking available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valetParkingAvailableException")]
        public virtual string ValetParkingAvailableException { get; set; }

        /// <summary>
        /// Free valet parking. Hotel staff member parks the cars of guests. Parking with this service is free.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeValetParking")]
        public virtual System.Nullable<bool> FreeValetParking { get; set; }

        /// <summary>Free valet parking exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeValetParkingException")]
        public virtual string FreeValetParkingException { get; set; }

        /// <summary>
        /// Electric car charging stations. Electric power stations, usually located outdoors, into which guests plug
        /// their electric cars to receive a charge.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("electricCarChargingStations")]
        public virtual System.Nullable<bool> ElectricCarChargingStations { get; set; }

        /// <summary>Electric car charging stations exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("electricCarChargingStationsException")]
        public virtual string ElectricCarChargingStationsException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Forms of payment accepted at the property.</summary>
    public class PaymentOptions : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Cash. The hotel accepts payment by paper/coin currency.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cash")]
        public virtual System.Nullable<bool> Cash { get; set; }

        /// <summary>Cash exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cashException")]
        public virtual string CashException { get; set; }

        /// <summary>
        /// Cheque. The hotel accepts a printed document issued by the guest's bank in the guest's name as a form of
        /// payment.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cheque")]
        public virtual System.Nullable<bool> Cheque { get; set; }

        /// <summary>Cheque exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("chequeException")]
        public virtual string ChequeException { get; set; }

        /// <summary>
        /// Credit card. The hotel accepts payment by a card issued by a bank or credit card company. Also known as
        /// charge card, debit card, bank card, or charge plate.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("creditCard")]
        public virtual System.Nullable<bool> CreditCard { get; set; }

        /// <summary>Credit card exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("creditCardException")]
        public virtual string CreditCardException { get; set; }

        /// <summary>
        /// Debit card. The hotel accepts a bank-issued card that immediately deducts the charged funds from the guest's
        /// bank account upon processing.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("debitCard")]
        public virtual System.Nullable<bool> DebitCard { get; set; }

        /// <summary>Debit card exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("debitCardException")]
        public virtual string DebitCardException { get; set; }

        /// <summary>
        /// Mobile nfc. The hotel has the compatible computer hardware terminal that reads and charges a payment app on
        /// the guest's smartphone without requiring the two devices to make physical contact. Also known as Apple Pay,
        /// Google Pay, Samsung Pay.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobileNfc")]
        public virtual System.Nullable<bool> MobileNfc { get; set; }

        /// <summary>Mobile nfc exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("mobileNfcException")]
        public virtual string MobileNfcException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Personal protection measures implemented by the hotel during COVID-19.</summary>
    public class PersonalProtection : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Hand-sanitizer and/or sanitizing wipes are offered in common areas.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonAreasOfferSanitizingItems")]
        public virtual System.Nullable<bool> CommonAreasOfferSanitizingItems { get; set; }

        /// <summary>Common areas offer sanitizing items exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonAreasOfferSanitizingItemsException")]
        public virtual string CommonAreasOfferSanitizingItemsException { get; set; }

        /// <summary>In-room hygiene kits with masks, hand sanitizer, and/or antibacterial wipes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("guestRoomHygieneKitsAvailable")]
        public virtual System.Nullable<bool> GuestRoomHygieneKitsAvailable { get; set; }

        /// <summary>Guest room hygiene kits available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("guestRoomHygieneKitsAvailableException")]
        public virtual string GuestRoomHygieneKitsAvailableException { get; set; }

        /// <summary>Masks and/or gloves available for guests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("protectiveEquipmentAvailable")]
        public virtual System.Nullable<bool> ProtectiveEquipmentAvailable { get; set; }

        /// <summary>Protective equipment available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("protectiveEquipmentAvailableException")]
        public virtual string ProtectiveEquipmentAvailableException { get; set; }

        /// <summary>Masks required on the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("faceMaskRequired")]
        public virtual System.Nullable<bool> FaceMaskRequired { get; set; }

        /// <summary>Face mask required exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("faceMaskRequiredException")]
        public virtual string FaceMaskRequiredException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Policies regarding guest-owned animals.</summary>
    public class Pets : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Pets allowed. Household animals are allowed at the property and in the specific guest room of their owner.
        /// May or may not include dogs, cats, reptiles and/or fish. May or may not require a fee. Service animals are
        /// not considered to be pets, so not governed by this policy.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("petsAllowed")]
        public virtual System.Nullable<bool> PetsAllowed { get; set; }

        /// <summary>Pets allowed exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("petsAllowedException")]
        public virtual string PetsAllowedException { get; set; }

        /// <summary>
        /// Pets allowed free. Household animals are allowed at the property and in the specific guest room of their
        /// owner for free. May or may not include dogs, cats, reptiles, and/or fish.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("petsAllowedFree")]
        public virtual System.Nullable<bool> PetsAllowedFree { get; set; }

        /// <summary>Pets allowed free exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("petsAllowedFreeException")]
        public virtual string PetsAllowedFreeException { get; set; }

        /// <summary>
        /// Dogs allowed. Domesticated canines are permitted at the property and allowed to stay in the guest room of
        /// their owner. May or may not require a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dogsAllowed")]
        public virtual System.Nullable<bool> DogsAllowed { get; set; }

        /// <summary>Dogs allowed exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dogsAllowedException")]
        public virtual string DogsAllowedException { get; set; }

        /// <summary>
        /// Cats allowed. Domesticated felines are permitted at the property and allowed to stay in the guest room of
        /// their owner. May or may not require a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("catsAllowed")]
        public virtual System.Nullable<bool> CatsAllowed { get; set; }

        /// <summary>Cats allowed exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("catsAllowedException")]
        public virtual string CatsAllowedException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Input for PHONE_CALL/SMS verification.</summary>
    public class PhoneInput : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The phone number that should be called or be sent SMS to. It must be one of the phone numbers in the
        /// eligible options.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("phoneNumber")]
        public virtual string PhoneNumber { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Display Data for verifications through phone, e.g. phone call, sms.</summary>
    public class PhoneVerificationData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Phone number that the PIN will be sent to.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("phoneNumber")]
        public virtual string PhoneNumber { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Physical distancing measures implemented by the hotel during COVID-19.</summary>
    public class PhysicalDistancing : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Physical distancing required.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("physicalDistancingRequired")]
        public virtual System.Nullable<bool> PhysicalDistancingRequired { get; set; }

        /// <summary>Physical distancing required exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("physicalDistancingRequiredException")]
        public virtual string PhysicalDistancingRequiredException { get; set; }

        /// <summary>Safety dividers at front desk and other locations.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("safetyDividers")]
        public virtual System.Nullable<bool> SafetyDividers { get; set; }

        /// <summary>Safety dividers exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("safetyDividersException")]
        public virtual string SafetyDividersException { get; set; }

        /// <summary>Guest occupancy limited within shared facilities.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sharedAreasLimitedOccupancy")]
        public virtual System.Nullable<bool> SharedAreasLimitedOccupancy { get; set; }

        /// <summary>Shared areas limited occupancy exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sharedAreasLimitedOccupancyException")]
        public virtual string SharedAreasLimitedOccupancyException { get; set; }

        /// <summary>Private spaces designated in spa and wellness areas.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wellnessAreasHavePrivateSpaces")]
        public virtual System.Nullable<bool> WellnessAreasHavePrivateSpaces { get; set; }

        /// <summary>Wellness areas have private spaces exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wellnessAreasHavePrivateSpacesException")]
        public virtual string WellnessAreasHavePrivateSpacesException { get; set; }

        /// <summary>Common areas arranged to maintain physical distancing.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonAreasPhysicalDistancingArranged")]
        public virtual System.Nullable<bool> CommonAreasPhysicalDistancingArranged { get; set; }

        /// <summary>Common areas physical distancing arranged exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("commonAreasPhysicalDistancingArrangedException")]
        public virtual string CommonAreasPhysicalDistancingArrangedException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Defines an area that's represented by a place ID.</summary>
    public class PlaceInfo : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The localized name of the place. For example, `Scottsdale, AZ`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// The ID of the place. Must correspond to a [region.]
        /// (https://developers.google.com/places/web-service/supported_types#table3)
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("placeId")]
        public virtual string PlaceId { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Defines the union of areas represented by a set of places.</summary>
    public class Places : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The areas represented by place IDs. Limited to a maximum of 20 places.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("placeInfos")]
        public virtual System.Collections.Generic.IList<PlaceInfo> PlaceInfos { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A radius around a particular point (latitude/longitude).</summary>
    public class PointRadius : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The latitude/longitude that specifies the center of an area defined by the radius.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("latlng")]
        public virtual LatLng Latlng { get; set; }

        /// <summary>The distance in kilometers of the area around the point.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("radiusKm")]
        public virtual System.Nullable<float> RadiusKm { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Property rules that impact guests.</summary>
    public class Policies : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Check-in time. The time of the day at which the hotel begins providing guests access to their unit at the
        /// beginning of their stay.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checkinTime")]
        public virtual TimeOfDay CheckinTime { get; set; }

        /// <summary>Check-in time exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checkinTimeException")]
        public virtual string CheckinTimeException { get; set; }

        /// <summary>
        /// Check-out time. The time of the day on the last day of a guest's reserved stay at which the guest must
        /// vacate their room and settle their bill. Some hotels may offer late or early check out for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checkoutTime")]
        public virtual TimeOfDay CheckoutTime { get; set; }

        /// <summary>Check-out time exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("checkoutTimeException")]
        public virtual string CheckoutTimeException { get; set; }

        /// <summary>
        /// Kids stay free. The children of guests are allowed to stay in the room/suite of a parent or adult without an
        /// additional fee. The policy may or may not stipulate a limit of the child's age or the overall number of
        /// children allowed.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kidsStayFree")]
        public virtual System.Nullable<bool> KidsStayFree { get; set; }

        /// <summary>Kids stay free exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("kidsStayFreeException")]
        public virtual string KidsStayFreeException { get; set; }

        /// <summary>
        /// Max kids stay free count. The hotel allows a specific, defined number of children to stay in the room/suite
        /// of a parent or adult without an additional fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxKidsStayFreeCount")]
        public virtual System.Nullable<int> MaxKidsStayFreeCount { get; set; }

        /// <summary>Max kids stay free count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxKidsStayFreeCountException")]
        public virtual string MaxKidsStayFreeCountException { get; set; }

        /// <summary>
        /// Max child age. The hotel allows children up to a certain age to stay in the room/suite of a parent or adult
        /// without an additional fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxChildAge")]
        public virtual System.Nullable<int> MaxChildAge { get; set; }

        /// <summary>Max child age exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("maxChildAgeException")]
        public virtual string MaxChildAgeException { get; set; }

        /// <summary>
        /// Smoke free property. Smoking is not allowed inside the building, on balconies, or in outside spaces. Hotels
        /// that offer a designated area for guests to smoke are not considered smoke-free properties.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smokeFreeProperty")]
        public virtual System.Nullable<bool> SmokeFreeProperty { get; set; }

        /// <summary>Smoke free property exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("smokeFreePropertyException")]
        public virtual string SmokeFreePropertyException { get; set; }

        /// <summary>
        /// All inclusive available. The hotel offers a rate option that includes the cost of the room, meals,
        /// activities, and other amenities that might otherwise be charged separately.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allInclusiveAvailable")]
        public virtual System.Nullable<bool> AllInclusiveAvailable { get; set; }

        /// <summary>All inclusive available exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allInclusiveAvailableException")]
        public virtual string AllInclusiveAvailableException { get; set; }

        /// <summary>
        /// All inclusive only. The only rate option offered by the hotel is a rate that includes the cost of the room,
        /// meals, activities and other amenities that might otherwise be charged separately.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allInclusiveOnly")]
        public virtual System.Nullable<bool> AllInclusiveOnly { get; set; }

        /// <summary>All inclusive only exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("allInclusiveOnlyException")]
        public virtual string AllInclusiveOnlyException { get; set; }

        /// <summary>Forms of payment accepted at the property.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("paymentOptions")]
        public virtual PaymentOptions PaymentOptions { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Swimming pool or recreational water facilities available at the hotel.</summary>
    public class Pools : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Pool. The presence of a pool, either indoors or outdoors, for guests to use for swimming and/or soaking. Use
        /// may or may not be restricted to adults and/or children.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("pool")]
        public virtual System.Nullable<bool> Pool { get; set; }

        /// <summary>Pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("poolException")]
        public virtual string PoolException { get; set; }

        /// <summary>Pools count. The sum of all pools at the hotel.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("poolsCount")]
        public virtual System.Nullable<int> PoolsCount { get; set; }

        /// <summary>Pools count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("poolsCountException")]
        public virtual string PoolsCountException { get; set; }

        /// <summary>
        /// Indoor pool. A pool located inside the hotel and available for guests to use for swimming and/or soaking.
        /// Use may or may not be restricted to adults and/or children.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indoorPool")]
        public virtual System.Nullable<bool> IndoorPool { get; set; }

        /// <summary>Indoor pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indoorPoolException")]
        public virtual string IndoorPoolException { get; set; }

        /// <summary>Indoor pools count. The sum of all indoor pools at the hotel.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indoorPoolsCount")]
        public virtual System.Nullable<int> IndoorPoolsCount { get; set; }

        /// <summary>Indoor pools count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("indoorPoolsCountException")]
        public virtual string IndoorPoolsCountException { get; set; }

        /// <summary>
        /// Outdoor pool. A pool located outside on the grounds of the hotel and available for guests to use for
        /// swimming, soaking or recreation. Use may or may not be restricted to adults and/or children.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("outdoorPool")]
        public virtual System.Nullable<bool> OutdoorPool { get; set; }

        /// <summary>Outdoor pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("outdoorPoolException")]
        public virtual string OutdoorPoolException { get; set; }

        /// <summary>Outdoor pools count. The sum of all outdoor pools at the hotel.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("outdoorPoolsCount")]
        public virtual System.Nullable<int> OutdoorPoolsCount { get; set; }

        /// <summary>Outdoor pools count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("outdoorPoolsCountException")]
        public virtual string OutdoorPoolsCountException { get; set; }

        /// <summary>
        /// Hot tub. A man-made pool containing bubbling water maintained at a higher temperature and circulated by
        /// aerating jets for the purpose of soaking, relaxation and hydrotherapy. Can be indoors or outdoors. Not used
        /// for active swimming. Also known as Jacuzzi. Hot tub must be in a common area where all guests can access it.
        /// Does not apply to room-specific hot tubs that are only accessible to guest occupying that room.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hotTub")]
        public virtual System.Nullable<bool> HotTub { get; set; }

        /// <summary>Hot tub exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hotTubException")]
        public virtual string HotTubException { get; set; }

        /// <summary>
        /// Waterslide. A continuously wetted chute positioned by an indoor or outdoor pool which people slide down into
        /// the water.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("waterslide")]
        public virtual System.Nullable<bool> Waterslide { get; set; }

        /// <summary>Waterslide exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("waterslideException")]
        public virtual string WaterslideException { get; set; }

        /// <summary>
        /// Lazy river. A man-made pool or several interconnected recreational pools built to mimic the shape and
        /// current of a winding river where guests float in the water on inflated rubber tubes. Can be indoors or
        /// outdoors.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lazyRiver")]
        public virtual System.Nullable<bool> LazyRiver { get; set; }

        /// <summary>Lazy river exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lazyRiverException")]
        public virtual string LazyRiverException { get; set; }

        /// <summary>Adult pool. A pool restricted for use by adults only. Can be indoors or outdoors.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adultPool")]
        public virtual System.Nullable<bool> AdultPool { get; set; }

        /// <summary>Adult pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("adultPoolException")]
        public virtual string AdultPoolException { get; set; }

        /// <summary>
        /// Wading pool. A shallow pool designed for small children to play in. Can be indoors or outdoors. Also known
        /// as kiddie pool.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wadingPool")]
        public virtual System.Nullable<bool> WadingPool { get; set; }

        /// <summary>Wading pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wadingPoolException")]
        public virtual string WadingPoolException { get; set; }

        /// <summary>
        /// Wave pool. A large indoor or outdoor pool with a machine that produces water currents to mimic the ocean's
        /// crests.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wavePool")]
        public virtual System.Nullable<bool> WavePool { get; set; }

        /// <summary>Wave pool exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wavePoolException")]
        public virtual string WavePoolException { get; set; }

        /// <summary>
        /// Water park. An aquatic recreation area with a large pool or series of pools that has features such as a
        /// water slide or tube, wavepool, fountains, rope swings, and/or obstacle course. Can be indoors or outdoors.
        /// Also known as adventure pool.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("waterPark")]
        public virtual System.Nullable<bool> WaterPark { get; set; }

        /// <summary>Water park exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("waterParkException")]
        public virtual string WaterParkException { get; set; }

        /// <summary>
        /// Lifeguard. A trained member of the hotel staff stationed by the hotel's indoor or outdoor swimming area and
        /// responsible for the safety of swimming guests.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lifeguard")]
        public virtual System.Nullable<bool> Lifeguard { get; set; }

        /// <summary>Lifeguard exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lifeguardException")]
        public virtual string LifeguardException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Serving portion size of a food dish.</summary>
    public class PortionSize : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Required. Number of the portion.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("quantity")]
        public virtual System.Nullable<int> Quantity { get; set; }

        /// <summary>Required. The repeated name_info field is for the unit in multiple languages.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("unit")]
        public virtual System.Collections.Generic.IList<MenuLabel> Unit { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal
    /// service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations
    /// (roads, towns, mountains). In typical usage an address would be created via user input or from importing
    /// existing data, depending on the type of process. Advice on address input / editing: - Use an i18n-ready address
    /// widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for
    /// input or editing of fields outside countries where that field is used. For more guidance on how to use this
    /// schema, please see: https://support.google.com/business/answer/6397478
    /// </summary>
    public class PostalAddress : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new
        /// revisions **must** be backward compatible with old revisions.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("revision")]
        public virtual System.Nullable<int> Revision { get; set; }

        /// <summary>
        /// Required. CLDR region code of the country/region of the address. This is never inferred and it is up to the
        /// user to ensure the value is correct. See http://cldr.unicode.org/ and
        /// http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for
        /// Switzerland.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("regionCode")]
        public virtual string RegionCode { get; set; }

        /// <summary>
        /// Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of
        /// the input form or is expected to match one of the languages used in the address' country/region, or their
        /// transliterated equivalents. This can affect formatting in certain countries, but is not critical to the
        /// correctness of the data and will never affect any validation or other non-formatting related operations. If
        /// this value is not known, it should be omitted (rather than specifying a possibly incorrect default).
        /// Examples: "zh-Hant", "ja", "ja-Latn", "en".
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>
        /// Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where
        /// they are used, they may trigger additional validation with other parts of the address (e.g. state/zip
        /// validation in the U.S.A.).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("postalCode")]
        public virtual string PostalCode { get; set; }

        /// <summary>
        /// Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used,
        /// the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a
        /// number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office
        /// indicator" (e.g. Côte d'Ivoire).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sortingCode")]
        public virtual string SortingCode { get; set; }

        /// <summary>
        /// Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For
        /// example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the
        /// province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use
        /// an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("administrativeArea")]
        public virtual string AdministrativeArea { get; set; }

        /// <summary>
        /// Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post
        /// town. In regions of the world where localities are not well defined or do not fit into this structure well,
        /// leave locality empty and use address_lines.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locality")]
        public virtual string Locality { get; set; }

        /// <summary>
        /// Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sublocality")]
        public virtual string Sublocality { get; set; }

        /// <summary>
        /// Unstructured address lines describing the lower levels of an address. Because values in address_lines do not
        /// have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is
        /// important that the line order is clear. The order of address lines should be "envelope order" for the
        /// country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make
        /// it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the
        /// most specific line of an address can be selected based on the language. The minimum permitted structural
        /// representation of an address consists of a region_code with all remaining information placed in the
        /// address_lines. It would be possible to format such an address very approximately without geocoding, but no
        /// semantic reasoning could be made about any of the address components until it was at least partially
        /// resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the
        /// recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the
        /// address should be localities or administrative areas).
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("addressLines")]
        public virtual System.Collections.Generic.IList<string> AddressLines { get; set; }

        /// <summary>
        /// Optional. The recipient at the address. This field may, under certain circumstances, contain multiline
        /// information. For example, it might contain "care of" information.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("recipients")]
        public virtual System.Collections.Generic.IList<string> Recipients { get; set; }

        /// <summary>Optional. The name of the organization at the address.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("organization")]
        public virtual string Organization { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A list of item price information. Price lists are structured as one or more price lists, each containing one or
    /// more sections with one or more items. For example, food price lists may represent breakfast/lunch/dinner menus,
    /// with sections for burgers/steak/seafood.
    /// </summary>
    public class PriceList : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. ID for the price list. Price list, section, and item IDs cannot be duplicated within this
        /// Location.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("priceListId")]
        public virtual string PriceListId { get; set; }

        /// <summary>Required. Language-tagged labels for the price list.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<Label> Labels { get; set; }

        /// <summary>
        /// Optional source URL of where the price list was retrieved from. For example, this could be the URL of the
        /// page that was automatically scraped to populate the menu information.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sourceUrl")]
        public virtual string SourceUrl { get; set; }

        /// <summary>
        /// Required. Sections for this price list. Each price list must contain at least one section.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sections")]
        public virtual System.Collections.Generic.IList<Section> Sections { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>All information pertaining to the location's profile.</summary>
    public class Profile : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Description of the location in your own voice, not editable by anyone else.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>General factual information about the property's physical structure and important dates.</summary>
    public class Property : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Built year. The year that construction of the property was completed.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("builtYear")]
        public virtual System.Nullable<int> BuiltYear { get; set; }

        /// <summary>Built year exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("builtYearException")]
        public virtual string BuiltYearException { get; set; }

        /// <summary>
        /// Last renovated year. The year when the most recent renovation of the property was completed. Renovation may
        /// include all or any combination of the following: the units, the public spaces, the exterior, or the
        /// interior.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lastRenovatedYear")]
        public virtual System.Nullable<int> LastRenovatedYear { get; set; }

        /// <summary>Last renovated year exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lastRenovatedYearException")]
        public virtual string LastRenovatedYearException { get; set; }

        /// <summary>
        /// Rooms count. The total number of rooms and suites bookable by guests for an overnight stay. Does not include
        /// event space, public spaces, conference rooms, fitness rooms, business centers, spa, salon, restaurants/bars,
        /// or shops.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("roomsCount")]
        public virtual System.Nullable<int> RoomsCount { get; set; }

        /// <summary>Rooms count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("roomsCountException")]
        public virtual string RoomsCountException { get; set; }

        /// <summary>
        /// Floors count. The number of stories the building has from the ground floor to the top floor that are
        /// accessible to guests.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("floorsCount")]
        public virtual System.Nullable<int> FloorsCount { get; set; }

        /// <summary>Floors count exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("floorsCountException")]
        public virtual string FloorsCountException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a single question and some of its answers.</summary>
    public class Question : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. The unique name for the question. accounts/*/locations/*/questions/*</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>Output only. The author of the question.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("author")]
        public virtual Author Author { get; set; }

        /// <summary>Output only. The number of upvotes for the question.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("upvoteCount")]
        public virtual System.Nullable<int> UpvoteCount { get; set; }

        /// <summary>
        /// The text of the question. It should contain at least three words and the total length should be greater than
        /// or equal to 10 characters. The maximum length is 4096 characters.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("text")]
        public virtual string Text { get; set; }

        /// <summary>Output only. The timestamp for when the question was written.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("createTime")]
        public virtual object CreateTime { get; set; }

        /// <summary>Output only. The timestamp for when the question was last modified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateTime")]
        public virtual object UpdateTime { get; set; }

        /// <summary>
        /// Output only. A list of answers to the question, sorted by upvotes. This may not be a complete list of
        /// answers depending on the request parameters (answers_per_question)
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("topAnswers")]
        public virtual System.Collections.Generic.IList<Answer> TopAnswers { get; set; }

        /// <summary>Output only. The total number of answers posted for this question.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("totalAnswerCount")]
        public virtual System.Nullable<int> TotalAnswerCount { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A region with its associated request count.</summary>
    public class RegionCount : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Center of region.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("latlng")]
        public virtual LatLng Latlng { get; set; }

        /// <summary>Human-readable label for the region.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("label")]
        public virtual string Label { get; set; }

        /// <summary>Number of driving-direction requests from this region.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("count")]
        public virtual System.Nullable<long> Count { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Information of all parent and children locations related to this one.</summary>
    public class RelationshipData : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The resource name of the Chain that this location is member of. How to find Chain ID</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("parentChain")]
        public virtual string ParentChain { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Values for an attribute with a `value_type` of REPEATED_ENUM. This consists of two lists of value IDs: those
    /// that are set (true) and those that are unset (false). Values absent are considered unknown. At least one value
    /// must be specified.
    /// </summary>
    public class RepeatedEnumAttributeValue : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Enum values that are set.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("setValues")]
        public virtual System.Collections.Generic.IList<string> SetValues { get; set; }

        /// <summary>Enum values that are unset.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("unsetValues")]
        public virtual System.Collections.Generic.IList<string> UnsetValues { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for reporting a GoogleLocation.</summary>
    public class ReportGoogleLocationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Optional. The resource name of the location group that this Google Location is being reported for, in the
        /// format `accounts/{account_id}`.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationGroupName")]
        public virtual string LocationGroupName { get; set; }

        /// <summary>
        /// The reason for which the user is reporting this location when the issue is with the location itself.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reportReasonBadLocation")]
        public virtual string ReportReasonBadLocation { get; set; }

        /// <summary>
        /// The reason for which the user is reporting this location when the issue is with the recommendation. This
        /// report is useful if the location has been recommended to the GMB account.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reportReasonBadRecommendation")]
        public virtual string ReportReasonBadRecommendation { get; set; }

        /// <summary>
        /// Optional. A text entry for elaborating on the reason for which the user is reporting this location. The
        /// maximum length is 512 characters.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reportReasonElaboration")]
        public virtual string ReportReasonElaboration { get; set; }

        /// <summary>Optional. The BCP 47 code of language used in `report_reason_elaboration`.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reportReasonLanguageCode")]
        public virtual string ReportReasonLanguageCode { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Insights.ReportLocalPostInsights</summary>
    public class ReportLocalPostInsightsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. The list of posts for which to fetch insights data. All posts have to belong to the location whose
        /// name is specified in the `name` field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localPostNames")]
        public virtual System.Collections.Generic.IList<string> LocalPostNames { get; set; }

        /// <summary>
        /// A request to include basic metric insights in the report. This request applies to all posts requested.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("basicRequest")]
        public virtual BasicMetricsRequest BasicRequest { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Insights.ReportLocalPostInsights</summary>
    public class ReportLocalPostInsightsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>One entry per requested post corresponding to this location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localPostMetrics")]
        public virtual System.Collections.Generic.IList<LocalPostMetrics> LocalPostMetrics { get; set; }

        /// <summary>Time zone (IANA timezone IDs, eg, 'Europe/London') of the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeZone")]
        public virtual string TimeZone { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Insights.ReportLocationInsights.</summary>
    public class ReportLocationInsightsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of locations to fetch insights for, specified by their names.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationNames")]
        public virtual System.Collections.Generic.IList<string> LocationNames { get; set; }

        /// <summary>A request to include basic metric insights in the report.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("basicRequest")]
        public virtual BasicMetricsRequest BasicRequest { get; set; }

        /// <summary>A request to include insights about driving-direction requests in the report.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("drivingDirectionsRequest")]
        public virtual DrivingDirectionMetricsRequest DrivingDirectionsRequest { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for `Insights.ReportLocationInsights`.</summary>
    public class ReportLocationInsightsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A collection of metric values by location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationMetrics")]
        public virtual System.Collections.Generic.IList<LocationMetrics> LocationMetrics { get; set; }

        /// <summary>A collection of values for driving direction-related metrics.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationDrivingDirectionMetrics")]
        public virtual System.Collections.Generic.IList<LocationDrivingDirectionMetrics> LocationDrivingDirectionMetrics { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Output only. Represents a review for a location.</summary>
    public class Review : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The resource name. For Review it is of the form
        /// `accounts/{account_id}/locations/{location_id}/reviews/{review_id}`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>The encrypted unique identifier.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewId")]
        public virtual string ReviewId { get; set; }

        /// <summary>The author of the review.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewer")]
        public virtual Reviewer Reviewer { get; set; }

        /// <summary>The star rating of the review.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("starRating")]
        public virtual string StarRating { get; set; }

        /// <summary>The body of the review as plain text with markups.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("comment")]
        public virtual string Comment { get; set; }

        /// <summary>The timestamp for when the review was written.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("createTime")]
        public virtual object CreateTime { get; set; }

        /// <summary>The timestamp for when the review was last modified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateTime")]
        public virtual object UpdateTime { get; set; }

        /// <summary>The owner/manager of this location's reply to this review.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("reviewReply")]
        public virtual ReviewReply ReviewReply { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents the location owner/manager's reply to a review.</summary>
    public class ReviewReply : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The body of the reply as plain text with markups. The maximum length is 4096 bytes.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("comment")]
        public virtual string Comment { get; set; }

        /// <summary>Output only. The timestamp for when the reply was last modified.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("updateTime")]
        public virtual object UpdateTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents the author of the review.</summary>
    public class Reviewer : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The profile photo link of the reviewer. Only populated if `is_anonymous` is false.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("profilePhotoUrl")]
        public virtual string ProfilePhotoUrl { get; set; }

        /// <summary>
        /// The name of the reviewer. Only populated with the reviewer's real name if `is_anonymous` is false.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>Indicates whether the reviewer has opted to remain anonymous.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isAnonymous")]
        public virtual System.Nullable<bool> IsAnonymous { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Locations.SearchChains.</summary>
    public class SearchChainsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Chains that match the queried chain_display_name in SearchChainsRequest. If there are no matches, this field
        /// will be empty. Results are listed in order of relevance.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("chains")]
        public virtual System.Collections.Generic.IList<Chain> Chains { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for GoogleLocations.SearchGoogleLocations.</summary>
    public class SearchGoogleLocationsRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Location to search for. If provided, will find locations which match the provided location details.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("location")]
        public virtual Location Location { get; set; }

        /// <summary>
        /// Text query to search for. The search results from a query string will be less accurate than if providing an
        /// exact location, but can provide more inexact matches.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("query")]
        public virtual string Query { get; set; }

        /// <summary>
        /// The number of matches to return. The default value is 3, with a maximum of 10. Note that latency may
        /// increase if more are requested. There is no pagination.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("resultCount")]
        public virtual System.Nullable<int> ResultCount { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for GoogleLocations.SearchGoogleLocations.</summary>
    public class SearchGoogleLocationsResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// A collection of GoogleLocations that are potential matches to the specified request, listed in order from
        /// most to least accuracy.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("googleLocations")]
        public virtual System.Collections.Generic.IList<GoogleLocation> GoogleLocations { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A section of the price list containing one or more items.</summary>
    public class Section : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. ID for the section. Price list, section, and item IDs cannot be duplicated within this Location.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sectionId")]
        public virtual string SectionId { get; set; }

        /// <summary>
        /// Required. Language-tagged labels for the section. We recommend that section names and descriptions be 140
        /// characters or less. At least one set of labels is required.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("labels")]
        public virtual System.Collections.Generic.IList<Label> Labels { get; set; }

        /// <summary>Optional. Type of the current price list section. Default value is FOOD.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sectionType")]
        public virtual string SectionType { get; set; }

        /// <summary>Items that are contained within this section of the price list.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("items")]
        public virtual System.Collections.Generic.IList<Item> Items { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Service area businesses provide their service at the customer's location (for example, a locksmith or plumber).
    /// </summary>
    public class ServiceAreaBusiness : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Indicates the type of the service area business.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("businessType")]
        public virtual string BusinessType { get; set; }

        /// <summary>Output only. The area that this business serves centered around a point.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("radius")]
        public virtual PointRadius Radius { get; set; }

        /// <summary>The area that this business serves defined through a set of places.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("places")]
        public virtual Places Places { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Additional data for service business verification.</summary>
    public class ServiceBusinessContext : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The verification address of the location. It is used to either enable more verification options or send a
        /// postcard.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("address")]
        public virtual PostalAddress Address { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A message that describes a single service item. It is used to describe the type of service that the merchant
    /// provides. For example, haircut can be a service.
    /// </summary>
    public class ServiceItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Optional. This field decides whether or not the input service is offered by the merchant.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isOffered")]
        public virtual System.Nullable<bool> IsOffered { get; set; }

        /// <summary>This field will be set case of structured services data.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("structuredServiceItem")]
        public virtual StructuredServiceItem StructuredServiceItem { get; set; }

        /// <summary>This field will be set case of free-form services data.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeFormServiceItem")]
        public virtual FreeFormServiceItem FreeFormServiceItem { get; set; }

        /// <summary>
        /// Optional. Represents the monetary price of the service item. We recommend that currency_code and units
        /// should be set when including a price.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("price")]
        public virtual Money Price { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A service list containing one or more service items.</summary>
    public class ServiceList : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. Google identifier for this location in the form:
        /// `accounts/{account_id}/locations/{location_id}/serviceList`
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>
        /// Service items that are contained within this service list. Duplicated service items will be removed
        /// automatically.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("serviceItems")]
        public virtual System.Collections.Generic.IList<ServiceItem> ServiceItems { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A message describing a service type that the business offers.</summary>
    public class ServiceType : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Output only. A stable ID (provided by Google) for this service type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("serviceTypeId")]
        public virtual string ServiceTypeId { get; set; }

        /// <summary>Output only. The human-readable display name for the service type.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("displayName")]
        public virtual string DisplayName { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Conveniences or help provided by the property to facilitate an easier, more comfortable stay.</summary>
    public class Services : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Front desk. A counter or desk in the lobby or the immediate interior of the hotel where a member of the
        /// staff greets guests and processes the information related to their stay (including check-in and check-out).
        /// May or may not be manned and open 24/7.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frontDesk")]
        public virtual System.Nullable<bool> FrontDesk { get; set; }

        /// <summary>Front desk exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("frontDeskException")]
        public virtual string FrontDeskException { get; set; }

        /// <summary>24hr front desk. Front desk is staffed 24 hours a day.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("twentyFourHourFrontDesk")]
        public virtual System.Nullable<bool> TwentyFourHourFrontDesk { get; set; }

        /// <summary>24hr front desk exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("twentyFourHourFrontDeskException")]
        public virtual string TwentyFourHourFrontDeskException { get; set; }

        /// <summary>
        /// Concierge. Hotel staff member(s) responsible for facilitating an easy, comfortable stay through making
        /// reservations for meals, sourcing theater tickets, arranging tours, finding a doctor, making recommendations,
        /// and answering questions.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("concierge")]
        public virtual System.Nullable<bool> Concierge { get; set; }

        /// <summary>Concierge exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("conciergeException")]
        public virtual string ConciergeException { get; set; }

        /// <summary>
        /// Elevator. A passenger elevator that transports guests from one story to another. Also known as lift.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("elevator")]
        public virtual System.Nullable<bool> Elevator { get; set; }

        /// <summary>Elevator exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("elevatorException")]
        public virtual string ElevatorException { get; set; }

        /// <summary>
        /// Baggage storage. A provision for guests to leave their bags at the hotel when they arrive for their stay
        /// before the official check-in time. May or may not apply for guests who wish to leave their bags after
        /// check-out and before departing the locale. Also known as bag dropoff.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("baggageStorage")]
        public virtual System.Nullable<bool> BaggageStorage { get; set; }

        /// <summary>Baggage storage exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("baggageStorageException")]
        public virtual string BaggageStorageException { get; set; }

        /// <summary>
        /// Full service laundry. Laundry and dry cleaning facilitated and handled by the hotel on behalf of the guest.
        /// Does not include the provision for guests to do their own laundry in on-site machines.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fullServiceLaundry")]
        public virtual System.Nullable<bool> FullServiceLaundry { get; set; }

        /// <summary>Full service laundry exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fullServiceLaundryException")]
        public virtual string FullServiceLaundryException { get; set; }

        /// <summary>
        /// Self service laundry. On-site clothes washers and dryers accessible to guests for the purpose of washing and
        /// drying their own clothes. May or may not require payment to use the machines.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("selfServiceLaundry")]
        public virtual System.Nullable<bool> SelfServiceLaundry { get; set; }

        /// <summary>Self service laundry exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("selfServiceLaundryException")]
        public virtual string SelfServiceLaundryException { get; set; }

        /// <summary>
        /// Social hour. A reception with complimentary soft drinks, tea, coffee, wine and/or cocktails in the afternoon
        /// or evening. Can be hosted by hotel staff or guests may serve themselves. Also known as wine hour. The
        /// availability of coffee/tea in the lobby throughout the day does not constitute a social or wine hour.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("socialHour")]
        public virtual System.Nullable<bool> SocialHour { get; set; }

        /// <summary>Social hour exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("socialHourException")]
        public virtual string SocialHourException { get; set; }

        /// <summary>
        /// Wake up calls. By direction of the guest, a hotel staff member will phone the guest unit at the requested
        /// hour. Also known as morning call.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wakeUpCalls")]
        public virtual System.Nullable<bool> WakeUpCalls { get; set; }

        /// <summary>Wake up calls exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("wakeUpCallsException")]
        public virtual string WakeUpCallsException { get; set; }

        /// <summary>
        /// Convenience store. A shop at the hotel primarily selling snacks, drinks, non-prescription medicines, health
        /// and beauty aids, magazines and newspapers.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("convenienceStore")]
        public virtual System.Nullable<bool> ConvenienceStore { get; set; }

        /// <summary>Convenience store exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("convenienceStoreException")]
        public virtual string ConvenienceStoreException { get; set; }

        /// <summary>
        /// Gift shop. An on-site store primarily selling souvenirs, mementos and other gift items. May or may not also
        /// sell sundries, magazines and newspapers, clothing, or snacks.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("giftShop")]
        public virtual System.Nullable<bool> GiftShop { get; set; }

        /// <summary>Gift shop exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("giftShopException")]
        public virtual string GiftShopException { get; set; }

        /// <summary>
        /// Currency exchange. A staff member or automated machine tasked with the transaction of providing the native
        /// currency of the hotel's locale in exchange for the foreign currency provided by a guest.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("currencyExchange")]
        public virtual System.Nullable<bool> CurrencyExchange { get; set; }

        /// <summary>Currency exchange exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("currencyExchangeException")]
        public virtual string CurrencyExchangeException { get; set; }

        /// <summary>Languages spoken by at least one staff member.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languagesSpoken")]
        public virtual LanguagesSpoken LanguagesSpoken { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a single time period when a location's operational hours differ from its normal business hours. A
    /// special hour period must represent a range of less than 24 hours. The `open_time` and `start_date` must predate
    /// the `close_time` and `end_date`. The `close_time` and `end_date` can extend to 11:59 a.m. on the day after the
    /// specified `start_date`. For example, the following inputs are valid: start_date=2015-11-23, open_time=08:00,
    /// close_time=18:00 start_date=2015-11-23, end_date=2015-11-23, open_time=08:00, close_time=18:00
    /// start_date=2015-11-23, end_date=2015-11-24, open_time=13:00, close_time=11:59 The following inputs are not
    /// valid: start_date=2015-11-23, open_time=13:00, close_time=11:59 start_date=2015-11-23, end_date=2015-11-24,
    /// open_time=13:00, close_time=12:00 start_date=2015-11-23, end_date=2015-11-25, open_time=08:00, close_time=18:00
    /// </summary>
    public class SpecialHourPeriod : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The calendar date this special hour period starts on.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startDate")]
        public virtual Date StartDate { get; set; }

        /// <summary>
        /// The wall time on `start_date` when a location opens, expressed in 24hr ISO 8601 extended format. (hh:mm)
        /// Valid values are 00:00-24:00, where 24:00 represents midnight at the end of the specified day field. Must be
        /// specified if `is_closed` is false.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("openTime")]
        public virtual string OpenTime { get; set; }

        /// <summary>
        /// The calendar date this special hour period ends on. If `end_date` field is not set, default to the date
        /// specified in `start_date`. If set, this field must be equal to or at most 1 day after `start_date`.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("endDate")]
        public virtual Date EndDate { get; set; }

        /// <summary>
        /// The wall time on `end_date` when a location closes, expressed in 24hr ISO 8601 extended format. (hh:mm)
        /// Valid values are 00:00-24:00, where 24:00 represents midnight at the end of the specified day field. Must be
        /// specified if `is_closed` is false.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("closeTime")]
        public virtual string CloseTime { get; set; }

        /// <summary>
        /// If true, `end_date`, `open_time`, and `close_time` are ignored, and the date specified in `start_date` is
        /// treated as the location being closed for the entire day.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("isClosed")]
        public virtual System.Nullable<bool> IsClosed { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a set of time periods when a location's operational hours differ from its normal business hours.
    /// </summary>
    public class SpecialHours : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>A list of exceptions to the business's regular hours.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("specialHourPeriods")]
        public virtual System.Collections.Generic.IList<SpecialHourPeriod> SpecialHourPeriods { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Media.StartUploadMediaItemData.</summary>
    public class StartUploadMediaItemDataRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a structured service offered by the merchant. For eg: toilet_installation.</summary>
    public class StructuredServiceItem : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Required. The `service_type_id` field is a Google provided unique ID that can be found in
        /// `ServiceTypeMetadata`. This information is provided by BatchGetBusinessCategories rpc service.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("serviceTypeId")]
        public virtual string ServiceTypeId { get; set; }

        /// <summary>Optional. Description of structured service item. The character limit is 300.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("description")]
        public virtual string Description { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Represents a target location for a pending invitation.</summary>
    public class TargetLocation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The name of the location to which the user is invited.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationName")]
        public virtual string LocationName { get; set; }

        /// <summary>The address of the location to which the user is invited.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("locationAddress")]
        public virtual string LocationAddress { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>The dimension for which data is divided over.</summary>
    public class TimeDimension : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// The day of the week ("MONDAY" to "SUNDAY") this value corresponds to. Set for BREAKDOWN_DAY_OF_WEEK option.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dayOfWeek")]
        public virtual string DayOfWeek { get; set; }

        /// <summary>
        /// The hour of the day (0 to 23) this value corresponds to. Set for BREAKDOWN_HOUR_OF_DAY option.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeOfDay")]
        public virtual TimeOfDay TimeOfDay { get; set; }

        /// <summary>
        /// The range of time this value covers. Set for AGGREGATED_TOTAL and AGGREGATED_DAILY options.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("timeRange")]
        public virtual TimeRange TimeRange { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>An interval of time, inclusive. It must contain all fields to be valid.</summary>
    public class TimeInterval : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The start date of this period.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startDate")]
        public virtual Date StartDate { get; set; }

        /// <summary>The start time of this period.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startTime")]
        public virtual TimeOfDay StartTime { get; set; }

        /// <summary>The end date of this period.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("endDate")]
        public virtual Date EndDate { get; set; }

        /// <summary>The end time of this period.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("endTime")]
        public virtual TimeOfDay EndTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a time of day. The date and time zone are either not significant or are specified elsewhere. An API
    /// may choose to allow leap seconds. Related types are google.type.Date and `google.protobuf.Timestamp`.
    /// </summary>
    public class TimeOfDay : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Hours of day in 24 hour format. Should be from 0 to 23. An API may choose to allow the value "24:00:00" for
        /// scenarios like business closing time.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("hours")]
        public virtual System.Nullable<int> Hours { get; set; }

        /// <summary>Minutes of hour of day. Must be from 0 to 59.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("minutes")]
        public virtual System.Nullable<int> Minutes { get; set; }

        /// <summary>
        /// Seconds of minutes of the time. Must normally be from 0 to 59. An API may allow the value 60 if it allows
        /// leap-seconds.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("seconds")]
        public virtual System.Nullable<int> Seconds { get; set; }

        /// <summary>Fractions of seconds in nanoseconds. Must be from 0 to 999,999,999.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("nanos")]
        public virtual System.Nullable<int> Nanos { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// Represents a span of time that the business is open, starting on the specified open day/time and closing on the
    /// specified close day/time. The closing time must occur after the opening time, for example later in the same day,
    /// or on a subsequent day.
    /// </summary>
    public class TimePeriod : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Indicates the day of the week this period starts on.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("openDay")]
        public virtual string OpenDay { get; set; }

        /// <summary>
        /// Time in 24hr ISO 8601 extended format (hh:mm). Valid values are 00:00-24:00, where 24:00 represents midnight
        /// at the end of the specified day field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("openTime")]
        public virtual string OpenTime { get; set; }

        /// <summary>Indicates the day of the week this period ends on.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("closeDay")]
        public virtual string CloseDay { get; set; }

        /// <summary>
        /// Time in 24hr ISO 8601 extended format (hh:mm). Valid values are 00:00-24:00, where 24:00 represents midnight
        /// at the end of the specified day field.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("closeTime")]
        public virtual string CloseTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// A range of time. Data will be pulled over the range as a half-open inverval (that is, [start_time, end_time)).
    /// </summary>
    public class TimeRange : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Epoch timestamp for the start of the range (inclusive).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("startTime")]
        public virtual object StartTime { get; set; }

        /// <summary>Epoch timestamp for the end of the range (exclusive).</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("endTime")]
        public virtual object EndTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Top regions where driving-direction requests originated from.</summary>
    public class TopDirectionSources : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The number of days data is aggregated over.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("dayCount")]
        public virtual System.Nullable<int> DayCount { get; set; }

        /// <summary>Regions sorted in descending order by count.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("regionCounts")]
        public virtual System.Collections.Generic.IList<RegionCount> RegionCounts { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Locations.TransferLocation.</summary>
    public class TransferLocationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Name of the account resource to transfer the location to (for example, "accounts/8675309").
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("toAccount")]
        public virtual string ToAccount { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Vehicles or vehicular services facilitated or owned by the property.</summary>
    public class Transportation : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Transfer. Hotel provides a shuttle service or car service to take guests to and from the nearest airport or
        /// train station. Can be free or for a fee. Guests may share the vehicle with other guests unknown to them.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transfer")]
        public virtual System.Nullable<bool> Transfer { get; set; }

        /// <summary>Transfer exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("transferException")]
        public virtual string TransferException { get; set; }

        /// <summary>
        /// Airport shuttle. The hotel provides guests with a chauffeured van or bus to and from the airport. Can be
        /// free or for a fee. Guests may share the vehicle with other guests unknown to them. Applies if the hotel has
        /// a third-party shuttle service (office/desk etc.) within the hotel. As long as hotel provides this service,
        /// it doesn't matter if it's directly with them or a third party they work with. Does not apply if guest has to
        /// coordinate with an entity outside/other than the hotel.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airportShuttle")]
        public virtual System.Nullable<bool> AirportShuttle { get; set; }

        /// <summary>Airport shuttle exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("airportShuttleException")]
        public virtual string AirportShuttleException { get; set; }

        /// <summary>
        /// Free airport shuttle. Airport shuttle is free to guests. Must be free to all guests without any conditions.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeAirportShuttle")]
        public virtual System.Nullable<bool> FreeAirportShuttle { get; set; }

        /// <summary>Free airport shuttle exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeAirportShuttleException")]
        public virtual string FreeAirportShuttleException { get; set; }

        /// <summary>
        /// Local shuttle. A car, van or bus provided by the hotel to transport guests to destinations within a
        /// specified range of distance around the hotel. Usually shopping and/or convention centers, downtown
        /// districts, or beaches. Can be free or for a fee.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localShuttle")]
        public virtual System.Nullable<bool> LocalShuttle { get; set; }

        /// <summary>Local shuttle exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("localShuttleException")]
        public virtual string LocalShuttleException { get; set; }

        /// <summary>
        /// Car rental on property. A branch of a rental car company with a processing desk in the hotel. Available cars
        /// for rent may be awaiting at the hotel or in a nearby lot.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("carRentalOnProperty")]
        public virtual System.Nullable<bool> CarRentalOnProperty { get; set; }

        /// <summary>Car rental on property exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("carRentalOnPropertyException")]
        public virtual string CarRentalOnPropertyException { get; set; }

        /// <summary>
        /// Private car service. Hotel provides a private chauffeured car to transport guests to destinations.
        /// Passengers in the car are either alone or are known to one another and have requested the car together.
        /// Service can be free or for a fee and travel distance is usually limited to a specific range. Not a taxi.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateCarService")]
        public virtual System.Nullable<bool> PrivateCarService { get; set; }

        /// <summary>Private car service exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("privateCarServiceException")]
        public virtual string PrivateCarServiceException { get; set; }

        /// <summary>Free private car service. Private chauffeured car service is free to guests.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freePrivateCarService")]
        public virtual System.Nullable<bool> FreePrivateCarService { get; set; }

        /// <summary>Free private car service exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freePrivateCarServiceException")]
        public virtual string FreePrivateCarServiceException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for QuestionsAndAnswers.UpsertAnswer</summary>
    public class UpsertAnswerRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The new answer.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("answer")]
        public virtual Answer Answer { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Values for an attribute with a `value_type` of URL.</summary>
    public class UrlAttributeValue : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The URL.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("url")]
        public virtual string Url { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>A verification represents a verification attempt on a location.</summary>
    public class Verification : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Resource name of the verification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("name")]
        public virtual string Name { get; set; }

        /// <summary>The method of the verification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("method")]
        public virtual string Method { get; set; }

        /// <summary>The state of the verification.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("state")]
        public virtual string State { get; set; }

        /// <summary>The timestamp when the verification is requested.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("createTime")]
        public virtual object CreateTime { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>
    /// The verification option represents how to verify the location (indicated by verification method) and where the
    /// verification will be sent to (indicated by display data).
    /// </summary>
    public class VerificationOption : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Method to verify the location.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("verificationMethod")]
        public virtual string VerificationMethod { get; set; }

        /// <summary>Set only if the method is PHONE_CALL or SMS.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("phoneData")]
        public virtual PhoneVerificationData PhoneData { get; set; }

        /// <summary>Set only if the method is MAIL.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("addressData")]
        public virtual AddressVerificationData AddressData { get; set; }

        /// <summary>Set only if the method is EMAIL.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("emailData")]
        public virtual EmailVerificationData EmailData { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Request message for Verifications.VerifyLocation.</summary>
    public class VerifyLocationRequest : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Verification method.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("method")]
        public virtual string Method { get; set; }

        /// <summary>
        /// The BCP 47 language code representing the language that is to be used for the verification process.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("languageCode")]
        public virtual string LanguageCode { get; set; }

        /// <summary>The input for EMAIL method.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("emailInput")]
        public virtual EmailInput EmailInput { get; set; }

        /// <summary>The input for ADDRESS method.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("addressInput")]
        public virtual AddressInput AddressInput { get; set; }

        /// <summary>The input for PHONE_CALL/SMS method</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("phoneInput")]
        public virtual PhoneInput PhoneInput { get; set; }

        /// <summary>
        /// Extra context information for the verification of service businesses. Required for the locations whose
        /// business type is CUSTOMER_LOCATION_ONLY. For ADDRESS verification, the address will be used to send out
        /// postcard. For other methods, it should be the same as the one that is passed to FetchVerificationOptions.
        /// INVALID_ARGUMENT will be thrown if it is set for other types of business locations.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("context")]
        public virtual ServiceBusinessContext Context { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Response message for Verifications.VerifyLocation.</summary>
    public class VerifyLocationResponse : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>The created verification request.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("verification")]
        public virtual Verification Verification { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Views available from the guest unit itself.</summary>
    public class ViewsFromUnit : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>Beach view. A guestroom that features a window through which guests can see the beach.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("beachView")]
        public virtual System.Nullable<bool> BeachView { get; set; }

        /// <summary>Beach view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("beachViewException")]
        public virtual string BeachViewException { get; set; }

        /// <summary>
        /// City view. A guestroom that features a window through which guests can see the buildings, parks and/or
        /// streets of the city.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cityView")]
        public virtual System.Nullable<bool> CityView { get; set; }

        /// <summary>City view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("cityViewException")]
        public virtual string CityViewException { get; set; }

        /// <summary>Garden view. A guestroom that features a window through which guests can see a garden.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gardenView")]
        public virtual System.Nullable<bool> GardenView { get; set; }

        /// <summary>Garden view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("gardenViewException")]
        public virtual string GardenViewException { get; set; }

        /// <summary>Lake view.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lakeView")]
        public virtual System.Nullable<bool> LakeView { get; set; }

        /// <summary>Lake view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("lakeViewException")]
        public virtual string LakeViewException { get; set; }

        /// <summary>
        /// Landmark view. A guestroom that features a window through which guests can see a landmark such as the
        /// countryside, a golf course, the forest, a park, a rain forst, a mountain or a slope.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("landmarkView")]
        public virtual System.Nullable<bool> LandmarkView { get; set; }

        /// <summary>Landmark view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("landmarkViewException")]
        public virtual string LandmarkViewException { get; set; }

        /// <summary>Ocean view. A guestroom that features a window through which guests can see the ocean.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("oceanView")]
        public virtual System.Nullable<bool> OceanView { get; set; }

        /// <summary>Ocean view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("oceanViewException")]
        public virtual string OceanViewException { get; set; }

        /// <summary>
        /// Pool view. A guestroom that features a window through which guests can see the hotel's swimming pool.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("poolView")]
        public virtual System.Nullable<bool> PoolView { get; set; }

        /// <summary>Pool view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("poolViewException")]
        public virtual string PoolViewException { get; set; }

        /// <summary>
        /// Valley view. A guestroom that features a window through which guests can see over a valley.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valleyView")]
        public virtual System.Nullable<bool> ValleyView { get; set; }

        /// <summary>Valley view exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("valleyViewException")]
        public virtual string ValleyViewException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }

    /// <summary>Guest facilities at the property to promote or maintain health, beauty, and fitness.</summary>
    public class Wellness : Google.Apis.Requests.IDirectResponseSchema
    {
        /// <summary>
        /// Fitness center. A room or building at the hotel containing equipment to promote physical activity, such as
        /// treadmills, elliptical machines, stationary bikes, weight machines, free weights, and/or stretching mats.
        /// Use of the fitness center can be free or for a fee. May or may not be staffed. May or may not offer
        /// instructor-led classes in various styles of physical conditioning. May or may not be open 24/7. May or may
        /// not include locker rooms and showers. Also known as health club, gym, fitness room, health center.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fitnessCenter")]
        public virtual System.Nullable<bool> FitnessCenter { get; set; }

        /// <summary>Fitness center exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("fitnessCenterException")]
        public virtual string FitnessCenterException { get; set; }

        /// <summary>Free fitness center. Guests may use the fitness center for free.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeFitnessCenter")]
        public virtual System.Nullable<bool> FreeFitnessCenter { get; set; }

        /// <summary>Free fitness center exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeFitnessCenterException")]
        public virtual string FreeFitnessCenterException { get; set; }

        /// <summary>
        /// Elliptical machine. An electric, stationary fitness machine with pedals that simulates climbing, walking or
        /// running and provides a user-controlled range of speeds and tensions. May not have arm-controlled levers to
        /// work out the upper body as well. Commonly found in a gym, fitness room, health center, or health club.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ellipticalMachine")]
        public virtual System.Nullable<bool> EllipticalMachine { get; set; }

        /// <summary>Elliptical machine exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("ellipticalMachineException")]
        public virtual string EllipticalMachineException { get; set; }

        /// <summary>
        /// Treadmill. An electric stationary fitness machine that simulates a moving path to promote walking or running
        /// within a range of user-controlled speeds and inclines. Also known as running machine. Commonly found in a
        /// gym, fitness room, health center, or health club.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("treadmill")]
        public virtual System.Nullable<bool> Treadmill { get; set; }

        /// <summary>Treadmill exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("treadmillException")]
        public virtual string TreadmillException { get; set; }

        /// <summary>
        /// Weight machine. Non-electronic fitness equipment designed for the user to target the exertion of different
        /// muscles. Usually incorporates a padded seat, a stack of flat weights and various bars and pulleys. May be
        /// designed for toning a specific part of the body or may involve different user-controlled settings, hardware
        /// and pulleys so as to provide an overall workout in one machine. Commonly found in a gym, fitness center,
        /// fitness room, or health club.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("weightMachine")]
        public virtual System.Nullable<bool> WeightMachine { get; set; }

        /// <summary>Weight machine exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("weightMachineException")]
        public virtual string WeightMachineException { get; set; }

        /// <summary>
        /// Free weights. Individual handheld fitness equipment of varied weights used for upper body strength training
        /// or bodybuilding. Also known as barbells, dumbbells, or kettlebells. Often stored on a rack with the weights
        /// arranged from light to heavy. Commonly found in a gym, fitness room, health center, or health club.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeWeights")]
        public virtual System.Nullable<bool> FreeWeights { get; set; }

        /// <summary>Free weights exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("freeWeightsException")]
        public virtual string FreeWeightsException { get; set; }

        /// <summary>
        /// Spa. A designated area, room or building at the hotel offering health and beauty treatment through such
        /// means as steam baths, exercise equipment, and massage. May also offer facials, nail care, and hair care.
        /// Services are usually available by appointment and for an additional fee. Does not apply if hotel only offers
        /// a steam room; must offer other beauty and/or health treatments as well.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("spa")]
        public virtual System.Nullable<bool> Spa { get; set; }

        /// <summary>Spa exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("spaException")]
        public virtual string SpaException { get; set; }

        /// <summary>
        /// Salon. A room at the hotel where professionals provide hair styling services such as shampooing, blow
        /// drying, hair dos, hair cutting and hair coloring. Also known as hairdresser or beauty salon.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("salon")]
        public virtual System.Nullable<bool> Salon { get; set; }

        /// <summary>Salon exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("salonException")]
        public virtual string SalonException { get; set; }

        /// <summary>
        /// Sauna. A wood-paneled room heated to a high temperature where guests sit on built-in wood benches for the
        /// purpose of perspiring and relaxing their muscles. Can be dry or slightly wet heat. Not a steam room.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("sauna")]
        public virtual System.Nullable<bool> Sauna { get; set; }

        /// <summary>Sauna exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("saunaException")]
        public virtual string SaunaException { get; set; }

        /// <summary>
        /// Massage. A service provided by a trained massage therapist involving the physical manipulation of a guest's
        /// muscles in order to achieve relaxation or pain relief.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("massage")]
        public virtual System.Nullable<bool> Massage { get; set; }

        /// <summary>Massage exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("massageException")]
        public virtual string MassageException { get; set; }

        /// <summary>
        /// Doctor on call. The hotel has a contract with a medical professional who provides services to hotel guests
        /// should they fall ill during their stay. The doctor may or may not have an on-site office or be at the hotel
        /// at all times.
        /// </summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doctorOnCall")]
        public virtual System.Nullable<bool> DoctorOnCall { get; set; }

        /// <summary>Doctor on call exception.</summary>
        [Newtonsoft.Json.JsonPropertyAttribute("doctorOnCallException")]
        public virtual string DoctorOnCallException { get; set; }

        /// <summary>The ETag of the item.</summary>
        public virtual string ETag { get; set; }
    }
}
