/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Represents a Location that is present on Google. This can be a location that has been claimed by
 * the user, someone else, or could be unclaimed.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GoogleLocation extends com.google.api.client.json.GenericJson {

  /**
   * The sparsely populated Location information. This field can be re-used in CreateLocation if it
   * is not currently claimed by a user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Location location;

  /**
   * Resource name of this GoogleLocation, in the format `googleLocations/{googleLocationId}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A URL that will redirect the user to the request admin rights UI. This field is only present if
   * the location has already been claimed by any user, including the current user.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestAdminRightsUrl;

  /**
   * The sparsely populated Location information. This field can be re-used in CreateLocation if it
   * is not currently claimed by a user.
   * @return value or {@code null} for none
   */
  public Location getLocation() {
    return location;
  }

  /**
   * The sparsely populated Location information. This field can be re-used in CreateLocation if it
   * is not currently claimed by a user.
   * @param location location or {@code null} for none
   */
  public GoogleLocation setLocation(Location location) {
    this.location = location;
    return this;
  }

  /**
   * Resource name of this GoogleLocation, in the format `googleLocations/{googleLocationId}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Resource name of this GoogleLocation, in the format `googleLocations/{googleLocationId}`.
   * @param name name or {@code null} for none
   */
  public GoogleLocation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A URL that will redirect the user to the request admin rights UI. This field is only present if
   * the location has already been claimed by any user, including the current user.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestAdminRightsUrl() {
    return requestAdminRightsUrl;
  }

  /**
   * A URL that will redirect the user to the request admin rights UI. This field is only present if
   * the location has already been claimed by any user, including the current user.
   * @param requestAdminRightsUrl requestAdminRightsUrl or {@code null} for none
   */
  public GoogleLocation setRequestAdminRightsUrl(java.lang.String requestAdminRightsUrl) {
    this.requestAdminRightsUrl = requestAdminRightsUrl;
    return this;
  }

  @Override
  public GoogleLocation set(String fieldName, Object value) {
    return (GoogleLocation) super.set(fieldName, value);
  }

  @Override
  public GoogleLocation clone() {
    return (GoogleLocation) super.clone();
  }

}
