/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A message that describes a single service item. It is used to describe the type of service that
 * the merchant provides. For example, haircut can be a service.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceItem extends com.google.api.client.json.GenericJson {

  /**
   * This field will be set case of free-form services data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FreeFormServiceItem freeFormServiceItem;

  /**
   * Optional. This field decides whether or not the input service is offered by the merchant.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isOffered;

  /**
   * Optional. Represents the monetary price of the service item. We recommend that currency_code
   * and units should be set when including a price.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money price;

  /**
   * This field will be set case of structured services data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StructuredServiceItem structuredServiceItem;

  /**
   * This field will be set case of free-form services data.
   * @return value or {@code null} for none
   */
  public FreeFormServiceItem getFreeFormServiceItem() {
    return freeFormServiceItem;
  }

  /**
   * This field will be set case of free-form services data.
   * @param freeFormServiceItem freeFormServiceItem or {@code null} for none
   */
  public ServiceItem setFreeFormServiceItem(FreeFormServiceItem freeFormServiceItem) {
    this.freeFormServiceItem = freeFormServiceItem;
    return this;
  }

  /**
   * Optional. This field decides whether or not the input service is offered by the merchant.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsOffered() {
    return isOffered;
  }

  /**
   * Optional. This field decides whether or not the input service is offered by the merchant.
   * @param isOffered isOffered or {@code null} for none
   */
  public ServiceItem setIsOffered(java.lang.Boolean isOffered) {
    this.isOffered = isOffered;
    return this;
  }

  /**
   * Optional. Represents the monetary price of the service item. We recommend that currency_code
   * and units should be set when including a price.
   * @return value or {@code null} for none
   */
  public Money getPrice() {
    return price;
  }

  /**
   * Optional. Represents the monetary price of the service item. We recommend that currency_code
   * and units should be set when including a price.
   * @param price price or {@code null} for none
   */
  public ServiceItem setPrice(Money price) {
    this.price = price;
    return this;
  }

  /**
   * This field will be set case of structured services data.
   * @return value or {@code null} for none
   */
  public StructuredServiceItem getStructuredServiceItem() {
    return structuredServiceItem;
  }

  /**
   * This field will be set case of structured services data.
   * @param structuredServiceItem structuredServiceItem or {@code null} for none
   */
  public ServiceItem setStructuredServiceItem(StructuredServiceItem structuredServiceItem) {
    this.structuredServiceItem = structuredServiceItem;
    return this;
  }

  @Override
  public ServiceItem set(String fieldName, Object value) {
    return (ServiceItem) super.set(fieldName, value);
  }

  @Override
  public ServiceItem clone() {
    return (ServiceItem) super.clone();
  }

}
