/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Media.ListMediaItems.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListMediaItemsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The returned list of media items.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MediaItem> mediaItems;

  static {
    // hack to force ProGuard to consider MediaItem used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MediaItem.class);
  }

  /**
   * If there are more media items than the requested page size, then this field is populated with a
   * token to fetch the next page of media items on a subsequent call to ListMediaItems.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The total number of media items for this location, irrespective of pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalMediaItemCount;

  /**
   * The returned list of media items.
   * @return value or {@code null} for none
   */
  public java.util.List<MediaItem> getMediaItems() {
    return mediaItems;
  }

  /**
   * The returned list of media items.
   * @param mediaItems mediaItems or {@code null} for none
   */
  public ListMediaItemsResponse setMediaItems(java.util.List<MediaItem> mediaItems) {
    this.mediaItems = mediaItems;
    return this;
  }

  /**
   * If there are more media items than the requested page size, then this field is populated with a
   * token to fetch the next page of media items on a subsequent call to ListMediaItems.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If there are more media items than the requested page size, then this field is populated with a
   * token to fetch the next page of media items on a subsequent call to ListMediaItems.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListMediaItemsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The total number of media items for this location, irrespective of pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalMediaItemCount() {
    return totalMediaItemCount;
  }

  /**
   * The total number of media items for this location, irrespective of pagination.
   * @param totalMediaItemCount totalMediaItemCount or {@code null} for none
   */
  public ListMediaItemsResponse setTotalMediaItemCount(java.lang.Integer totalMediaItemCount) {
    this.totalMediaItemCount = totalMediaItemCount;
    return this;
  }

  @Override
  public ListMediaItemsResponse set(String fieldName, Object value) {
    return (ListMediaItemsResponse) super.set(fieldName, value);
  }

  @Override
  public ListMediaItemsResponse clone() {
    return (ListMediaItemsResponse) super.clone();
  }

}
