/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A category describing what this business is (not what it does). For a list of valid category IDs,
 * and the mappings to their human-readable names, see
 * [categories.list](https://developers.google.com/my-business/reference/rest/v4/categories/list).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Category extends com.google.api.client.json.GenericJson {

  /**
   * @OutputOnly. A stable ID (provided by Google) for this category. The `category_id` must be
   * specified when modifying the category (when creating or updating a location).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryId;

  /**
   * @OutputOnly. The human-readable name of the category. This is set when reading the location.
   * When modifying the location, `category_id` must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * Output only. More hours types that are available for this business category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MoreHoursType> moreHoursTypes;

  /**
   * @OutputOnly. A list of all the service types that are available for this business category.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceType> serviceTypes;

  /**
   * @OutputOnly. A stable ID (provided by Google) for this category. The `category_id` must be
   * specified when modifying the category (when creating or updating a location).
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryId() {
    return categoryId;
  }

  /**
   * @OutputOnly. A stable ID (provided by Google) for this category. The `category_id` must be
   * specified when modifying the category (when creating or updating a location).
   * @param categoryId categoryId or {@code null} for none
   */
  public Category setCategoryId(java.lang.String categoryId) {
    this.categoryId = categoryId;
    return this;
  }

  /**
   * @OutputOnly. The human-readable name of the category. This is set when reading the location.
   * When modifying the location, `category_id` must be set.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * @OutputOnly. The human-readable name of the category. This is set when reading the location.
   * When modifying the location, `category_id` must be set.
   * @param displayName displayName or {@code null} for none
   */
  public Category setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * Output only. More hours types that are available for this business category.
   * @return value or {@code null} for none
   */
  public java.util.List<MoreHoursType> getMoreHoursTypes() {
    return moreHoursTypes;
  }

  /**
   * Output only. More hours types that are available for this business category.
   * @param moreHoursTypes moreHoursTypes or {@code null} for none
   */
  public Category setMoreHoursTypes(java.util.List<MoreHoursType> moreHoursTypes) {
    this.moreHoursTypes = moreHoursTypes;
    return this;
  }

  /**
   * @OutputOnly. A list of all the service types that are available for this business category.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceType> getServiceTypes() {
    return serviceTypes;
  }

  /**
   * @OutputOnly. A list of all the service types that are available for this business category.
   * @param serviceTypes serviceTypes or {@code null} for none
   */
  public Category setServiceTypes(java.util.List<ServiceType> serviceTypes) {
    this.serviceTypes = serviceTypes;
    return this;
  }

  @Override
  public Category set(String fieldName, Object value) {
    return (Category) super.set(fieldName, value);
  }

  @Override
  public Category clone() {
    return (Category) super.clone();
  }

}
