/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A specific type of unit primarily defined by its features.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GuestUnitType extends com.google.api.client.json.GenericJson {

  /**
   * Required. Unit or room code identifiers for a single GuestUnitType. Each code must be unique
   * within a Lodging instance.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> codes;

  /**
   * Features and available amenities of the GuestUnitType.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private GuestUnitFeatures features;

  /**
   * Required. Short, English label or name of the GuestUnitType. Target <50 chars.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String label;

  /**
   * Required. Unit or room code identifiers for a single GuestUnitType. Each code must be unique
   * within a Lodging instance.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCodes() {
    return codes;
  }

  /**
   * Required. Unit or room code identifiers for a single GuestUnitType. Each code must be unique
   * within a Lodging instance.
   * @param codes codes or {@code null} for none
   */
  public GuestUnitType setCodes(java.util.List<java.lang.String> codes) {
    this.codes = codes;
    return this;
  }

  /**
   * Features and available amenities of the GuestUnitType.
   * @return value or {@code null} for none
   */
  public GuestUnitFeatures getFeatures() {
    return features;
  }

  /**
   * Features and available amenities of the GuestUnitType.
   * @param features features or {@code null} for none
   */
  public GuestUnitType setFeatures(GuestUnitFeatures features) {
    this.features = features;
    return this;
  }

  /**
   * Required. Short, English label or name of the GuestUnitType. Target <50 chars.
   * @return value or {@code null} for none
   */
  public java.lang.String getLabel() {
    return label;
  }

  /**
   * Required. Short, English label or name of the GuestUnitType. Target <50 chars.
   * @param label label or {@code null} for none
   */
  public GuestUnitType setLabel(java.lang.String label) {
    this.label = label;
    return this;
  }

  @Override
  public GuestUnitType set(String fieldName, Object value) {
    return (GuestUnitType) super.set(fieldName, value);
  }

  @Override
  public GuestUnitType clone() {
    return (GuestUnitType) super.clone();
  }

}
