/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for Locations.FindMatchingLocations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FindMatchingLocationsRequest extends com.google.api.client.json.GenericJson {

  /**
   * The preferred language for the matching location (in BCP-47 format).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Deprecated. This field is ignored for all requests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String maxCacheDuration;

  /**
   * The number of matches to return. The default value is 3, with a maximum of 10. Note that
   * latency may increase if more are requested. There is no pagination.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer numResults;

  /**
   * The preferred language for the matching location (in BCP-47 format).
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * The preferred language for the matching location (in BCP-47 format).
   * @param languageCode languageCode or {@code null} for none
   */
  public FindMatchingLocationsRequest setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  /**
   * Deprecated. This field is ignored for all requests.
   * @return value or {@code null} for none
   */
  public String getMaxCacheDuration() {
    return maxCacheDuration;
  }

  /**
   * Deprecated. This field is ignored for all requests.
   * @param maxCacheDuration maxCacheDuration or {@code null} for none
   */
  public FindMatchingLocationsRequest setMaxCacheDuration(String maxCacheDuration) {
    this.maxCacheDuration = maxCacheDuration;
    return this;
  }

  /**
   * The number of matches to return. The default value is 3, with a maximum of 10. Note that
   * latency may increase if more are requested. There is no pagination.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getNumResults() {
    return numResults;
  }

  /**
   * The number of matches to return. The default value is 3, with a maximum of 10. Note that
   * latency may increase if more are requested. There is no pagination.
   * @param numResults numResults or {@code null} for none
   */
  public FindMatchingLocationsRequest setNumResults(java.lang.Integer numResults) {
    this.numResults = numResults;
    return this;
  }

  @Override
  public FindMatchingLocationsRequest set(String fieldName, Object value) {
    return (FindMatchingLocationsRequest) super.set(fieldName, value);
  }

  @Override
  public FindMatchingLocationsRequest clone() {
    return (FindMatchingLocationsRequest) super.clone();
  }

}
