/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Reference to the photo binary data of a `MediaItem` uploaded through the My Business API. Create
 * a data ref using StartUploadMediaItemData, and use this ref when uploading bytes to [UpdateMedia]
 * and subsequently calling CreateMediaItem.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediaItemDataRef extends com.google.api.client.json.GenericJson {

  /**
   * The unique ID for this media item's binary data. Used to upload the photo data with
   * [UpdateMedia] and when creating a new media item from those bytes with CreateMediaItem. Example
   * of uploading bytes: `curl -X POST -T{path_to_file}
   * "http://mybusiness.googleapis.com/upload/v1/media/{resource_name}?upload_type=media"` For
   * CreateMediaItem calls, set this as the `MediaItem` `data_ref`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String resourceName;

  /**
   * The unique ID for this media item's binary data. Used to upload the photo data with
   * [UpdateMedia] and when creating a new media item from those bytes with CreateMediaItem. Example
   * of uploading bytes: `curl -X POST -T{path_to_file}
   * "http://mybusiness.googleapis.com/upload/v1/media/{resource_name}?upload_type=media"` For
   * CreateMediaItem calls, set this as the `MediaItem` `data_ref`.
   * @return value or {@code null} for none
   */
  public java.lang.String getResourceName() {
    return resourceName;
  }

  /**
   * The unique ID for this media item's binary data. Used to upload the photo data with
   * [UpdateMedia] and when creating a new media item from those bytes with CreateMediaItem. Example
   * of uploading bytes: `curl -X POST -T{path_to_file}
   * "http://mybusiness.googleapis.com/upload/v1/media/{resource_name}?upload_type=media"` For
   * CreateMediaItem calls, set this as the `MediaItem` `data_ref`.
   * @param resourceName resourceName or {@code null} for none
   */
  public MediaItemDataRef setResourceName(java.lang.String resourceName) {
    this.resourceName = resourceName;
    return this;
  }

  @Override
  public MediaItemDataRef set(String fieldName, Object value) {
    return (MediaItemDataRef) super.set(fieldName, value);
  }

  @Override
  public MediaItemDataRef clone() {
    return (MediaItemDataRef) super.clone();
  }

}
