/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A service list containing one or more service items.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ServiceList extends com.google.api.client.json.GenericJson {

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/serviceList`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Service items that are contained within this service list. Duplicated service items will be
   * removed automatically.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ServiceItem> serviceItems;

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/serviceList`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/serviceList`
   * @param name name or {@code null} for none
   */
  public ServiceList setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Service items that are contained within this service list. Duplicated service items will be
   * removed automatically.
   * @return value or {@code null} for none
   */
  public java.util.List<ServiceItem> getServiceItems() {
    return serviceItems;
  }

  /**
   * Service items that are contained within this service list. Duplicated service items will be
   * removed automatically.
   * @param serviceItems serviceItems or {@code null} for none
   */
  public ServiceList setServiceItems(java.util.List<ServiceItem> serviceItems) {
    this.serviceItems = serviceItems;
    return this;
  }

  @Override
  public ServiceList set(String fieldName, Object value) {
    return (ServiceList) super.set(fieldName, value);
  }

  @Override
  public ServiceList clone() {
    return (ServiceList) super.clone();
  }

}
