/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A single media item.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class MediaItem extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Attribution information for customer media items. You must display this
   * attribution as provided to your users and must not delete or alter the attribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Attribution attribution;

  /**
   * Output only. Creation time of this media item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String createTime;

  /**
   * Input only. A reference to media item binary data as obtained by the `StartUploadMediaItemData`
   * method. When creating a media item, either sourceUrl or dataRef must be set.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MediaItemDataRef dataRef;

  /**
   * Description for this media item. Descriptions cannot be modified through the My Business API,
   * but can be set when creating a new media item that is not a cover photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Output only. The dimensions (width and height) in pixels.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Dimensions dimensions;

  /**
   * Output only. Google-hosted URL for this media item. This URL is not static since it may change
   * over time. For video this will be a preview image with an overlaid play icon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String googleUrl;

  /**
   * Output only. Statistics for this media item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private MediaInsights insights;

  /**
   * Required when calling `CreatePhoto`. Describes how this media item is connected to its
   * location. Must be either a category (for example, EXTERIOR) or the ID of a price list item.
   * This is required when adding new media to a location with `CreateMediaItem`. For other types of
   * media, for example, photos on local posts, this will not be present.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LocationAssociation locationAssociation;

  /**
   * The format of this media item. Must be set when the media item is created, and is read-only on
   * all other requests. Cannot be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String mediaFormat;

  /**
   * The resource name for this media item.
   * `accounts/{account_id}/locations/{location_id}/media/{media_key}`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * A publicly accessible URL where the media item can be retrieved from. When creating one of this
   * or data_ref must be set to specify the source of the media item. If `source_url` was used when
   * creating a media item, it will be populated with that source URL when the media item is
   * retrieved. This field cannot be updated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceUrl;

  /**
   * Output only. Where provided, the URL of a thumbnail image for this media item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String thumbnailUrl;

  /**
   * Output only. Attribution information for customer media items. You must display this
   * attribution as provided to your users and must not delete or alter the attribution.
   * @return value or {@code null} for none
   */
  public Attribution getAttribution() {
    return attribution;
  }

  /**
   * Output only. Attribution information for customer media items. You must display this
   * attribution as provided to your users and must not delete or alter the attribution.
   * @param attribution attribution or {@code null} for none
   */
  public MediaItem setAttribution(Attribution attribution) {
    this.attribution = attribution;
    return this;
  }

  /**
   * Output only. Creation time of this media item.
   * @return value or {@code null} for none
   */
  public String getCreateTime() {
    return createTime;
  }

  /**
   * Output only. Creation time of this media item.
   * @param createTime createTime or {@code null} for none
   */
  public MediaItem setCreateTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

  /**
   * Input only. A reference to media item binary data as obtained by the `StartUploadMediaItemData`
   * method. When creating a media item, either sourceUrl or dataRef must be set.
   * @return value or {@code null} for none
   */
  public MediaItemDataRef getDataRef() {
    return dataRef;
  }

  /**
   * Input only. A reference to media item binary data as obtained by the `StartUploadMediaItemData`
   * method. When creating a media item, either sourceUrl or dataRef must be set.
   * @param dataRef dataRef or {@code null} for none
   */
  public MediaItem setDataRef(MediaItemDataRef dataRef) {
    this.dataRef = dataRef;
    return this;
  }

  /**
   * Description for this media item. Descriptions cannot be modified through the My Business API,
   * but can be set when creating a new media item that is not a cover photo.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Description for this media item. Descriptions cannot be modified through the My Business API,
   * but can be set when creating a new media item that is not a cover photo.
   * @param description description or {@code null} for none
   */
  public MediaItem setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Output only. The dimensions (width and height) in pixels.
   * @return value or {@code null} for none
   */
  public Dimensions getDimensions() {
    return dimensions;
  }

  /**
   * Output only. The dimensions (width and height) in pixels.
   * @param dimensions dimensions or {@code null} for none
   */
  public MediaItem setDimensions(Dimensions dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * Output only. Google-hosted URL for this media item. This URL is not static since it may change
   * over time. For video this will be a preview image with an overlaid play icon.
   * @return value or {@code null} for none
   */
  public java.lang.String getGoogleUrl() {
    return googleUrl;
  }

  /**
   * Output only. Google-hosted URL for this media item. This URL is not static since it may change
   * over time. For video this will be a preview image with an overlaid play icon.
   * @param googleUrl googleUrl or {@code null} for none
   */
  public MediaItem setGoogleUrl(java.lang.String googleUrl) {
    this.googleUrl = googleUrl;
    return this;
  }

  /**
   * Output only. Statistics for this media item.
   * @return value or {@code null} for none
   */
  public MediaInsights getInsights() {
    return insights;
  }

  /**
   * Output only. Statistics for this media item.
   * @param insights insights or {@code null} for none
   */
  public MediaItem setInsights(MediaInsights insights) {
    this.insights = insights;
    return this;
  }

  /**
   * Required when calling `CreatePhoto`. Describes how this media item is connected to its
   * location. Must be either a category (for example, EXTERIOR) or the ID of a price list item.
   * This is required when adding new media to a location with `CreateMediaItem`. For other types of
   * media, for example, photos on local posts, this will not be present.
   * @return value or {@code null} for none
   */
  public LocationAssociation getLocationAssociation() {
    return locationAssociation;
  }

  /**
   * Required when calling `CreatePhoto`. Describes how this media item is connected to its
   * location. Must be either a category (for example, EXTERIOR) or the ID of a price list item.
   * This is required when adding new media to a location with `CreateMediaItem`. For other types of
   * media, for example, photos on local posts, this will not be present.
   * @param locationAssociation locationAssociation or {@code null} for none
   */
  public MediaItem setLocationAssociation(LocationAssociation locationAssociation) {
    this.locationAssociation = locationAssociation;
    return this;
  }

  /**
   * The format of this media item. Must be set when the media item is created, and is read-only on
   * all other requests. Cannot be updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getMediaFormat() {
    return mediaFormat;
  }

  /**
   * The format of this media item. Must be set when the media item is created, and is read-only on
   * all other requests. Cannot be updated.
   * @param mediaFormat mediaFormat or {@code null} for none
   */
  public MediaItem setMediaFormat(java.lang.String mediaFormat) {
    this.mediaFormat = mediaFormat;
    return this;
  }

  /**
   * The resource name for this media item.
   * `accounts/{account_id}/locations/{location_id}/media/{media_key}`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name for this media item.
   * `accounts/{account_id}/locations/{location_id}/media/{media_key}`
   * @param name name or {@code null} for none
   */
  public MediaItem setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * A publicly accessible URL where the media item can be retrieved from. When creating one of this
   * or data_ref must be set to specify the source of the media item. If `source_url` was used when
   * creating a media item, it will be populated with that source URL when the media item is
   * retrieved. This field cannot be updated.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceUrl() {
    return sourceUrl;
  }

  /**
   * A publicly accessible URL where the media item can be retrieved from. When creating one of this
   * or data_ref must be set to specify the source of the media item. If `source_url` was used when
   * creating a media item, it will be populated with that source URL when the media item is
   * retrieved. This field cannot be updated.
   * @param sourceUrl sourceUrl or {@code null} for none
   */
  public MediaItem setSourceUrl(java.lang.String sourceUrl) {
    this.sourceUrl = sourceUrl;
    return this;
  }

  /**
   * Output only. Where provided, the URL of a thumbnail image for this media item.
   * @return value or {@code null} for none
   */
  public java.lang.String getThumbnailUrl() {
    return thumbnailUrl;
  }

  /**
   * Output only. Where provided, the URL of a thumbnail image for this media item.
   * @param thumbnailUrl thumbnailUrl or {@code null} for none
   */
  public MediaItem setThumbnailUrl(java.lang.String thumbnailUrl) {
    this.thumbnailUrl = thumbnailUrl;
    return this;
  }

  @Override
  public MediaItem set(String fieldName, Object value) {
    return (MediaItem) super.set(fieldName, value);
  }

  @Override
  public MediaItem clone() {
    return (MediaItem) super.clone();
  }

}
