/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Menu of a business that serves food dishes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FoodMenu extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Cuisine information for the food menu. It is highly recommended to provide this
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> cuisines;

  /**
   * Required. Language-tagged labels for the menu. E.g. "menu", "lunch special". Display names
   * should be 140 characters or less, with descriptions 1,000 characters or less. At least one set
   * of labels is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MenuLabel> labels;

  static {
    // hack to force ProGuard to consider MenuLabel used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MenuLabel.class);
  }

  /**
   * Required. Sections of the menu.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FoodMenuSection> sections;

  static {
    // hack to force ProGuard to consider FoodMenuSection used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FoodMenuSection.class);
  }

  /**
   * Optional. Source URL of menu if there is a webpage to go to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceUrl;

  /**
   * Optional. Cuisine information for the food menu. It is highly recommended to provide this
   * field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getCuisines() {
    return cuisines;
  }

  /**
   * Optional. Cuisine information for the food menu. It is highly recommended to provide this
   * field.
   * @param cuisines cuisines or {@code null} for none
   */
  public FoodMenu setCuisines(java.util.List<java.lang.String> cuisines) {
    this.cuisines = cuisines;
    return this;
  }

  /**
   * Required. Language-tagged labels for the menu. E.g. "menu", "lunch special". Display names
   * should be 140 characters or less, with descriptions 1,000 characters or less. At least one set
   * of labels is required.
   * @return value or {@code null} for none
   */
  public java.util.List<MenuLabel> getLabels() {
    return labels;
  }

  /**
   * Required. Language-tagged labels for the menu. E.g. "menu", "lunch special". Display names
   * should be 140 characters or less, with descriptions 1,000 characters or less. At least one set
   * of labels is required.
   * @param labels labels or {@code null} for none
   */
  public FoodMenu setLabels(java.util.List<MenuLabel> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Required. Sections of the menu.
   * @return value or {@code null} for none
   */
  public java.util.List<FoodMenuSection> getSections() {
    return sections;
  }

  /**
   * Required. Sections of the menu.
   * @param sections sections or {@code null} for none
   */
  public FoodMenu setSections(java.util.List<FoodMenuSection> sections) {
    this.sections = sections;
    return this;
  }

  /**
   * Optional. Source URL of menu if there is a webpage to go to.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceUrl() {
    return sourceUrl;
  }

  /**
   * Optional. Source URL of menu if there is a webpage to go to.
   * @param sourceUrl sourceUrl or {@code null} for none
   */
  public FoodMenu setSourceUrl(java.lang.String sourceUrl) {
    this.sourceUrl = sourceUrl;
    return this;
  }

  @Override
  public FoodMenu set(String fieldName, Object value) {
    return (FoodMenu) super.set(fieldName, value);
  }

  @Override
  public FoodMenu clone() {
    return (FoodMenu) super.clone();
  }

}
