/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A location indexed with the regions that people usually come from. This is captured by counting
 * how many driving-direction requests to this location are from each region.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocationDrivingDirectionMetrics extends com.google.api.client.json.GenericJson {

  /**
   * The location resource name this metric value belongs to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationName;

  /**
   * Time zone (IANA timezone IDs, for example, 'Europe/London') of the location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timeZone;

  /**
   * Driving-direction requests by source region. By convention, these are sorted by count with at
   * most 10 results.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<TopDirectionSources> topDirectionSources;

  static {
    // hack to force ProGuard to consider TopDirectionSources used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(TopDirectionSources.class);
  }

  /**
   * The location resource name this metric value belongs to.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationName() {
    return locationName;
  }

  /**
   * The location resource name this metric value belongs to.
   * @param locationName locationName or {@code null} for none
   */
  public LocationDrivingDirectionMetrics setLocationName(java.lang.String locationName) {
    this.locationName = locationName;
    return this;
  }

  /**
   * Time zone (IANA timezone IDs, for example, 'Europe/London') of the location.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimeZone() {
    return timeZone;
  }

  /**
   * Time zone (IANA timezone IDs, for example, 'Europe/London') of the location.
   * @param timeZone timeZone or {@code null} for none
   */
  public LocationDrivingDirectionMetrics setTimeZone(java.lang.String timeZone) {
    this.timeZone = timeZone;
    return this;
  }

  /**
   * Driving-direction requests by source region. By convention, these are sorted by count with at
   * most 10 results.
   * @return value or {@code null} for none
   */
  public java.util.List<TopDirectionSources> getTopDirectionSources() {
    return topDirectionSources;
  }

  /**
   * Driving-direction requests by source region. By convention, these are sorted by count with at
   * most 10 results.
   * @param topDirectionSources topDirectionSources or {@code null} for none
   */
  public LocationDrivingDirectionMetrics setTopDirectionSources(java.util.List<TopDirectionSources> topDirectionSources) {
    this.topDirectionSources = topDirectionSources;
    return this;
  }

  @Override
  public LocationDrivingDirectionMetrics set(String fieldName, Object value) {
    return (LocationDrivingDirectionMetrics) super.set(fieldName, value);
  }

  @Override
  public LocationDrivingDirectionMetrics clone() {
    return (LocationDrivingDirectionMetrics) super.clone();
  }

}
