/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for QuestionsAndAnswers.ListAnswers
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListAnswersResponse extends com.google.api.client.json.GenericJson {

  /**
   * The requested answers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Answer> answers;

  /**
   * If the number of answers exceeds the requested max page size, this field is populated with a
   * token to fetch the next page of answers on a subsequent call. If there are no more answers,
   * this field is not present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The total number of answers posted for this question across all pages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalSize;

  /**
   * The requested answers.
   * @return value or {@code null} for none
   */
  public java.util.List<Answer> getAnswers() {
    return answers;
  }

  /**
   * The requested answers.
   * @param answers answers or {@code null} for none
   */
  public ListAnswersResponse setAnswers(java.util.List<Answer> answers) {
    this.answers = answers;
    return this;
  }

  /**
   * If the number of answers exceeds the requested max page size, this field is populated with a
   * token to fetch the next page of answers on a subsequent call. If there are no more answers,
   * this field is not present in the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If the number of answers exceeds the requested max page size, this field is populated with a
   * token to fetch the next page of answers on a subsequent call. If there are no more answers,
   * this field is not present in the response.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListAnswersResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The total number of answers posted for this question across all pages.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalSize() {
    return totalSize;
  }

  /**
   * The total number of answers posted for this question across all pages.
   * @param totalSize totalSize or {@code null} for none
   */
  public ListAnswersResponse setTotalSize(java.lang.Integer totalSize) {
    this.totalSize = totalSize;
    return this;
  }

  @Override
  public ListAnswersResponse set(String fieldName, Object value) {
    return (ListAnswersResponse) super.set(fieldName, value);
  }

  @Override
  public ListAnswersResponse clone() {
    return (ListAnswersResponse) super.clone();
  }

}
