/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Alternate/surrogate key references for a location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LocationKey extends com.google.api.client.json.GenericJson {

  /**
   * Output only. A value of true indicates that an unset place ID is deliberate, which is different
   * from no association being made yet.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean explicitNoPlaceId;

  /**
   * If this location has been verified and is connected to/appears on Google Maps, this field is
   * populated with the place ID for the location. This ID can be used in various Places APIs. If
   * this location is unverified, this field may be populated if the location has been associated
   * with a place that appears on Google Maps. This field can be set during Create calls, but not
   * for Update. The additional `explicit_no_place_id` bool qualifies whether an unset place ID is
   * deliberate or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String placeId;

  /**
   * Output only. If this location has a Google+ page associated with it, this is populated with the
   * Google+ page ID for this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String plusPageId;

  /**
   * Output only. The `request_id` used to create this location. May be empty if this location was
   * created outside of the GMB API or Google My Business Locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String requestId;

  /**
   * Output only. A value of true indicates that an unset place ID is deliberate, which is different
   * from no association being made yet.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExplicitNoPlaceId() {
    return explicitNoPlaceId;
  }

  /**
   * Output only. A value of true indicates that an unset place ID is deliberate, which is different
   * from no association being made yet.
   * @param explicitNoPlaceId explicitNoPlaceId or {@code null} for none
   */
  public LocationKey setExplicitNoPlaceId(java.lang.Boolean explicitNoPlaceId) {
    this.explicitNoPlaceId = explicitNoPlaceId;
    return this;
  }

  /**
   * If this location has been verified and is connected to/appears on Google Maps, this field is
   * populated with the place ID for the location. This ID can be used in various Places APIs. If
   * this location is unverified, this field may be populated if the location has been associated
   * with a place that appears on Google Maps. This field can be set during Create calls, but not
   * for Update. The additional `explicit_no_place_id` bool qualifies whether an unset place ID is
   * deliberate or not.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaceId() {
    return placeId;
  }

  /**
   * If this location has been verified and is connected to/appears on Google Maps, this field is
   * populated with the place ID for the location. This ID can be used in various Places APIs. If
   * this location is unverified, this field may be populated if the location has been associated
   * with a place that appears on Google Maps. This field can be set during Create calls, but not
   * for Update. The additional `explicit_no_place_id` bool qualifies whether an unset place ID is
   * deliberate or not.
   * @param placeId placeId or {@code null} for none
   */
  public LocationKey setPlaceId(java.lang.String placeId) {
    this.placeId = placeId;
    return this;
  }

  /**
   * Output only. If this location has a Google+ page associated with it, this is populated with the
   * Google+ page ID for this location.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlusPageId() {
    return plusPageId;
  }

  /**
   * Output only. If this location has a Google+ page associated with it, this is populated with the
   * Google+ page ID for this location.
   * @param plusPageId plusPageId or {@code null} for none
   */
  public LocationKey setPlusPageId(java.lang.String plusPageId) {
    this.plusPageId = plusPageId;
    return this;
  }

  /**
   * Output only. The `request_id` used to create this location. May be empty if this location was
   * created outside of the GMB API or Google My Business Locations.
   * @return value or {@code null} for none
   */
  public java.lang.String getRequestId() {
    return requestId;
  }

  /**
   * Output only. The `request_id` used to create this location. May be empty if this location was
   * created outside of the GMB API or Google My Business Locations.
   * @param requestId requestId or {@code null} for none
   */
  public LocationKey setRequestId(java.lang.String requestId) {
    this.requestId = requestId;
    return this;
  }

  @Override
  public LocationKey set(String fieldName, Object value) {
    return (LocationKey) super.set(fieldName, value);
  }

  @Override
  public LocationKey clone() {
    return (LocationKey) super.clone();
  }

}
