/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Model definition for ListBusinessCategoriesResponse.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListBusinessCategoriesResponse extends com.google.api.client.json.GenericJson {

  /**
   * The categories. Categories are BASIC view. They don't contain any ServiceType information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Category> categories;

  static {
    // hack to force ProGuard to consider Category used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Category.class);
  }

  /**
   * If the number of categories exceeded the requested page size, this field will be populated with
   * a token to fetch the next page of categories on a subsequent call to `ListBusinessCategories`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The total number of categories for the request parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer totalCategoryCount;

  /**
   * The categories. Categories are BASIC view. They don't contain any ServiceType information.
   * @return value or {@code null} for none
   */
  public java.util.List<Category> getCategories() {
    return categories;
  }

  /**
   * The categories. Categories are BASIC view. They don't contain any ServiceType information.
   * @param categories categories or {@code null} for none
   */
  public ListBusinessCategoriesResponse setCategories(java.util.List<Category> categories) {
    this.categories = categories;
    return this;
  }

  /**
   * If the number of categories exceeded the requested page size, this field will be populated with
   * a token to fetch the next page of categories on a subsequent call to `ListBusinessCategories`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If the number of categories exceeded the requested page size, this field will be populated with
   * a token to fetch the next page of categories on a subsequent call to `ListBusinessCategories`.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListBusinessCategoriesResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  /**
   * The total number of categories for the request parameters.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getTotalCategoryCount() {
    return totalCategoryCount;
  }

  /**
   * The total number of categories for the request parameters.
   * @param totalCategoryCount totalCategoryCount or {@code null} for none
   */
  public ListBusinessCategoriesResponse setTotalCategoryCount(java.lang.Integer totalCategoryCount) {
    this.totalCategoryCount = totalCategoryCount;
    return this;
  }

  @Override
  public ListBusinessCategoriesResponse set(String fieldName, Object value) {
    return (ListBusinessCategoriesResponse) super.set(fieldName, value);
  }

  @Override
  public ListBusinessCategoriesResponse clone() {
    return (ListBusinessCategoriesResponse) super.clone();
  }

}
