/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * An individual room, such as kitchen, bathroom, bedroom, within a bookable guest unit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LivingArea extends com.google.api.client.json.GenericJson {

  /**
   * Accessibility features of the living area.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingAreaAccessibility accessibility;

  /**
   * Information about eating features in the living area.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingAreaEating eating;

  /**
   * Features in the living area.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingAreaFeatures features;

  /**
   * Information about the layout of the living area.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingAreaLayout layout;

  /**
   * Information about sleeping features in the living area.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingAreaSleeping sleeping;

  /**
   * Accessibility features of the living area.
   * @return value or {@code null} for none
   */
  public LivingAreaAccessibility getAccessibility() {
    return accessibility;
  }

  /**
   * Accessibility features of the living area.
   * @param accessibility accessibility or {@code null} for none
   */
  public LivingArea setAccessibility(LivingAreaAccessibility accessibility) {
    this.accessibility = accessibility;
    return this;
  }

  /**
   * Information about eating features in the living area.
   * @return value or {@code null} for none
   */
  public LivingAreaEating getEating() {
    return eating;
  }

  /**
   * Information about eating features in the living area.
   * @param eating eating or {@code null} for none
   */
  public LivingArea setEating(LivingAreaEating eating) {
    this.eating = eating;
    return this;
  }

  /**
   * Features in the living area.
   * @return value or {@code null} for none
   */
  public LivingAreaFeatures getFeatures() {
    return features;
  }

  /**
   * Features in the living area.
   * @param features features or {@code null} for none
   */
  public LivingArea setFeatures(LivingAreaFeatures features) {
    this.features = features;
    return this;
  }

  /**
   * Information about the layout of the living area.
   * @return value or {@code null} for none
   */
  public LivingAreaLayout getLayout() {
    return layout;
  }

  /**
   * Information about the layout of the living area.
   * @param layout layout or {@code null} for none
   */
  public LivingArea setLayout(LivingAreaLayout layout) {
    this.layout = layout;
    return this;
  }

  /**
   * Information about sleeping features in the living area.
   * @return value or {@code null} for none
   */
  public LivingAreaSleeping getSleeping() {
    return sleeping;
  }

  /**
   * Information about sleeping features in the living area.
   * @param sleeping sleeping or {@code null} for none
   */
  public LivingArea setSleeping(LivingAreaSleeping sleeping) {
    this.sleeping = sleeping;
    return this;
  }

  @Override
  public LivingArea set(String fieldName, Object value) {
    return (LivingArea) super.set(fieldName, value);
  }

  @Override
  public LivingArea clone() {
    return (LivingArea) super.clone();
  }

}
