/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4;

/**
 * Service definition for MyBusiness (v4).
 *
 * <p>
 * The Google My Business API provides an interface for managing business location information on Google.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/my-business/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link MyBusinessRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class MyBusiness extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 15,
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.15 of google-api-client to run version " +
        "1.25.0 of the Google My Business API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://mybusiness.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public MyBusiness(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  MyBusiness(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Accounts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusiness mybusiness = new MyBusiness(...);}
   *   {@code MyBusiness.Accounts.List request = mybusiness.accounts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Accounts accounts() {
    return new Accounts();
  }

  /**
   * The "accounts" collection of methods.
   */
  public class Accounts {

    /**
     * Creates an account with the specified name and type under the given parent. - Personal accounts
     * and Organizations cannot be created. - User Groups cannot be created with a Personal account as
     * primary owner. - Location Groups cannot be created with a primary owner of a Personal account if
     * the Personal account is in an Organization. - Location Groups cannot own Location Groups.
     *
     * Create a request for the method "accounts.create".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Create#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.mybusiness.v4.model.Account}
     * @return the request
     */
    public Create create(com.google.api.services.mybusiness.v4.model.Account content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Account> {

      private static final String REST_PATH = "v4/accounts";

      /**
       * Creates an account with the specified name and type under the given parent. - Personal accounts
       * and Organizations cannot be created. - User Groups cannot be created with a Personal account as
       * primary owner. - Location Groups cannot be created with a primary owner of a Personal account
       * if the Personal account is in an Organization. - Location Groups cannot own Location Groups.
       *
       * Create a request for the method "accounts.create".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
       * <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Account}
       * @since 1.13
       */
      protected Create(com.google.api.services.mybusiness.v4.model.Account content) {
        super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Account.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The resource name of the account which will be the primary owner of the account being
       * created. It should be of the form `accounts/{account_id}/`.
       */
      @com.google.api.client.util.Key
      private java.lang.String primaryOwner;

      /** The resource name of the account which will be the primary owner of the account being created. It
     should be of the form `accounts/{account_id}/`.
       */
      public java.lang.String getPrimaryOwner() {
        return primaryOwner;
      }

      /**
       * The resource name of the account which will be the primary owner of the account being
       * created. It should be of the form `accounts/{account_id}/`.
       */
      public Create setPrimaryOwner(java.lang.String primaryOwner) {
        this.primaryOwner = primaryOwner;
        return this;
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Clears the pubsub notification settings for the account.
     *
     * Create a request for the method "accounts.deleteNotifications".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link DeleteNotifications#execute()} method to invoke the remote operation.
     *
     * @param name The resource name for the notification settings to be cleared.
     * @return the request
     */
    public DeleteNotifications deleteNotifications(java.lang.String name) throws java.io.IOException {
      DeleteNotifications result = new DeleteNotifications(name);
      initialize(result);
      return result;
    }

    public class DeleteNotifications extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

      private static final String REST_PATH = "v4/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+/notifications$");

      /**
       * Clears the pubsub notification settings for the account.
       *
       * Create a request for the method "accounts.deleteNotifications".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link DeleteNotifications#execute()} method to invoke the remote
       * operation. <p> {@link DeleteNotifications#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param name The resource name for the notification settings to be cleared.
       * @since 1.13
       */
      protected DeleteNotifications(java.lang.String name) {
        super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/notifications$");
        }
      }

      @Override
      public DeleteNotifications set$Xgafv(java.lang.String $Xgafv) {
        return (DeleteNotifications) super.set$Xgafv($Xgafv);
      }

      @Override
      public DeleteNotifications setAccessToken(java.lang.String accessToken) {
        return (DeleteNotifications) super.setAccessToken(accessToken);
      }

      @Override
      public DeleteNotifications setAlt(java.lang.String alt) {
        return (DeleteNotifications) super.setAlt(alt);
      }

      @Override
      public DeleteNotifications setCallback(java.lang.String callback) {
        return (DeleteNotifications) super.setCallback(callback);
      }

      @Override
      public DeleteNotifications setFields(java.lang.String fields) {
        return (DeleteNotifications) super.setFields(fields);
      }

      @Override
      public DeleteNotifications setKey(java.lang.String key) {
        return (DeleteNotifications) super.setKey(key);
      }

      @Override
      public DeleteNotifications setOauthToken(java.lang.String oauthToken) {
        return (DeleteNotifications) super.setOauthToken(oauthToken);
      }

      @Override
      public DeleteNotifications setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (DeleteNotifications) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public DeleteNotifications setQuotaUser(java.lang.String quotaUser) {
        return (DeleteNotifications) super.setQuotaUser(quotaUser);
      }

      @Override
      public DeleteNotifications setUploadType(java.lang.String uploadType) {
        return (DeleteNotifications) super.setUploadType(uploadType);
      }

      @Override
      public DeleteNotifications setUploadProtocol(java.lang.String uploadProtocol) {
        return (DeleteNotifications) super.setUploadProtocol(uploadProtocol);
      }

      /** The resource name for the notification settings to be cleared. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The resource name for the notification settings to be cleared.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The resource name for the notification settings to be cleared. */
      public DeleteNotifications setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/notifications$");
        }
        this.name = name;
        return this;
      }

      @Override
      public DeleteNotifications set(String parameterName, Object value) {
        return (DeleteNotifications) super.set(parameterName, value);
      }
    }
    /**
     * Generates an account number for this account. The account number is not provisioned when an
     * account is created. Use this request to create an account number when it is required.
     *
     * Create a request for the method "accounts.generateAccountNumber".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link GenerateAccountNumber#execute()} method to invoke the remote
     * operation.
     *
     * @param name The name of the account to generate an account number for.
     * @param content the {@link com.google.api.services.mybusiness.v4.model.GenerateAccountNumberRequest}
     * @return the request
     */
    public GenerateAccountNumber generateAccountNumber(java.lang.String name, com.google.api.services.mybusiness.v4.model.GenerateAccountNumberRequest content) throws java.io.IOException {
      GenerateAccountNumber result = new GenerateAccountNumber(name, content);
      initialize(result);
      return result;
    }

    public class GenerateAccountNumber extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Account> {

      private static final String REST_PATH = "v4/{+name}:generateAccountNumber";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Generates an account number for this account. The account number is not provisioned when an
       * account is created. Use this request to create an account number when it is required.
       *
       * Create a request for the method "accounts.generateAccountNumber".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link GenerateAccountNumber#execute()} method to invoke the
       * remote operation. <p> {@link GenerateAccountNumber#initialize(com.google.api.client.googleapis.
       * services.AbstractGoogleClientRequest)} must be called to initialize this instance immediately
       * after invoking the constructor. </p>
       *
       * @param name The name of the account to generate an account number for.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.GenerateAccountNumberRequest}
       * @since 1.13
       */
      protected GenerateAccountNumber(java.lang.String name, com.google.api.services.mybusiness.v4.model.GenerateAccountNumberRequest content) {
        super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Account.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public GenerateAccountNumber set$Xgafv(java.lang.String $Xgafv) {
        return (GenerateAccountNumber) super.set$Xgafv($Xgafv);
      }

      @Override
      public GenerateAccountNumber setAccessToken(java.lang.String accessToken) {
        return (GenerateAccountNumber) super.setAccessToken(accessToken);
      }

      @Override
      public GenerateAccountNumber setAlt(java.lang.String alt) {
        return (GenerateAccountNumber) super.setAlt(alt);
      }

      @Override
      public GenerateAccountNumber setCallback(java.lang.String callback) {
        return (GenerateAccountNumber) super.setCallback(callback);
      }

      @Override
      public GenerateAccountNumber setFields(java.lang.String fields) {
        return (GenerateAccountNumber) super.setFields(fields);
      }

      @Override
      public GenerateAccountNumber setKey(java.lang.String key) {
        return (GenerateAccountNumber) super.setKey(key);
      }

      @Override
      public GenerateAccountNumber setOauthToken(java.lang.String oauthToken) {
        return (GenerateAccountNumber) super.setOauthToken(oauthToken);
      }

      @Override
      public GenerateAccountNumber setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GenerateAccountNumber) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GenerateAccountNumber setQuotaUser(java.lang.String quotaUser) {
        return (GenerateAccountNumber) super.setQuotaUser(quotaUser);
      }

      @Override
      public GenerateAccountNumber setUploadType(java.lang.String uploadType) {
        return (GenerateAccountNumber) super.setUploadType(uploadType);
      }

      @Override
      public GenerateAccountNumber setUploadProtocol(java.lang.String uploadProtocol) {
        return (GenerateAccountNumber) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the account to generate an account number for. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the account to generate an account number for.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the account to generate an account number for. */
      public GenerateAccountNumber setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public GenerateAccountNumber set(String parameterName, Object value) {
        return (GenerateAccountNumber) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified account. Returns `NOT_FOUND` if the account does not exist or if the caller
     * does not have access rights to it.
     *
     * Create a request for the method "accounts.get".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The name of the account to fetch.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Account> {

      private static final String REST_PATH = "v4/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Gets the specified account. Returns `NOT_FOUND` if the account does not exist or if the caller
       * does not have access rights to it.
       *
       * Create a request for the method "accounts.get".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the account to fetch.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Account.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the account to fetch. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the account to fetch.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the account to fetch. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Returns the pubsub notification settings for the account.
     *
     * Create a request for the method "accounts.getNotifications".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link GetNotifications#execute()} method to invoke the remote operation.
     *
     * @param name The notification settings resource name.
     * @return the request
     */
    public GetNotifications getNotifications(java.lang.String name) throws java.io.IOException {
      GetNotifications result = new GetNotifications(name);
      initialize(result);
      return result;
    }

    public class GetNotifications extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Notifications> {

      private static final String REST_PATH = "v4/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+/notifications$");

      /**
       * Returns the pubsub notification settings for the account.
       *
       * Create a request for the method "accounts.getNotifications".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link GetNotifications#execute()} method to invoke the remote
       * operation. <p> {@link GetNotifications#initialize(com.google.api.client.googleapis.services.Abs
       * tractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param name The notification settings resource name.
       * @since 1.13
       */
      protected GetNotifications(java.lang.String name) {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Notifications.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/notifications$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public GetNotifications set$Xgafv(java.lang.String $Xgafv) {
        return (GetNotifications) super.set$Xgafv($Xgafv);
      }

      @Override
      public GetNotifications setAccessToken(java.lang.String accessToken) {
        return (GetNotifications) super.setAccessToken(accessToken);
      }

      @Override
      public GetNotifications setAlt(java.lang.String alt) {
        return (GetNotifications) super.setAlt(alt);
      }

      @Override
      public GetNotifications setCallback(java.lang.String callback) {
        return (GetNotifications) super.setCallback(callback);
      }

      @Override
      public GetNotifications setFields(java.lang.String fields) {
        return (GetNotifications) super.setFields(fields);
      }

      @Override
      public GetNotifications setKey(java.lang.String key) {
        return (GetNotifications) super.setKey(key);
      }

      @Override
      public GetNotifications setOauthToken(java.lang.String oauthToken) {
        return (GetNotifications) super.setOauthToken(oauthToken);
      }

      @Override
      public GetNotifications setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (GetNotifications) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public GetNotifications setQuotaUser(java.lang.String quotaUser) {
        return (GetNotifications) super.setQuotaUser(quotaUser);
      }

      @Override
      public GetNotifications setUploadType(java.lang.String uploadType) {
        return (GetNotifications) super.setUploadType(uploadType);
      }

      @Override
      public GetNotifications setUploadProtocol(java.lang.String uploadProtocol) {
        return (GetNotifications) super.setUploadProtocol(uploadProtocol);
      }

      /** The notification settings resource name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The notification settings resource name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The notification settings resource name. */
      public GetNotifications setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/notifications$");
        }
        this.name = name;
        return this;
      }

      @Override
      public GetNotifications set(String parameterName, Object value) {
        return (GetNotifications) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the accounts for the authenticated user. This includes all accounts that the user
     * owns, as well as any accounts for which the user has management rights.
     *
     * Create a request for the method "accounts.list".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListAccountsResponse> {

      private static final String REST_PATH = "v4/accounts";

      /**
       * Lists all of the accounts for the authenticated user. This includes all accounts that the user
       * owns, as well as any accounts for which the user has management rights.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListAccountsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * A filter constraining the accounts to return. The response includes only entries that match
       * the filter. If `filter` is empty, then no constraints are applied and all accounts
       * (paginated) are retrieved for the requested account. For example, a request with the filter
       * `type=USER_GROUP` will only return user groups.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** A filter constraining the accounts to return. The response includes only entries that match the
     filter. If `filter` is empty, then no constraints are applied and all accounts (paginated) are
     retrieved for the requested account. For example, a request with the filter `type=USER_GROUP` will
     only return user groups.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * A filter constraining the accounts to return. The response includes only entries that match
       * the filter. If `filter` is empty, then no constraints are applied and all accounts
       * (paginated) are retrieved for the requested account. For example, a request with the filter
       * `type=USER_GROUP` will only return user groups.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * If specified, the next page of accounts is retrieved. The `pageToken` is returned when a
       * call to `accounts.list` returns more results than can fit into the requested page size.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** If specified, the next page of accounts is retrieved. The `pageToken` is returned when a call to
     `accounts.list` returns more results than can fit into the requested page size.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * If specified, the next page of accounts is retrieved. The `pageToken` is returned when a
       * call to `accounts.list` returns more results than can fit into the requested page size.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * The resource name of the account for which the list of directly accessible accounts is to
       * be retrieved. This only makes sense for Organizations and User Groups. If empty, will
       * return `ListAccounts` for the authenticated user.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The resource name of the account for which the list of directly accessible accounts is to be
     retrieved. This only makes sense for Organizations and User Groups. If empty, will return
     `ListAccounts` for the authenticated user.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * The resource name of the account for which the list of directly accessible accounts is to
       * be retrieved. This only makes sense for Organizations and User Groups. If empty, will
       * return `ListAccounts` for the authenticated user.
       */
      public List setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      /**
       * How many accounts to fetch per page. Default is 20, minimum is 2, and maximum page size is
       * 20.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** How many accounts to fetch per page. Default is 20, minimum is 2, and maximum page size is 20.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * How many accounts to fetch per page. Default is 20, minimum is 2, and maximum page size is
       * 20.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * List all the GoogleLocations that have been recommended to the specified GMB account.
     * Recommendations are provided for personal accounts and location groups only, requests for all
     * other account types will result in an error. The recommendations for location groups are based on
     * the locations in that group. The recommendations for personal accounts are based on all of the
     * locations that the user has access to on Google My Business (which includes locations they can
     * access through location groups), and is a superset of all recommendations generated for the user.
     *
     * Create a request for the method "accounts.listRecommendGoogleLocations".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link ListRecommendGoogleLocations#execute()} method to invoke the remote
     * operation.
     *
     * @param name Name of the account resource to fetch recommended Google locations for.
     * @return the request
     */
    public ListRecommendGoogleLocations listRecommendGoogleLocations(java.lang.String name) throws java.io.IOException {
      ListRecommendGoogleLocations result = new ListRecommendGoogleLocations(name);
      initialize(result);
      return result;
    }

    public class ListRecommendGoogleLocations extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListRecommendedGoogleLocationsResponse> {

      private static final String REST_PATH = "v4/{+name}:recommendGoogleLocations";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * List all the GoogleLocations that have been recommended to the specified GMB account.
       * Recommendations are provided for personal accounts and location groups only, requests for all
       * other account types will result in an error. The recommendations for location groups are based
       * on the locations in that group. The recommendations for personal accounts are based on all of
       * the locations that the user has access to on Google My Business (which includes locations they
       * can access through location groups), and is a superset of all recommendations generated for the
       * user.
       *
       * Create a request for the method "accounts.listRecommendGoogleLocations".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link ListRecommendGoogleLocations#execute()} method to invoke
       * the remote operation. <p> {@link ListRecommendGoogleLocations#initialize(com.google.api.client.
       * googleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
       * immediately after invoking the constructor. </p>
       *
       * @param name Name of the account resource to fetch recommended Google locations for.
       * @since 1.13
       */
      protected ListRecommendGoogleLocations(java.lang.String name) {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListRecommendedGoogleLocationsResponse.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public ListRecommendGoogleLocations set$Xgafv(java.lang.String $Xgafv) {
        return (ListRecommendGoogleLocations) super.set$Xgafv($Xgafv);
      }

      @Override
      public ListRecommendGoogleLocations setAccessToken(java.lang.String accessToken) {
        return (ListRecommendGoogleLocations) super.setAccessToken(accessToken);
      }

      @Override
      public ListRecommendGoogleLocations setAlt(java.lang.String alt) {
        return (ListRecommendGoogleLocations) super.setAlt(alt);
      }

      @Override
      public ListRecommendGoogleLocations setCallback(java.lang.String callback) {
        return (ListRecommendGoogleLocations) super.setCallback(callback);
      }

      @Override
      public ListRecommendGoogleLocations setFields(java.lang.String fields) {
        return (ListRecommendGoogleLocations) super.setFields(fields);
      }

      @Override
      public ListRecommendGoogleLocations setKey(java.lang.String key) {
        return (ListRecommendGoogleLocations) super.setKey(key);
      }

      @Override
      public ListRecommendGoogleLocations setOauthToken(java.lang.String oauthToken) {
        return (ListRecommendGoogleLocations) super.setOauthToken(oauthToken);
      }

      @Override
      public ListRecommendGoogleLocations setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (ListRecommendGoogleLocations) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public ListRecommendGoogleLocations setQuotaUser(java.lang.String quotaUser) {
        return (ListRecommendGoogleLocations) super.setQuotaUser(quotaUser);
      }

      @Override
      public ListRecommendGoogleLocations setUploadType(java.lang.String uploadType) {
        return (ListRecommendGoogleLocations) super.setUploadType(uploadType);
      }

      @Override
      public ListRecommendGoogleLocations setUploadProtocol(java.lang.String uploadProtocol) {
        return (ListRecommendGoogleLocations) super.setUploadProtocol(uploadProtocol);
      }

      /** Name of the account resource to fetch recommended Google locations for. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Name of the account resource to fetch recommended Google locations for.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Name of the account resource to fetch recommended Google locations for. */
      public ListRecommendGoogleLocations setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /** If specified, the next page of locations is retrieved. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** If specified, the next page of locations is retrieved.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** If specified, the next page of locations is retrieved. */
      public ListRecommendGoogleLocations setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * How many locations to fetch per page. Default is 25, minimum is 1, and maximum page size is
       * 100.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** How many locations to fetch per page. Default is 25, minimum is 1, and maximum page size is 100.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * How many locations to fetch per page. Default is 25, minimum is 1, and maximum page size is
       * 100.
       */
      public ListRecommendGoogleLocations setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      @Override
      public ListRecommendGoogleLocations set(String parameterName, Object value) {
        return (ListRecommendGoogleLocations) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified business account. Personal accounts cannot be updated using this method.
     * *Note:* The only editable field for an account is `account_name`. Any other fields passed in
     * (such as `type` or `role`) are ignored.
     *
     * Create a request for the method "accounts.update".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Update#execute()} method to invoke the remote operation.
     *
     * @param name The name of the account to update.
     * @param content the {@link com.google.api.services.mybusiness.v4.model.Account}
     * @return the request
     */
    public Update update(java.lang.String name, com.google.api.services.mybusiness.v4.model.Account content) throws java.io.IOException {
      Update result = new Update(name, content);
      initialize(result);
      return result;
    }

    public class Update extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Account> {

      private static final String REST_PATH = "v4/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Updates the specified business account. Personal accounts cannot be updated using this method.
       * *Note:* The only editable field for an account is `account_name`. Any other fields passed in
       * (such as `type` or `role`) are ignored.
       *
       * Create a request for the method "accounts.update".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Update#execute()} method to invoke the remote operation.
       * <p> {@link
       * Update#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The name of the account to update.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Account}
       * @since 1.13
       */
      protected Update(java.lang.String name, com.google.api.services.mybusiness.v4.model.Account content) {
        super(MyBusiness.this, "PUT", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Account.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public Update set$Xgafv(java.lang.String $Xgafv) {
        return (Update) super.set$Xgafv($Xgafv);
      }

      @Override
      public Update setAccessToken(java.lang.String accessToken) {
        return (Update) super.setAccessToken(accessToken);
      }

      @Override
      public Update setAlt(java.lang.String alt) {
        return (Update) super.setAlt(alt);
      }

      @Override
      public Update setCallback(java.lang.String callback) {
        return (Update) super.setCallback(callback);
      }

      @Override
      public Update setFields(java.lang.String fields) {
        return (Update) super.setFields(fields);
      }

      @Override
      public Update setKey(java.lang.String key) {
        return (Update) super.setKey(key);
      }

      @Override
      public Update setOauthToken(java.lang.String oauthToken) {
        return (Update) super.setOauthToken(oauthToken);
      }

      @Override
      public Update setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Update) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Update setQuotaUser(java.lang.String quotaUser) {
        return (Update) super.setQuotaUser(quotaUser);
      }

      @Override
      public Update setUploadType(java.lang.String uploadType) {
        return (Update) super.setUploadType(uploadType);
      }

      @Override
      public Update setUploadProtocol(java.lang.String uploadProtocol) {
        return (Update) super.setUploadProtocol(uploadProtocol);
      }

      /** The name of the account to update. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The name of the account to update.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The name of the account to update. */
      public Update setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /** If true, the request is validated without actually updating the account. */
      @com.google.api.client.util.Key
      private java.lang.Boolean validateOnly;

      /** If true, the request is validated without actually updating the account.
       */
      public java.lang.Boolean getValidateOnly() {
        return validateOnly;
      }

      /** If true, the request is validated without actually updating the account. */
      public Update setValidateOnly(java.lang.Boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
      }

      @Override
      public Update set(String parameterName, Object value) {
        return (Update) super.set(parameterName, value);
      }
    }
    /**
     * Sets the pubsub notification settings for the account informing My Business which topic to send
     * pubsub notifications for: - New reviews for locations administered by the account. - Updated
     * reviews for locations administered by the account. - New `GoogleUpdates` for locations
     * administered by the account. An account will only have one notification settings resource, and
     * only one pubsub topic can be set.
     *
     * Create a request for the method "accounts.updateNotifications".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link UpdateNotifications#execute()} method to invoke the remote operation.
     *
     * @param name The notification settings resource name.
     * @param content the {@link com.google.api.services.mybusiness.v4.model.Notifications}
     * @return the request
     */
    public UpdateNotifications updateNotifications(java.lang.String name, com.google.api.services.mybusiness.v4.model.Notifications content) throws java.io.IOException {
      UpdateNotifications result = new UpdateNotifications(name, content);
      initialize(result);
      return result;
    }

    public class UpdateNotifications extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Notifications> {

      private static final String REST_PATH = "v4/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+/notifications$");

      /**
       * Sets the pubsub notification settings for the account informing My Business which topic to send
       * pubsub notifications for: - New reviews for locations administered by the account. - Updated
       * reviews for locations administered by the account. - New `GoogleUpdates` for locations
       * administered by the account. An account will only have one notification settings resource, and
       * only one pubsub topic can be set.
       *
       * Create a request for the method "accounts.updateNotifications".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link UpdateNotifications#execute()} method to invoke the remote
       * operation. <p> {@link UpdateNotifications#initialize(com.google.api.client.googleapis.services.
       * AbstractGoogleClientRequest)} must be called to initialize this instance immediately after
       * invoking the constructor. </p>
       *
       * @param name The notification settings resource name.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Notifications}
       * @since 1.13
       */
      protected UpdateNotifications(java.lang.String name, com.google.api.services.mybusiness.v4.model.Notifications content) {
        super(MyBusiness.this, "PUT", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Notifications.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/notifications$");
        }
      }

      @Override
      public UpdateNotifications set$Xgafv(java.lang.String $Xgafv) {
        return (UpdateNotifications) super.set$Xgafv($Xgafv);
      }

      @Override
      public UpdateNotifications setAccessToken(java.lang.String accessToken) {
        return (UpdateNotifications) super.setAccessToken(accessToken);
      }

      @Override
      public UpdateNotifications setAlt(java.lang.String alt) {
        return (UpdateNotifications) super.setAlt(alt);
      }

      @Override
      public UpdateNotifications setCallback(java.lang.String callback) {
        return (UpdateNotifications) super.setCallback(callback);
      }

      @Override
      public UpdateNotifications setFields(java.lang.String fields) {
        return (UpdateNotifications) super.setFields(fields);
      }

      @Override
      public UpdateNotifications setKey(java.lang.String key) {
        return (UpdateNotifications) super.setKey(key);
      }

      @Override
      public UpdateNotifications setOauthToken(java.lang.String oauthToken) {
        return (UpdateNotifications) super.setOauthToken(oauthToken);
      }

      @Override
      public UpdateNotifications setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (UpdateNotifications) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public UpdateNotifications setQuotaUser(java.lang.String quotaUser) {
        return (UpdateNotifications) super.setQuotaUser(quotaUser);
      }

      @Override
      public UpdateNotifications setUploadType(java.lang.String uploadType) {
        return (UpdateNotifications) super.setUploadType(uploadType);
      }

      @Override
      public UpdateNotifications setUploadProtocol(java.lang.String uploadProtocol) {
        return (UpdateNotifications) super.setUploadProtocol(uploadProtocol);
      }

      /** The notification settings resource name. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The notification settings resource name.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The notification settings resource name. */
      public UpdateNotifications setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+/notifications$");
        }
        this.name = name;
        return this;
      }

      @Override
      public UpdateNotifications set(String parameterName, Object value) {
        return (UpdateNotifications) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Admins collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code MyBusiness mybusiness = new MyBusiness(...);}
     *   {@code MyBusiness.Admins.List request = mybusiness.admins().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Admins admins() {
      return new Admins();
    }

    /**
     * The "admins" collection of methods.
     */
    public class Admins {

      /**
       * Invites the specified user to become an administrator for the specified account. The invitee must
       * accept the invitation in order to be granted access to the account. See AcceptInvitation to
       * programmatically accept an invitation.
       *
       * Create a request for the method "admins.create".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent The resource name of the account this admin is created for.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Admin content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Admin> {

        private static final String REST_PATH = "v4/{+parent}/admins";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Invites the specified user to become an administrator for the specified account. The invitee
         * must accept the invitation in order to be granted access to the account. See AcceptInvitation
         * to programmatically accept an invitation.
         *
         * Create a request for the method "admins.create".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The resource name of the account this admin is created for.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Admin content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Admin.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource name of the account this admin is created for. */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The resource name of the account this admin is created for.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** The resource name of the account this admin is created for. */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Removes the specified admin from the specified account.
       *
       * Create a request for the method "admins.delete".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the admin to remove from the account.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/admins/[^/]+$");

        /**
         * Removes the specified admin from the specified account.
         *
         * Create a request for the method "admins.delete".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the admin to remove from the account.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource name of the admin to remove from the account. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the admin to remove from the account.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource name of the admin to remove from the account. */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lists the admins for the specified account.
       *
       * Create a request for the method "admins.list".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The name of the account from which to retrieve a list of admins.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListAccountAdminsResponse> {

        private static final String REST_PATH = "v4/{+parent}/admins";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Lists the admins for the specified account.
         *
         * Create a request for the method "admins.list".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The name of the account from which to retrieve a list of admins.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListAccountAdminsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the account from which to retrieve a list of admins. */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The name of the account from which to retrieve a list of admins.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** The name of the account from which to retrieve a list of admins. */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the Admin for the specified Account Admin. Only the AdminRole of the Admin can be
       * updated.
       *
       * Create a request for the method "admins.patch".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the admin to update.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Admin content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Admin> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/admins/[^/]+$");

        /**
         * Updates the Admin for the specified Account Admin. Only the AdminRole of the Admin can be
         * updated.
         *
         * Create a request for the method "admins.patch".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the admin to update.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Admin content) {
          super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Admin.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource name of the admin to update. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the admin to update.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource name of the admin to update. */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Invitations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code MyBusiness mybusiness = new MyBusiness(...);}
     *   {@code MyBusiness.Invitations.List request = mybusiness.invitations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Invitations invitations() {
      return new Invitations();
    }

    /**
     * The "invitations" collection of methods.
     */
    public class Invitations {

      /**
       * Accepts the specified invitation.
       *
       * Create a request for the method "invitations.accept".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Accept#execute()} method to invoke the remote operation.
       *
       * @param name The name of the invitation that is being accepted.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.AcceptInvitationRequest}
       * @return the request
       */
      public Accept accept(java.lang.String name, com.google.api.services.mybusiness.v4.model.AcceptInvitationRequest content) throws java.io.IOException {
        Accept result = new Accept(name, content);
        initialize(result);
        return result;
      }

      public class Accept extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

        private static final String REST_PATH = "v4/{+name}:accept";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/invitations/[^/]+$");

        /**
         * Accepts the specified invitation.
         *
         * Create a request for the method "invitations.accept".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Accept#execute()} method to invoke the remote operation.
         * <p> {@link
         * Accept#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the invitation that is being accepted.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.AcceptInvitationRequest}
         * @since 1.13
         */
        protected Accept(java.lang.String name, com.google.api.services.mybusiness.v4.model.AcceptInvitationRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
        }

        @Override
        public Accept set$Xgafv(java.lang.String $Xgafv) {
          return (Accept) super.set$Xgafv($Xgafv);
        }

        @Override
        public Accept setAccessToken(java.lang.String accessToken) {
          return (Accept) super.setAccessToken(accessToken);
        }

        @Override
        public Accept setAlt(java.lang.String alt) {
          return (Accept) super.setAlt(alt);
        }

        @Override
        public Accept setCallback(java.lang.String callback) {
          return (Accept) super.setCallback(callback);
        }

        @Override
        public Accept setFields(java.lang.String fields) {
          return (Accept) super.setFields(fields);
        }

        @Override
        public Accept setKey(java.lang.String key) {
          return (Accept) super.setKey(key);
        }

        @Override
        public Accept setOauthToken(java.lang.String oauthToken) {
          return (Accept) super.setOauthToken(oauthToken);
        }

        @Override
        public Accept setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Accept) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Accept setQuotaUser(java.lang.String quotaUser) {
          return (Accept) super.setQuotaUser(quotaUser);
        }

        @Override
        public Accept setUploadType(java.lang.String uploadType) {
          return (Accept) super.setUploadType(uploadType);
        }

        @Override
        public Accept setUploadProtocol(java.lang.String uploadProtocol) {
          return (Accept) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the invitation that is being accepted. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the invitation that is being accepted.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the invitation that is being accepted. */
        public Accept setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Accept set(String parameterName, Object value) {
          return (Accept) super.set(parameterName, value);
        }
      }
      /**
       * Declines the specified invitation.
       *
       * Create a request for the method "invitations.decline".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Decline#execute()} method to invoke the remote operation.
       *
       * @param name The name of the account invitation that is being declined.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.DeclineInvitationRequest}
       * @return the request
       */
      public Decline decline(java.lang.String name, com.google.api.services.mybusiness.v4.model.DeclineInvitationRequest content) throws java.io.IOException {
        Decline result = new Decline(name, content);
        initialize(result);
        return result;
      }

      public class Decline extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

        private static final String REST_PATH = "v4/{+name}:decline";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/invitations/[^/]+$");

        /**
         * Declines the specified invitation.
         *
         * Create a request for the method "invitations.decline".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Decline#execute()} method to invoke the remote operation.
         * <p> {@link
         * Decline#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the account invitation that is being declined.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.DeclineInvitationRequest}
         * @since 1.13
         */
        protected Decline(java.lang.String name, com.google.api.services.mybusiness.v4.model.DeclineInvitationRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
        }

        @Override
        public Decline set$Xgafv(java.lang.String $Xgafv) {
          return (Decline) super.set$Xgafv($Xgafv);
        }

        @Override
        public Decline setAccessToken(java.lang.String accessToken) {
          return (Decline) super.setAccessToken(accessToken);
        }

        @Override
        public Decline setAlt(java.lang.String alt) {
          return (Decline) super.setAlt(alt);
        }

        @Override
        public Decline setCallback(java.lang.String callback) {
          return (Decline) super.setCallback(callback);
        }

        @Override
        public Decline setFields(java.lang.String fields) {
          return (Decline) super.setFields(fields);
        }

        @Override
        public Decline setKey(java.lang.String key) {
          return (Decline) super.setKey(key);
        }

        @Override
        public Decline setOauthToken(java.lang.String oauthToken) {
          return (Decline) super.setOauthToken(oauthToken);
        }

        @Override
        public Decline setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Decline) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Decline setQuotaUser(java.lang.String quotaUser) {
          return (Decline) super.setQuotaUser(quotaUser);
        }

        @Override
        public Decline setUploadType(java.lang.String uploadType) {
          return (Decline) super.setUploadType(uploadType);
        }

        @Override
        public Decline setUploadProtocol(java.lang.String uploadProtocol) {
          return (Decline) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the account invitation that is being declined. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the account invitation that is being declined.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the account invitation that is being declined. */
        public Decline setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Decline set(String parameterName, Object value) {
          return (Decline) super.set(parameterName, value);
        }
      }
      /**
       * Lists pending invitations for the specified account.
       *
       * Create a request for the method "invitations.list".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The name of the account from which the list of invitations is being retrieved.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListInvitationsResponse> {

        private static final String REST_PATH = "v4/{+parent}/invitations";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Lists pending invitations for the specified account.
         *
         * Create a request for the method "invitations.list".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The name of the account from which the list of invitations is being retrieved.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListInvitationsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the account from which the list of invitations is being retrieved. */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The name of the account from which the list of invitations is being retrieved.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** The name of the account from which the list of invitations is being retrieved. */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /** Specifies which target types should appear in the response. */
        @com.google.api.client.util.Key
        private java.lang.String targetType;

        /** Specifies which target types should appear in the response.
         */
        public java.lang.String getTargetType() {
          return targetType;
        }

        /** Specifies which target types should appear in the response. */
        public List setTargetType(java.lang.String targetType) {
          this.targetType = targetType;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Locations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code MyBusiness mybusiness = new MyBusiness(...);}
     *   {@code MyBusiness.Locations.List request = mybusiness.locations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Locations locations() {
      return new Locations();
    }

    /**
     * The "locations" collection of methods.
     */
    public class Locations {

      /**
       * Associates a location to a place ID. Any previous association is overwritten. This operation is
       * only valid if the location is unverified. The association must be valid, that is, it appears in
       * the list of `FindMatchingLocations`.
       *
       * Create a request for the method "locations.associate".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Associate#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the location to associate.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.AssociateLocationRequest}
       * @return the request
       */
      public Associate associate(java.lang.String name, com.google.api.services.mybusiness.v4.model.AssociateLocationRequest content) throws java.io.IOException {
        Associate result = new Associate(name, content);
        initialize(result);
        return result;
      }

      public class Associate extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

        private static final String REST_PATH = "v4/{+name}:associate";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Associates a location to a place ID. Any previous association is overwritten. This operation is
         * only valid if the location is unverified. The association must be valid, that is, it appears in
         * the list of `FindMatchingLocations`.
         *
         * Create a request for the method "locations.associate".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Associate#execute()} method to invoke the remote
         * operation. <p> {@link
         * Associate#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the location to associate.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.AssociateLocationRequest}
         * @since 1.13
         */
        protected Associate(java.lang.String name, com.google.api.services.mybusiness.v4.model.AssociateLocationRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public Associate set$Xgafv(java.lang.String $Xgafv) {
          return (Associate) super.set$Xgafv($Xgafv);
        }

        @Override
        public Associate setAccessToken(java.lang.String accessToken) {
          return (Associate) super.setAccessToken(accessToken);
        }

        @Override
        public Associate setAlt(java.lang.String alt) {
          return (Associate) super.setAlt(alt);
        }

        @Override
        public Associate setCallback(java.lang.String callback) {
          return (Associate) super.setCallback(callback);
        }

        @Override
        public Associate setFields(java.lang.String fields) {
          return (Associate) super.setFields(fields);
        }

        @Override
        public Associate setKey(java.lang.String key) {
          return (Associate) super.setKey(key);
        }

        @Override
        public Associate setOauthToken(java.lang.String oauthToken) {
          return (Associate) super.setOauthToken(oauthToken);
        }

        @Override
        public Associate setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Associate) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Associate setQuotaUser(java.lang.String quotaUser) {
          return (Associate) super.setQuotaUser(quotaUser);
        }

        @Override
        public Associate setUploadType(java.lang.String uploadType) {
          return (Associate) super.setUploadType(uploadType);
        }

        @Override
        public Associate setUploadProtocol(java.lang.String uploadProtocol) {
          return (Associate) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource name of the location to associate. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the location to associate.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource name of the location to associate. */
        public Associate setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Associate set(String parameterName, Object value) {
          return (Associate) super.set(parameterName, value);
        }
      }
      /**
       * Gets all of the specified locations in the given account.
       *
       * Create a request for the method "locations.batchGet".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
       *
       * @param name The name of the account from which to fetch locations.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.BatchGetLocationsRequest}
       * @return the request
       */
      public BatchGet batchGet(java.lang.String name, com.google.api.services.mybusiness.v4.model.BatchGetLocationsRequest content) throws java.io.IOException {
        BatchGet result = new BatchGet(name, content);
        initialize(result);
        return result;
      }

      public class BatchGet extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.BatchGetLocationsResponse> {

        private static final String REST_PATH = "v4/{+name}/locations:batchGet";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Gets all of the specified locations in the given account.
         *
         * Create a request for the method "locations.batchGet".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
         * <p> {@link
         * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the account from which to fetch locations.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.BatchGetLocationsRequest}
         * @since 1.13
         */
        protected BatchGet(java.lang.String name, com.google.api.services.mybusiness.v4.model.BatchGetLocationsRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.BatchGetLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public BatchGet set$Xgafv(java.lang.String $Xgafv) {
          return (BatchGet) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchGet setAccessToken(java.lang.String accessToken) {
          return (BatchGet) super.setAccessToken(accessToken);
        }

        @Override
        public BatchGet setAlt(java.lang.String alt) {
          return (BatchGet) super.setAlt(alt);
        }

        @Override
        public BatchGet setCallback(java.lang.String callback) {
          return (BatchGet) super.setCallback(callback);
        }

        @Override
        public BatchGet setFields(java.lang.String fields) {
          return (BatchGet) super.setFields(fields);
        }

        @Override
        public BatchGet setKey(java.lang.String key) {
          return (BatchGet) super.setKey(key);
        }

        @Override
        public BatchGet setOauthToken(java.lang.String oauthToken) {
          return (BatchGet) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchGet) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchGet setQuotaUser(java.lang.String quotaUser) {
          return (BatchGet) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchGet setUploadType(java.lang.String uploadType) {
          return (BatchGet) super.setUploadType(uploadType);
        }

        @Override
        public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchGet) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the account from which to fetch locations. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the account from which to fetch locations.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the account from which to fetch locations. */
        public BatchGet setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public BatchGet set(String parameterName, Object value) {
          return (BatchGet) super.set(parameterName, value);
        }
      }
      /**
       * Returns the paginated list of reviews for all specified locations. This operation is only valid
       * if the specified locations are verified. *Note:* Reviews are limited to a batch size of 200
       * `location_names` per call.
       *
       * Create a request for the method "locations.batchGetReviews".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link BatchGetReviews#execute()} method to invoke the remote operation.
       *
       * @param name The name of the account from which to retrieve a list of reviews across multiple locations.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.BatchGetReviewsRequest}
       * @return the request
       */
      public BatchGetReviews batchGetReviews(java.lang.String name, com.google.api.services.mybusiness.v4.model.BatchGetReviewsRequest content) throws java.io.IOException {
        BatchGetReviews result = new BatchGetReviews(name, content);
        initialize(result);
        return result;
      }

      public class BatchGetReviews extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.BatchGetReviewsResponse> {

        private static final String REST_PATH = "v4/{+name}/locations:batchGetReviews";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Returns the paginated list of reviews for all specified locations. This operation is only valid
         * if the specified locations are verified. *Note:* Reviews are limited to a batch size of 200
         * `location_names` per call.
         *
         * Create a request for the method "locations.batchGetReviews".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link BatchGetReviews#execute()} method to invoke the remote
         * operation. <p> {@link BatchGetReviews#initialize(com.google.api.client.googleapis.services.Abst
         * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param name The name of the account from which to retrieve a list of reviews across multiple locations.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.BatchGetReviewsRequest}
         * @since 1.13
         */
        protected BatchGetReviews(java.lang.String name, com.google.api.services.mybusiness.v4.model.BatchGetReviewsRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.BatchGetReviewsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public BatchGetReviews set$Xgafv(java.lang.String $Xgafv) {
          return (BatchGetReviews) super.set$Xgafv($Xgafv);
        }

        @Override
        public BatchGetReviews setAccessToken(java.lang.String accessToken) {
          return (BatchGetReviews) super.setAccessToken(accessToken);
        }

        @Override
        public BatchGetReviews setAlt(java.lang.String alt) {
          return (BatchGetReviews) super.setAlt(alt);
        }

        @Override
        public BatchGetReviews setCallback(java.lang.String callback) {
          return (BatchGetReviews) super.setCallback(callback);
        }

        @Override
        public BatchGetReviews setFields(java.lang.String fields) {
          return (BatchGetReviews) super.setFields(fields);
        }

        @Override
        public BatchGetReviews setKey(java.lang.String key) {
          return (BatchGetReviews) super.setKey(key);
        }

        @Override
        public BatchGetReviews setOauthToken(java.lang.String oauthToken) {
          return (BatchGetReviews) super.setOauthToken(oauthToken);
        }

        @Override
        public BatchGetReviews setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (BatchGetReviews) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public BatchGetReviews setQuotaUser(java.lang.String quotaUser) {
          return (BatchGetReviews) super.setQuotaUser(quotaUser);
        }

        @Override
        public BatchGetReviews setUploadType(java.lang.String uploadType) {
          return (BatchGetReviews) super.setUploadType(uploadType);
        }

        @Override
        public BatchGetReviews setUploadProtocol(java.lang.String uploadProtocol) {
          return (BatchGetReviews) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the account from which to retrieve a list of reviews across multiple
         * locations.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the account from which to retrieve a list of reviews across multiple locations.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * The name of the account from which to retrieve a list of reviews across multiple
         * locations.
         */
        public BatchGetReviews setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public BatchGetReviews set(String parameterName, Object value) {
          return (BatchGetReviews) super.set(parameterName, value);
        }
      }
      /**
       * Clears an association between a location and its place ID. This operation is only valid if the
       * location is unverified.
       *
       * Create a request for the method "locations.clearAssociation".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link ClearAssociation#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the location to disassociate.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.ClearLocationAssociationRequest}
       * @return the request
       */
      public ClearAssociation clearAssociation(java.lang.String name, com.google.api.services.mybusiness.v4.model.ClearLocationAssociationRequest content) throws java.io.IOException {
        ClearAssociation result = new ClearAssociation(name, content);
        initialize(result);
        return result;
      }

      public class ClearAssociation extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

        private static final String REST_PATH = "v4/{+name}:clearAssociation";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Clears an association between a location and its place ID. This operation is only valid if the
         * location is unverified.
         *
         * Create a request for the method "locations.clearAssociation".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link ClearAssociation#execute()} method to invoke the remote
         * operation. <p> {@link ClearAssociation#initialize(com.google.api.client.googleapis.services.Abs
         * tractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param name The resource name of the location to disassociate.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.ClearLocationAssociationRequest}
         * @since 1.13
         */
        protected ClearAssociation(java.lang.String name, com.google.api.services.mybusiness.v4.model.ClearLocationAssociationRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public ClearAssociation set$Xgafv(java.lang.String $Xgafv) {
          return (ClearAssociation) super.set$Xgafv($Xgafv);
        }

        @Override
        public ClearAssociation setAccessToken(java.lang.String accessToken) {
          return (ClearAssociation) super.setAccessToken(accessToken);
        }

        @Override
        public ClearAssociation setAlt(java.lang.String alt) {
          return (ClearAssociation) super.setAlt(alt);
        }

        @Override
        public ClearAssociation setCallback(java.lang.String callback) {
          return (ClearAssociation) super.setCallback(callback);
        }

        @Override
        public ClearAssociation setFields(java.lang.String fields) {
          return (ClearAssociation) super.setFields(fields);
        }

        @Override
        public ClearAssociation setKey(java.lang.String key) {
          return (ClearAssociation) super.setKey(key);
        }

        @Override
        public ClearAssociation setOauthToken(java.lang.String oauthToken) {
          return (ClearAssociation) super.setOauthToken(oauthToken);
        }

        @Override
        public ClearAssociation setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ClearAssociation) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ClearAssociation setQuotaUser(java.lang.String quotaUser) {
          return (ClearAssociation) super.setQuotaUser(quotaUser);
        }

        @Override
        public ClearAssociation setUploadType(java.lang.String uploadType) {
          return (ClearAssociation) super.setUploadType(uploadType);
        }

        @Override
        public ClearAssociation setUploadProtocol(java.lang.String uploadProtocol) {
          return (ClearAssociation) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource name of the location to disassociate. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the location to disassociate.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource name of the location to disassociate. */
        public ClearAssociation setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public ClearAssociation set(String parameterName, Object value) {
          return (ClearAssociation) super.set(parameterName, value);
        }
      }
      /**
       * Creates a new location owned by the specified account, and returns it.
       *
       * Create a request for the method "locations.create".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Create#execute()} method to invoke the remote operation.
       *
       * @param parent The name of the account in which to create this location.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Location}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Location content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Location> {

        private static final String REST_PATH = "v4/{+parent}/locations";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Creates a new location owned by the specified account, and returns it.
         *
         * Create a request for the method "locations.create".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
         * <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The name of the account in which to create this location.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Location}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Location content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Location.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the account in which to create this location. */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The name of the account in which to create this location.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /** The name of the account in which to create this location. */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /** If true, the request is validated without actually creating the location. */
        @com.google.api.client.util.Key
        private java.lang.Boolean validateOnly;

        /** If true, the request is validated without actually creating the location.
         */
        public java.lang.Boolean getValidateOnly() {
          return validateOnly;
        }

        /** If true, the request is validated without actually creating the location. */
        public Create setValidateOnly(java.lang.Boolean validateOnly) {
          this.validateOnly = validateOnly;
          return this;
        }

        /**
         * A unique request ID for the server to detect duplicated requests. We recommend using
         * UUIDs. Max length is 50 characters.
         */
        @com.google.api.client.util.Key
        private java.lang.String requestId;

        /** A unique request ID for the server to detect duplicated requests. We recommend using UUIDs. Max
       length is 50 characters.
         */
        public java.lang.String getRequestId() {
          return requestId;
        }

        /**
         * A unique request ID for the server to detect duplicated requests. We recommend using
         * UUIDs. Max length is 50 characters.
         */
        public Create setRequestId(java.lang.String requestId) {
          this.requestId = requestId;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Deletes a location. *Note:* If this location cannot be deleted using the API as marked in the
       * LocationState, use the [Google My Business](https://business.google.com/manage/) website. Returns
       * `NOT_FOUND` if the location does not exist.
       *
       * Create a request for the method "locations.delete".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
       *
       * @param name The name of the location to delete.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Deletes a location. *Note:* If this location cannot be deleted using the API as marked in the
         * LocationState, use the [Google My Business](https://business.google.com/manage/) website.
         * Returns `NOT_FOUND` if the location does not exist.
         *
         * Create a request for the method "locations.delete".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         * <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the location to delete.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the location to delete. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the location to delete.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the location to delete. */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Reports all eligible verification options for a location in a specific language.
       *
       * Create a request for the method "locations.fetchVerificationOptions".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link FetchVerificationOptions#execute()} method to invoke the remote
       * operation.
       *
       * @param name Resource name of the location to verify.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsRequest}
       * @return the request
       */
      public FetchVerificationOptions fetchVerificationOptions(java.lang.String name, com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsRequest content) throws java.io.IOException {
        FetchVerificationOptions result = new FetchVerificationOptions(name, content);
        initialize(result);
        return result;
      }

      public class FetchVerificationOptions extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsResponse> {

        private static final String REST_PATH = "v4/{+name}:fetchVerificationOptions";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Reports all eligible verification options for a location in a specific language.
         *
         * Create a request for the method "locations.fetchVerificationOptions".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link FetchVerificationOptions#execute()} method to invoke the
         * remote operation. <p> {@link FetchVerificationOptions#initialize(com.google.api.client.googleap
         * is.services.AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param name Resource name of the location to verify.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsRequest}
         * @since 1.13
         */
        protected FetchVerificationOptions(java.lang.String name, com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public FetchVerificationOptions set$Xgafv(java.lang.String $Xgafv) {
          return (FetchVerificationOptions) super.set$Xgafv($Xgafv);
        }

        @Override
        public FetchVerificationOptions setAccessToken(java.lang.String accessToken) {
          return (FetchVerificationOptions) super.setAccessToken(accessToken);
        }

        @Override
        public FetchVerificationOptions setAlt(java.lang.String alt) {
          return (FetchVerificationOptions) super.setAlt(alt);
        }

        @Override
        public FetchVerificationOptions setCallback(java.lang.String callback) {
          return (FetchVerificationOptions) super.setCallback(callback);
        }

        @Override
        public FetchVerificationOptions setFields(java.lang.String fields) {
          return (FetchVerificationOptions) super.setFields(fields);
        }

        @Override
        public FetchVerificationOptions setKey(java.lang.String key) {
          return (FetchVerificationOptions) super.setKey(key);
        }

        @Override
        public FetchVerificationOptions setOauthToken(java.lang.String oauthToken) {
          return (FetchVerificationOptions) super.setOauthToken(oauthToken);
        }

        @Override
        public FetchVerificationOptions setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (FetchVerificationOptions) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public FetchVerificationOptions setQuotaUser(java.lang.String quotaUser) {
          return (FetchVerificationOptions) super.setQuotaUser(quotaUser);
        }

        @Override
        public FetchVerificationOptions setUploadType(java.lang.String uploadType) {
          return (FetchVerificationOptions) super.setUploadType(uploadType);
        }

        @Override
        public FetchVerificationOptions setUploadProtocol(java.lang.String uploadProtocol) {
          return (FetchVerificationOptions) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name of the location to verify. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name of the location to verify.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name of the location to verify. */
        public FetchVerificationOptions setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public FetchVerificationOptions set(String parameterName, Object value) {
          return (FetchVerificationOptions) super.set(parameterName, value);
        }
      }
      /**
       * Finds all of the possible locations that are a match to the specified location. This operation is
       * only valid if the location is unverified.
       *
       * Create a request for the method "locations.findMatches".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link FindMatches#execute()} method to invoke the remote operation.
       *
       * @param name The resource name of the location to find matches for.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.FindMatchingLocationsRequest}
       * @return the request
       */
      public FindMatches findMatches(java.lang.String name, com.google.api.services.mybusiness.v4.model.FindMatchingLocationsRequest content) throws java.io.IOException {
        FindMatches result = new FindMatches(name, content);
        initialize(result);
        return result;
      }

      public class FindMatches extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.FindMatchingLocationsResponse> {

        private static final String REST_PATH = "v4/{+name}:findMatches";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Finds all of the possible locations that are a match to the specified location. This operation
         * is only valid if the location is unverified.
         *
         * Create a request for the method "locations.findMatches".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link FindMatches#execute()} method to invoke the remote
         * operation. <p> {@link
         * FindMatches#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The resource name of the location to find matches for.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.FindMatchingLocationsRequest}
         * @since 1.13
         */
        protected FindMatches(java.lang.String name, com.google.api.services.mybusiness.v4.model.FindMatchingLocationsRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.FindMatchingLocationsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public FindMatches set$Xgafv(java.lang.String $Xgafv) {
          return (FindMatches) super.set$Xgafv($Xgafv);
        }

        @Override
        public FindMatches setAccessToken(java.lang.String accessToken) {
          return (FindMatches) super.setAccessToken(accessToken);
        }

        @Override
        public FindMatches setAlt(java.lang.String alt) {
          return (FindMatches) super.setAlt(alt);
        }

        @Override
        public FindMatches setCallback(java.lang.String callback) {
          return (FindMatches) super.setCallback(callback);
        }

        @Override
        public FindMatches setFields(java.lang.String fields) {
          return (FindMatches) super.setFields(fields);
        }

        @Override
        public FindMatches setKey(java.lang.String key) {
          return (FindMatches) super.setKey(key);
        }

        @Override
        public FindMatches setOauthToken(java.lang.String oauthToken) {
          return (FindMatches) super.setOauthToken(oauthToken);
        }

        @Override
        public FindMatches setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (FindMatches) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public FindMatches setQuotaUser(java.lang.String quotaUser) {
          return (FindMatches) super.setQuotaUser(quotaUser);
        }

        @Override
        public FindMatches setUploadType(java.lang.String uploadType) {
          return (FindMatches) super.setUploadType(uploadType);
        }

        @Override
        public FindMatches setUploadProtocol(java.lang.String uploadProtocol) {
          return (FindMatches) super.setUploadProtocol(uploadProtocol);
        }

        /** The resource name of the location to find matches for. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The resource name of the location to find matches for.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The resource name of the location to find matches for. */
        public FindMatches setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public FindMatches set(String parameterName, Object value) {
          return (FindMatches) super.set(parameterName, value);
        }
      }
      /**
       * Gets the specified location. Returns `NOT_FOUND` if the location does not exist.
       *
       * Create a request for the method "locations.get".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Get#execute()} method to invoke the remote operation.
       *
       * @param name The name of the location to fetch.
       * @return the request
       */
      public Get get(java.lang.String name) throws java.io.IOException {
        Get result = new Get(name);
        initialize(result);
        return result;
      }

      public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Location> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Gets the specified location. Returns `NOT_FOUND` if the location does not exist.
         *
         * Create a request for the method "locations.get".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
         * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the location to fetch.
         * @since 1.13
         */
        protected Get(java.lang.String name) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public Get set$Xgafv(java.lang.String $Xgafv) {
          return (Get) super.set$Xgafv($Xgafv);
        }

        @Override
        public Get setAccessToken(java.lang.String accessToken) {
          return (Get) super.setAccessToken(accessToken);
        }

        @Override
        public Get setAlt(java.lang.String alt) {
          return (Get) super.setAlt(alt);
        }

        @Override
        public Get setCallback(java.lang.String callback) {
          return (Get) super.setCallback(callback);
        }

        @Override
        public Get setFields(java.lang.String fields) {
          return (Get) super.setFields(fields);
        }

        @Override
        public Get setKey(java.lang.String key) {
          return (Get) super.setKey(key);
        }

        @Override
        public Get setOauthToken(java.lang.String oauthToken) {
          return (Get) super.setOauthToken(oauthToken);
        }

        @Override
        public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Get) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Get setQuotaUser(java.lang.String quotaUser) {
          return (Get) super.setQuotaUser(quotaUser);
        }

        @Override
        public Get setUploadType(java.lang.String uploadType) {
          return (Get) super.setUploadType(uploadType);
        }

        @Override
        public Get setUploadProtocol(java.lang.String uploadProtocol) {
          return (Get) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the location to fetch. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the location to fetch.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the location to fetch. */
        public Get setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Get set(String parameterName, Object value) {
          return (Get) super.set(parameterName, value);
        }
      }
      /**
       * Returns the food menus of a specific location. Only call this if
       * location.location_state.can_have_food_menu is true.
       *
       * Create a request for the method "locations.getFoodMenus".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link GetFoodMenus#execute()} method to invoke the remote operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/foodMenus`
       * @return the request
       */
      public GetFoodMenus getFoodMenus(java.lang.String name) throws java.io.IOException {
        GetFoodMenus result = new GetFoodMenus(name);
        initialize(result);
        return result;
      }

      public class GetFoodMenus extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.FoodMenus> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/foodMenus$");

        /**
         * Returns the food menus of a specific location. Only call this if
         * location.location_state.can_have_food_menu is true.
         *
         * Create a request for the method "locations.getFoodMenus".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link GetFoodMenus#execute()} method to invoke the remote
         * operation. <p> {@link
         * GetFoodMenus#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/foodMenus`
         * @since 1.13
         */
        protected GetFoodMenus(java.lang.String name) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.FoodMenus.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/foodMenus$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetFoodMenus set$Xgafv(java.lang.String $Xgafv) {
          return (GetFoodMenus) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetFoodMenus setAccessToken(java.lang.String accessToken) {
          return (GetFoodMenus) super.setAccessToken(accessToken);
        }

        @Override
        public GetFoodMenus setAlt(java.lang.String alt) {
          return (GetFoodMenus) super.setAlt(alt);
        }

        @Override
        public GetFoodMenus setCallback(java.lang.String callback) {
          return (GetFoodMenus) super.setCallback(callback);
        }

        @Override
        public GetFoodMenus setFields(java.lang.String fields) {
          return (GetFoodMenus) super.setFields(fields);
        }

        @Override
        public GetFoodMenus setKey(java.lang.String key) {
          return (GetFoodMenus) super.setKey(key);
        }

        @Override
        public GetFoodMenus setOauthToken(java.lang.String oauthToken) {
          return (GetFoodMenus) super.setOauthToken(oauthToken);
        }

        @Override
        public GetFoodMenus setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetFoodMenus) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetFoodMenus setQuotaUser(java.lang.String quotaUser) {
          return (GetFoodMenus) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetFoodMenus setUploadType(java.lang.String uploadType) {
          return (GetFoodMenus) super.setUploadType(uploadType);
        }

        @Override
        public GetFoodMenus setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetFoodMenus) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/foodMenus`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/foodMenus`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/foodMenus`
         */
        public GetFoodMenus setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/foodMenus$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The specific fields to return. If no mask is specified, then it returns the
         * full FoodMenu (same as "*"). Repeated field items can not be individually specified. For
         * example: "name" and "menus" are valid masks, while "menus.sections" is invalid.
         */
        @com.google.api.client.util.Key
        private String readMask;

        /** Optional. The specific fields to return. If no mask is specified, then it returns the full FoodMenu
       (same as "*"). Repeated field items can not be individually specified. For example: "name" and
       "menus" are valid masks, while "menus.sections" is invalid.
         */
        public String getReadMask() {
          return readMask;
        }

        /**
         * Optional. The specific fields to return. If no mask is specified, then it returns the
         * full FoodMenu (same as "*"). Repeated field items can not be individually specified. For
         * example: "name" and "menus" are valid masks, while "menus.sections" is invalid.
         */
        public GetFoodMenus setReadMask(String readMask) {
          this.readMask = readMask;
          return this;
        }

        @Override
        public GetFoodMenus set(String parameterName, Object value) {
          return (GetFoodMenus) super.set(parameterName, value);
        }
      }
      /**
       * Gets the Google-updated version of the specified location. Returns `NOT_FOUND` if the location
       * does not exist.
       *
       * Create a request for the method "locations.getGoogleUpdated".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link GetGoogleUpdated#execute()} method to invoke the remote operation.
       *
       * @param name The name of the location to fetch.
       * @return the request
       */
      public GetGoogleUpdated getGoogleUpdated(java.lang.String name) throws java.io.IOException {
        GetGoogleUpdated result = new GetGoogleUpdated(name);
        initialize(result);
        return result;
      }

      public class GetGoogleUpdated extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.GoogleUpdatedLocation> {

        private static final String REST_PATH = "v4/{+name}:googleUpdated";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Gets the Google-updated version of the specified location. Returns `NOT_FOUND` if the location
         * does not exist.
         *
         * Create a request for the method "locations.getGoogleUpdated".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link GetGoogleUpdated#execute()} method to invoke the remote
         * operation. <p> {@link GetGoogleUpdated#initialize(com.google.api.client.googleapis.services.Abs
         * tractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param name The name of the location to fetch.
         * @since 1.13
         */
        protected GetGoogleUpdated(java.lang.String name) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.GoogleUpdatedLocation.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetGoogleUpdated set$Xgafv(java.lang.String $Xgafv) {
          return (GetGoogleUpdated) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetGoogleUpdated setAccessToken(java.lang.String accessToken) {
          return (GetGoogleUpdated) super.setAccessToken(accessToken);
        }

        @Override
        public GetGoogleUpdated setAlt(java.lang.String alt) {
          return (GetGoogleUpdated) super.setAlt(alt);
        }

        @Override
        public GetGoogleUpdated setCallback(java.lang.String callback) {
          return (GetGoogleUpdated) super.setCallback(callback);
        }

        @Override
        public GetGoogleUpdated setFields(java.lang.String fields) {
          return (GetGoogleUpdated) super.setFields(fields);
        }

        @Override
        public GetGoogleUpdated setKey(java.lang.String key) {
          return (GetGoogleUpdated) super.setKey(key);
        }

        @Override
        public GetGoogleUpdated setOauthToken(java.lang.String oauthToken) {
          return (GetGoogleUpdated) super.setOauthToken(oauthToken);
        }

        @Override
        public GetGoogleUpdated setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetGoogleUpdated) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetGoogleUpdated setQuotaUser(java.lang.String quotaUser) {
          return (GetGoogleUpdated) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetGoogleUpdated setUploadType(java.lang.String uploadType) {
          return (GetGoogleUpdated) super.setUploadType(uploadType);
        }

        @Override
        public GetGoogleUpdated setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetGoogleUpdated) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the location to fetch. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the location to fetch.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the location to fetch. */
        public GetGoogleUpdated setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public GetGoogleUpdated set(String parameterName, Object value) {
          return (GetGoogleUpdated) super.set(parameterName, value);
        }
      }
      /**
       * Returns the Health provider attributes of a specific location.
       *
       * Create a request for the method "locations.getHealthProviderAttributes".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link GetHealthProviderAttributes#execute()} method to invoke the remote
       * operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        accounts/{account_id}/locations/{location_id}/healthProviderAttributes
       * @return the request
       */
      public GetHealthProviderAttributes getHealthProviderAttributes(java.lang.String name) throws java.io.IOException {
        GetHealthProviderAttributes result = new GetHealthProviderAttributes(name);
        initialize(result);
        return result;
      }

      public class GetHealthProviderAttributes extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.HealthProviderAttributes> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");

        /**
         * Returns the Health provider attributes of a specific location.
         *
         * Create a request for the method "locations.getHealthProviderAttributes".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link GetHealthProviderAttributes#execute()} method to invoke
         * the remote operation. <p> {@link GetHealthProviderAttributes#initialize(com.google.api.client.g
         * oogleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        accounts/{account_id}/locations/{location_id}/healthProviderAttributes
         * @since 1.13
         */
        protected GetHealthProviderAttributes(java.lang.String name) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.HealthProviderAttributes.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetHealthProviderAttributes set$Xgafv(java.lang.String $Xgafv) {
          return (GetHealthProviderAttributes) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetHealthProviderAttributes setAccessToken(java.lang.String accessToken) {
          return (GetHealthProviderAttributes) super.setAccessToken(accessToken);
        }

        @Override
        public GetHealthProviderAttributes setAlt(java.lang.String alt) {
          return (GetHealthProviderAttributes) super.setAlt(alt);
        }

        @Override
        public GetHealthProviderAttributes setCallback(java.lang.String callback) {
          return (GetHealthProviderAttributes) super.setCallback(callback);
        }

        @Override
        public GetHealthProviderAttributes setFields(java.lang.String fields) {
          return (GetHealthProviderAttributes) super.setFields(fields);
        }

        @Override
        public GetHealthProviderAttributes setKey(java.lang.String key) {
          return (GetHealthProviderAttributes) super.setKey(key);
        }

        @Override
        public GetHealthProviderAttributes setOauthToken(java.lang.String oauthToken) {
          return (GetHealthProviderAttributes) super.setOauthToken(oauthToken);
        }

        @Override
        public GetHealthProviderAttributes setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetHealthProviderAttributes) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetHealthProviderAttributes setQuotaUser(java.lang.String quotaUser) {
          return (GetHealthProviderAttributes) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetHealthProviderAttributes setUploadType(java.lang.String uploadType) {
          return (GetHealthProviderAttributes) super.setUploadType(uploadType);
        }

        @Override
        public GetHealthProviderAttributes setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetHealthProviderAttributes) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * accounts/{account_id}/locations/{location_id}/healthProviderAttributes
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       accounts/{account_id}/locations/{location_id}/healthProviderAttributes
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * accounts/{account_id}/locations/{location_id}/healthProviderAttributes
         */
        public GetHealthProviderAttributes setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The BCP 47 code for the language. If a language code is not provided, it
         * defaults to English. Right now only 'en' is supported.
         */
        @com.google.api.client.util.Key
        private java.lang.String languageCode;

        /** Optional. The BCP 47 code for the language. If a language code is not provided, it defaults to
       English. Right now only 'en' is supported.
         */
        public java.lang.String getLanguageCode() {
          return languageCode;
        }

        /**
         * Optional. The BCP 47 code for the language. If a language code is not provided, it
         * defaults to English. Right now only 'en' is supported.
         */
        public GetHealthProviderAttributes setLanguageCode(java.lang.String languageCode) {
          this.languageCode = languageCode;
          return this;
        }

        @Override
        public GetHealthProviderAttributes set(String parameterName, Object value) {
          return (GetHealthProviderAttributes) super.set(parameterName, value);
        }
      }
      /**
       * Returns the Lodging of a specific location.
       *
       * Create a request for the method "locations.getLodging".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link GetLodging#execute()} method to invoke the remote operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/lodging`
       * @return the request
       */
      public GetLodging getLodging(java.lang.String name) throws java.io.IOException {
        GetLodging result = new GetLodging(name);
        initialize(result);
        return result;
      }

      public class GetLodging extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Lodging> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/lodging$");

        /**
         * Returns the Lodging of a specific location.
         *
         * Create a request for the method "locations.getLodging".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link GetLodging#execute()} method to invoke the remote
         * operation. <p> {@link
         * GetLodging#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/lodging`
         * @since 1.13
         */
        protected GetLodging(java.lang.String name) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Lodging.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/lodging$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetLodging set$Xgafv(java.lang.String $Xgafv) {
          return (GetLodging) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetLodging setAccessToken(java.lang.String accessToken) {
          return (GetLodging) super.setAccessToken(accessToken);
        }

        @Override
        public GetLodging setAlt(java.lang.String alt) {
          return (GetLodging) super.setAlt(alt);
        }

        @Override
        public GetLodging setCallback(java.lang.String callback) {
          return (GetLodging) super.setCallback(callback);
        }

        @Override
        public GetLodging setFields(java.lang.String fields) {
          return (GetLodging) super.setFields(fields);
        }

        @Override
        public GetLodging setKey(java.lang.String key) {
          return (GetLodging) super.setKey(key);
        }

        @Override
        public GetLodging setOauthToken(java.lang.String oauthToken) {
          return (GetLodging) super.setOauthToken(oauthToken);
        }

        @Override
        public GetLodging setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetLodging) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetLodging setQuotaUser(java.lang.String quotaUser) {
          return (GetLodging) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetLodging setUploadType(java.lang.String uploadType) {
          return (GetLodging) super.setUploadType(uploadType);
        }

        @Override
        public GetLodging setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetLodging) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/lodging`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/lodging`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/lodging`
         */
        public GetLodging setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/lodging$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The specific fields to return. If no mask is specified, then it returns the
         * full Lodging (same as "*"). Repeated field items cannot be individually specified.
         */
        @com.google.api.client.util.Key
        private String readMask;

        /** Optional. The specific fields to return. If no mask is specified, then it returns the full Lodging
       (same as "*"). Repeated field items cannot be individually specified.
         */
        public String getReadMask() {
          return readMask;
        }

        /**
         * Optional. The specific fields to return. If no mask is specified, then it returns the
         * full Lodging (same as "*"). Repeated field items cannot be individually specified.
         */
        public GetLodging setReadMask(String readMask) {
          this.readMask = readMask;
          return this;
        }

        @Override
        public GetLodging set(String parameterName, Object value) {
          return (GetLodging) super.set(parameterName, value);
        }
      }
      /**
       * Get the specified service list of a location.
       *
       * Create a request for the method "locations.getServiceList".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link GetServiceList#execute()} method to invoke the remote operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/servicelist`
       * @return the request
       */
      public GetServiceList getServiceList(java.lang.String name) throws java.io.IOException {
        GetServiceList result = new GetServiceList(name);
        initialize(result);
        return result;
      }

      public class GetServiceList extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ServiceList> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/serviceList$");

        /**
         * Get the specified service list of a location.
         *
         * Create a request for the method "locations.getServiceList".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link GetServiceList#execute()} method to invoke the remote
         * operation. <p> {@link GetServiceList#initialize(com.google.api.client.googleapis.services.Abstr
         * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/servicelist`
         * @since 1.13
         */
        protected GetServiceList(java.lang.String name) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ServiceList.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/serviceList$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public GetServiceList set$Xgafv(java.lang.String $Xgafv) {
          return (GetServiceList) super.set$Xgafv($Xgafv);
        }

        @Override
        public GetServiceList setAccessToken(java.lang.String accessToken) {
          return (GetServiceList) super.setAccessToken(accessToken);
        }

        @Override
        public GetServiceList setAlt(java.lang.String alt) {
          return (GetServiceList) super.setAlt(alt);
        }

        @Override
        public GetServiceList setCallback(java.lang.String callback) {
          return (GetServiceList) super.setCallback(callback);
        }

        @Override
        public GetServiceList setFields(java.lang.String fields) {
          return (GetServiceList) super.setFields(fields);
        }

        @Override
        public GetServiceList setKey(java.lang.String key) {
          return (GetServiceList) super.setKey(key);
        }

        @Override
        public GetServiceList setOauthToken(java.lang.String oauthToken) {
          return (GetServiceList) super.setOauthToken(oauthToken);
        }

        @Override
        public GetServiceList setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (GetServiceList) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public GetServiceList setQuotaUser(java.lang.String quotaUser) {
          return (GetServiceList) super.setQuotaUser(quotaUser);
        }

        @Override
        public GetServiceList setUploadType(java.lang.String uploadType) {
          return (GetServiceList) super.setUploadType(uploadType);
        }

        @Override
        public GetServiceList setUploadProtocol(java.lang.String uploadProtocol) {
          return (GetServiceList) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/servicelist`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/servicelist`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/servicelist`
         */
        public GetServiceList setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/serviceList$");
          }
          this.name = name;
          return this;
        }

        @Override
        public GetServiceList set(String parameterName, Object value) {
          return (GetServiceList) super.set(parameterName, value);
        }
      }
      /**
       * Lists the locations for the specified account.
       *
       * Create a request for the method "locations.list".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link List#execute()} method to invoke the remote operation.
       *
       * @param parent The name of the account to fetch locations from. If the Account is of AccountType PERSONAL, only
       *        Locations that are directly owned by the Account are returned, otherwise it will return
       *        all accessible locations from the Account, either directly or indirectly.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListLocationsResponse> {

        private static final String REST_PATH = "v4/{+parent}/locations";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Lists the locations for the specified account.
         *
         * Create a request for the method "locations.list".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
         * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent The name of the account to fetch locations from. If the Account is of AccountType PERSONAL, only
       *        Locations that are directly owned by the Account are returned, otherwise it will return
       *        all accessible locations from the Account, either directly or indirectly.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListLocationsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * The name of the account to fetch locations from. If the Account is of AccountType
         * PERSONAL, only Locations that are directly owned by the Account are returned, otherwise
         * it will return all accessible locations from the Account, either directly or indirectly.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** The name of the account to fetch locations from. If the Account is of AccountType PERSONAL, only
       Locations that are directly owned by the Account are returned, otherwise it will return all
       accessible locations from the Account, either directly or indirectly.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * The name of the account to fetch locations from. If the Account is of AccountType
         * PERSONAL, only Locations that are directly owned by the Account are returned, otherwise
         * it will return all accessible locations from the Account, either directly or indirectly.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /**
         * The BCP 47 code of language to get display location properties in. If this language is
         * not available, they will be provided in the language of the location. If neither is
         * available, they will be provided in English. Deprecated. After August 15th, 2020, this
         * field will no longer be applied. Instead, the language of the location will always be
         * used.
         */
        @com.google.api.client.util.Key
        private java.lang.String languageCode;

        /** The BCP 47 code of language to get display location properties in. If this language is not
       available, they will be provided in the language of the location. If neither is available, they
       will be provided in English. Deprecated. After August 15th, 2020, this field will no longer be
       applied. Instead, the language of the location will always be used.
         */
        public java.lang.String getLanguageCode() {
          return languageCode;
        }

        /**
         * The BCP 47 code of language to get display location properties in. If this language is
         * not available, they will be provided in the language of the location. If neither is
         * available, they will be provided in English. Deprecated. After August 15th, 2020, this
         * field will no longer be applied. Instead, the language of the location will always be
         * used.
         */
        public List setLanguageCode(java.lang.String languageCode) {
          this.languageCode = languageCode;
          return this;
        }

        /**
         * If specified, it fetches the next `page` of locations. The page token is returned by
         * previous calls to `ListLocations` when there were more locations than could fit in the
         * requested page size.
         */
        @com.google.api.client.util.Key
        private java.lang.String pageToken;

        /** If specified, it fetches the next `page` of locations. The page token is returned by previous calls
       to `ListLocations` when there were more locations than could fit in the requested page size.
         */
        public java.lang.String getPageToken() {
          return pageToken;
        }

        /**
         * If specified, it fetches the next `page` of locations. The page token is returned by
         * previous calls to `ListLocations` when there were more locations than could fit in the
         * requested page size.
         */
        public List setPageToken(java.lang.String pageToken) {
          this.pageToken = pageToken;
          return this;
        }

        /**
         * How many locations to fetch per page. Default is 100, minimum is 1, and maximum page size
         * is 100.
         */
        @com.google.api.client.util.Key
        private java.lang.Integer pageSize;

        /** How many locations to fetch per page. Default is 100, minimum is 1, and maximum page size is 100.
         */
        public java.lang.Integer getPageSize() {
          return pageSize;
        }

        /**
         * How many locations to fetch per page. Default is 100, minimum is 1, and maximum page size
         * is 100.
         */
        public List setPageSize(java.lang.Integer pageSize) {
          this.pageSize = pageSize;
          return this;
        }

        /**
         * A filter constraining the locations to return. The response includes only entries that
         * match the filter. If `filter` is empty, then constraints are applied and all locations
         * (paginated) are retrieved for the requested account. For more information about valid
         * fields and example usage, see [Work with Location Data
         * Guide](https://developers.google.com/my-business/content/location-
         * data#filter_results_when_you_list_locations).
         */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** A filter constraining the locations to return. The response includes only entries that match the
       filter. If `filter` is empty, then constraints are applied and all locations (paginated) are
       retrieved for the requested account. For more information about valid fields and example usage, see
       [Work with Location Data Guide](https://developers.google.com/my-business/content/location-
       data#filter_results_when_you_list_locations).
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /**
         * A filter constraining the locations to return. The response includes only entries that
         * match the filter. If `filter` is empty, then constraints are applied and all locations
         * (paginated) are retrieved for the requested account. For more information about valid
         * fields and example usage, see [Work with Location Data
         * Guide](https://developers.google.com/my-business/content/location-
         * data#filter_results_when_you_list_locations).
         */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        /**
         * Sorting order for the request. Multiple fields should be comma-separated, following SQL
         * syntax. The default sorting order is ascending. To specify descending order, a suffix "
         * desc" should be added. Valid fields to order_by are location_name and store_code. For
         * example: "location_name, store_code desc" or "location_name" or "store_code desc"
         */
        @com.google.api.client.util.Key
        private java.lang.String orderBy;

        /** Sorting order for the request. Multiple fields should be comma-separated, following SQL syntax. The
       default sorting order is ascending. To specify descending order, a suffix " desc" should be added.
       Valid fields to order_by are location_name and store_code. For example: "location_name, store_code
       desc" or "location_name" or "store_code desc"
         */
        public java.lang.String getOrderBy() {
          return orderBy;
        }

        /**
         * Sorting order for the request. Multiple fields should be comma-separated, following SQL
         * syntax. The default sorting order is ascending. To specify descending order, a suffix "
         * desc" should be added. Valid fields to order_by are location_name and store_code. For
         * example: "location_name, store_code desc" or "location_name" or "store_code desc"
         */
        public List setOrderBy(java.lang.String orderBy) {
          this.orderBy = orderBy;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the specified location. Photos are only allowed on a location that has a Google+ page.
       * Returns `NOT_FOUND` if the location does not exist.
       *
       * Create a request for the method "locations.patch".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
       *
       * @param name The name of the location to update.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Location}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Location content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Location> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Updates the specified location. Photos are only allowed on a location that has a Google+ page.
         * Returns `NOT_FOUND` if the location does not exist.
         *
         * Create a request for the method "locations.patch".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         * <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the location to update.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Location}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Location content) {
          super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the location to update. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the location to update.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the location to update. */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /** If true, the request is validated without actually updating the location. */
        @com.google.api.client.util.Key
        private java.lang.Boolean validateOnly;

        /** If true, the request is validated without actually updating the location.
         */
        public java.lang.Boolean getValidateOnly() {
          return validateOnly;
        }

        /** If true, the request is validated without actually updating the location. */
        public Patch setValidateOnly(java.lang.Boolean validateOnly) {
          this.validateOnly = validateOnly;
          return this;
        }

        /**
         * The IDs of the attributes to update. Only attributes noted in the mask will be updated.
         * If an attribute is present in the mask and not in the location, it will be removed. An
         * empty mask will update all attributes. Whenever this field is set, the update_mask should
         * include attributes as one of the fields to update.
         */
        @com.google.api.client.util.Key
        private String attributeMask;

        /** The IDs of the attributes to update. Only attributes noted in the mask will be updated. If an
       attribute is present in the mask and not in the location, it will be removed. An empty mask will
       update all attributes. Whenever this field is set, the update_mask should include attributes as one
       of the fields to update.
         */
        public String getAttributeMask() {
          return attributeMask;
        }

        /**
         * The IDs of the attributes to update. Only attributes noted in the mask will be updated.
         * If an attribute is present in the mask and not in the location, it will be removed. An
         * empty mask will update all attributes. Whenever this field is set, the update_mask should
         * include attributes as one of the fields to update.
         */
        public Patch setAttributeMask(String attributeMask) {
          this.attributeMask = attributeMask;
          return this;
        }

        /**
         * The specific fields to update. If no mask is specified, then this is treated as a full
         * update and all fields are set to the values passed in, which may include unsetting empty
         * fields in the request.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** The specific fields to update. If no mask is specified, then this is treated as a full update and
       all fields are set to the values passed in, which may include unsetting empty fields in the
       request.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * The specific fields to update. If no mask is specified, then this is treated as a full
         * update and all fields are set to the values passed in, which may include unsetting empty
         * fields in the request.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }
      /**
       * Returns a report containing insights on one or more metrics by location. *Note:* Insight reports
       * are limited to a batch size of 10 `location_names` per call.
       *
       * Create a request for the method "locations.reportInsights".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link ReportInsights#execute()} method to invoke the remote operation.
       *
       * @param name The account resource name.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.ReportLocationInsightsRequest}
       * @return the request
       */
      public ReportInsights reportInsights(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReportLocationInsightsRequest content) throws java.io.IOException {
        ReportInsights result = new ReportInsights(name, content);
        initialize(result);
        return result;
      }

      public class ReportInsights extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ReportLocationInsightsResponse> {

        private static final String REST_PATH = "v4/{+name}/locations:reportInsights";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Returns a report containing insights on one or more metrics by location. *Note:* Insight
         * reports are limited to a batch size of 10 `location_names` per call.
         *
         * Create a request for the method "locations.reportInsights".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link ReportInsights#execute()} method to invoke the remote
         * operation. <p> {@link ReportInsights#initialize(com.google.api.client.googleapis.services.Abstr
         * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param name The account resource name.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.ReportLocationInsightsRequest}
         * @since 1.13
         */
        protected ReportInsights(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReportLocationInsightsRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.ReportLocationInsightsResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public ReportInsights set$Xgafv(java.lang.String $Xgafv) {
          return (ReportInsights) super.set$Xgafv($Xgafv);
        }

        @Override
        public ReportInsights setAccessToken(java.lang.String accessToken) {
          return (ReportInsights) super.setAccessToken(accessToken);
        }

        @Override
        public ReportInsights setAlt(java.lang.String alt) {
          return (ReportInsights) super.setAlt(alt);
        }

        @Override
        public ReportInsights setCallback(java.lang.String callback) {
          return (ReportInsights) super.setCallback(callback);
        }

        @Override
        public ReportInsights setFields(java.lang.String fields) {
          return (ReportInsights) super.setFields(fields);
        }

        @Override
        public ReportInsights setKey(java.lang.String key) {
          return (ReportInsights) super.setKey(key);
        }

        @Override
        public ReportInsights setOauthToken(java.lang.String oauthToken) {
          return (ReportInsights) super.setOauthToken(oauthToken);
        }

        @Override
        public ReportInsights setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (ReportInsights) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public ReportInsights setQuotaUser(java.lang.String quotaUser) {
          return (ReportInsights) super.setQuotaUser(quotaUser);
        }

        @Override
        public ReportInsights setUploadType(java.lang.String uploadType) {
          return (ReportInsights) super.setUploadType(uploadType);
        }

        @Override
        public ReportInsights setUploadProtocol(java.lang.String uploadProtocol) {
          return (ReportInsights) super.setUploadProtocol(uploadProtocol);
        }

        /** The account resource name. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The account resource name.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The account resource name. */
        public ReportInsights setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public ReportInsights set(String parameterName, Object value) {
          return (ReportInsights) super.set(parameterName, value);
        }
      }
      /**
       * Moves a location from an account that the user owns to another account that the same user
       * administers. The user must be an owner of the account the location is currently associated with
       * and must also be at least a manager of the destination account. Returns the Location with its new
       * resource name.
       *
       * Create a request for the method "locations.transfer".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Transfer#execute()} method to invoke the remote operation.
       *
       * @param name The name of the location to transfer.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.TransferLocationRequest}
       * @return the request
       */
      public Transfer transfer(java.lang.String name, com.google.api.services.mybusiness.v4.model.TransferLocationRequest content) throws java.io.IOException {
        Transfer result = new Transfer(name, content);
        initialize(result);
        return result;
      }

      public class Transfer extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Location> {

        private static final String REST_PATH = "v4/{+name}:transfer";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Moves a location from an account that the user owns to another account that the same user
         * administers. The user must be an owner of the account the location is currently associated with
         * and must also be at least a manager of the destination account. Returns the Location with its
         * new resource name.
         *
         * Create a request for the method "locations.transfer".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Transfer#execute()} method to invoke the remote operation.
         * <p> {@link
         * Transfer#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
         * must be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name The name of the location to transfer.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.TransferLocationRequest}
         * @since 1.13
         */
        protected Transfer(java.lang.String name, com.google.api.services.mybusiness.v4.model.TransferLocationRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Location.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public Transfer set$Xgafv(java.lang.String $Xgafv) {
          return (Transfer) super.set$Xgafv($Xgafv);
        }

        @Override
        public Transfer setAccessToken(java.lang.String accessToken) {
          return (Transfer) super.setAccessToken(accessToken);
        }

        @Override
        public Transfer setAlt(java.lang.String alt) {
          return (Transfer) super.setAlt(alt);
        }

        @Override
        public Transfer setCallback(java.lang.String callback) {
          return (Transfer) super.setCallback(callback);
        }

        @Override
        public Transfer setFields(java.lang.String fields) {
          return (Transfer) super.setFields(fields);
        }

        @Override
        public Transfer setKey(java.lang.String key) {
          return (Transfer) super.setKey(key);
        }

        @Override
        public Transfer setOauthToken(java.lang.String oauthToken) {
          return (Transfer) super.setOauthToken(oauthToken);
        }

        @Override
        public Transfer setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Transfer) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Transfer setQuotaUser(java.lang.String quotaUser) {
          return (Transfer) super.setQuotaUser(quotaUser);
        }

        @Override
        public Transfer setUploadType(java.lang.String uploadType) {
          return (Transfer) super.setUploadType(uploadType);
        }

        @Override
        public Transfer setUploadProtocol(java.lang.String uploadProtocol) {
          return (Transfer) super.setUploadProtocol(uploadProtocol);
        }

        /** The name of the location to transfer. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** The name of the location to transfer.
         */
        public java.lang.String getName() {
          return name;
        }

        /** The name of the location to transfer. */
        public Transfer setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Transfer set(String parameterName, Object value) {
          return (Transfer) super.set(parameterName, value);
        }
      }
      /**
       * Updates the food menus of a specific location. Only call this if
       * location.location_state.can_have_food_menu is true.
       *
       * Create a request for the method "locations.updateFoodMenus".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link UpdateFoodMenus#execute()} method to invoke the remote operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/foodMenus`
       * @param content the {@link com.google.api.services.mybusiness.v4.model.FoodMenus}
       * @return the request
       */
      public UpdateFoodMenus updateFoodMenus(java.lang.String name, com.google.api.services.mybusiness.v4.model.FoodMenus content) throws java.io.IOException {
        UpdateFoodMenus result = new UpdateFoodMenus(name, content);
        initialize(result);
        return result;
      }

      public class UpdateFoodMenus extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.FoodMenus> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/foodMenus$");

        /**
         * Updates the food menus of a specific location. Only call this if
         * location.location_state.can_have_food_menu is true.
         *
         * Create a request for the method "locations.updateFoodMenus".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link UpdateFoodMenus#execute()} method to invoke the remote
         * operation. <p> {@link UpdateFoodMenus#initialize(com.google.api.client.googleapis.services.Abst
         * ractGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/foodMenus`
         * @param content the {@link com.google.api.services.mybusiness.v4.model.FoodMenus}
         * @since 1.13
         */
        protected UpdateFoodMenus(java.lang.String name, com.google.api.services.mybusiness.v4.model.FoodMenus content) {
          super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.FoodMenus.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/foodMenus$");
          }
        }

        @Override
        public UpdateFoodMenus set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateFoodMenus) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateFoodMenus setAccessToken(java.lang.String accessToken) {
          return (UpdateFoodMenus) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateFoodMenus setAlt(java.lang.String alt) {
          return (UpdateFoodMenus) super.setAlt(alt);
        }

        @Override
        public UpdateFoodMenus setCallback(java.lang.String callback) {
          return (UpdateFoodMenus) super.setCallback(callback);
        }

        @Override
        public UpdateFoodMenus setFields(java.lang.String fields) {
          return (UpdateFoodMenus) super.setFields(fields);
        }

        @Override
        public UpdateFoodMenus setKey(java.lang.String key) {
          return (UpdateFoodMenus) super.setKey(key);
        }

        @Override
        public UpdateFoodMenus setOauthToken(java.lang.String oauthToken) {
          return (UpdateFoodMenus) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateFoodMenus setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateFoodMenus) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateFoodMenus setQuotaUser(java.lang.String quotaUser) {
          return (UpdateFoodMenus) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateFoodMenus setUploadType(java.lang.String uploadType) {
          return (UpdateFoodMenus) super.setUploadType(uploadType);
        }

        @Override
        public UpdateFoodMenus setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateFoodMenus) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/foodMenus`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/foodMenus`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/foodMenus`
         */
        public UpdateFoodMenus setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/foodMenus$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update and all fields are set to the values passed in, which may include unsetting
         * empty fields in the request. Repeated field items can not be individually updated. Note:
         * "name" of FoodMenus is the resource identifier which is not updatable.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Optional. The specific fields to update. If no mask is specified, then this is treated as a full
       update and all fields are set to the values passed in, which may include unsetting empty fields in
       the request. Repeated field items can not be individually updated. Note: "name" of FoodMenus is the
       resource identifier which is not updatable.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update and all fields are set to the values passed in, which may include unsetting
         * empty fields in the request. Repeated field items can not be individually updated. Note:
         * "name" of FoodMenus is the resource identifier which is not updatable.
         */
        public UpdateFoodMenus setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public UpdateFoodMenus set(String parameterName, Object value) {
          return (UpdateFoodMenus) super.set(parameterName, value);
        }
      }
      /**
       * Updates the Health provider attributes of a specific location.
       *
       * Create a request for the method "locations.updateHealthProviderAttributes".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link UpdateHealthProviderAttributes#execute()} method to invoke the remote
       * operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
       * @param content the {@link com.google.api.services.mybusiness.v4.model.HealthProviderAttributes}
       * @return the request
       */
      public UpdateHealthProviderAttributes updateHealthProviderAttributes(java.lang.String name, com.google.api.services.mybusiness.v4.model.HealthProviderAttributes content) throws java.io.IOException {
        UpdateHealthProviderAttributes result = new UpdateHealthProviderAttributes(name, content);
        initialize(result);
        return result;
      }

      public class UpdateHealthProviderAttributes extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.HealthProviderAttributes> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");

        /**
         * Updates the Health provider attributes of a specific location.
         *
         * Create a request for the method "locations.updateHealthProviderAttributes".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link UpdateHealthProviderAttributes#execute()} method to invoke
         * the remote operation. <p> {@link UpdateHealthProviderAttributes#initialize(com.google.api.clien
         * t.googleapis.services.AbstractGoogleClientRequest)} must be called to initialize this instance
         * immediately after invoking the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
         * @param content the {@link com.google.api.services.mybusiness.v4.model.HealthProviderAttributes}
         * @since 1.13
         */
        protected UpdateHealthProviderAttributes(java.lang.String name, com.google.api.services.mybusiness.v4.model.HealthProviderAttributes content) {
          super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.HealthProviderAttributes.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
          }
        }

        @Override
        public UpdateHealthProviderAttributes set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateHealthProviderAttributes) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateHealthProviderAttributes setAccessToken(java.lang.String accessToken) {
          return (UpdateHealthProviderAttributes) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateHealthProviderAttributes setAlt(java.lang.String alt) {
          return (UpdateHealthProviderAttributes) super.setAlt(alt);
        }

        @Override
        public UpdateHealthProviderAttributes setCallback(java.lang.String callback) {
          return (UpdateHealthProviderAttributes) super.setCallback(callback);
        }

        @Override
        public UpdateHealthProviderAttributes setFields(java.lang.String fields) {
          return (UpdateHealthProviderAttributes) super.setFields(fields);
        }

        @Override
        public UpdateHealthProviderAttributes setKey(java.lang.String key) {
          return (UpdateHealthProviderAttributes) super.setKey(key);
        }

        @Override
        public UpdateHealthProviderAttributes setOauthToken(java.lang.String oauthToken) {
          return (UpdateHealthProviderAttributes) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateHealthProviderAttributes setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateHealthProviderAttributes) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateHealthProviderAttributes setQuotaUser(java.lang.String quotaUser) {
          return (UpdateHealthProviderAttributes) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateHealthProviderAttributes setUploadType(java.lang.String uploadType) {
          return (UpdateHealthProviderAttributes) super.setUploadType(uploadType);
        }

        @Override
        public UpdateHealthProviderAttributes setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateHealthProviderAttributes) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/healthProviderAttributes`
         */
        public UpdateHealthProviderAttributes setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update and all fields are set to the values passed in, which may include unsetting
         * empty fields in the request. In V1, there is only the insurance_networks field to update.
         * More attributes will be supported later.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Optional. The specific fields to update. If no mask is specified, then this is treated as a full
       update and all fields are set to the values passed in, which may include unsetting empty fields in
       the request. In V1, there is only the insurance_networks field to update. More attributes will be
       supported later.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update and all fields are set to the values passed in, which may include unsetting
         * empty fields in the request. In V1, there is only the insurance_networks field to update.
         * More attributes will be supported later.
         */
        public UpdateHealthProviderAttributes setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public UpdateHealthProviderAttributes set(String parameterName, Object value) {
          return (UpdateHealthProviderAttributes) super.set(parameterName, value);
        }
      }
      /**
       * Updates the Lodging of a specific location.
       *
       * Create a request for the method "locations.updateLodging".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link UpdateLodging#execute()} method to invoke the remote operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/lodging`
       * @param content the {@link com.google.api.services.mybusiness.v4.model.Lodging}
       * @return the request
       */
      public UpdateLodging updateLodging(java.lang.String name, com.google.api.services.mybusiness.v4.model.Lodging content) throws java.io.IOException {
        UpdateLodging result = new UpdateLodging(name, content);
        initialize(result);
        return result;
      }

      public class UpdateLodging extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Lodging> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/lodging$");

        /**
         * Updates the Lodging of a specific location.
         *
         * Create a request for the method "locations.updateLodging".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link UpdateLodging#execute()} method to invoke the remote
         * operation. <p> {@link UpdateLodging#initialize(com.google.api.client.googleapis.services.Abstra
         * ctGoogleClientRequest)} must be called to initialize this instance immediately after invoking
         * the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/lodging`
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Lodging}
         * @since 1.13
         */
        protected UpdateLodging(java.lang.String name, com.google.api.services.mybusiness.v4.model.Lodging content) {
          super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Lodging.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/lodging$");
          }
        }

        @Override
        public UpdateLodging set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateLodging) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateLodging setAccessToken(java.lang.String accessToken) {
          return (UpdateLodging) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateLodging setAlt(java.lang.String alt) {
          return (UpdateLodging) super.setAlt(alt);
        }

        @Override
        public UpdateLodging setCallback(java.lang.String callback) {
          return (UpdateLodging) super.setCallback(callback);
        }

        @Override
        public UpdateLodging setFields(java.lang.String fields) {
          return (UpdateLodging) super.setFields(fields);
        }

        @Override
        public UpdateLodging setKey(java.lang.String key) {
          return (UpdateLodging) super.setKey(key);
        }

        @Override
        public UpdateLodging setOauthToken(java.lang.String oauthToken) {
          return (UpdateLodging) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateLodging setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateLodging) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateLodging setQuotaUser(java.lang.String quotaUser) {
          return (UpdateLodging) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateLodging setUploadType(java.lang.String uploadType) {
          return (UpdateLodging) super.setUploadType(uploadType);
        }

        @Override
        public UpdateLodging setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateLodging) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/lodging`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/lodging`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/lodging`
         */
        public UpdateLodging setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/lodging$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update (same as "*") and all fields are set to the values passed in, which may
         * include unsetting empty fields in the request. Repeated field items cannot be
         * individually updated.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Optional. The specific fields to update. If no mask is specified, then this is treated as a full
       update (same as "*") and all fields are set to the values passed in, which may include unsetting
       empty fields in the request. Repeated field items cannot be individually updated.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update (same as "*") and all fields are set to the values passed in, which may
         * include unsetting empty fields in the request. Repeated field items cannot be
         * individually updated.
         */
        public UpdateLodging setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public UpdateLodging set(String parameterName, Object value) {
          return (UpdateLodging) super.set(parameterName, value);
        }
      }
      /**
       * Updates the specified service list of a location.
       *
       * Create a request for the method "locations.updateServiceList".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link UpdateServiceList#execute()} method to invoke the remote operation.
       *
       * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/serviceList`
       * @param content the {@link com.google.api.services.mybusiness.v4.model.ServiceList}
       * @return the request
       */
      public UpdateServiceList updateServiceList(java.lang.String name, com.google.api.services.mybusiness.v4.model.ServiceList content) throws java.io.IOException {
        UpdateServiceList result = new UpdateServiceList(name, content);
        initialize(result);
        return result;
      }

      public class UpdateServiceList extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ServiceList> {

        private static final String REST_PATH = "v4/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/serviceList$");

        /**
         * Updates the specified service list of a location.
         *
         * Create a request for the method "locations.updateServiceList".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link UpdateServiceList#execute()} method to invoke the remote
         * operation. <p> {@link UpdateServiceList#initialize(com.google.api.client.googleapis.services.Ab
         * stractGoogleClientRequest)} must be called to initialize this instance immediately after
         * invoking the constructor. </p>
         *
         * @param name Required. Google identifier for this location in the form:
       *        `accounts/{account_id}/locations/{location_id}/serviceList`
         * @param content the {@link com.google.api.services.mybusiness.v4.model.ServiceList}
         * @since 1.13
         */
        protected UpdateServiceList(java.lang.String name, com.google.api.services.mybusiness.v4.model.ServiceList content) {
          super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.ServiceList.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/serviceList$");
          }
        }

        @Override
        public UpdateServiceList set$Xgafv(java.lang.String $Xgafv) {
          return (UpdateServiceList) super.set$Xgafv($Xgafv);
        }

        @Override
        public UpdateServiceList setAccessToken(java.lang.String accessToken) {
          return (UpdateServiceList) super.setAccessToken(accessToken);
        }

        @Override
        public UpdateServiceList setAlt(java.lang.String alt) {
          return (UpdateServiceList) super.setAlt(alt);
        }

        @Override
        public UpdateServiceList setCallback(java.lang.String callback) {
          return (UpdateServiceList) super.setCallback(callback);
        }

        @Override
        public UpdateServiceList setFields(java.lang.String fields) {
          return (UpdateServiceList) super.setFields(fields);
        }

        @Override
        public UpdateServiceList setKey(java.lang.String key) {
          return (UpdateServiceList) super.setKey(key);
        }

        @Override
        public UpdateServiceList setOauthToken(java.lang.String oauthToken) {
          return (UpdateServiceList) super.setOauthToken(oauthToken);
        }

        @Override
        public UpdateServiceList setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (UpdateServiceList) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public UpdateServiceList setQuotaUser(java.lang.String quotaUser) {
          return (UpdateServiceList) super.setQuotaUser(quotaUser);
        }

        @Override
        public UpdateServiceList setUploadType(java.lang.String uploadType) {
          return (UpdateServiceList) super.setUploadType(uploadType);
        }

        @Override
        public UpdateServiceList setUploadProtocol(java.lang.String uploadProtocol) {
          return (UpdateServiceList) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/serviceList`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. Google identifier for this location in the form:
       `accounts/{account_id}/locations/{location_id}/serviceList`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. Google identifier for this location in the form:
         * `accounts/{account_id}/locations/{location_id}/serviceList`
         */
        public UpdateServiceList setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+/serviceList$");
          }
          this.name = name;
          return this;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update and all fields are set to the values passed in, which may include unsetting
         * empty fields in the request. Repeated field items can not be individually updated.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Optional. The specific fields to update. If no mask is specified, then this is treated as a full
       update and all fields are set to the values passed in, which may include unsetting empty fields in
       the request. Repeated field items can not be individually updated.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Optional. The specific fields to update. If no mask is specified, then this is treated as
         * a full update and all fields are set to the values passed in, which may include unsetting
         * empty fields in the request. Repeated field items can not be individually updated.
         */
        public UpdateServiceList setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public UpdateServiceList set(String parameterName, Object value) {
          return (UpdateServiceList) super.set(parameterName, value);
        }
      }
      /**
       * Starts the verification process for a location.
       *
       * Create a request for the method "locations.verify".
       *
       * This request holds the parameters needed by the mybusiness server.  After setting any optional
       * parameters, call the {@link Verify#execute()} method to invoke the remote operation.
       *
       * @param name Resource name of the location to verify.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.VerifyLocationRequest}
       * @return the request
       */
      public Verify verify(java.lang.String name, com.google.api.services.mybusiness.v4.model.VerifyLocationRequest content) throws java.io.IOException {
        Verify result = new Verify(name, content);
        initialize(result);
        return result;
      }

      public class Verify extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.VerifyLocationResponse> {

        private static final String REST_PATH = "v4/{+name}:verify";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

        /**
         * Starts the verification process for a location.
         *
         * Create a request for the method "locations.verify".
         *
         * This request holds the parameters needed by the the mybusiness server.  After setting any
         * optional parameters, call the {@link Verify#execute()} method to invoke the remote operation.
         * <p> {@link
         * Verify#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Resource name of the location to verify.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.VerifyLocationRequest}
         * @since 1.13
         */
        protected Verify(java.lang.String name, com.google.api.services.mybusiness.v4.model.VerifyLocationRequest content) {
          super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.VerifyLocationResponse.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
        }

        @Override
        public Verify set$Xgafv(java.lang.String $Xgafv) {
          return (Verify) super.set$Xgafv($Xgafv);
        }

        @Override
        public Verify setAccessToken(java.lang.String accessToken) {
          return (Verify) super.setAccessToken(accessToken);
        }

        @Override
        public Verify setAlt(java.lang.String alt) {
          return (Verify) super.setAlt(alt);
        }

        @Override
        public Verify setCallback(java.lang.String callback) {
          return (Verify) super.setCallback(callback);
        }

        @Override
        public Verify setFields(java.lang.String fields) {
          return (Verify) super.setFields(fields);
        }

        @Override
        public Verify setKey(java.lang.String key) {
          return (Verify) super.setKey(key);
        }

        @Override
        public Verify setOauthToken(java.lang.String oauthToken) {
          return (Verify) super.setOauthToken(oauthToken);
        }

        @Override
        public Verify setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Verify) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Verify setQuotaUser(java.lang.String quotaUser) {
          return (Verify) super.setQuotaUser(quotaUser);
        }

        @Override
        public Verify setUploadType(java.lang.String uploadType) {
          return (Verify) super.setUploadType(uploadType);
        }

        @Override
        public Verify setUploadProtocol(java.lang.String uploadProtocol) {
          return (Verify) super.setUploadProtocol(uploadProtocol);
        }

        /** Resource name of the location to verify. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Resource name of the location to verify.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Resource name of the location to verify. */
        public Verify setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/locations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Verify set(String parameterName, Object value) {
          return (Verify) super.set(parameterName, value);
        }
      }

      /**
       * An accessor for creating requests from the Admins collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Admins.List request = mybusiness.admins().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Admins admins() {
        return new Admins();
      }

      /**
       * The "admins" collection of methods.
       */
      public class Admins {

        /**
         * Invites the specified user to become an administrator for the specified location. The invitee
         * must accept the invitation in order to be granted access to the location. See AcceptInvitation to
         * programmatically accept an invitation.
         *
         * Create a request for the method "admins.create".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent The resource name of the location this admin is created for.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Admin content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Admin> {

          private static final String REST_PATH = "v4/{+parent}/admins";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Invites the specified user to become an administrator for the specified location. The invitee
           * must accept the invitation in order to be granted access to the location. See AcceptInvitation
           * to programmatically accept an invitation.
           *
           * Create a request for the method "admins.create".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The resource name of the location this admin is created for.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Admin content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Admin.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** The resource name of the location this admin is created for. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The resource name of the location this admin is created for.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The resource name of the location this admin is created for. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Removes the specified admin as a manager of the specified location.
         *
         * Create a request for the method "admins.delete".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the admin to remove from the location.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");

          /**
           * Removes the specified admin as a manager of the specified location.
           *
           * Create a request for the method "admins.delete".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the admin to remove from the location.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The resource name of the admin to remove from the location. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the admin to remove from the location.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The resource name of the admin to remove from the location. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Lists all of the admins for the specified location.
         *
         * Create a request for the method "admins.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location to list admins of.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListLocationAdminsResponse> {

          private static final String REST_PATH = "v4/{+parent}/admins";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Lists all of the admins for the specified location.
           *
           * Create a request for the method "admins.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location to list admins of.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListLocationAdminsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location to list admins of. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location to list admins of.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location to list admins of. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates the Admin for the specified Location Admin. Only the AdminRole of the Admin can be
         * updated.
         *
         * Create a request for the method "admins.patch".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the admin to update.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Admin content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Admin> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");

          /**
           * Updates the Admin for the specified Location Admin. Only the AdminRole of the Admin can be
           * updated.
           *
           * Create a request for the method "admins.patch".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the admin to update.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.Admin}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Admin content) {
            super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Admin.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /** The resource name of the admin to update. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the admin to update.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The resource name of the admin to update. */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Followers collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Followers.List request = mybusiness.followers().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Followers followers() {
        return new Followers();
      }

      /**
       * The "followers" collection of methods.
       */
      public class Followers {

        /**
         * Get the followers settings for a location. NOT_FOUND is returned if either the account or the
         * location doesn't exist. PRECONDITION_FAILED is returned if the location is not verified nor
         * connected to Maps.
         *
         * Create a request for the method "followers.getMetadata".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link GetMetadata#execute()} method to invoke the remote operation.
         *
         * @param name The resource name of the location's followers metadata.
         *        accounts/{account_id}/locations/{location_id}/followers/metadata
         * @return the request
         */
        public GetMetadata getMetadata(java.lang.String name) throws java.io.IOException {
          GetMetadata result = new GetMetadata(name);
          initialize(result);
          return result;
        }

        public class GetMetadata extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.FollowersMetadata> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/followers/metadata$");

          /**
           * Get the followers settings for a location. NOT_FOUND is returned if either the account or the
           * location doesn't exist. PRECONDITION_FAILED is returned if the location is not verified nor
           * connected to Maps.
           *
           * Create a request for the method "followers.getMetadata".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link GetMetadata#execute()} method to invoke the remote
           * operation. <p> {@link
           * GetMetadata#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The resource name of the location's followers metadata.
         *        accounts/{account_id}/locations/{location_id}/followers/metadata
           * @since 1.13
           */
          protected GetMetadata(java.lang.String name) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.FollowersMetadata.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/followers/metadata$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetMetadata set$Xgafv(java.lang.String $Xgafv) {
            return (GetMetadata) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetMetadata setAccessToken(java.lang.String accessToken) {
            return (GetMetadata) super.setAccessToken(accessToken);
          }

          @Override
          public GetMetadata setAlt(java.lang.String alt) {
            return (GetMetadata) super.setAlt(alt);
          }

          @Override
          public GetMetadata setCallback(java.lang.String callback) {
            return (GetMetadata) super.setCallback(callback);
          }

          @Override
          public GetMetadata setFields(java.lang.String fields) {
            return (GetMetadata) super.setFields(fields);
          }

          @Override
          public GetMetadata setKey(java.lang.String key) {
            return (GetMetadata) super.setKey(key);
          }

          @Override
          public GetMetadata setOauthToken(java.lang.String oauthToken) {
            return (GetMetadata) super.setOauthToken(oauthToken);
          }

          @Override
          public GetMetadata setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetMetadata) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetMetadata setQuotaUser(java.lang.String quotaUser) {
            return (GetMetadata) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetMetadata setUploadType(java.lang.String uploadType) {
            return (GetMetadata) super.setUploadType(uploadType);
          }

          @Override
          public GetMetadata setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetMetadata) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * The resource name of the location's followers metadata.
           * accounts/{account_id}/locations/{location_id}/followers/metadata
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The resource name of the location's followers metadata.
         accounts/{account_id}/locations/{location_id}/followers/metadata
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * The resource name of the location's followers metadata.
           * accounts/{account_id}/locations/{location_id}/followers/metadata
           */
          public GetMetadata setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/followers/metadata$");
            }
            this.name = name;
            return this;
          }

          @Override
          public GetMetadata set(String parameterName, Object value) {
            return (GetMetadata) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the InsuranceNetworks collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.InsuranceNetworks.List request = mybusiness.insuranceNetworks().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public InsuranceNetworks insuranceNetworks() {
        return new InsuranceNetworks();
      }

      /**
       * The "insuranceNetworks" collection of methods.
       */
      public class InsuranceNetworks {

        /**
         * Returns a list of all insurance networks supported by Google.
         *
         * Create a request for the method "insuranceNetworks.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Required. The name of the location whose insurance networks will be listed. The name is in the form:
         *        accounts/{account_id}/locations/{location_id}
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListInsuranceNetworksResponse> {

          private static final String REST_PATH = "v4/{+parent}/insuranceNetworks";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Returns a list of all insurance networks supported by Google.
           *
           * Create a request for the method "insuranceNetworks.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Required. The name of the location whose insurance networks will be listed. The name is in the form:
         *        accounts/{account_id}/locations/{location_id}
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListInsuranceNetworksResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. The name of the location whose insurance networks will be listed. The name is
           * in the form: accounts/{account_id}/locations/{location_id}
           */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Required. The name of the location whose insurance networks will be listed. The name is in the
         form: accounts/{account_id}/locations/{location_id}
           */
          public java.lang.String getParent() {
            return parent;
          }

          /**
           * Required. The name of the location whose insurance networks will be listed. The name is
           * in the form: accounts/{account_id}/locations/{location_id}
           */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /**
           * Optional. The BCP 47 code for the language. If a language code is not provided, it
           * defaults to English. Right now only 'en' is supported.
           */
          @com.google.api.client.util.Key
          private java.lang.String languageCode;

          /** Optional. The BCP 47 code for the language. If a language code is not provided, it defaults to
         English. Right now only 'en' is supported.
           */
          public java.lang.String getLanguageCode() {
            return languageCode;
          }

          /**
           * Optional. The BCP 47 code for the language. If a language code is not provided, it
           * defaults to English. Right now only 'en' is supported.
           */
          public List setLanguageCode(java.lang.String languageCode) {
            this.languageCode = languageCode;
            return this;
          }

          /** If specified, returns the next page of insurance networks. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If specified, returns the next page of insurance networks.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** If specified, returns the next page of insurance networks. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * How many insurance networks to return per page. The default value is 5000. Maximum page
           * size is 10000.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** How many insurance networks to return per page. The default value is 5000. Maximum page size is
         10000.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * How many insurance networks to return per page. The default value is 5000. Maximum page
           * size is 10000.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the LocalPosts collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.LocalPosts.List request = mybusiness.localPosts().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public LocalPosts localPosts() {
        return new LocalPosts();
      }

      /**
       * The "localPosts" collection of methods.
       */
      public class LocalPosts {

        /**
         * Creates a new local post associated with the specified location, and returns it.
         *
         * Create a request for the method "localPosts.create".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location in which to create this local post.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.LocalPost}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.LocalPost content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.LocalPost> {

          private static final String REST_PATH = "v4/{+parent}/localPosts";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Creates a new local post associated with the specified location, and returns it.
           *
           * Create a request for the method "localPosts.create".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location in which to create this local post.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.LocalPost}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.LocalPost content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.LocalPost.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location in which to create this local post. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location in which to create this local post.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location in which to create this local post. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a local post. Returns `NOT_FOUND` if the local post does not exist.
         *
         * Create a request for the method "localPosts.delete".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the local post to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");

          /**
           * Deletes a local post. Returns `NOT_FOUND` if the local post does not exist.
           *
           * Create a request for the method "localPosts.delete".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the local post to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the local post to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the local post to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the local post to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Gets the specified local post. Returns `NOT_FOUND` if the local post does not exist.
         *
         * Create a request for the method "localPosts.get".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the local post to fetch.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.LocalPost> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");

          /**
           * Gets the specified local post. Returns `NOT_FOUND` if the local post does not exist.
           *
           * Create a request for the method "localPosts.get".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the local post to fetch.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.LocalPost.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the local post to fetch. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the local post to fetch.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the local post to fetch. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Returns a list of local posts associated with a location.
         *
         * Create a request for the method "localPosts.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location whose local posts will be listed.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListLocalPostsResponse> {

          private static final String REST_PATH = "v4/{+parent}/localPosts";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Returns a list of local posts associated with a location.
           *
           * Create a request for the method "localPosts.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location whose local posts will be listed.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListLocalPostsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location whose local posts will be listed. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location whose local posts will be listed.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location whose local posts will be listed. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** If specified, returns the next page of local posts. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If specified, returns the next page of local posts.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** If specified, returns the next page of local posts. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * How many local posts to return per page. Default of 20. The minimum is 1, and maximum
           * page size is 100.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** How many local posts to return per page. Default of 20. The minimum is 1, and maximum page size is
         100.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * How many local posts to return per page. Default of 20. The minimum is 1, and maximum
           * page size is 100.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates the specified local post and returns the updated local post.
         *
         * Create a request for the method "localPosts.patch".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The name of the local post to update.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.LocalPost}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.LocalPost content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.LocalPost> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");

          /**
           * Updates the specified local post and returns the updated local post.
           *
           * Create a request for the method "localPosts.patch".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the local post to update.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.LocalPost}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.LocalPost content) {
            super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.LocalPost.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the local post to update. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the local post to update.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the local post to update. */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The specific fields to update. You must specify each field that is being updated in the
           * mask.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The specific fields to update. You must specify each field that is being updated in the mask.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * The specific fields to update. You must specify each field that is being updated in the
           * mask.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Returns insights for a set of local posts associated with a single listing. Which metrics and how
         * they are reported are options specified in the request proto. *Note:* Insight reports are limited
         * to 100 `local_post_names` per call.
         *
         * Create a request for the method "localPosts.reportInsights".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link ReportInsights#execute()} method to invoke the remote operation.
         *
         * @param name Required. The name of the location for which to fetch insights.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsRequest}
         * @return the request
         */
        public ReportInsights reportInsights(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsRequest content) throws java.io.IOException {
          ReportInsights result = new ReportInsights(name, content);
          initialize(result);
          return result;
        }

        public class ReportInsights extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsResponse> {

          private static final String REST_PATH = "v4/{+name}/localPosts:reportInsights";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Returns insights for a set of local posts associated with a single listing. Which metrics and
           * how they are reported are options specified in the request proto. *Note:* Insight reports are
           * limited to 100 `local_post_names` per call.
           *
           * Create a request for the method "localPosts.reportInsights".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link ReportInsights#execute()} method to invoke the remote
           * operation. <p> {@link ReportInsights#initialize(com.google.api.client.googleapis.services.Abstr
           * actGoogleClientRequest)} must be called to initialize this instance immediately after invoking
           * the constructor. </p>
           *
           * @param name Required. The name of the location for which to fetch insights.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsRequest}
           * @since 1.13
           */
          protected ReportInsights(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsRequest content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public ReportInsights set$Xgafv(java.lang.String $Xgafv) {
            return (ReportInsights) super.set$Xgafv($Xgafv);
          }

          @Override
          public ReportInsights setAccessToken(java.lang.String accessToken) {
            return (ReportInsights) super.setAccessToken(accessToken);
          }

          @Override
          public ReportInsights setAlt(java.lang.String alt) {
            return (ReportInsights) super.setAlt(alt);
          }

          @Override
          public ReportInsights setCallback(java.lang.String callback) {
            return (ReportInsights) super.setCallback(callback);
          }

          @Override
          public ReportInsights setFields(java.lang.String fields) {
            return (ReportInsights) super.setFields(fields);
          }

          @Override
          public ReportInsights setKey(java.lang.String key) {
            return (ReportInsights) super.setKey(key);
          }

          @Override
          public ReportInsights setOauthToken(java.lang.String oauthToken) {
            return (ReportInsights) super.setOauthToken(oauthToken);
          }

          @Override
          public ReportInsights setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (ReportInsights) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public ReportInsights setQuotaUser(java.lang.String quotaUser) {
            return (ReportInsights) super.setQuotaUser(quotaUser);
          }

          @Override
          public ReportInsights setUploadType(java.lang.String uploadType) {
            return (ReportInsights) super.setUploadType(uploadType);
          }

          @Override
          public ReportInsights setUploadProtocol(java.lang.String uploadProtocol) {
            return (ReportInsights) super.setUploadProtocol(uploadProtocol);
          }

          /** Required. The name of the location for which to fetch insights. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. The name of the location for which to fetch insights.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Required. The name of the location for which to fetch insights. */
          public ReportInsights setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public ReportInsights set(String parameterName, Object value) {
            return (ReportInsights) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Lodging collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Lodging.List request = mybusiness.lodging().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Lodging lodging() {
        return new Lodging();
      }

      /**
       * The "lodging" collection of methods.
       */
      public class Lodging {

        /**
         * Returns the Google updated Lodging of a specific location.
         *
         * Create a request for the method "lodging.getGoogleUpdated".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link GetGoogleUpdated#execute()} method to invoke the remote operation.
         *
         * @param name Required. Google identifier for this location in the form:
         *        `accounts/{account_id}/locations/{location_id}/lodging`
         * @return the request
         */
        public GetGoogleUpdated getGoogleUpdated(java.lang.String name) throws java.io.IOException {
          GetGoogleUpdated result = new GetGoogleUpdated(name);
          initialize(result);
          return result;
        }

        public class GetGoogleUpdated extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.GetGoogleUpdatedLodgingResponse> {

          private static final String REST_PATH = "v4/{+name}:getGoogleUpdated";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/lodging$");

          /**
           * Returns the Google updated Lodging of a specific location.
           *
           * Create a request for the method "lodging.getGoogleUpdated".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link GetGoogleUpdated#execute()} method to invoke the remote
           * operation. <p> {@link GetGoogleUpdated#initialize(com.google.api.client.googleapis.services.Abs
           * tractGoogleClientRequest)} must be called to initialize this instance immediately after
           * invoking the constructor. </p>
           *
           * @param name Required. Google identifier for this location in the form:
         *        `accounts/{account_id}/locations/{location_id}/lodging`
           * @since 1.13
           */
          protected GetGoogleUpdated(java.lang.String name) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.GetGoogleUpdatedLodgingResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/lodging$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public GetGoogleUpdated set$Xgafv(java.lang.String $Xgafv) {
            return (GetGoogleUpdated) super.set$Xgafv($Xgafv);
          }

          @Override
          public GetGoogleUpdated setAccessToken(java.lang.String accessToken) {
            return (GetGoogleUpdated) super.setAccessToken(accessToken);
          }

          @Override
          public GetGoogleUpdated setAlt(java.lang.String alt) {
            return (GetGoogleUpdated) super.setAlt(alt);
          }

          @Override
          public GetGoogleUpdated setCallback(java.lang.String callback) {
            return (GetGoogleUpdated) super.setCallback(callback);
          }

          @Override
          public GetGoogleUpdated setFields(java.lang.String fields) {
            return (GetGoogleUpdated) super.setFields(fields);
          }

          @Override
          public GetGoogleUpdated setKey(java.lang.String key) {
            return (GetGoogleUpdated) super.setKey(key);
          }

          @Override
          public GetGoogleUpdated setOauthToken(java.lang.String oauthToken) {
            return (GetGoogleUpdated) super.setOauthToken(oauthToken);
          }

          @Override
          public GetGoogleUpdated setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (GetGoogleUpdated) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public GetGoogleUpdated setQuotaUser(java.lang.String quotaUser) {
            return (GetGoogleUpdated) super.setQuotaUser(quotaUser);
          }

          @Override
          public GetGoogleUpdated setUploadType(java.lang.String uploadType) {
            return (GetGoogleUpdated) super.setUploadType(uploadType);
          }

          @Override
          public GetGoogleUpdated setUploadProtocol(java.lang.String uploadProtocol) {
            return (GetGoogleUpdated) super.setUploadProtocol(uploadProtocol);
          }

          /**
           * Required. Google identifier for this location in the form:
           * `accounts/{account_id}/locations/{location_id}/lodging`
           */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Required. Google identifier for this location in the form:
         `accounts/{account_id}/locations/{location_id}/lodging`
           */
          public java.lang.String getName() {
            return name;
          }

          /**
           * Required. Google identifier for this location in the form:
           * `accounts/{account_id}/locations/{location_id}/lodging`
           */
          public GetGoogleUpdated setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/lodging$");
            }
            this.name = name;
            return this;
          }

          /**
           * Optional. The specific fields to return. If no mask is specified, then it returns the
           * full Lodging (same as "*"). Repeated field items cannot be individually specified.
           */
          @com.google.api.client.util.Key
          private String readMask;

          /** Optional. The specific fields to return. If no mask is specified, then it returns the full Lodging
         (same as "*"). Repeated field items cannot be individually specified.
           */
          public String getReadMask() {
            return readMask;
          }

          /**
           * Optional. The specific fields to return. If no mask is specified, then it returns the
           * full Lodging (same as "*"). Repeated field items cannot be individually specified.
           */
          public GetGoogleUpdated setReadMask(String readMask) {
            this.readMask = readMask;
            return this;
          }

          @Override
          public GetGoogleUpdated set(String parameterName, Object value) {
            return (GetGoogleUpdated) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Media collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Media.List request = mybusiness.media().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Media media() {
        return new Media();
      }

      /**
       * The "media" collection of methods.
       */
      public class Media {

        /**
         * Creates a new media item for the location.
         *
         * Create a request for the method "media.create".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent The resource name of the location where this media item will be created.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.MediaItem}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.MediaItem content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.MediaItem> {

          private static final String REST_PATH = "v4/{+parent}/media";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Creates a new media item for the location.
           *
           * Create a request for the method "media.create".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The resource name of the location where this media item will be created.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.MediaItem}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.MediaItem content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.MediaItem.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** The resource name of the location where this media item will be created. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The resource name of the location where this media item will be created.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The resource name of the location where this media item will be created. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes the specified media item.
         *
         * Create a request for the method "media.delete".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the media item to be deleted.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/[^/]+$");

          /**
           * Deletes the specified media item.
           *
           * Create a request for the method "media.delete".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the media item to be deleted.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the media item to be deleted. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the media item to be deleted.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the media item to be deleted. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Returns metadata for the requested media item.
         *
         * Create a request for the method "media.get".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the requested media item.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.MediaItem> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/[^/]+$");

          /**
           * Returns metadata for the requested media item.
           *
           * Create a request for the method "media.get".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the requested media item.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.MediaItem.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the requested media item. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the requested media item.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the requested media item. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Returns a list of media items associated with a location.
         *
         * Create a request for the method "media.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location whose media items will be listed.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListMediaItemsResponse> {

          private static final String REST_PATH = "v4/{+parent}/media";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Returns a list of media items associated with a location.
           *
           * Create a request for the method "media.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location whose media items will be listed.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListMediaItemsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location whose media items will be listed. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location whose media items will be listed.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location whose media items will be listed. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** If specified, returns the next page of media items. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If specified, returns the next page of media items.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** If specified, returns the next page of media items. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * How many media items to return per page. The default value is 100, which is also the
           * maximum supported number of media items able to be added to a location with the My
           * Business API. Maximum page size is 2500.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** How many media items to return per page. The default value is 100, which is also the maximum
         supported number of media items able to be added to a location with the My Business API. Maximum
         page size is 2500.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * How many media items to return per page. The default value is 100, which is also the
           * maximum supported number of media items able to be added to a location with the My
           * Business API. Maximum page size is 2500.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates metadata of the specified media item. This can only be used to update the Category of a
         * media item, with the exception that the new category cannot be COVER or PROFILE.
         *
         * Create a request for the method "media.patch".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The name of the media item to be updated.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.MediaItem}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.MediaItem content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.MediaItem> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/[^/]+$");

          /**
           * Updates metadata of the specified media item. This can only be used to update the Category of a
           * media item, with the exception that the new category cannot be COVER or PROFILE.
           *
           * Create a request for the method "media.patch".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the media item to be updated.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.MediaItem}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.MediaItem content) {
            super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.MediaItem.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the media item to be updated. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the media item to be updated.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the media item to be updated. */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
            }
            this.name = name;
            return this;
          }

          /**
           * The specific fields to update. If no mask is specified, then this is treated as a full
           * update and all editable fields are set to the values passed in.
           */
          @com.google.api.client.util.Key
          private String updateMask;

          /** The specific fields to update. If no mask is specified, then this is treated as a full update and
         all editable fields are set to the values passed in.
           */
          public String getUpdateMask() {
            return updateMask;
          }

          /**
           * The specific fields to update. If no mask is specified, then this is treated as a full
           * update and all editable fields are set to the values passed in.
           */
          public Patch setUpdateMask(String updateMask) {
            this.updateMask = updateMask;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }
        /**
         * Generates a `MediaItemDataRef` for media item uploading.
         *
         * Create a request for the method "media.startUpload".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link StartUpload#execute()} method to invoke the remote operation.
         *
         * @param parent The resource name of the location this media item is to be added to.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.StartUploadMediaItemDataRequest}
         * @return the request
         */
        public StartUpload startUpload(java.lang.String parent, com.google.api.services.mybusiness.v4.model.StartUploadMediaItemDataRequest content) throws java.io.IOException {
          StartUpload result = new StartUpload(parent, content);
          initialize(result);
          return result;
        }

        public class StartUpload extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.MediaItemDataRef> {

          private static final String REST_PATH = "v4/{+parent}/media:startUpload";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Generates a `MediaItemDataRef` for media item uploading.
           *
           * Create a request for the method "media.startUpload".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link StartUpload#execute()} method to invoke the remote
           * operation. <p> {@link
           * StartUpload#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The resource name of the location this media item is to be added to.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.StartUploadMediaItemDataRequest}
           * @since 1.13
           */
          protected StartUpload(java.lang.String parent, com.google.api.services.mybusiness.v4.model.StartUploadMediaItemDataRequest content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.MediaItemDataRef.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public StartUpload set$Xgafv(java.lang.String $Xgafv) {
            return (StartUpload) super.set$Xgafv($Xgafv);
          }

          @Override
          public StartUpload setAccessToken(java.lang.String accessToken) {
            return (StartUpload) super.setAccessToken(accessToken);
          }

          @Override
          public StartUpload setAlt(java.lang.String alt) {
            return (StartUpload) super.setAlt(alt);
          }

          @Override
          public StartUpload setCallback(java.lang.String callback) {
            return (StartUpload) super.setCallback(callback);
          }

          @Override
          public StartUpload setFields(java.lang.String fields) {
            return (StartUpload) super.setFields(fields);
          }

          @Override
          public StartUpload setKey(java.lang.String key) {
            return (StartUpload) super.setKey(key);
          }

          @Override
          public StartUpload setOauthToken(java.lang.String oauthToken) {
            return (StartUpload) super.setOauthToken(oauthToken);
          }

          @Override
          public StartUpload setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (StartUpload) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public StartUpload setQuotaUser(java.lang.String quotaUser) {
            return (StartUpload) super.setQuotaUser(quotaUser);
          }

          @Override
          public StartUpload setUploadType(java.lang.String uploadType) {
            return (StartUpload) super.setUploadType(uploadType);
          }

          @Override
          public StartUpload setUploadProtocol(java.lang.String uploadProtocol) {
            return (StartUpload) super.setUploadProtocol(uploadProtocol);
          }

          /** The resource name of the location this media item is to be added to. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The resource name of the location this media item is to be added to.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The resource name of the location this media item is to be added to. */
          public StartUpload setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public StartUpload set(String parameterName, Object value) {
            return (StartUpload) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the Customers collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code MyBusiness mybusiness = new MyBusiness(...);}
         *   {@code MyBusiness.Customers.List request = mybusiness.customers().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Customers customers() {
          return new Customers();
        }

        /**
         * The "customers" collection of methods.
         */
        public class Customers {

          /**
           * Returns metadata for the requested customer media item.
           *
           * Create a request for the method "customers.get".
           *
           * This request holds the parameters needed by the mybusiness server.  After setting any optional
           * parameters, call the {@link Get#execute()} method to invoke the remote operation.
           *
           * @param name The resource name of the requested customer media item.
           * @return the request
           */
          public Get get(java.lang.String name) throws java.io.IOException {
            Get result = new Get(name);
            initialize(result);
            return result;
          }

          public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.MediaItem> {

            private static final String REST_PATH = "v4/{+name}";

            private final java.util.regex.Pattern NAME_PATTERN =
                java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$");

            /**
             * Returns metadata for the requested customer media item.
             *
             * Create a request for the method "customers.get".
             *
             * This request holds the parameters needed by the the mybusiness server.  After setting any
             * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
             * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param name The resource name of the requested customer media item.
             * @since 1.13
             */
            protected Get(java.lang.String name) {
              super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.MediaItem.class);
              this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public Get set$Xgafv(java.lang.String $Xgafv) {
              return (Get) super.set$Xgafv($Xgafv);
            }

            @Override
            public Get setAccessToken(java.lang.String accessToken) {
              return (Get) super.setAccessToken(accessToken);
            }

            @Override
            public Get setAlt(java.lang.String alt) {
              return (Get) super.setAlt(alt);
            }

            @Override
            public Get setCallback(java.lang.String callback) {
              return (Get) super.setCallback(callback);
            }

            @Override
            public Get setFields(java.lang.String fields) {
              return (Get) super.setFields(fields);
            }

            @Override
            public Get setKey(java.lang.String key) {
              return (Get) super.setKey(key);
            }

            @Override
            public Get setOauthToken(java.lang.String oauthToken) {
              return (Get) super.setOauthToken(oauthToken);
            }

            @Override
            public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Get) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Get setQuotaUser(java.lang.String quotaUser) {
              return (Get) super.setQuotaUser(quotaUser);
            }

            @Override
            public Get setUploadType(java.lang.String uploadType) {
              return (Get) super.setUploadType(uploadType);
            }

            @Override
            public Get setUploadProtocol(java.lang.String uploadProtocol) {
              return (Get) super.setUploadProtocol(uploadProtocol);
            }

            /** The resource name of the requested customer media item. */
            @com.google.api.client.util.Key
            private java.lang.String name;

            /** The resource name of the requested customer media item.
             */
            public java.lang.String getName() {
              return name;
            }

            /** The resource name of the requested customer media item. */
            public Get setName(java.lang.String name) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                    "Parameter name must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$");
              }
              this.name = name;
              return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
              return (Get) super.set(parameterName, value);
            }
          }
          /**
           * Returns a list of media items associated with a location that have been contributed by customers.
           *
           * Create a request for the method "customers.list".
           *
           * This request holds the parameters needed by the mybusiness server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the location whose customer media items will be listed.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListCustomerMediaItemsResponse> {

            private static final String REST_PATH = "v4/{+parent}/media/customers";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

            /**
             * Returns a list of media items associated with a location that have been contributed by
             * customers.
             *
             * Create a request for the method "customers.list".
             *
             * This request holds the parameters needed by the the mybusiness server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the location whose customer media items will be listed.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListCustomerMediaItemsResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the location whose customer media items will be listed. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the location whose customer media items will be listed.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the location whose customer media items will be listed. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /** If specified, returns the next page of media items. */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** If specified, returns the next page of media items.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /** If specified, returns the next page of media items. */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            /**
             * How many media items to return per page. The default value is 100, the maximum
             * supported page size is 200.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** How many media items to return per page. The default value is 100, the maximum supported page size
           is 200.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * How many media items to return per page. The default value is 100, the maximum
             * supported page size is 200.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Questions collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Questions.List request = mybusiness.questions().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Questions questions() {
        return new Questions();
      }

      /**
       * The "questions" collection of methods.
       */
      public class Questions {

        /**
         * Adds a question for the specified location.
         *
         * Create a request for the method "questions.create".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Create#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location to write a question for.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Question}
         * @return the request
         */
        public Create create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Question content) throws java.io.IOException {
          Create result = new Create(parent, content);
          initialize(result);
          return result;
        }

        public class Create extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Question> {

          private static final String REST_PATH = "v4/{+parent}/questions";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Adds a question for the specified location.
           *
           * Create a request for the method "questions.create".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Create#execute()} method to invoke the remote operation.
           * <p> {@link
           * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location to write a question for.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.Question}
           * @since 1.13
           */
          protected Create(java.lang.String parent, com.google.api.services.mybusiness.v4.model.Question content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Question.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public Create set$Xgafv(java.lang.String $Xgafv) {
            return (Create) super.set$Xgafv($Xgafv);
          }

          @Override
          public Create setAccessToken(java.lang.String accessToken) {
            return (Create) super.setAccessToken(accessToken);
          }

          @Override
          public Create setAlt(java.lang.String alt) {
            return (Create) super.setAlt(alt);
          }

          @Override
          public Create setCallback(java.lang.String callback) {
            return (Create) super.setCallback(callback);
          }

          @Override
          public Create setFields(java.lang.String fields) {
            return (Create) super.setFields(fields);
          }

          @Override
          public Create setKey(java.lang.String key) {
            return (Create) super.setKey(key);
          }

          @Override
          public Create setOauthToken(java.lang.String oauthToken) {
            return (Create) super.setOauthToken(oauthToken);
          }

          @Override
          public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Create) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Create setQuotaUser(java.lang.String quotaUser) {
            return (Create) super.setQuotaUser(quotaUser);
          }

          @Override
          public Create setUploadType(java.lang.String uploadType) {
            return (Create) super.setUploadType(uploadType);
          }

          @Override
          public Create setUploadProtocol(java.lang.String uploadProtocol) {
            return (Create) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location to write a question for. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location to write a question for.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location to write a question for. */
          public Create setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          @Override
          public Create set(String parameterName, Object value) {
            return (Create) super.set(parameterName, value);
          }
        }
        /**
         * Deletes a specific question written by the current user.
         *
         * Create a request for the method "questions.delete".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
         *
         * @param name The name of the question to delete.
         * @return the request
         */
        public Delete delete(java.lang.String name) throws java.io.IOException {
          Delete result = new Delete(name);
          initialize(result);
          return result;
        }

        public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");

          /**
           * Deletes a specific question written by the current user.
           *
           * Create a request for the method "questions.delete".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the question to delete.
           * @since 1.13
           */
          protected Delete(java.lang.String name) {
            super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
            }
          }

          @Override
          public Delete set$Xgafv(java.lang.String $Xgafv) {
            return (Delete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Delete setAccessToken(java.lang.String accessToken) {
            return (Delete) super.setAccessToken(accessToken);
          }

          @Override
          public Delete setAlt(java.lang.String alt) {
            return (Delete) super.setAlt(alt);
          }

          @Override
          public Delete setCallback(java.lang.String callback) {
            return (Delete) super.setCallback(callback);
          }

          @Override
          public Delete setFields(java.lang.String fields) {
            return (Delete) super.setFields(fields);
          }

          @Override
          public Delete setKey(java.lang.String key) {
            return (Delete) super.setKey(key);
          }

          @Override
          public Delete setOauthToken(java.lang.String oauthToken) {
            return (Delete) super.setOauthToken(oauthToken);
          }

          @Override
          public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Delete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Delete setQuotaUser(java.lang.String quotaUser) {
            return (Delete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Delete setUploadType(java.lang.String uploadType) {
            return (Delete) super.setUploadType(uploadType);
          }

          @Override
          public Delete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Delete) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the question to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the question to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the question to delete. */
          public Delete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Delete set(String parameterName, Object value) {
            return (Delete) super.set(parameterName, value);
          }
        }
        /**
         * Returns the paginated list of questions and some of its answers for a specified location.
         *
         * Create a request for the method "questions.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location to fetch questions for.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListQuestionsResponse> {

          private static final String REST_PATH = "v4/{+parent}/questions";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Returns the paginated list of questions and some of its answers for a specified location.
           *
           * Create a request for the method "questions.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location to fetch questions for.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListQuestionsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location to fetch questions for. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location to fetch questions for.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location to fetch questions for. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** If specified, the next page of questions is retrieved. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If specified, the next page of questions is retrieved.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** If specified, the next page of questions is retrieved. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * How many answers to fetch per question. The default and maximum `answers_per_question`
           * values are 10.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer answersPerQuestion;

          /** How many answers to fetch per question. The default and maximum `answers_per_question` values are
         10.
           */
          public java.lang.Integer getAnswersPerQuestion() {
            return answersPerQuestion;
          }

          /**
           * How many answers to fetch per question. The default and maximum `answers_per_question`
           * values are 10.
           */
          public List setAnswersPerQuestion(java.lang.Integer answersPerQuestion) {
            this.answersPerQuestion = answersPerQuestion;
            return this;
          }

          /**
           * How many questions to fetch per page. The default and maximum `page_size` values are
           * 10.
           */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** How many questions to fetch per page. The default and maximum `page_size` values are 10.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /**
           * How many questions to fetch per page. The default and maximum `page_size` values are
           * 10.
           */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          /**
           * A filter constraining the questions to return. The only filter currently supported is
           * "ignore_answered=true"
           */
          @com.google.api.client.util.Key
          private java.lang.String filter;

          /** A filter constraining the questions to return. The only filter currently supported is
         "ignore_answered=true"
           */
          public java.lang.String getFilter() {
            return filter;
          }

          /**
           * A filter constraining the questions to return. The only filter currently supported is
           * "ignore_answered=true"
           */
          public List setFilter(java.lang.String filter) {
            this.filter = filter;
            return this;
          }

          /**
           * The order to return the questions. Valid options include 'update_time desc' and
           * 'upvote_count desc', which will return the questions sorted descendingly by the
           * requested field. The default sort order is 'update_time desc'.
           */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** The order to return the questions. Valid options include 'update_time desc' and 'upvote_count
         desc', which will return the questions sorted descendingly by the requested field. The default sort
         order is 'update_time desc'.
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /**
           * The order to return the questions. Valid options include 'update_time desc' and
           * 'upvote_count desc', which will return the questions sorted descendingly by the
           * requested field. The default sort order is 'update_time desc'.
           */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates a specific question written by the current user.
         *
         * Create a request for the method "questions.patch".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Patch#execute()} method to invoke the remote operation.
         *
         * @param name The name of the question to update.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.Question}
         * @return the request
         */
        public Patch patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Question content) throws java.io.IOException {
          Patch result = new Patch(name, content);
          initialize(result);
          return result;
        }

        public class Patch extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Question> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");

          /**
           * Updates a specific question written by the current user.
           *
           * Create a request for the method "questions.patch".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Patch#execute()} method to invoke the remote operation.
           * <p> {@link
           * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
           * be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the question to update.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.Question}
           * @since 1.13
           */
          protected Patch(java.lang.String name, com.google.api.services.mybusiness.v4.model.Question content) {
            super(MyBusiness.this, "PATCH", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Question.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
            }
          }

          @Override
          public Patch set$Xgafv(java.lang.String $Xgafv) {
            return (Patch) super.set$Xgafv($Xgafv);
          }

          @Override
          public Patch setAccessToken(java.lang.String accessToken) {
            return (Patch) super.setAccessToken(accessToken);
          }

          @Override
          public Patch setAlt(java.lang.String alt) {
            return (Patch) super.setAlt(alt);
          }

          @Override
          public Patch setCallback(java.lang.String callback) {
            return (Patch) super.setCallback(callback);
          }

          @Override
          public Patch setFields(java.lang.String fields) {
            return (Patch) super.setFields(fields);
          }

          @Override
          public Patch setKey(java.lang.String key) {
            return (Patch) super.setKey(key);
          }

          @Override
          public Patch setOauthToken(java.lang.String oauthToken) {
            return (Patch) super.setOauthToken(oauthToken);
          }

          @Override
          public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Patch) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Patch setQuotaUser(java.lang.String quotaUser) {
            return (Patch) super.setQuotaUser(quotaUser);
          }

          @Override
          public Patch setUploadType(java.lang.String uploadType) {
            return (Patch) super.setUploadType(uploadType);
          }

          @Override
          public Patch setUploadProtocol(java.lang.String uploadProtocol) {
            return (Patch) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the question to update. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the question to update.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the question to update. */
          public Patch setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Patch set(String parameterName, Object value) {
            return (Patch) super.set(parameterName, value);
          }
        }

        /**
         * An accessor for creating requests from the Answers collection.
         *
         * <p>The typical use is:</p>
         * <pre>
         *   {@code MyBusiness mybusiness = new MyBusiness(...);}
         *   {@code MyBusiness.Answers.List request = mybusiness.answers().list(parameters ...)}
         * </pre>
         *
         * @return the resource collection
         */
        public Answers answers() {
          return new Answers();
        }

        /**
         * The "answers" collection of methods.
         */
        public class Answers {

          /**
           * Deletes the answer written by the current user to a question.
           *
           * Create a request for the method "answers.delete".
           *
           * This request holds the parameters needed by the mybusiness server.  After setting any optional
           * parameters, call the {@link Delete#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the question to delete an answer for.
           * @return the request
           */
          public Delete delete(java.lang.String parent) throws java.io.IOException {
            Delete result = new Delete(parent);
            initialize(result);
            return result;
          }

          public class Delete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

            private static final String REST_PATH = "v4/{+parent}/answers:delete";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");

            /**
             * Deletes the answer written by the current user to a question.
             *
             * Create a request for the method "answers.delete".
             *
             * This request holds the parameters needed by the the mybusiness server.  After setting any
             * optional parameters, call the {@link Delete#execute()} method to invoke the remote operation.
             * <p> {@link
             * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the question to delete an answer for.
             * @since 1.13
             */
            protected Delete(java.lang.String parent) {
              super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
              }
            }

            @Override
            public Delete set$Xgafv(java.lang.String $Xgafv) {
              return (Delete) super.set$Xgafv($Xgafv);
            }

            @Override
            public Delete setAccessToken(java.lang.String accessToken) {
              return (Delete) super.setAccessToken(accessToken);
            }

            @Override
            public Delete setAlt(java.lang.String alt) {
              return (Delete) super.setAlt(alt);
            }

            @Override
            public Delete setCallback(java.lang.String callback) {
              return (Delete) super.setCallback(callback);
            }

            @Override
            public Delete setFields(java.lang.String fields) {
              return (Delete) super.setFields(fields);
            }

            @Override
            public Delete setKey(java.lang.String key) {
              return (Delete) super.setKey(key);
            }

            @Override
            public Delete setOauthToken(java.lang.String oauthToken) {
              return (Delete) super.setOauthToken(oauthToken);
            }

            @Override
            public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Delete) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Delete setQuotaUser(java.lang.String quotaUser) {
              return (Delete) super.setQuotaUser(quotaUser);
            }

            @Override
            public Delete setUploadType(java.lang.String uploadType) {
              return (Delete) super.setUploadType(uploadType);
            }

            @Override
            public Delete setUploadProtocol(java.lang.String uploadProtocol) {
              return (Delete) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the question to delete an answer for. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the question to delete an answer for.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the question to delete an answer for. */
            public Delete setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
              return (Delete) super.set(parameterName, value);
            }
          }
          /**
           * Returns the paginated list of answers for a specified question.
           *
           * Create a request for the method "answers.list".
           *
           * This request holds the parameters needed by the mybusiness server.  After setting any optional
           * parameters, call the {@link List#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the question to fetch answers for.
           * @return the request
           */
          public List list(java.lang.String parent) throws java.io.IOException {
            List result = new List(parent);
            initialize(result);
            return result;
          }

          public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListAnswersResponse> {

            private static final String REST_PATH = "v4/{+parent}/answers";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");

            /**
             * Returns the paginated list of answers for a specified question.
             *
             * Create a request for the method "answers.list".
             *
             * This request holds the parameters needed by the the mybusiness server.  After setting any
             * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
             * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
             * must be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the question to fetch answers for.
             * @since 1.13
             */
            protected List(java.lang.String parent) {
              super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListAnswersResponse.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
              }
            }

            @Override
            public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
              return super.executeUsingHead();
            }

            @Override
            public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
              return super.buildHttpRequestUsingHead();
            }

            @Override
            public List set$Xgafv(java.lang.String $Xgafv) {
              return (List) super.set$Xgafv($Xgafv);
            }

            @Override
            public List setAccessToken(java.lang.String accessToken) {
              return (List) super.setAccessToken(accessToken);
            }

            @Override
            public List setAlt(java.lang.String alt) {
              return (List) super.setAlt(alt);
            }

            @Override
            public List setCallback(java.lang.String callback) {
              return (List) super.setCallback(callback);
            }

            @Override
            public List setFields(java.lang.String fields) {
              return (List) super.setFields(fields);
            }

            @Override
            public List setKey(java.lang.String key) {
              return (List) super.setKey(key);
            }

            @Override
            public List setOauthToken(java.lang.String oauthToken) {
              return (List) super.setOauthToken(oauthToken);
            }

            @Override
            public List setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (List) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public List setQuotaUser(java.lang.String quotaUser) {
              return (List) super.setQuotaUser(quotaUser);
            }

            @Override
            public List setUploadType(java.lang.String uploadType) {
              return (List) super.setUploadType(uploadType);
            }

            @Override
            public List setUploadProtocol(java.lang.String uploadProtocol) {
              return (List) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the question to fetch answers for. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the question to fetch answers for.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the question to fetch answers for. */
            public List setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            /** If specified, the next page of answers is retrieved. */
            @com.google.api.client.util.Key
            private java.lang.String pageToken;

            /** If specified, the next page of answers is retrieved.
             */
            public java.lang.String getPageToken() {
              return pageToken;
            }

            /** If specified, the next page of answers is retrieved. */
            public List setPageToken(java.lang.String pageToken) {
              this.pageToken = pageToken;
              return this;
            }

            /**
             * The order to return the answers. Valid options include 'update_time desc' and
             * 'upvote_count desc', which will return the answers sorted descendingly by the
             * requested field. The default sort order is 'update_time desc'.
             */
            @com.google.api.client.util.Key
            private java.lang.String orderBy;

            /** The order to return the answers. Valid options include 'update_time desc' and 'upvote_count desc',
           which will return the answers sorted descendingly by the requested field. The default sort order is
           'update_time desc'.
             */
            public java.lang.String getOrderBy() {
              return orderBy;
            }

            /**
             * The order to return the answers. Valid options include 'update_time desc' and
             * 'upvote_count desc', which will return the answers sorted descendingly by the
             * requested field. The default sort order is 'update_time desc'.
             */
            public List setOrderBy(java.lang.String orderBy) {
              this.orderBy = orderBy;
              return this;
            }

            /**
             * How many answers to fetch per page. The default and maximum `page_size` values are
             * 10.
             */
            @com.google.api.client.util.Key
            private java.lang.Integer pageSize;

            /** How many answers to fetch per page. The default and maximum `page_size` values are 10.
             */
            public java.lang.Integer getPageSize() {
              return pageSize;
            }

            /**
             * How many answers to fetch per page. The default and maximum `page_size` values are
             * 10.
             */
            public List setPageSize(java.lang.Integer pageSize) {
              this.pageSize = pageSize;
              return this;
            }

            @Override
            public List set(String parameterName, Object value) {
              return (List) super.set(parameterName, value);
            }
          }
          /**
           * Creates an answer or updates the existing answer written by the user for the specified question.
           * A user can only create one answer per question.
           *
           * Create a request for the method "answers.upsert".
           *
           * This request holds the parameters needed by the mybusiness server.  After setting any optional
           * parameters, call the {@link Upsert#execute()} method to invoke the remote operation.
           *
           * @param parent The name of the question to write an answer for.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.UpsertAnswerRequest}
           * @return the request
           */
          public Upsert upsert(java.lang.String parent, com.google.api.services.mybusiness.v4.model.UpsertAnswerRequest content) throws java.io.IOException {
            Upsert result = new Upsert(parent, content);
            initialize(result);
            return result;
          }

          public class Upsert extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Answer> {

            private static final String REST_PATH = "v4/{+parent}/answers:upsert";

            private final java.util.regex.Pattern PARENT_PATTERN =
                java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");

            /**
             * Creates an answer or updates the existing answer written by the user for the specified
             * question. A user can only create one answer per question.
             *
             * Create a request for the method "answers.upsert".
             *
             * This request holds the parameters needed by the the mybusiness server.  After setting any
             * optional parameters, call the {@link Upsert#execute()} method to invoke the remote operation.
             * <p> {@link
             * Upsert#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
             * be called to initialize this instance immediately after invoking the constructor. </p>
             *
             * @param parent The name of the question to write an answer for.
             * @param content the {@link com.google.api.services.mybusiness.v4.model.UpsertAnswerRequest}
             * @since 1.13
             */
            protected Upsert(java.lang.String parent, com.google.api.services.mybusiness.v4.model.UpsertAnswerRequest content) {
              super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Answer.class);
              this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
              }
            }

            @Override
            public Upsert set$Xgafv(java.lang.String $Xgafv) {
              return (Upsert) super.set$Xgafv($Xgafv);
            }

            @Override
            public Upsert setAccessToken(java.lang.String accessToken) {
              return (Upsert) super.setAccessToken(accessToken);
            }

            @Override
            public Upsert setAlt(java.lang.String alt) {
              return (Upsert) super.setAlt(alt);
            }

            @Override
            public Upsert setCallback(java.lang.String callback) {
              return (Upsert) super.setCallback(callback);
            }

            @Override
            public Upsert setFields(java.lang.String fields) {
              return (Upsert) super.setFields(fields);
            }

            @Override
            public Upsert setKey(java.lang.String key) {
              return (Upsert) super.setKey(key);
            }

            @Override
            public Upsert setOauthToken(java.lang.String oauthToken) {
              return (Upsert) super.setOauthToken(oauthToken);
            }

            @Override
            public Upsert setPrettyPrint(java.lang.Boolean prettyPrint) {
              return (Upsert) super.setPrettyPrint(prettyPrint);
            }

            @Override
            public Upsert setQuotaUser(java.lang.String quotaUser) {
              return (Upsert) super.setQuotaUser(quotaUser);
            }

            @Override
            public Upsert setUploadType(java.lang.String uploadType) {
              return (Upsert) super.setUploadType(uploadType);
            }

            @Override
            public Upsert setUploadProtocol(java.lang.String uploadProtocol) {
              return (Upsert) super.setUploadProtocol(uploadProtocol);
            }

            /** The name of the question to write an answer for. */
            @com.google.api.client.util.Key
            private java.lang.String parent;

            /** The name of the question to write an answer for.
             */
            public java.lang.String getParent() {
              return parent;
            }

            /** The name of the question to write an answer for. */
            public Upsert setParent(java.lang.String parent) {
              if (!getSuppressPatternChecks()) {
                com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                    "Parameter parent must conform to the pattern " +
                    "^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
              }
              this.parent = parent;
              return this;
            }

            @Override
            public Upsert set(String parameterName, Object value) {
              return (Upsert) super.set(parameterName, value);
            }
          }

        }
      }
      /**
       * An accessor for creating requests from the Reviews collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Reviews.List request = mybusiness.reviews().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Reviews reviews() {
        return new Reviews();
      }

      /**
       * The "reviews" collection of methods.
       */
      public class Reviews {

        /**
         * Deletes the response to the specified review. This operation is only valid if the specified
         * location is verified.
         *
         * Create a request for the method "reviews.deleteReply".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link DeleteReply#execute()} method to invoke the remote operation.
         *
         * @param name The name of the review reply to delete.
         * @return the request
         */
        public DeleteReply deleteReply(java.lang.String name) throws java.io.IOException {
          DeleteReply result = new DeleteReply(name);
          initialize(result);
          return result;
        }

        public class DeleteReply extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

          private static final String REST_PATH = "v4/{+name}/reply";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");

          /**
           * Deletes the response to the specified review. This operation is only valid if the specified
           * location is verified.
           *
           * Create a request for the method "reviews.deleteReply".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link DeleteReply#execute()} method to invoke the remote
           * operation. <p> {@link
           * DeleteReply#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the review reply to delete.
           * @since 1.13
           */
          protected DeleteReply(java.lang.String name) {
            super(MyBusiness.this, "DELETE", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Empty.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
            }
          }

          @Override
          public DeleteReply set$Xgafv(java.lang.String $Xgafv) {
            return (DeleteReply) super.set$Xgafv($Xgafv);
          }

          @Override
          public DeleteReply setAccessToken(java.lang.String accessToken) {
            return (DeleteReply) super.setAccessToken(accessToken);
          }

          @Override
          public DeleteReply setAlt(java.lang.String alt) {
            return (DeleteReply) super.setAlt(alt);
          }

          @Override
          public DeleteReply setCallback(java.lang.String callback) {
            return (DeleteReply) super.setCallback(callback);
          }

          @Override
          public DeleteReply setFields(java.lang.String fields) {
            return (DeleteReply) super.setFields(fields);
          }

          @Override
          public DeleteReply setKey(java.lang.String key) {
            return (DeleteReply) super.setKey(key);
          }

          @Override
          public DeleteReply setOauthToken(java.lang.String oauthToken) {
            return (DeleteReply) super.setOauthToken(oauthToken);
          }

          @Override
          public DeleteReply setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (DeleteReply) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public DeleteReply setQuotaUser(java.lang.String quotaUser) {
            return (DeleteReply) super.setQuotaUser(quotaUser);
          }

          @Override
          public DeleteReply setUploadType(java.lang.String uploadType) {
            return (DeleteReply) super.setUploadType(uploadType);
          }

          @Override
          public DeleteReply setUploadProtocol(java.lang.String uploadProtocol) {
            return (DeleteReply) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the review reply to delete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the review reply to delete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the review reply to delete. */
          public DeleteReply setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public DeleteReply set(String parameterName, Object value) {
            return (DeleteReply) super.set(parameterName, value);
          }
        }
        /**
         * Returns the specified review. This operation is only valid if the specified location is verified.
         * Returns `NOT_FOUND` if the review does not exist, or has been deleted.
         *
         * Create a request for the method "reviews.get".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Get#execute()} method to invoke the remote operation.
         *
         * @param name The name of the review to fetch.
         * @return the request
         */
        public Get get(java.lang.String name) throws java.io.IOException {
          Get result = new Get(name);
          initialize(result);
          return result;
        }

        public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Review> {

          private static final String REST_PATH = "v4/{+name}";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");

          /**
           * Returns the specified review. This operation is only valid if the specified location is
           * verified. Returns `NOT_FOUND` if the review does not exist, or has been deleted.
           *
           * Create a request for the method "reviews.get".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
           * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the review to fetch.
           * @since 1.13
           */
          protected Get(java.lang.String name) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Review.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public Get set$Xgafv(java.lang.String $Xgafv) {
            return (Get) super.set$Xgafv($Xgafv);
          }

          @Override
          public Get setAccessToken(java.lang.String accessToken) {
            return (Get) super.setAccessToken(accessToken);
          }

          @Override
          public Get setAlt(java.lang.String alt) {
            return (Get) super.setAlt(alt);
          }

          @Override
          public Get setCallback(java.lang.String callback) {
            return (Get) super.setCallback(callback);
          }

          @Override
          public Get setFields(java.lang.String fields) {
            return (Get) super.setFields(fields);
          }

          @Override
          public Get setKey(java.lang.String key) {
            return (Get) super.setKey(key);
          }

          @Override
          public Get setOauthToken(java.lang.String oauthToken) {
            return (Get) super.setOauthToken(oauthToken);
          }

          @Override
          public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Get) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Get setQuotaUser(java.lang.String quotaUser) {
            return (Get) super.setQuotaUser(quotaUser);
          }

          @Override
          public Get setUploadType(java.lang.String uploadType) {
            return (Get) super.setUploadType(uploadType);
          }

          @Override
          public Get setUploadProtocol(java.lang.String uploadProtocol) {
            return (Get) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the review to fetch. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the review to fetch.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the review to fetch. */
          public Get setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Get set(String parameterName, Object value) {
            return (Get) super.set(parameterName, value);
          }
        }
        /**
         * Returns the paginated list of reviews for the specified location. This operation is only valid if
         * the specified location is verified.
         *
         * Create a request for the method "reviews.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent The name of the location to fetch reviews for.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListReviewsResponse> {

          private static final String REST_PATH = "v4/{+parent}/reviews";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * Returns the paginated list of reviews for the specified location. This operation is only valid
           * if the specified location is verified.
           *
           * Create a request for the method "reviews.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent The name of the location to fetch reviews for.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListReviewsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the location to fetch reviews for. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** The name of the location to fetch reviews for.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** The name of the location to fetch reviews for. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** If specified, it fetches the next page of reviews. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If specified, it fetches the next page of reviews.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** If specified, it fetches the next page of reviews. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /**
           * Specifies the field to sort reviews by. If unspecified, the order of reviews returned
           * will default to `update_time desc`. Valid orders to sort by are `rating`, `rating desc`
           * and `update_time desc`.
           */
          @com.google.api.client.util.Key
          private java.lang.String orderBy;

          /** Specifies the field to sort reviews by. If unspecified, the order of reviews returned will default
         to `update_time desc`. Valid orders to sort by are `rating`, `rating desc` and `update_time desc`.
           */
          public java.lang.String getOrderBy() {
            return orderBy;
          }

          /**
           * Specifies the field to sort reviews by. If unspecified, the order of reviews returned
           * will default to `update_time desc`. Valid orders to sort by are `rating`, `rating desc`
           * and `update_time desc`.
           */
          public List setOrderBy(java.lang.String orderBy) {
            this.orderBy = orderBy;
            return this;
          }

          /** How many reviews to fetch per page. The maximum `page_size` is 50. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** How many reviews to fetch per page. The maximum `page_size` is 50.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** How many reviews to fetch per page. The maximum `page_size` is 50. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }
        /**
         * Updates the reply to the specified review. A reply is created if one does not exist. This
         * operation is only valid if the specified location is verified.
         *
         * Create a request for the method "reviews.updateReply".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link UpdateReply#execute()} method to invoke the remote operation.
         *
         * @param name The name of the review to respond to.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.ReviewReply}
         * @return the request
         */
        public UpdateReply updateReply(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReviewReply content) throws java.io.IOException {
          UpdateReply result = new UpdateReply(name, content);
          initialize(result);
          return result;
        }

        public class UpdateReply extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ReviewReply> {

          private static final String REST_PATH = "v4/{+name}/reply";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");

          /**
           * Updates the reply to the specified review. A reply is created if one does not exist. This
           * operation is only valid if the specified location is verified.
           *
           * Create a request for the method "reviews.updateReply".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link UpdateReply#execute()} method to invoke the remote
           * operation. <p> {@link
           * UpdateReply#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name The name of the review to respond to.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.ReviewReply}
           * @since 1.13
           */
          protected UpdateReply(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReviewReply content) {
            super(MyBusiness.this, "PUT", REST_PATH, content, com.google.api.services.mybusiness.v4.model.ReviewReply.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
            }
          }

          @Override
          public UpdateReply set$Xgafv(java.lang.String $Xgafv) {
            return (UpdateReply) super.set$Xgafv($Xgafv);
          }

          @Override
          public UpdateReply setAccessToken(java.lang.String accessToken) {
            return (UpdateReply) super.setAccessToken(accessToken);
          }

          @Override
          public UpdateReply setAlt(java.lang.String alt) {
            return (UpdateReply) super.setAlt(alt);
          }

          @Override
          public UpdateReply setCallback(java.lang.String callback) {
            return (UpdateReply) super.setCallback(callback);
          }

          @Override
          public UpdateReply setFields(java.lang.String fields) {
            return (UpdateReply) super.setFields(fields);
          }

          @Override
          public UpdateReply setKey(java.lang.String key) {
            return (UpdateReply) super.setKey(key);
          }

          @Override
          public UpdateReply setOauthToken(java.lang.String oauthToken) {
            return (UpdateReply) super.setOauthToken(oauthToken);
          }

          @Override
          public UpdateReply setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (UpdateReply) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public UpdateReply setQuotaUser(java.lang.String quotaUser) {
            return (UpdateReply) super.setQuotaUser(quotaUser);
          }

          @Override
          public UpdateReply setUploadType(java.lang.String uploadType) {
            return (UpdateReply) super.setUploadType(uploadType);
          }

          @Override
          public UpdateReply setUploadProtocol(java.lang.String uploadProtocol) {
            return (UpdateReply) super.setUploadProtocol(uploadProtocol);
          }

          /** The name of the review to respond to. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** The name of the review to respond to.
           */
          public java.lang.String getName() {
            return name;
          }

          /** The name of the review to respond to. */
          public UpdateReply setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public UpdateReply set(String parameterName, Object value) {
            return (UpdateReply) super.set(parameterName, value);
          }
        }

      }
      /**
       * An accessor for creating requests from the Verifications collection.
       *
       * <p>The typical use is:</p>
       * <pre>
       *   {@code MyBusiness mybusiness = new MyBusiness(...);}
       *   {@code MyBusiness.Verifications.List request = mybusiness.verifications().list(parameters ...)}
       * </pre>
       *
       * @return the resource collection
       */
      public Verifications verifications() {
        return new Verifications();
      }

      /**
       * The "verifications" collection of methods.
       */
      public class Verifications {

        /**
         * Completes a `PENDING` verification. It is only necessary for non `AUTO` verification methods.
         * `AUTO` verification request is instantly `VERIFIED` upon creation.
         *
         * Create a request for the method "verifications.complete".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link Complete#execute()} method to invoke the remote operation.
         *
         * @param name Resource name of the verification to complete.
         * @param content the {@link com.google.api.services.mybusiness.v4.model.CompleteVerificationRequest}
         * @return the request
         */
        public Complete complete(java.lang.String name, com.google.api.services.mybusiness.v4.model.CompleteVerificationRequest content) throws java.io.IOException {
          Complete result = new Complete(name, content);
          initialize(result);
          return result;
        }

        public class Complete extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.CompleteVerificationResponse> {

          private static final String REST_PATH = "v4/{+name}:complete";

          private final java.util.regex.Pattern NAME_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$");

          /**
           * Completes a `PENDING` verification. It is only necessary for non `AUTO` verification methods.
           * `AUTO` verification request is instantly `VERIFIED` upon creation.
           *
           * Create a request for the method "verifications.complete".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link Complete#execute()} method to invoke the remote operation.
           * <p> {@link
           * Complete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param name Resource name of the verification to complete.
           * @param content the {@link com.google.api.services.mybusiness.v4.model.CompleteVerificationRequest}
           * @since 1.13
           */
          protected Complete(java.lang.String name, com.google.api.services.mybusiness.v4.model.CompleteVerificationRequest content) {
            super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.CompleteVerificationResponse.class);
            this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$");
            }
          }

          @Override
          public Complete set$Xgafv(java.lang.String $Xgafv) {
            return (Complete) super.set$Xgafv($Xgafv);
          }

          @Override
          public Complete setAccessToken(java.lang.String accessToken) {
            return (Complete) super.setAccessToken(accessToken);
          }

          @Override
          public Complete setAlt(java.lang.String alt) {
            return (Complete) super.setAlt(alt);
          }

          @Override
          public Complete setCallback(java.lang.String callback) {
            return (Complete) super.setCallback(callback);
          }

          @Override
          public Complete setFields(java.lang.String fields) {
            return (Complete) super.setFields(fields);
          }

          @Override
          public Complete setKey(java.lang.String key) {
            return (Complete) super.setKey(key);
          }

          @Override
          public Complete setOauthToken(java.lang.String oauthToken) {
            return (Complete) super.setOauthToken(oauthToken);
          }

          @Override
          public Complete setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (Complete) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public Complete setQuotaUser(java.lang.String quotaUser) {
            return (Complete) super.setQuotaUser(quotaUser);
          }

          @Override
          public Complete setUploadType(java.lang.String uploadType) {
            return (Complete) super.setUploadType(uploadType);
          }

          @Override
          public Complete setUploadProtocol(java.lang.String uploadProtocol) {
            return (Complete) super.setUploadProtocol(uploadProtocol);
          }

          /** Resource name of the verification to complete. */
          @com.google.api.client.util.Key
          private java.lang.String name;

          /** Resource name of the verification to complete.
           */
          public java.lang.String getName() {
            return name;
          }

          /** Resource name of the verification to complete. */
          public Complete setName(java.lang.String name) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                  "Parameter name must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$");
            }
            this.name = name;
            return this;
          }

          @Override
          public Complete set(String parameterName, Object value) {
            return (Complete) super.set(parameterName, value);
          }
        }
        /**
         * List verifications of a location, ordered by create time.
         *
         * Create a request for the method "verifications.list".
         *
         * This request holds the parameters needed by the mybusiness server.  After setting any optional
         * parameters, call the {@link List#execute()} method to invoke the remote operation.
         *
         * @param parent Resource name of the location that verification requests belong to.
         * @return the request
         */
        public List list(java.lang.String parent) throws java.io.IOException {
          List result = new List(parent);
          initialize(result);
          return result;
        }

        public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListVerificationsResponse> {

          private static final String REST_PATH = "v4/{+parent}/verifications";

          private final java.util.regex.Pattern PARENT_PATTERN =
              java.util.regex.Pattern.compile("^accounts/[^/]+/locations/[^/]+$");

          /**
           * List verifications of a location, ordered by create time.
           *
           * Create a request for the method "verifications.list".
           *
           * This request holds the parameters needed by the the mybusiness server.  After setting any
           * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
           * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
           * must be called to initialize this instance immediately after invoking the constructor. </p>
           *
           * @param parent Resource name of the location that verification requests belong to.
           * @since 1.13
           */
          protected List(java.lang.String parent) {
            super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListVerificationsResponse.class);
            this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
          }

          @Override
          public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
            return super.executeUsingHead();
          }

          @Override
          public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
            return super.buildHttpRequestUsingHead();
          }

          @Override
          public List set$Xgafv(java.lang.String $Xgafv) {
            return (List) super.set$Xgafv($Xgafv);
          }

          @Override
          public List setAccessToken(java.lang.String accessToken) {
            return (List) super.setAccessToken(accessToken);
          }

          @Override
          public List setAlt(java.lang.String alt) {
            return (List) super.setAlt(alt);
          }

          @Override
          public List setCallback(java.lang.String callback) {
            return (List) super.setCallback(callback);
          }

          @Override
          public List setFields(java.lang.String fields) {
            return (List) super.setFields(fields);
          }

          @Override
          public List setKey(java.lang.String key) {
            return (List) super.setKey(key);
          }

          @Override
          public List setOauthToken(java.lang.String oauthToken) {
            return (List) super.setOauthToken(oauthToken);
          }

          @Override
          public List setPrettyPrint(java.lang.Boolean prettyPrint) {
            return (List) super.setPrettyPrint(prettyPrint);
          }

          @Override
          public List setQuotaUser(java.lang.String quotaUser) {
            return (List) super.setQuotaUser(quotaUser);
          }

          @Override
          public List setUploadType(java.lang.String uploadType) {
            return (List) super.setUploadType(uploadType);
          }

          @Override
          public List setUploadProtocol(java.lang.String uploadProtocol) {
            return (List) super.setUploadProtocol(uploadProtocol);
          }

          /** Resource name of the location that verification requests belong to. */
          @com.google.api.client.util.Key
          private java.lang.String parent;

          /** Resource name of the location that verification requests belong to.
           */
          public java.lang.String getParent() {
            return parent;
          }

          /** Resource name of the location that verification requests belong to. */
          public List setParent(java.lang.String parent) {
            if (!getSuppressPatternChecks()) {
              com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                  "Parameter parent must conform to the pattern " +
                  "^accounts/[^/]+/locations/[^/]+$");
            }
            this.parent = parent;
            return this;
          }

          /** If specified, returns the next page of verifications. */
          @com.google.api.client.util.Key
          private java.lang.String pageToken;

          /** If specified, returns the next page of verifications.
           */
          public java.lang.String getPageToken() {
            return pageToken;
          }

          /** If specified, returns the next page of verifications. */
          public List setPageToken(java.lang.String pageToken) {
            this.pageToken = pageToken;
            return this;
          }

          /** How many verification to include per page. If not set, return all. */
          @com.google.api.client.util.Key
          private java.lang.Integer pageSize;

          /** How many verification to include per page. If not set, return all.
           */
          public java.lang.Integer getPageSize() {
            return pageSize;
          }

          /** How many verification to include per page. If not set, return all. */
          public List setPageSize(java.lang.Integer pageSize) {
            this.pageSize = pageSize;
            return this;
          }

          @Override
          public List set(String parameterName, Object value) {
            return (List) super.set(parameterName, value);
          }
        }

      }
    }
  }

  /**
   * An accessor for creating requests from the Attributes collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusiness mybusiness = new MyBusiness(...);}
   *   {@code MyBusiness.Attributes.List request = mybusiness.attributes().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Attributes attributes() {
    return new Attributes();
  }

  /**
   * The "attributes" collection of methods.
   */
  public class Attributes {

    /**
     * Returns the list of available attributes that would be available for a location with the given
     * primary category and country.
     *
     * Create a request for the method "attributes.list".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListAttributeMetadataResponse> {

      private static final String REST_PATH = "v4/attributes";

      /**
       * Returns the list of available attributes that would be available for a location with the given
       * primary category and country.
       *
       * Create a request for the method "attributes.list".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListAttributeMetadataResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The BCP 47 code of language to get attribute display names in. If this language is not
       * available, they will be provided in English.
       */
      @com.google.api.client.util.Key
      private java.lang.String languageCode;

      /** The BCP 47 code of language to get attribute display names in. If this language is not available,
     they will be provided in English.
       */
      public java.lang.String getLanguageCode() {
        return languageCode;
      }

      /**
       * The BCP 47 code of language to get attribute display names in. If this language is not
       * available, they will be provided in English.
       */
      public List setLanguageCode(java.lang.String languageCode) {
        this.languageCode = languageCode;
        return this;
      }

      /**
       * If specified, the next page of attribute metadata is retrieved. The `pageToken` is returned
       * when a call to `attributes.list` returns more results than can fit into the requested page
       * size.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** If specified, the next page of attribute metadata is retrieved. The `pageToken` is returned when a
     call to `attributes.list` returns more results than can fit into the requested page size.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * If specified, the next page of attribute metadata is retrieved. The `pageToken` is returned
       * when a call to `attributes.list` returns more results than can fit into the requested page
       * size.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The ISO 3166-1 alpha-2 country code to find available attributes. */
      @com.google.api.client.util.Key
      private java.lang.String country;

      /** The ISO 3166-1 alpha-2 country code to find available attributes.
       */
      public java.lang.String getCountry() {
        return country;
      }

      /** The ISO 3166-1 alpha-2 country code to find available attributes. */
      public List setCountry(java.lang.String country) {
        this.country = country;
        return this;
      }

      /** How many attributes to include per page. Default is 200, minimum is 1. */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** How many attributes to include per page. Default is 200, minimum is 1.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /** How many attributes to include per page. Default is 200, minimum is 1. */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /** The primary category stable ID to find available attributes. */
      @com.google.api.client.util.Key
      private java.lang.String categoryId;

      /** The primary category stable ID to find available attributes.
       */
      public java.lang.String getCategoryId() {
        return categoryId;
      }

      /** The primary category stable ID to find available attributes. */
      public List setCategoryId(java.lang.String categoryId) {
        this.categoryId = categoryId;
        return this;
      }

      /** Resource name of the location to look up available attributes. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Resource name of the location to look up available attributes.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Resource name of the location to look up available attributes. */
      public List setName(java.lang.String name) {
        this.name = name;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Categories collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusiness mybusiness = new MyBusiness(...);}
   *   {@code MyBusiness.Categories.List request = mybusiness.categories().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Categories categories() {
    return new Categories();
  }

  /**
   * The "categories" collection of methods.
   */
  public class Categories {

    /**
     * Returns a list of business categories for the provided language and GConcept ids.
     *
     * Create a request for the method "categories.batchGet".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public BatchGet batchGet() throws java.io.IOException {
      BatchGet result = new BatchGet();
      initialize(result);
      return result;
    }

    public class BatchGet extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.BatchGetBusinessCategoriesResponse> {

      private static final String REST_PATH = "v4/categories:batchGet";

      /**
       * Returns a list of business categories for the provided language and GConcept ids.
       *
       * Create a request for the method "categories.batchGet".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link BatchGet#execute()} method to invoke the remote operation.
       * <p> {@link
       * BatchGet#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected BatchGet() {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.BatchGetBusinessCategoriesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public BatchGet set$Xgafv(java.lang.String $Xgafv) {
        return (BatchGet) super.set$Xgafv($Xgafv);
      }

      @Override
      public BatchGet setAccessToken(java.lang.String accessToken) {
        return (BatchGet) super.setAccessToken(accessToken);
      }

      @Override
      public BatchGet setAlt(java.lang.String alt) {
        return (BatchGet) super.setAlt(alt);
      }

      @Override
      public BatchGet setCallback(java.lang.String callback) {
        return (BatchGet) super.setCallback(callback);
      }

      @Override
      public BatchGet setFields(java.lang.String fields) {
        return (BatchGet) super.setFields(fields);
      }

      @Override
      public BatchGet setKey(java.lang.String key) {
        return (BatchGet) super.setKey(key);
      }

      @Override
      public BatchGet setOauthToken(java.lang.String oauthToken) {
        return (BatchGet) super.setOauthToken(oauthToken);
      }

      @Override
      public BatchGet setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (BatchGet) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public BatchGet setQuotaUser(java.lang.String quotaUser) {
        return (BatchGet) super.setQuotaUser(quotaUser);
      }

      @Override
      public BatchGet setUploadType(java.lang.String uploadType) {
        return (BatchGet) super.setUploadType(uploadType);
      }

      @Override
      public BatchGet setUploadProtocol(java.lang.String uploadProtocol) {
        return (BatchGet) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The BCP 47 code of language that the category names should be returned in. */
      @com.google.api.client.util.Key
      private java.lang.String languageCode;

      /** Required. The BCP 47 code of language that the category names should be returned in.
       */
      public java.lang.String getLanguageCode() {
        return languageCode;
      }

      /** Required. The BCP 47 code of language that the category names should be returned in. */
      public BatchGet setLanguageCode(java.lang.String languageCode) {
        this.languageCode = languageCode;
        return this;
      }

      /**
       * Required. Specifies which parts to the Category resource should be returned in the
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String view;

      /** Required. Specifies which parts to the Category resource should be returned in the response.
       */
      public java.lang.String getView() {
        return view;
      }

      /**
       * Required. Specifies which parts to the Category resource should be returned in the
       * response.
       */
      public BatchGet setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      /** Optional. The ISO 3166-1 alpha-2 country code used to infer non-standard language. */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** Optional. The ISO 3166-1 alpha-2 country code used to infer non-standard language.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /** Optional. The ISO 3166-1 alpha-2 country code used to infer non-standard language. */
      public BatchGet setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * Required. At least one name must be set. The GConcept ids the localized category names
       * should be returned for.
       */
      @com.google.api.client.util.Key
      private java.util.List<java.lang.String> categoryIds;

      /** Required. At least one name must be set. The GConcept ids the localized category names should be
     returned for.
       */
      public java.util.List<java.lang.String> getCategoryIds() {
        return categoryIds;
      }

      /**
       * Required. At least one name must be set. The GConcept ids the localized category names
       * should be returned for.
       */
      public BatchGet setCategoryIds(java.util.List<java.lang.String> categoryIds) {
        this.categoryIds = categoryIds;
        return this;
      }

      @Override
      public BatchGet set(String parameterName, Object value) {
        return (BatchGet) super.set(parameterName, value);
      }
    }
    /**
     * Returns a list of business categories. Search will match the category name but not the category
     * ID. *Note:* Search only matches the front of a category name (that is, 'food' may return 'Food
     * Court' but not 'Fast Food Restaurant').
     *
     * Create a request for the method "categories.list".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link List#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.ListBusinessCategoriesResponse> {

      private static final String REST_PATH = "v4/categories";

      /**
       * Returns a list of business categories. Search will match the category name but not the category
       * ID. *Note:* Search only matches the front of a category name (that is, 'food' may return 'Food
       * Court' but not 'Fast Food Restaurant').
       *
       * Create a request for the method "categories.list".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link List#execute()} method to invoke the remote operation. <p>
       * {@link List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.ListBusinessCategoriesResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /** Optional filter string from user. */
      @com.google.api.client.util.Key
      private java.lang.String searchTerm;

      /** Optional filter string from user.
       */
      public java.lang.String getSearchTerm() {
        return searchTerm;
      }

      /** Optional filter string from user. */
      public List setSearchTerm(java.lang.String searchTerm) {
        this.searchTerm = searchTerm;
        return this;
      }

      /**
       * The BCP 47 code of language. If the language is not available, it will default to English.
       */
      @com.google.api.client.util.Key
      private java.lang.String languageCode;

      /** The BCP 47 code of language. If the language is not available, it will default to English.
       */
      public java.lang.String getLanguageCode() {
        return languageCode;
      }

      /**
       * The BCP 47 code of language. If the language is not available, it will default to English.
       */
      public List setLanguageCode(java.lang.String languageCode) {
        this.languageCode = languageCode;
        return this;
      }

      /** If specified, the next page of categories will be fetched. */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** If specified, the next page of categories will be fetched.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /** If specified, the next page of categories will be fetched. */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /** The ISO 3166-1 alpha-2 country code. */
      @com.google.api.client.util.Key
      private java.lang.String regionCode;

      /** The ISO 3166-1 alpha-2 country code.
       */
      public java.lang.String getRegionCode() {
        return regionCode;
      }

      /** The ISO 3166-1 alpha-2 country code. */
      public List setRegionCode(java.lang.String regionCode) {
        this.regionCode = regionCode;
        return this;
      }

      /**
       * How many categories to fetch per page. Default is 100, minimum is 1, and maximum page size
       * is 100.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** How many categories to fetch per page. Default is 100, minimum is 1, and maximum page size is 100.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * How many categories to fetch per page. Default is 100, minimum is 1, and maximum page size
       * is 100.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. Specifies which parts to the Category resource should be returned in the
       * response.
       */
      @com.google.api.client.util.Key
      private java.lang.String view;

      /** Optional. Specifies which parts to the Category resource should be returned in the response.
       */
      public java.lang.String getView() {
        return view;
      }

      /**
       * Optional. Specifies which parts to the Category resource should be returned in the
       * response.
       */
      public List setView(java.lang.String view) {
        this.view = view;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the Chains collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusiness mybusiness = new MyBusiness(...);}
   *   {@code MyBusiness.Chains.List request = mybusiness.chains().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Chains chains() {
    return new Chains();
  }

  /**
   * The "chains" collection of methods.
   */
  public class Chains {

    /**
     * Gets the specified chain. Returns `NOT_FOUND` if the chain does not exist.
     *
     * Create a request for the method "chains.get".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Get#execute()} method to invoke the remote operation.
     *
     * @param name The chain's resource name, in the format `chains/{chain_place_id}`.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Chain> {

      private static final String REST_PATH = "v4/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^chains/[^/]+$");

      /**
       * Gets the specified chain. Returns `NOT_FOUND` if the chain does not exist.
       *
       * Create a request for the method "chains.get".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Get#execute()} method to invoke the remote operation. <p>
       * {@link Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name The chain's resource name, in the format `chains/{chain_place_id}`.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Chain.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^chains/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** The chain's resource name, in the format `chains/{chain_place_id}`. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** The chain's resource name, in the format `chains/{chain_place_id}`.
       */
      public java.lang.String getName() {
        return name;
      }

      /** The chain's resource name, in the format `chains/{chain_place_id}`. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^chains/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Searches the chain based on chain name.
     *
     * Create a request for the method "chains.search".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @return the request
     */
    public Search search() throws java.io.IOException {
      Search result = new Search();
      initialize(result);
      return result;
    }

    public class Search extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.SearchChainsResponse> {

      private static final String REST_PATH = "v4/chains:search";

      /**
       * Searches the chain based on chain name.
       *
       * Create a request for the method "chains.search".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
       * <p> {@link
       * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected Search() {
        super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.SearchChainsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Search set$Xgafv(java.lang.String $Xgafv) {
        return (Search) super.set$Xgafv($Xgafv);
      }

      @Override
      public Search setAccessToken(java.lang.String accessToken) {
        return (Search) super.setAccessToken(accessToken);
      }

      @Override
      public Search setAlt(java.lang.String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setCallback(java.lang.String callback) {
        return (Search) super.setCallback(callback);
      }

      @Override
      public Search setFields(java.lang.String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(java.lang.String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(java.lang.String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(java.lang.String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUploadType(java.lang.String uploadType) {
        return (Search) super.setUploadType(uploadType);
      }

      @Override
      public Search setUploadProtocol(java.lang.String uploadProtocol) {
        return (Search) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * The maximum number of matched chains to return from this query. The default is 10. The
       * maximum possible value is 500.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer resultCount;

      /** The maximum number of matched chains to return from this query. The default is 10. The maximum
     possible value is 500.
       */
      public java.lang.Integer getResultCount() {
        return resultCount;
      }

      /**
       * The maximum number of matched chains to return from this query. The default is 10. The
       * maximum possible value is 500.
       */
      public Search setResultCount(java.lang.Integer resultCount) {
        this.resultCount = resultCount;
        return this;
      }

      /**
       * Search for a chain by its name. Exact/partial/fuzzy/related queries are supported.
       * Examples: "walmart", "wal-mart", "walmmmart", "沃尔玛"
       */
      @com.google.api.client.util.Key
      private java.lang.String chainDisplayName;

      /** Search for a chain by its name. Exact/partial/fuzzy/related queries are supported. Examples:
     "walmart", "wal-mart", "walmmmart", "沃尔玛"
       */
      public java.lang.String getChainDisplayName() {
        return chainDisplayName;
      }

      /**
       * Search for a chain by its name. Exact/partial/fuzzy/related queries are supported.
       * Examples: "walmart", "wal-mart", "walmmmart", "沃尔玛"
       */
      public Search setChainDisplayName(java.lang.String chainDisplayName) {
        this.chainDisplayName = chainDisplayName;
        return this;
      }

      @Override
      public Search set(String parameterName, Object value) {
        return (Search) super.set(parameterName, value);
      }
    }

  }

  /**
   * An accessor for creating requests from the GoogleLocations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusiness mybusiness = new MyBusiness(...);}
   *   {@code MyBusiness.GoogleLocations.List request = mybusiness.googleLocations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public GoogleLocations googleLocations() {
    return new GoogleLocations();
  }

  /**
   * The "googleLocations" collection of methods.
   */
  public class GoogleLocations {

    /**
     * Report a GoogleLocation.
     *
     * Create a request for the method "googleLocations.report".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Report#execute()} method to invoke the remote operation.
     *
     * @param name Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
     * @param content the {@link com.google.api.services.mybusiness.v4.model.ReportGoogleLocationRequest}
     * @return the request
     */
    public Report report(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReportGoogleLocationRequest content) throws java.io.IOException {
      Report result = new Report(name, content);
      initialize(result);
      return result;
    }

    public class Report extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Empty> {

      private static final String REST_PATH = "v4/{+name}:report";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^googleLocations/[^/]+$");

      /**
       * Report a GoogleLocation.
       *
       * Create a request for the method "googleLocations.report".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Report#execute()} method to invoke the remote operation.
       * <p> {@link
       * Report#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
       * @param content the {@link com.google.api.services.mybusiness.v4.model.ReportGoogleLocationRequest}
       * @since 1.13
       */
      protected Report(java.lang.String name, com.google.api.services.mybusiness.v4.model.ReportGoogleLocationRequest content) {
        super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^googleLocations/[^/]+$");
        }
      }

      @Override
      public Report set$Xgafv(java.lang.String $Xgafv) {
        return (Report) super.set$Xgafv($Xgafv);
      }

      @Override
      public Report setAccessToken(java.lang.String accessToken) {
        return (Report) super.setAccessToken(accessToken);
      }

      @Override
      public Report setAlt(java.lang.String alt) {
        return (Report) super.setAlt(alt);
      }

      @Override
      public Report setCallback(java.lang.String callback) {
        return (Report) super.setCallback(callback);
      }

      @Override
      public Report setFields(java.lang.String fields) {
        return (Report) super.setFields(fields);
      }

      @Override
      public Report setKey(java.lang.String key) {
        return (Report) super.setKey(key);
      }

      @Override
      public Report setOauthToken(java.lang.String oauthToken) {
        return (Report) super.setOauthToken(oauthToken);
      }

      @Override
      public Report setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Report) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Report setQuotaUser(java.lang.String quotaUser) {
        return (Report) super.setQuotaUser(quotaUser);
      }

      @Override
      public Report setUploadType(java.lang.String uploadType) {
        return (Report) super.setUploadType(uploadType);
      }

      @Override
      public Report setUploadProtocol(java.lang.String uploadProtocol) {
        return (Report) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
       */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
       */
      public java.lang.String getName() {
        return name;
      }

      /**
       * Resource name of a [GoogleLocation], in the format `googleLocations/{googleLocationId}`.
       */
      public Report setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^googleLocations/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Report set(String parameterName, Object value) {
        return (Report) super.set(parameterName, value);
      }
    }
    /**
     * Search all of the possible locations that are a match to the specified request.
     *
     * Create a request for the method "googleLocations.search".
     *
     * This request holds the parameters needed by the mybusiness server.  After setting any optional
     * parameters, call the {@link Search#execute()} method to invoke the remote operation.
     *
     * @param content the {@link com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsRequest}
     * @return the request
     */
    public Search search(com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsRequest content) throws java.io.IOException {
      Search result = new Search(content);
      initialize(result);
      return result;
    }

    public class Search extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsResponse> {

      private static final String REST_PATH = "v4/googleLocations:search";

      /**
       * Search all of the possible locations that are a match to the specified request.
       *
       * Create a request for the method "googleLocations.search".
       *
       * This request holds the parameters needed by the the mybusiness server.  After setting any
       * optional parameters, call the {@link Search#execute()} method to invoke the remote operation.
       * <p> {@link
       * Search#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsRequest}
       * @since 1.13
       */
      protected Search(com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsRequest content) {
        super(MyBusiness.this, "POST", REST_PATH, content, com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsResponse.class);
      }

      @Override
      public Search set$Xgafv(java.lang.String $Xgafv) {
        return (Search) super.set$Xgafv($Xgafv);
      }

      @Override
      public Search setAccessToken(java.lang.String accessToken) {
        return (Search) super.setAccessToken(accessToken);
      }

      @Override
      public Search setAlt(java.lang.String alt) {
        return (Search) super.setAlt(alt);
      }

      @Override
      public Search setCallback(java.lang.String callback) {
        return (Search) super.setCallback(callback);
      }

      @Override
      public Search setFields(java.lang.String fields) {
        return (Search) super.setFields(fields);
      }

      @Override
      public Search setKey(java.lang.String key) {
        return (Search) super.setKey(key);
      }

      @Override
      public Search setOauthToken(java.lang.String oauthToken) {
        return (Search) super.setOauthToken(oauthToken);
      }

      @Override
      public Search setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Search) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Search setQuotaUser(java.lang.String quotaUser) {
        return (Search) super.setQuotaUser(quotaUser);
      }

      @Override
      public Search setUploadType(java.lang.String uploadType) {
        return (Search) super.setUploadType(uploadType);
      }

      @Override
      public Search setUploadProtocol(java.lang.String uploadProtocol) {
        return (Search) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Search set(String parameterName, Object value) {
        return (Search) super.set(parameterName, value);
      }
    }

  }

  /**
   * Builder for {@link MyBusiness}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          DEFAULT_ROOT_URL,
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link MyBusiness}. */
    @Override
    public MyBusiness build() {
      return new MyBusiness(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link MyBusinessRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setMyBusinessRequestInitializer(
        MyBusinessRequestInitializer mybusinessRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(mybusinessRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
