/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Reviews.BatchGetReviews.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BatchGetReviewsResponse extends com.google.api.client.json.GenericJson {

  /**
   * Reviews with location information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocationReview> locationReviews;

  /**
   * If the number of reviews exceeded the requested page size, this field is populated with a token
   * to fetch the next page of reviews on a subsequent calls. If there are no more reviews, this
   * field will not be present in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * Reviews with location information.
   * @return value or {@code null} for none
   */
  public java.util.List<LocationReview> getLocationReviews() {
    return locationReviews;
  }

  /**
   * Reviews with location information.
   * @param locationReviews locationReviews or {@code null} for none
   */
  public BatchGetReviewsResponse setLocationReviews(java.util.List<LocationReview> locationReviews) {
    this.locationReviews = locationReviews;
    return this;
  }

  /**
   * If the number of reviews exceeded the requested page size, this field is populated with a token
   * to fetch the next page of reviews on a subsequent calls. If there are no more reviews, this
   * field will not be present in the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If the number of reviews exceeded the requested page size, this field is populated with a token
   * to fetch the next page of reviews on a subsequent calls. If there are no more reviews, this
   * field will not be present in the response.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public BatchGetReviewsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public BatchGetReviewsResponse set(String fieldName, Object value) {
    return (BatchGetReviewsResponse) super.set(fieldName, value);
  }

  @Override
  public BatchGetReviewsResponse clone() {
    return (BatchGetReviewsResponse) super.clone();
  }

}
