/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Information about the layout of the living area.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class LivingAreaLayout extends com.google.api.client.json.GenericJson {

  /**
   * Balcony. An outdoor platform attached to a building and surrounded by a short wall, fence or
   * other safety railing. The balcony is accessed through a door in a guestroom or suite and is for
   * use by the guest staying in that room. May or may not include seating or outdoor furniture. Is
   * not located on the ground floor. Also lanai.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean balcony;

  /**
   * Balcony exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String balconyException;

  /**
   * Living area sq meters. The measurement in meters of the area of a guestroom's living space.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Float livingAreaSqMeters;

  /**
   * Living area sq meters exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String livingAreaSqMetersException;

  /**
   * Loft. A three-walled upper area accessed by stairs or a ladder that overlooks the lower area of
   * a room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean loft;

  /**
   * Loft exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String loftException;

  /**
   * Non smoking. A guestroom in which the smoking of cigarettes, cigars and pipes is prohibited.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean nonSmoking;

  /**
   * Non smoking exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nonSmokingException;

  /**
   * Patio. A paved, outdoor area with seating attached to and accessed through a ground-floor
   * guestroom for use by the occupants of the guestroom.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean patio;

  /**
   * Patio exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String patioException;

  /**
   * Stairs. There are steps leading from one level or story to another in the unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean stairs;

  /**
   * Stairs exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String stairsException;

  /**
   * Balcony. An outdoor platform attached to a building and surrounded by a short wall, fence or
   * other safety railing. The balcony is accessed through a door in a guestroom or suite and is for
   * use by the guest staying in that room. May or may not include seating or outdoor furniture. Is
   * not located on the ground floor. Also lanai.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBalcony() {
    return balcony;
  }

  /**
   * Balcony. An outdoor platform attached to a building and surrounded by a short wall, fence or
   * other safety railing. The balcony is accessed through a door in a guestroom or suite and is for
   * use by the guest staying in that room. May or may not include seating or outdoor furniture. Is
   * not located on the ground floor. Also lanai.
   * @param balcony balcony or {@code null} for none
   */
  public LivingAreaLayout setBalcony(java.lang.Boolean balcony) {
    this.balcony = balcony;
    return this;
  }

  /**
   * Balcony exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getBalconyException() {
    return balconyException;
  }

  /**
   * Balcony exception.
   * @param balconyException balconyException or {@code null} for none
   */
  public LivingAreaLayout setBalconyException(java.lang.String balconyException) {
    this.balconyException = balconyException;
    return this;
  }

  /**
   * Living area sq meters. The measurement in meters of the area of a guestroom's living space.
   * @return value or {@code null} for none
   */
  public java.lang.Float getLivingAreaSqMeters() {
    return livingAreaSqMeters;
  }

  /**
   * Living area sq meters. The measurement in meters of the area of a guestroom's living space.
   * @param livingAreaSqMeters livingAreaSqMeters or {@code null} for none
   */
  public LivingAreaLayout setLivingAreaSqMeters(java.lang.Float livingAreaSqMeters) {
    this.livingAreaSqMeters = livingAreaSqMeters;
    return this;
  }

  /**
   * Living area sq meters exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getLivingAreaSqMetersException() {
    return livingAreaSqMetersException;
  }

  /**
   * Living area sq meters exception.
   * @param livingAreaSqMetersException livingAreaSqMetersException or {@code null} for none
   */
  public LivingAreaLayout setLivingAreaSqMetersException(java.lang.String livingAreaSqMetersException) {
    this.livingAreaSqMetersException = livingAreaSqMetersException;
    return this;
  }

  /**
   * Loft. A three-walled upper area accessed by stairs or a ladder that overlooks the lower area of
   * a room.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLoft() {
    return loft;
  }

  /**
   * Loft. A three-walled upper area accessed by stairs or a ladder that overlooks the lower area of
   * a room.
   * @param loft loft or {@code null} for none
   */
  public LivingAreaLayout setLoft(java.lang.Boolean loft) {
    this.loft = loft;
    return this;
  }

  /**
   * Loft exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getLoftException() {
    return loftException;
  }

  /**
   * Loft exception.
   * @param loftException loftException or {@code null} for none
   */
  public LivingAreaLayout setLoftException(java.lang.String loftException) {
    this.loftException = loftException;
    return this;
  }

  /**
   * Non smoking. A guestroom in which the smoking of cigarettes, cigars and pipes is prohibited.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getNonSmoking() {
    return nonSmoking;
  }

  /**
   * Non smoking. A guestroom in which the smoking of cigarettes, cigars and pipes is prohibited.
   * @param nonSmoking nonSmoking or {@code null} for none
   */
  public LivingAreaLayout setNonSmoking(java.lang.Boolean nonSmoking) {
    this.nonSmoking = nonSmoking;
    return this;
  }

  /**
   * Non smoking exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getNonSmokingException() {
    return nonSmokingException;
  }

  /**
   * Non smoking exception.
   * @param nonSmokingException nonSmokingException or {@code null} for none
   */
  public LivingAreaLayout setNonSmokingException(java.lang.String nonSmokingException) {
    this.nonSmokingException = nonSmokingException;
    return this;
  }

  /**
   * Patio. A paved, outdoor area with seating attached to and accessed through a ground-floor
   * guestroom for use by the occupants of the guestroom.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPatio() {
    return patio;
  }

  /**
   * Patio. A paved, outdoor area with seating attached to and accessed through a ground-floor
   * guestroom for use by the occupants of the guestroom.
   * @param patio patio or {@code null} for none
   */
  public LivingAreaLayout setPatio(java.lang.Boolean patio) {
    this.patio = patio;
    return this;
  }

  /**
   * Patio exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPatioException() {
    return patioException;
  }

  /**
   * Patio exception.
   * @param patioException patioException or {@code null} for none
   */
  public LivingAreaLayout setPatioException(java.lang.String patioException) {
    this.patioException = patioException;
    return this;
  }

  /**
   * Stairs. There are steps leading from one level or story to another in the unit.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getStairs() {
    return stairs;
  }

  /**
   * Stairs. There are steps leading from one level or story to another in the unit.
   * @param stairs stairs or {@code null} for none
   */
  public LivingAreaLayout setStairs(java.lang.Boolean stairs) {
    this.stairs = stairs;
    return this;
  }

  /**
   * Stairs exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getStairsException() {
    return stairsException;
  }

  /**
   * Stairs exception.
   * @param stairsException stairsException or {@code null} for none
   */
  public LivingAreaLayout setStairsException(java.lang.String stairsException) {
    this.stairsException = stairsException;
    return this;
  }

  @Override
  public LivingAreaLayout set(String fieldName, Object value) {
    return (LivingAreaLayout) super.set(fieldName, value);
  }

  @Override
  public LivingAreaLayout clone() {
    return (LivingAreaLayout) super.clone();
  }

}
