/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A list of item price information. Price lists are structured as one or more price lists, each
 * containing one or more sections with one or more items. For example, food price lists may
 * represent breakfast/lunch/dinner menus, with sections for burgers/steak/seafood.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PriceList extends com.google.api.client.json.GenericJson {

  /**
   * Required. Language-tagged labels for the price list.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Label> labels;

  /**
   * Required. ID for the price list. Price list, section, and item IDs cannot be duplicated within
   * this Location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String priceListId;

  /**
   * Required. Sections for this price list. Each price list must contain at least one section.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Section> sections;

  static {
    // hack to force ProGuard to consider Section used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Section.class);
  }

  /**
   * Optional source URL of where the price list was retrieved from. For example, this could be the
   * URL of the page that was automatically scraped to populate the menu information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String sourceUrl;

  /**
   * Required. Language-tagged labels for the price list.
   * @return value or {@code null} for none
   */
  public java.util.List<Label> getLabels() {
    return labels;
  }

  /**
   * Required. Language-tagged labels for the price list.
   * @param labels labels or {@code null} for none
   */
  public PriceList setLabels(java.util.List<Label> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Required. ID for the price list. Price list, section, and item IDs cannot be duplicated within
   * this Location.
   * @return value or {@code null} for none
   */
  public java.lang.String getPriceListId() {
    return priceListId;
  }

  /**
   * Required. ID for the price list. Price list, section, and item IDs cannot be duplicated within
   * this Location.
   * @param priceListId priceListId or {@code null} for none
   */
  public PriceList setPriceListId(java.lang.String priceListId) {
    this.priceListId = priceListId;
    return this;
  }

  /**
   * Required. Sections for this price list. Each price list must contain at least one section.
   * @return value or {@code null} for none
   */
  public java.util.List<Section> getSections() {
    return sections;
  }

  /**
   * Required. Sections for this price list. Each price list must contain at least one section.
   * @param sections sections or {@code null} for none
   */
  public PriceList setSections(java.util.List<Section> sections) {
    this.sections = sections;
    return this;
  }

  /**
   * Optional source URL of where the price list was retrieved from. For example, this could be the
   * URL of the page that was automatically scraped to populate the menu information.
   * @return value or {@code null} for none
   */
  public java.lang.String getSourceUrl() {
    return sourceUrl;
  }

  /**
   * Optional source URL of where the price list was retrieved from. For example, this could be the
   * URL of the page that was automatically scraped to populate the menu information.
   * @param sourceUrl sourceUrl or {@code null} for none
   */
  public PriceList setSourceUrl(java.lang.String sourceUrl) {
    this.sourceUrl = sourceUrl;
    return this;
  }

  @Override
  public PriceList set(String fieldName, Object value) {
    return (PriceList) super.set(fieldName, value);
  }

  @Override
  public PriceList clone() {
    return (PriceList) super.clone();
  }

}
