/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Vehicles or vehicular services facilitated or owned by the property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Transportation extends com.google.api.client.json.GenericJson {

  /**
   * Airport shuttle. The hotel provides guests with a chauffeured van or bus to and from the
   * airport. Can be free or for a fee. Guests may share the vehicle with other guests unknown to
   * them. Applies if the hotel has a third-party shuttle service (office/desk etc.) within the
   * hotel. As long as hotel provides this service, it doesn't matter if it's directly with them or
   * a third party they work with. Does not apply if guest has to coordinate with an entity
   * outside/other than the hotel.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean airportShuttle;

  /**
   * Airport shuttle exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String airportShuttleException;

  /**
   * Car rental on property. A branch of a rental car company with a processing desk in the hotel.
   * Available cars for rent may be awaiting at the hotel or in a nearby lot.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean carRentalOnProperty;

  /**
   * Car rental on property exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String carRentalOnPropertyException;

  /**
   * Free airport shuttle. Airport shuttle is free to guests. Must be free to all guests without any
   * conditions.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeAirportShuttle;

  /**
   * Free airport shuttle exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeAirportShuttleException;

  /**
   * Free private car service. Private chauffeured car service is free to guests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freePrivateCarService;

  /**
   * Free private car service exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freePrivateCarServiceException;

  /**
   * Local shuttle. A car, van or bus provided by the hotel to transport guests to destinations
   * within a specified range of distance around the hotel. Usually shopping and/or convention
   * centers, downtown districts, or beaches. Can be free or for a fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean localShuttle;

  /**
   * Local shuttle exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String localShuttleException;

  /**
   * Private car service. Hotel provides a private chauffeured car to transport guests to
   * destinations. Passengers in the car are either alone or are known to one another and have
   * requested the car together. Service can be free or for a fee and travel distance is usually
   * limited to a specific range. Not a taxi.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean privateCarService;

  /**
   * Private car service exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateCarServiceException;

  /**
   * Transfer. Hotel provides a shuttle service or car service to take guests to and from the
   * nearest airport or train station. Can be free or for a fee. Guests may share the vehicle with
   * other guests unknown to them.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean transfer;

  /**
   * Transfer exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String transferException;

  /**
   * Airport shuttle. The hotel provides guests with a chauffeured van or bus to and from the
   * airport. Can be free or for a fee. Guests may share the vehicle with other guests unknown to
   * them. Applies if the hotel has a third-party shuttle service (office/desk etc.) within the
   * hotel. As long as hotel provides this service, it doesn't matter if it's directly with them or
   * a third party they work with. Does not apply if guest has to coordinate with an entity
   * outside/other than the hotel.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAirportShuttle() {
    return airportShuttle;
  }

  /**
   * Airport shuttle. The hotel provides guests with a chauffeured van or bus to and from the
   * airport. Can be free or for a fee. Guests may share the vehicle with other guests unknown to
   * them. Applies if the hotel has a third-party shuttle service (office/desk etc.) within the
   * hotel. As long as hotel provides this service, it doesn't matter if it's directly with them or
   * a third party they work with. Does not apply if guest has to coordinate with an entity
   * outside/other than the hotel.
   * @param airportShuttle airportShuttle or {@code null} for none
   */
  public Transportation setAirportShuttle(java.lang.Boolean airportShuttle) {
    this.airportShuttle = airportShuttle;
    return this;
  }

  /**
   * Airport shuttle exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getAirportShuttleException() {
    return airportShuttleException;
  }

  /**
   * Airport shuttle exception.
   * @param airportShuttleException airportShuttleException or {@code null} for none
   */
  public Transportation setAirportShuttleException(java.lang.String airportShuttleException) {
    this.airportShuttleException = airportShuttleException;
    return this;
  }

  /**
   * Car rental on property. A branch of a rental car company with a processing desk in the hotel.
   * Available cars for rent may be awaiting at the hotel or in a nearby lot.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCarRentalOnProperty() {
    return carRentalOnProperty;
  }

  /**
   * Car rental on property. A branch of a rental car company with a processing desk in the hotel.
   * Available cars for rent may be awaiting at the hotel or in a nearby lot.
   * @param carRentalOnProperty carRentalOnProperty or {@code null} for none
   */
  public Transportation setCarRentalOnProperty(java.lang.Boolean carRentalOnProperty) {
    this.carRentalOnProperty = carRentalOnProperty;
    return this;
  }

  /**
   * Car rental on property exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCarRentalOnPropertyException() {
    return carRentalOnPropertyException;
  }

  /**
   * Car rental on property exception.
   * @param carRentalOnPropertyException carRentalOnPropertyException or {@code null} for none
   */
  public Transportation setCarRentalOnPropertyException(java.lang.String carRentalOnPropertyException) {
    this.carRentalOnPropertyException = carRentalOnPropertyException;
    return this;
  }

  /**
   * Free airport shuttle. Airport shuttle is free to guests. Must be free to all guests without any
   * conditions.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeAirportShuttle() {
    return freeAirportShuttle;
  }

  /**
   * Free airport shuttle. Airport shuttle is free to guests. Must be free to all guests without any
   * conditions.
   * @param freeAirportShuttle freeAirportShuttle or {@code null} for none
   */
  public Transportation setFreeAirportShuttle(java.lang.Boolean freeAirportShuttle) {
    this.freeAirportShuttle = freeAirportShuttle;
    return this;
  }

  /**
   * Free airport shuttle exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeAirportShuttleException() {
    return freeAirportShuttleException;
  }

  /**
   * Free airport shuttle exception.
   * @param freeAirportShuttleException freeAirportShuttleException or {@code null} for none
   */
  public Transportation setFreeAirportShuttleException(java.lang.String freeAirportShuttleException) {
    this.freeAirportShuttleException = freeAirportShuttleException;
    return this;
  }

  /**
   * Free private car service. Private chauffeured car service is free to guests.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreePrivateCarService() {
    return freePrivateCarService;
  }

  /**
   * Free private car service. Private chauffeured car service is free to guests.
   * @param freePrivateCarService freePrivateCarService or {@code null} for none
   */
  public Transportation setFreePrivateCarService(java.lang.Boolean freePrivateCarService) {
    this.freePrivateCarService = freePrivateCarService;
    return this;
  }

  /**
   * Free private car service exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreePrivateCarServiceException() {
    return freePrivateCarServiceException;
  }

  /**
   * Free private car service exception.
   * @param freePrivateCarServiceException freePrivateCarServiceException or {@code null} for none
   */
  public Transportation setFreePrivateCarServiceException(java.lang.String freePrivateCarServiceException) {
    this.freePrivateCarServiceException = freePrivateCarServiceException;
    return this;
  }

  /**
   * Local shuttle. A car, van or bus provided by the hotel to transport guests to destinations
   * within a specified range of distance around the hotel. Usually shopping and/or convention
   * centers, downtown districts, or beaches. Can be free or for a fee.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getLocalShuttle() {
    return localShuttle;
  }

  /**
   * Local shuttle. A car, van or bus provided by the hotel to transport guests to destinations
   * within a specified range of distance around the hotel. Usually shopping and/or convention
   * centers, downtown districts, or beaches. Can be free or for a fee.
   * @param localShuttle localShuttle or {@code null} for none
   */
  public Transportation setLocalShuttle(java.lang.Boolean localShuttle) {
    this.localShuttle = localShuttle;
    return this;
  }

  /**
   * Local shuttle exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocalShuttleException() {
    return localShuttleException;
  }

  /**
   * Local shuttle exception.
   * @param localShuttleException localShuttleException or {@code null} for none
   */
  public Transportation setLocalShuttleException(java.lang.String localShuttleException) {
    this.localShuttleException = localShuttleException;
    return this;
  }

  /**
   * Private car service. Hotel provides a private chauffeured car to transport guests to
   * destinations. Passengers in the car are either alone or are known to one another and have
   * requested the car together. Service can be free or for a fee and travel distance is usually
   * limited to a specific range. Not a taxi.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrivateCarService() {
    return privateCarService;
  }

  /**
   * Private car service. Hotel provides a private chauffeured car to transport guests to
   * destinations. Passengers in the car are either alone or are known to one another and have
   * requested the car together. Service can be free or for a fee and travel distance is usually
   * limited to a specific range. Not a taxi.
   * @param privateCarService privateCarService or {@code null} for none
   */
  public Transportation setPrivateCarService(java.lang.Boolean privateCarService) {
    this.privateCarService = privateCarService;
    return this;
  }

  /**
   * Private car service exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateCarServiceException() {
    return privateCarServiceException;
  }

  /**
   * Private car service exception.
   * @param privateCarServiceException privateCarServiceException or {@code null} for none
   */
  public Transportation setPrivateCarServiceException(java.lang.String privateCarServiceException) {
    this.privateCarServiceException = privateCarServiceException;
    return this;
  }

  /**
   * Transfer. Hotel provides a shuttle service or car service to take guests to and from the
   * nearest airport or train station. Can be free or for a fee. Guests may share the vehicle with
   * other guests unknown to them.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTransfer() {
    return transfer;
  }

  /**
   * Transfer. Hotel provides a shuttle service or car service to take guests to and from the
   * nearest airport or train station. Can be free or for a fee. Guests may share the vehicle with
   * other guests unknown to them.
   * @param transfer transfer or {@code null} for none
   */
  public Transportation setTransfer(java.lang.Boolean transfer) {
    this.transfer = transfer;
    return this;
  }

  /**
   * Transfer exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getTransferException() {
    return transferException;
  }

  /**
   * Transfer exception.
   * @param transferException transferException or {@code null} for none
   */
  public Transportation setTransferException(java.lang.String transferException) {
    this.transferException = transferException;
    return this;
  }

  @Override
  public Transportation set(String fieldName, Object value) {
    return (Transportation) super.set(fieldName, value);
  }

  @Override
  public Transportation clone() {
    return (Transportation) super.clone();
  }

}
