/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.mybusiness.v4;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.mybusiness.v4.MyBusinessRequest;
import com.google.api.services.mybusiness.v4.MyBusinessRequestInitializer;
import com.google.api.services.mybusiness.v4.model.AcceptInvitationRequest;
import com.google.api.services.mybusiness.v4.model.Account;
import com.google.api.services.mybusiness.v4.model.Admin;
import com.google.api.services.mybusiness.v4.model.Answer;
import com.google.api.services.mybusiness.v4.model.AssociateLocationRequest;
import com.google.api.services.mybusiness.v4.model.BatchGetBusinessCategoriesResponse;
import com.google.api.services.mybusiness.v4.model.BatchGetLocationsRequest;
import com.google.api.services.mybusiness.v4.model.BatchGetLocationsResponse;
import com.google.api.services.mybusiness.v4.model.BatchGetReviewsRequest;
import com.google.api.services.mybusiness.v4.model.BatchGetReviewsResponse;
import com.google.api.services.mybusiness.v4.model.Chain;
import com.google.api.services.mybusiness.v4.model.ClearLocationAssociationRequest;
import com.google.api.services.mybusiness.v4.model.CompleteVerificationRequest;
import com.google.api.services.mybusiness.v4.model.CompleteVerificationResponse;
import com.google.api.services.mybusiness.v4.model.DeclineInvitationRequest;
import com.google.api.services.mybusiness.v4.model.Empty;
import com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsRequest;
import com.google.api.services.mybusiness.v4.model.FetchVerificationOptionsResponse;
import com.google.api.services.mybusiness.v4.model.FindMatchingLocationsRequest;
import com.google.api.services.mybusiness.v4.model.FindMatchingLocationsResponse;
import com.google.api.services.mybusiness.v4.model.FollowersMetadata;
import com.google.api.services.mybusiness.v4.model.FoodMenus;
import com.google.api.services.mybusiness.v4.model.GenerateAccountNumberRequest;
import com.google.api.services.mybusiness.v4.model.GetGoogleUpdatedLodgingResponse;
import com.google.api.services.mybusiness.v4.model.GoogleUpdatedLocation;
import com.google.api.services.mybusiness.v4.model.HealthProviderAttributes;
import com.google.api.services.mybusiness.v4.model.ListAccountAdminsResponse;
import com.google.api.services.mybusiness.v4.model.ListAccountsResponse;
import com.google.api.services.mybusiness.v4.model.ListAnswersResponse;
import com.google.api.services.mybusiness.v4.model.ListAttributeMetadataResponse;
import com.google.api.services.mybusiness.v4.model.ListBusinessCategoriesResponse;
import com.google.api.services.mybusiness.v4.model.ListCustomerMediaItemsResponse;
import com.google.api.services.mybusiness.v4.model.ListInsuranceNetworksResponse;
import com.google.api.services.mybusiness.v4.model.ListInvitationsResponse;
import com.google.api.services.mybusiness.v4.model.ListLocalPostsResponse;
import com.google.api.services.mybusiness.v4.model.ListLocationAdminsResponse;
import com.google.api.services.mybusiness.v4.model.ListLocationsResponse;
import com.google.api.services.mybusiness.v4.model.ListMediaItemsResponse;
import com.google.api.services.mybusiness.v4.model.ListQuestionsResponse;
import com.google.api.services.mybusiness.v4.model.ListRecommendedGoogleLocationsResponse;
import com.google.api.services.mybusiness.v4.model.ListReviewsResponse;
import com.google.api.services.mybusiness.v4.model.ListVerificationsResponse;
import com.google.api.services.mybusiness.v4.model.LocalPost;
import com.google.api.services.mybusiness.v4.model.Location;
import com.google.api.services.mybusiness.v4.model.Lodging;
import com.google.api.services.mybusiness.v4.model.MediaItem;
import com.google.api.services.mybusiness.v4.model.MediaItemDataRef;
import com.google.api.services.mybusiness.v4.model.Notifications;
import com.google.api.services.mybusiness.v4.model.Question;
import com.google.api.services.mybusiness.v4.model.ReportGoogleLocationRequest;
import com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsRequest;
import com.google.api.services.mybusiness.v4.model.ReportLocalPostInsightsResponse;
import com.google.api.services.mybusiness.v4.model.ReportLocationInsightsRequest;
import com.google.api.services.mybusiness.v4.model.ReportLocationInsightsResponse;
import com.google.api.services.mybusiness.v4.model.Review;
import com.google.api.services.mybusiness.v4.model.ReviewReply;
import com.google.api.services.mybusiness.v4.model.SearchChainsResponse;
import com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsRequest;
import com.google.api.services.mybusiness.v4.model.SearchGoogleLocationsResponse;
import com.google.api.services.mybusiness.v4.model.ServiceList;
import com.google.api.services.mybusiness.v4.model.StartUploadMediaItemDataRequest;
import com.google.api.services.mybusiness.v4.model.TransferLocationRequest;
import com.google.api.services.mybusiness.v4.model.UpsertAnswerRequest;
import com.google.api.services.mybusiness.v4.model.VerifyLocationRequest;
import com.google.api.services.mybusiness.v4.model.VerifyLocationResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class MyBusiness
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://mybusiness.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://mybusiness.googleapis.com/";

    public MyBusiness(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    MyBusiness(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Accounts accounts() {
        return new Accounts();
    }

    public Attributes attributes() {
        return new Attributes();
    }

    public Categories categories() {
        return new Categories();
    }

    public Chains chains() {
        return new Chains();
    }

    public GoogleLocations googleLocations() {
        return new GoogleLocations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Google My Business API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, "https://mybusiness.googleapis.com/", MyBusiness.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(MyBusiness.DEFAULT_BATCH_PATH);
        }

        public MyBusiness build() {
            return new MyBusiness(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setMyBusinessRequestInitializer(MyBusinessRequestInitializer mybusinessRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)mybusinessRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class GoogleLocations {
        public Report report(String name, ReportGoogleLocationRequest content) throws IOException {
            Report result = new Report(name, content);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search(SearchGoogleLocationsRequest content) throws IOException {
            Search result = new Search(this, content);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends MyBusinessRequest<SearchGoogleLocationsResponse> {
            private static final String REST_PATH = "v4/googleLocations:search";

            protected Search(GoogleLocations this$1, SearchGoogleLocationsRequest content) {
                super(this$1.MyBusiness.this, "POST", REST_PATH, (Object)content, SearchGoogleLocationsResponse.class);
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class Report
        extends MyBusinessRequest<Empty> {
            private static final String REST_PATH = "v4/{+name}:report";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Report(String name, ReportGoogleLocationRequest content) {
                super(MyBusiness.this, "POST", REST_PATH, (Object)content, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^googleLocations/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^googleLocations/[^/]+$");
                }
            }

            public Report set$Xgafv(String $Xgafv) {
                return (Report)super.set$Xgafv($Xgafv);
            }

            public Report setAccessToken(String accessToken) {
                return (Report)super.setAccessToken(accessToken);
            }

            public Report setAlt(String alt) {
                return (Report)super.setAlt(alt);
            }

            public Report setCallback(String callback) {
                return (Report)super.setCallback(callback);
            }

            public Report setFields(String fields) {
                return (Report)super.setFields(fields);
            }

            public Report setKey(String key) {
                return (Report)super.setKey(key);
            }

            public Report setOauthToken(String oauthToken) {
                return (Report)super.setOauthToken(oauthToken);
            }

            public Report setPrettyPrint(Boolean prettyPrint) {
                return (Report)super.setPrettyPrint(prettyPrint);
            }

            public Report setQuotaUser(String quotaUser) {
                return (Report)super.setQuotaUser(quotaUser);
            }

            public Report setUploadType(String uploadType) {
                return (Report)super.setUploadType(uploadType);
            }

            public Report setUploadProtocol(String uploadProtocol) {
                return (Report)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Report setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^googleLocations/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Report set(String parameterName, Object value) {
                return (Report)super.set(parameterName, value);
            }
        }
    }

    public class Chains {
        public Get get(String name) throws IOException {
            Get result = new Get(name);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Search search() throws IOException {
            Search result = new Search(this);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Search
        extends MyBusinessRequest<SearchChainsResponse> {
            private static final String REST_PATH = "v4/chains:search";
            @Key
            private Integer resultCount;
            @Key
            private String chainDisplayName;

            protected Search(Chains this$1) {
                super(this$1.MyBusiness.this, "GET", REST_PATH, null, SearchChainsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Search set$Xgafv(String $Xgafv) {
                return (Search)super.set$Xgafv($Xgafv);
            }

            public Search setAccessToken(String accessToken) {
                return (Search)super.setAccessToken(accessToken);
            }

            public Search setAlt(String alt) {
                return (Search)super.setAlt(alt);
            }

            public Search setCallback(String callback) {
                return (Search)super.setCallback(callback);
            }

            public Search setFields(String fields) {
                return (Search)super.setFields(fields);
            }

            public Search setKey(String key) {
                return (Search)super.setKey(key);
            }

            public Search setOauthToken(String oauthToken) {
                return (Search)super.setOauthToken(oauthToken);
            }

            public Search setPrettyPrint(Boolean prettyPrint) {
                return (Search)super.setPrettyPrint(prettyPrint);
            }

            public Search setQuotaUser(String quotaUser) {
                return (Search)super.setQuotaUser(quotaUser);
            }

            public Search setUploadType(String uploadType) {
                return (Search)super.setUploadType(uploadType);
            }

            public Search setUploadProtocol(String uploadProtocol) {
                return (Search)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getResultCount() {
                return this.resultCount;
            }

            public Search setResultCount(Integer resultCount) {
                this.resultCount = resultCount;
                return this;
            }

            public String getChainDisplayName() {
                return this.chainDisplayName;
            }

            public Search setChainDisplayName(String chainDisplayName) {
                this.chainDisplayName = chainDisplayName;
                return this;
            }

            @Override
            public Search set(String parameterName, Object value) {
                return (Search)super.set(parameterName, value);
            }
        }

        public class Get
        extends MyBusinessRequest<Chain> {
            private static final String REST_PATH = "v4/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(MyBusiness.this, "GET", REST_PATH, null, Chain.class);
                this.NAME_PATTERN = Pattern.compile("^chains/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^chains/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^chains/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }
    }

    public class Categories {
        public BatchGet batchGet() throws IOException {
            BatchGet result = new BatchGet(this);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List(this);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends MyBusinessRequest<ListBusinessCategoriesResponse> {
            private static final String REST_PATH = "v4/categories";
            @Key
            private String searchTerm;
            @Key
            private String languageCode;
            @Key
            private String pageToken;
            @Key
            private String regionCode;
            @Key
            private Integer pageSize;
            @Key
            private String view;

            protected List(Categories this$1) {
                super(this$1.MyBusiness.this, "GET", REST_PATH, null, ListBusinessCategoriesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getSearchTerm() {
                return this.searchTerm;
            }

            public List setSearchTerm(String searchTerm) {
                this.searchTerm = searchTerm;
                return this;
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public List setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public List setView(String view) {
                this.view = view;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class BatchGet
        extends MyBusinessRequest<BatchGetBusinessCategoriesResponse> {
            private static final String REST_PATH = "v4/categories:batchGet";
            @Key
            private String languageCode;
            @Key
            private String view;
            @Key
            private String regionCode;
            @Key
            private java.util.List<String> categoryIds;

            protected BatchGet(Categories this$1) {
                super(this$1.MyBusiness.this, "GET", REST_PATH, null, BatchGetBusinessCategoriesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public BatchGet set$Xgafv(String $Xgafv) {
                return (BatchGet)super.set$Xgafv($Xgafv);
            }

            public BatchGet setAccessToken(String accessToken) {
                return (BatchGet)super.setAccessToken(accessToken);
            }

            public BatchGet setAlt(String alt) {
                return (BatchGet)super.setAlt(alt);
            }

            public BatchGet setCallback(String callback) {
                return (BatchGet)super.setCallback(callback);
            }

            public BatchGet setFields(String fields) {
                return (BatchGet)super.setFields(fields);
            }

            public BatchGet setKey(String key) {
                return (BatchGet)super.setKey(key);
            }

            public BatchGet setOauthToken(String oauthToken) {
                return (BatchGet)super.setOauthToken(oauthToken);
            }

            public BatchGet setPrettyPrint(Boolean prettyPrint) {
                return (BatchGet)super.setPrettyPrint(prettyPrint);
            }

            public BatchGet setQuotaUser(String quotaUser) {
                return (BatchGet)super.setQuotaUser(quotaUser);
            }

            public BatchGet setUploadType(String uploadType) {
                return (BatchGet)super.setUploadType(uploadType);
            }

            public BatchGet setUploadProtocol(String uploadProtocol) {
                return (BatchGet)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public BatchGet setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public String getView() {
                return this.view;
            }

            public BatchGet setView(String view) {
                this.view = view;
                return this;
            }

            public String getRegionCode() {
                return this.regionCode;
            }

            public BatchGet setRegionCode(String regionCode) {
                this.regionCode = regionCode;
                return this;
            }

            public java.util.List<String> getCategoryIds() {
                return this.categoryIds;
            }

            public BatchGet setCategoryIds(java.util.List<String> categoryIds) {
                this.categoryIds = categoryIds;
                return this;
            }

            @Override
            public BatchGet set(String parameterName, Object value) {
                return (BatchGet)super.set(parameterName, value);
            }
        }
    }

    public class Attributes {
        public List list() throws IOException {
            List result = new List(this);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class List
        extends MyBusinessRequest<ListAttributeMetadataResponse> {
            private static final String REST_PATH = "v4/attributes";
            @Key
            private String languageCode;
            @Key
            private String pageToken;
            @Key
            private String country;
            @Key
            private Integer pageSize;
            @Key
            private String categoryId;
            @Key
            private String name;

            protected List(Attributes this$1) {
                super(this$1.MyBusiness.this, "GET", REST_PATH, null, ListAttributeMetadataResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getLanguageCode() {
                return this.languageCode;
            }

            public List setLanguageCode(String languageCode) {
                this.languageCode = languageCode;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getCountry() {
                return this.country;
            }

            public List setCountry(String country) {
                this.country = country;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            public String getCategoryId() {
                return this.categoryId;
            }

            public List setCategoryId(String categoryId) {
                this.categoryId = categoryId;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }
    }

    public class Accounts {
        public Create create(Account content) throws IOException {
            Create result = new Create(this, content);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public DeleteNotifications deleteNotifications(String name) throws IOException {
            DeleteNotifications result = new DeleteNotifications(name);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GenerateAccountNumber generateAccountNumber(String name, GenerateAccountNumberRequest content) throws IOException {
            GenerateAccountNumber result = new GenerateAccountNumber(name, content);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String name) throws IOException {
            Get result = new Get(name);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public GetNotifications getNotifications(String name) throws IOException {
            GetNotifications result = new GetNotifications(name);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List(this);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public ListRecommendGoogleLocations listRecommendGoogleLocations(String name) throws IOException {
            ListRecommendGoogleLocations result = new ListRecommendGoogleLocations(name);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String name, Account content) throws IOException {
            Update result = new Update(name, content);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public UpdateNotifications updateNotifications(String name, Notifications content) throws IOException {
            UpdateNotifications result = new UpdateNotifications(name, content);
            MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Admins admins() {
            return new Admins();
        }

        public Invitations invitations() {
            return new Invitations();
        }

        public Locations locations() {
            return new Locations();
        }

        public class Locations {
            public Associate associate(String name, AssociateLocationRequest content) throws IOException {
                Associate result = new Associate(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchGet batchGet(String name, BatchGetLocationsRequest content) throws IOException {
                BatchGet result = new BatchGet(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public BatchGetReviews batchGetReviews(String name, BatchGetReviewsRequest content) throws IOException {
                BatchGetReviews result = new BatchGetReviews(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ClearAssociation clearAssociation(String name, ClearLocationAssociationRequest content) throws IOException {
                ClearAssociation result = new ClearAssociation(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Create create(String parent, Location content) throws IOException {
                Create result = new Create(parent, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public FetchVerificationOptions fetchVerificationOptions(String name, FetchVerificationOptionsRequest content) throws IOException {
                FetchVerificationOptions result = new FetchVerificationOptions(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public FindMatches findMatches(String name, FindMatchingLocationsRequest content) throws IOException {
                FindMatches result = new FindMatches(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String name) throws IOException {
                Get result = new Get(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetFoodMenus getFoodMenus(String name) throws IOException {
                GetFoodMenus result = new GetFoodMenus(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetGoogleUpdated getGoogleUpdated(String name) throws IOException {
                GetGoogleUpdated result = new GetGoogleUpdated(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetHealthProviderAttributes getHealthProviderAttributes(String name) throws IOException {
                GetHealthProviderAttributes result = new GetHealthProviderAttributes(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetLodging getLodging(String name) throws IOException {
                GetLodging result = new GetLodging(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public GetServiceList getServiceList(String name) throws IOException {
                GetServiceList result = new GetServiceList(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Location content) throws IOException {
                Patch result = new Patch(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public ReportInsights reportInsights(String name, ReportLocationInsightsRequest content) throws IOException {
                ReportInsights result = new ReportInsights(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Transfer transfer(String name, TransferLocationRequest content) throws IOException {
                Transfer result = new Transfer(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateFoodMenus updateFoodMenus(String name, FoodMenus content) throws IOException {
                UpdateFoodMenus result = new UpdateFoodMenus(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateHealthProviderAttributes updateHealthProviderAttributes(String name, HealthProviderAttributes content) throws IOException {
                UpdateHealthProviderAttributes result = new UpdateHealthProviderAttributes(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateLodging updateLodging(String name, com.google.api.services.mybusiness.v4.model.Lodging content) throws IOException {
                UpdateLodging result = new UpdateLodging(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public UpdateServiceList updateServiceList(String name, ServiceList content) throws IOException {
                UpdateServiceList result = new UpdateServiceList(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Verify verify(String name, VerifyLocationRequest content) throws IOException {
                Verify result = new Verify(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Admins admins() {
                return new Admins();
            }

            public Followers followers() {
                return new Followers();
            }

            public InsuranceNetworks insuranceNetworks() {
                return new InsuranceNetworks();
            }

            public LocalPosts localPosts() {
                return new LocalPosts();
            }

            public Lodging lodging() {
                return new Lodging();
            }

            public Media media() {
                return new Media();
            }

            public Questions questions() {
                return new Questions();
            }

            public Reviews reviews() {
                return new Reviews();
            }

            public Verifications verifications() {
                return new Verifications();
            }

            public class Verifications {
                public Complete complete(String name, CompleteVerificationRequest content) throws IOException {
                    Complete result = new Complete(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends MyBusinessRequest<ListVerificationsResponse> {
                    private static final String REST_PATH = "v4/{+parent}/verifications";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListVerificationsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Complete
                extends MyBusinessRequest<CompleteVerificationResponse> {
                    private static final String REST_PATH = "v4/{+name}:complete";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Complete(String name, CompleteVerificationRequest content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, CompleteVerificationResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$");
                        }
                    }

                    public Complete set$Xgafv(String $Xgafv) {
                        return (Complete)super.set$Xgafv($Xgafv);
                    }

                    public Complete setAccessToken(String accessToken) {
                        return (Complete)super.setAccessToken(accessToken);
                    }

                    public Complete setAlt(String alt) {
                        return (Complete)super.setAlt(alt);
                    }

                    public Complete setCallback(String callback) {
                        return (Complete)super.setCallback(callback);
                    }

                    public Complete setFields(String fields) {
                        return (Complete)super.setFields(fields);
                    }

                    public Complete setKey(String key) {
                        return (Complete)super.setKey(key);
                    }

                    public Complete setOauthToken(String oauthToken) {
                        return (Complete)super.setOauthToken(oauthToken);
                    }

                    public Complete setPrettyPrint(Boolean prettyPrint) {
                        return (Complete)super.setPrettyPrint(prettyPrint);
                    }

                    public Complete setQuotaUser(String quotaUser) {
                        return (Complete)super.setQuotaUser(quotaUser);
                    }

                    public Complete setUploadType(String uploadType) {
                        return (Complete)super.setUploadType(uploadType);
                    }

                    public Complete setUploadProtocol(String uploadProtocol) {
                        return (Complete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Complete setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/verifications/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Complete set(String parameterName, Object value) {
                        return (Complete)super.set(parameterName, value);
                    }
                }
            }

            public class Reviews {
                public DeleteReply deleteReply(String name) throws IOException {
                    DeleteReply result = new DeleteReply(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public UpdateReply updateReply(String name, ReviewReply content) throws IOException {
                    UpdateReply result = new UpdateReply(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class UpdateReply
                extends MyBusinessRequest<ReviewReply> {
                    private static final String REST_PATH = "v4/{+name}/reply";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected UpdateReply(String name, ReviewReply content) {
                        super(MyBusiness.this, "PUT", REST_PATH, (Object)content, ReviewReply.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        }
                    }

                    public UpdateReply set$Xgafv(String $Xgafv) {
                        return (UpdateReply)super.set$Xgafv($Xgafv);
                    }

                    public UpdateReply setAccessToken(String accessToken) {
                        return (UpdateReply)super.setAccessToken(accessToken);
                    }

                    public UpdateReply setAlt(String alt) {
                        return (UpdateReply)super.setAlt(alt);
                    }

                    public UpdateReply setCallback(String callback) {
                        return (UpdateReply)super.setCallback(callback);
                    }

                    public UpdateReply setFields(String fields) {
                        return (UpdateReply)super.setFields(fields);
                    }

                    public UpdateReply setKey(String key) {
                        return (UpdateReply)super.setKey(key);
                    }

                    public UpdateReply setOauthToken(String oauthToken) {
                        return (UpdateReply)super.setOauthToken(oauthToken);
                    }

                    public UpdateReply setPrettyPrint(Boolean prettyPrint) {
                        return (UpdateReply)super.setPrettyPrint(prettyPrint);
                    }

                    public UpdateReply setQuotaUser(String quotaUser) {
                        return (UpdateReply)super.setQuotaUser(quotaUser);
                    }

                    public UpdateReply setUploadType(String uploadType) {
                        return (UpdateReply)super.setUploadType(uploadType);
                    }

                    public UpdateReply setUploadProtocol(String uploadProtocol) {
                        return (UpdateReply)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public UpdateReply setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public UpdateReply set(String parameterName, Object value) {
                        return (UpdateReply)super.set(parameterName, value);
                    }
                }

                public class List
                extends MyBusinessRequest<ListReviewsResponse> {
                    private static final String REST_PATH = "v4/{+parent}/reviews";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private String orderBy;
                    @Key
                    private Integer pageSize;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListReviewsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends MyBusinessRequest<Review> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(MyBusiness.this, "GET", REST_PATH, null, Review.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class DeleteReply
                extends MyBusinessRequest<Empty> {
                    private static final String REST_PATH = "v4/{+name}/reply";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected DeleteReply(String name) {
                        super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        }
                    }

                    public DeleteReply set$Xgafv(String $Xgafv) {
                        return (DeleteReply)super.set$Xgafv($Xgafv);
                    }

                    public DeleteReply setAccessToken(String accessToken) {
                        return (DeleteReply)super.setAccessToken(accessToken);
                    }

                    public DeleteReply setAlt(String alt) {
                        return (DeleteReply)super.setAlt(alt);
                    }

                    public DeleteReply setCallback(String callback) {
                        return (DeleteReply)super.setCallback(callback);
                    }

                    public DeleteReply setFields(String fields) {
                        return (DeleteReply)super.setFields(fields);
                    }

                    public DeleteReply setKey(String key) {
                        return (DeleteReply)super.setKey(key);
                    }

                    public DeleteReply setOauthToken(String oauthToken) {
                        return (DeleteReply)super.setOauthToken(oauthToken);
                    }

                    public DeleteReply setPrettyPrint(Boolean prettyPrint) {
                        return (DeleteReply)super.setPrettyPrint(prettyPrint);
                    }

                    public DeleteReply setQuotaUser(String quotaUser) {
                        return (DeleteReply)super.setQuotaUser(quotaUser);
                    }

                    public DeleteReply setUploadType(String uploadType) {
                        return (DeleteReply)super.setUploadType(uploadType);
                    }

                    public DeleteReply setUploadProtocol(String uploadProtocol) {
                        return (DeleteReply)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public DeleteReply setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/reviews/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public DeleteReply set(String parameterName, Object value) {
                        return (DeleteReply)super.set(parameterName, value);
                    }
                }
            }

            public class Questions {
                public Create create(String parent, Question content) throws IOException {
                    Create result = new Create(parent, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Question content) throws IOException {
                    Patch result = new Patch(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Answers answers() {
                    return new Answers();
                }

                public class Answers {
                    public Delete delete(String parent) throws IOException {
                        Delete result = new Delete(parent);
                        MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Upsert upsert(String parent, UpsertAnswerRequest content) throws IOException {
                        Upsert result = new Upsert(parent, content);
                        MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class Upsert
                    extends MyBusinessRequest<Answer> {
                        private static final String REST_PATH = "v4/{+parent}/answers:upsert";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Upsert(String parent, UpsertAnswerRequest content) {
                            super(MyBusiness.this, "POST", REST_PATH, (Object)content, Answer.class);
                            this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            }
                        }

                        public Upsert set$Xgafv(String $Xgafv) {
                            return (Upsert)super.set$Xgafv($Xgafv);
                        }

                        public Upsert setAccessToken(String accessToken) {
                            return (Upsert)super.setAccessToken(accessToken);
                        }

                        public Upsert setAlt(String alt) {
                            return (Upsert)super.setAlt(alt);
                        }

                        public Upsert setCallback(String callback) {
                            return (Upsert)super.setCallback(callback);
                        }

                        public Upsert setFields(String fields) {
                            return (Upsert)super.setFields(fields);
                        }

                        public Upsert setKey(String key) {
                            return (Upsert)super.setKey(key);
                        }

                        public Upsert setOauthToken(String oauthToken) {
                            return (Upsert)super.setOauthToken(oauthToken);
                        }

                        public Upsert setPrettyPrint(Boolean prettyPrint) {
                            return (Upsert)super.setPrettyPrint(prettyPrint);
                        }

                        public Upsert setQuotaUser(String quotaUser) {
                            return (Upsert)super.setQuotaUser(quotaUser);
                        }

                        public Upsert setUploadType(String uploadType) {
                            return (Upsert)super.setUploadType(uploadType);
                        }

                        public Upsert setUploadProtocol(String uploadProtocol) {
                            return (Upsert)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Upsert setParent(String parent) {
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Upsert set(String parameterName, Object value) {
                            return (Upsert)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends MyBusinessRequest<ListAnswersResponse> {
                        private static final String REST_PATH = "v4/{+parent}/answers";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String pageToken;
                        @Key
                        private String orderBy;
                        @Key
                        private Integer pageSize;

                        protected List(String parent) {
                            super(MyBusiness.this, "GET", REST_PATH, null, ListAnswersResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public String getOrderBy() {
                            return this.orderBy;
                        }

                        public List setOrderBy(String orderBy) {
                            this.orderBy = orderBy;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Delete
                    extends MyBusinessRequest<Empty> {
                        private static final String REST_PATH = "v4/{+parent}/answers:delete";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;

                        protected Delete(String parent) {
                            super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                            this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            }
                        }

                        public Delete set$Xgafv(String $Xgafv) {
                            return (Delete)super.set$Xgafv($Xgafv);
                        }

                        public Delete setAccessToken(String accessToken) {
                            return (Delete)super.setAccessToken(accessToken);
                        }

                        public Delete setAlt(String alt) {
                            return (Delete)super.setAlt(alt);
                        }

                        public Delete setCallback(String callback) {
                            return (Delete)super.setCallback(callback);
                        }

                        public Delete setFields(String fields) {
                            return (Delete)super.setFields(fields);
                        }

                        public Delete setKey(String key) {
                            return (Delete)super.setKey(key);
                        }

                        public Delete setOauthToken(String oauthToken) {
                            return (Delete)super.setOauthToken(oauthToken);
                        }

                        public Delete setPrettyPrint(Boolean prettyPrint) {
                            return (Delete)super.setPrettyPrint(prettyPrint);
                        }

                        public Delete setQuotaUser(String quotaUser) {
                            return (Delete)super.setQuotaUser(quotaUser);
                        }

                        public Delete setUploadType(String uploadType) {
                            return (Delete)super.setUploadType(uploadType);
                        }

                        public Delete setUploadProtocol(String uploadProtocol) {
                            return (Delete)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public Delete setParent(String parent) {
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        @Override
                        public Delete set(String parameterName, Object value) {
                            return (Delete)super.set(parameterName, value);
                        }
                    }
                }

                public class Patch
                extends MyBusinessRequest<Question> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Patch(String name, Question content) {
                        super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, Question.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends MyBusinessRequest<ListQuestionsResponse> {
                    private static final String REST_PATH = "v4/{+parent}/questions";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer answersPerQuestion;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String filter;
                    @Key
                    private String orderBy;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListQuestionsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Integer getAnswersPerQuestion() {
                        return this.answersPerQuestion;
                    }

                    public List setAnswersPerQuestion(Integer answersPerQuestion) {
                        this.answersPerQuestion = answersPerQuestion;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getFilter() {
                        return this.filter;
                    }

                    public List setFilter(String filter) {
                        this.filter = filter;
                        return this;
                    }

                    public String getOrderBy() {
                        return this.orderBy;
                    }

                    public List setOrderBy(String orderBy) {
                        this.orderBy = orderBy;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends MyBusinessRequest<Empty> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/questions/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends MyBusinessRequest<Question> {
                    private static final String REST_PATH = "v4/{+parent}/questions";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Question content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, Question.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Media {
                public Create create(String parent, MediaItem content) throws IOException {
                    Create result = new Create(parent, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, MediaItem content) throws IOException {
                    Patch result = new Patch(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public StartUpload startUpload(String parent, StartUploadMediaItemDataRequest content) throws IOException {
                    StartUpload result = new StartUpload(parent, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Customers customers() {
                    return new Customers();
                }

                public class Customers {
                    public Get get(String name) throws IOException {
                        Get result = new Get(name);
                        MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String parent) throws IOException {
                        List result = new List(parent);
                        MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends MyBusinessRequest<ListCustomerMediaItemsResponse> {
                        private static final String REST_PATH = "v4/{+parent}/media/customers";
                        private final Pattern PARENT_PATTERN;
                        @Key
                        private String parent;
                        @Key
                        private String pageToken;
                        @Key
                        private Integer pageSize;

                        protected List(String parent) {
                            super(MyBusiness.this, "GET", REST_PATH, null, ListCustomerMediaItemsResponse.class);
                            this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                            this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getParent() {
                            return this.parent;
                        }

                        public List setParent(String parent) {
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                            }
                            this.parent = parent;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends MyBusinessRequest<MediaItem> {
                        private static final String REST_PATH = "v4/{+name}";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;

                        protected Get(String name) {
                            super(MyBusiness.this, "GET", REST_PATH, null, MediaItem.class);
                            this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public Get setName(String name) {
                            if (!MyBusiness.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/customers/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }

                public class StartUpload
                extends MyBusinessRequest<MediaItemDataRef> {
                    private static final String REST_PATH = "v4/{+parent}/media:startUpload";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected StartUpload(String parent, StartUploadMediaItemDataRequest content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, MediaItemDataRef.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public StartUpload set$Xgafv(String $Xgafv) {
                        return (StartUpload)super.set$Xgafv($Xgafv);
                    }

                    public StartUpload setAccessToken(String accessToken) {
                        return (StartUpload)super.setAccessToken(accessToken);
                    }

                    public StartUpload setAlt(String alt) {
                        return (StartUpload)super.setAlt(alt);
                    }

                    public StartUpload setCallback(String callback) {
                        return (StartUpload)super.setCallback(callback);
                    }

                    public StartUpload setFields(String fields) {
                        return (StartUpload)super.setFields(fields);
                    }

                    public StartUpload setKey(String key) {
                        return (StartUpload)super.setKey(key);
                    }

                    public StartUpload setOauthToken(String oauthToken) {
                        return (StartUpload)super.setOauthToken(oauthToken);
                    }

                    public StartUpload setPrettyPrint(Boolean prettyPrint) {
                        return (StartUpload)super.setPrettyPrint(prettyPrint);
                    }

                    public StartUpload setQuotaUser(String quotaUser) {
                        return (StartUpload)super.setQuotaUser(quotaUser);
                    }

                    public StartUpload setUploadType(String uploadType) {
                        return (StartUpload)super.setUploadType(uploadType);
                    }

                    public StartUpload setUploadProtocol(String uploadProtocol) {
                        return (StartUpload)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public StartUpload setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public StartUpload set(String parameterName, Object value) {
                        return (StartUpload)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends MyBusinessRequest<MediaItem> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, MediaItem content) {
                        super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, MediaItem.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends MyBusinessRequest<ListMediaItemsResponse> {
                    private static final String REST_PATH = "v4/{+parent}/media";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListMediaItemsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends MyBusinessRequest<MediaItem> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(MyBusiness.this, "GET", REST_PATH, null, MediaItem.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends MyBusinessRequest<Empty> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/media/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends MyBusinessRequest<MediaItem> {
                    private static final String REST_PATH = "v4/{+parent}/media";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, MediaItem content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, MediaItem.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Lodging {
                public GetGoogleUpdated getGoogleUpdated(String name) throws IOException {
                    GetGoogleUpdated result = new GetGoogleUpdated(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class GetGoogleUpdated
                extends MyBusinessRequest<GetGoogleUpdatedLodgingResponse> {
                    private static final String REST_PATH = "v4/{+name}:getGoogleUpdated";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String readMask;

                    protected GetGoogleUpdated(String name) {
                        super(MyBusiness.this, "GET", REST_PATH, null, GetGoogleUpdatedLodgingResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/lodging$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/lodging$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetGoogleUpdated set$Xgafv(String $Xgafv) {
                        return (GetGoogleUpdated)super.set$Xgafv($Xgafv);
                    }

                    public GetGoogleUpdated setAccessToken(String accessToken) {
                        return (GetGoogleUpdated)super.setAccessToken(accessToken);
                    }

                    public GetGoogleUpdated setAlt(String alt) {
                        return (GetGoogleUpdated)super.setAlt(alt);
                    }

                    public GetGoogleUpdated setCallback(String callback) {
                        return (GetGoogleUpdated)super.setCallback(callback);
                    }

                    public GetGoogleUpdated setFields(String fields) {
                        return (GetGoogleUpdated)super.setFields(fields);
                    }

                    public GetGoogleUpdated setKey(String key) {
                        return (GetGoogleUpdated)super.setKey(key);
                    }

                    public GetGoogleUpdated setOauthToken(String oauthToken) {
                        return (GetGoogleUpdated)super.setOauthToken(oauthToken);
                    }

                    public GetGoogleUpdated setPrettyPrint(Boolean prettyPrint) {
                        return (GetGoogleUpdated)super.setPrettyPrint(prettyPrint);
                    }

                    public GetGoogleUpdated setQuotaUser(String quotaUser) {
                        return (GetGoogleUpdated)super.setQuotaUser(quotaUser);
                    }

                    public GetGoogleUpdated setUploadType(String uploadType) {
                        return (GetGoogleUpdated)super.setUploadType(uploadType);
                    }

                    public GetGoogleUpdated setUploadProtocol(String uploadProtocol) {
                        return (GetGoogleUpdated)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public GetGoogleUpdated setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/lodging$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getReadMask() {
                        return this.readMask;
                    }

                    public GetGoogleUpdated setReadMask(String readMask) {
                        this.readMask = readMask;
                        return this;
                    }

                    @Override
                    public GetGoogleUpdated set(String parameterName, Object value) {
                        return (GetGoogleUpdated)super.set(parameterName, value);
                    }
                }
            }

            public class LocalPosts {
                public Create create(String parent, LocalPost content) throws IOException {
                    Create result = new Create(parent, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String name) throws IOException {
                    Get result = new Get(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, LocalPost content) throws IOException {
                    Patch result = new Patch(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public ReportInsights reportInsights(String name, ReportLocalPostInsightsRequest content) throws IOException {
                    ReportInsights result = new ReportInsights(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class ReportInsights
                extends MyBusinessRequest<ReportLocalPostInsightsResponse> {
                    private static final String REST_PATH = "v4/{+name}/localPosts:reportInsights";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected ReportInsights(String name, ReportLocalPostInsightsRequest content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, ReportLocalPostInsightsResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public ReportInsights set$Xgafv(String $Xgafv) {
                        return (ReportInsights)super.set$Xgafv($Xgafv);
                    }

                    public ReportInsights setAccessToken(String accessToken) {
                        return (ReportInsights)super.setAccessToken(accessToken);
                    }

                    public ReportInsights setAlt(String alt) {
                        return (ReportInsights)super.setAlt(alt);
                    }

                    public ReportInsights setCallback(String callback) {
                        return (ReportInsights)super.setCallback(callback);
                    }

                    public ReportInsights setFields(String fields) {
                        return (ReportInsights)super.setFields(fields);
                    }

                    public ReportInsights setKey(String key) {
                        return (ReportInsights)super.setKey(key);
                    }

                    public ReportInsights setOauthToken(String oauthToken) {
                        return (ReportInsights)super.setOauthToken(oauthToken);
                    }

                    public ReportInsights setPrettyPrint(Boolean prettyPrint) {
                        return (ReportInsights)super.setPrettyPrint(prettyPrint);
                    }

                    public ReportInsights setQuotaUser(String quotaUser) {
                        return (ReportInsights)super.setQuotaUser(quotaUser);
                    }

                    public ReportInsights setUploadType(String uploadType) {
                        return (ReportInsights)super.setUploadType(uploadType);
                    }

                    public ReportInsights setUploadProtocol(String uploadProtocol) {
                        return (ReportInsights)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public ReportInsights setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public ReportInsights set(String parameterName, Object value) {
                        return (ReportInsights)super.set(parameterName, value);
                    }
                }

                public class Patch
                extends MyBusinessRequest<LocalPost> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String updateMask;

                    protected Patch(String name, LocalPost content) {
                        super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, LocalPost.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    public String getUpdateMask() {
                        return this.updateMask;
                    }

                    public Patch setUpdateMask(String updateMask) {
                        this.updateMask = updateMask;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends MyBusinessRequest<ListLocalPostsResponse> {
                    private static final String REST_PATH = "v4/{+parent}/localPosts";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListLocalPostsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends MyBusinessRequest<LocalPost> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Get(String name) {
                        super(MyBusiness.this, "GET", REST_PATH, null, LocalPost.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends MyBusinessRequest<Empty> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/localPosts/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends MyBusinessRequest<LocalPost> {
                    private static final String REST_PATH = "v4/{+parent}/localPosts";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, LocalPost content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, LocalPost.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class InsuranceNetworks {
                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class List
                extends MyBusinessRequest<ListInsuranceNetworksResponse> {
                    private static final String REST_PATH = "v4/{+parent}/insuranceNetworks";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;
                    @Key
                    private String languageCode;
                    @Key
                    private String pageToken;
                    @Key
                    private Integer pageSize;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListInsuranceNetworksResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    public String getLanguageCode() {
                        return this.languageCode;
                    }

                    public List setLanguageCode(String languageCode) {
                        this.languageCode = languageCode;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }
            }

            public class Followers {
                public GetMetadata getMetadata(String name) throws IOException {
                    GetMetadata result = new GetMetadata(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class GetMetadata
                extends MyBusinessRequest<FollowersMetadata> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected GetMetadata(String name) {
                        super(MyBusiness.this, "GET", REST_PATH, null, FollowersMetadata.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/followers/metadata$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/followers/metadata$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public GetMetadata set$Xgafv(String $Xgafv) {
                        return (GetMetadata)super.set$Xgafv($Xgafv);
                    }

                    public GetMetadata setAccessToken(String accessToken) {
                        return (GetMetadata)super.setAccessToken(accessToken);
                    }

                    public GetMetadata setAlt(String alt) {
                        return (GetMetadata)super.setAlt(alt);
                    }

                    public GetMetadata setCallback(String callback) {
                        return (GetMetadata)super.setCallback(callback);
                    }

                    public GetMetadata setFields(String fields) {
                        return (GetMetadata)super.setFields(fields);
                    }

                    public GetMetadata setKey(String key) {
                        return (GetMetadata)super.setKey(key);
                    }

                    public GetMetadata setOauthToken(String oauthToken) {
                        return (GetMetadata)super.setOauthToken(oauthToken);
                    }

                    public GetMetadata setPrettyPrint(Boolean prettyPrint) {
                        return (GetMetadata)super.setPrettyPrint(prettyPrint);
                    }

                    public GetMetadata setQuotaUser(String quotaUser) {
                        return (GetMetadata)super.setQuotaUser(quotaUser);
                    }

                    public GetMetadata setUploadType(String uploadType) {
                        return (GetMetadata)super.setUploadType(uploadType);
                    }

                    public GetMetadata setUploadProtocol(String uploadProtocol) {
                        return (GetMetadata)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public GetMetadata setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/followers/metadata$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public GetMetadata set(String parameterName, Object value) {
                        return (GetMetadata)super.set(parameterName, value);
                    }
                }
            }

            public class Admins {
                public Create create(String parent, Admin content) throws IOException {
                    Create result = new Create(parent, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Delete delete(String name) throws IOException {
                    Delete result = new Delete(name);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String parent) throws IOException {
                    List result = new List(parent);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String name, Admin content) throws IOException {
                    Patch result = new Patch(name, content);
                    MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public class Patch
                extends MyBusinessRequest<Admin> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Patch(String name, Admin content) {
                        super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, Admin.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
                        }
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Patch setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends MyBusinessRequest<ListLocationAdminsResponse> {
                    private static final String REST_PATH = "v4/{+parent}/admins";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected List(String parent) {
                        super(MyBusiness.this, "GET", REST_PATH, null, ListLocationAdminsResponse.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public List setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Delete
                extends MyBusinessRequest<Empty> {
                    private static final String REST_PATH = "v4/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String name) {
                        super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String $Xgafv) {
                        return (Delete)super.set$Xgafv($Xgafv);
                    }

                    public Delete setAccessToken(String accessToken) {
                        return (Delete)super.setAccessToken(accessToken);
                    }

                    public Delete setAlt(String alt) {
                        return (Delete)super.setAlt(alt);
                    }

                    public Delete setCallback(String callback) {
                        return (Delete)super.setCallback(callback);
                    }

                    public Delete setFields(String fields) {
                        return (Delete)super.setFields(fields);
                    }

                    public Delete setKey(String key) {
                        return (Delete)super.setKey(key);
                    }

                    public Delete setOauthToken(String oauthToken) {
                        return (Delete)super.setOauthToken(oauthToken);
                    }

                    public Delete setPrettyPrint(Boolean prettyPrint) {
                        return (Delete)super.setPrettyPrint(prettyPrint);
                    }

                    public Delete setQuotaUser(String quotaUser) {
                        return (Delete)super.setQuotaUser(quotaUser);
                    }

                    public Delete setUploadType(String uploadType) {
                        return (Delete)super.setUploadType(uploadType);
                    }

                    public Delete setUploadProtocol(String uploadProtocol) {
                        return (Delete)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String name) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/admins/[^/]+$");
                        }
                        this.name = name;
                        return this;
                    }

                    @Override
                    public Delete set(String parameterName, Object value) {
                        return (Delete)super.set(parameterName, value);
                    }
                }

                public class Create
                extends MyBusinessRequest<Admin> {
                    private static final String REST_PATH = "v4/{+parent}/admins";
                    private final Pattern PARENT_PATTERN;
                    @Key
                    private String parent;

                    protected Create(String parent, Admin content) {
                        super(MyBusiness.this, "POST", REST_PATH, (Object)content, Admin.class);
                        this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                        this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getParent() {
                        return this.parent;
                    }

                    public Create setParent(String parent) {
                        if (!MyBusiness.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                        }
                        this.parent = parent;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class Verify
            extends MyBusinessRequest<VerifyLocationResponse> {
                private static final String REST_PATH = "v4/{+name}:verify";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Verify(String name, VerifyLocationRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, VerifyLocationResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public Verify set$Xgafv(String $Xgafv) {
                    return (Verify)super.set$Xgafv($Xgafv);
                }

                public Verify setAccessToken(String accessToken) {
                    return (Verify)super.setAccessToken(accessToken);
                }

                public Verify setAlt(String alt) {
                    return (Verify)super.setAlt(alt);
                }

                public Verify setCallback(String callback) {
                    return (Verify)super.setCallback(callback);
                }

                public Verify setFields(String fields) {
                    return (Verify)super.setFields(fields);
                }

                public Verify setKey(String key) {
                    return (Verify)super.setKey(key);
                }

                public Verify setOauthToken(String oauthToken) {
                    return (Verify)super.setOauthToken(oauthToken);
                }

                public Verify setPrettyPrint(Boolean prettyPrint) {
                    return (Verify)super.setPrettyPrint(prettyPrint);
                }

                public Verify setQuotaUser(String quotaUser) {
                    return (Verify)super.setQuotaUser(quotaUser);
                }

                public Verify setUploadType(String uploadType) {
                    return (Verify)super.setUploadType(uploadType);
                }

                public Verify setUploadProtocol(String uploadProtocol) {
                    return (Verify)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Verify setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Verify set(String parameterName, Object value) {
                    return (Verify)super.set(parameterName, value);
                }
            }

            public class UpdateServiceList
            extends MyBusinessRequest<ServiceList> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateServiceList(String name, ServiceList content) {
                    super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, ServiceList.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/serviceList$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/serviceList$");
                    }
                }

                public UpdateServiceList set$Xgafv(String $Xgafv) {
                    return (UpdateServiceList)super.set$Xgafv($Xgafv);
                }

                public UpdateServiceList setAccessToken(String accessToken) {
                    return (UpdateServiceList)super.setAccessToken(accessToken);
                }

                public UpdateServiceList setAlt(String alt) {
                    return (UpdateServiceList)super.setAlt(alt);
                }

                public UpdateServiceList setCallback(String callback) {
                    return (UpdateServiceList)super.setCallback(callback);
                }

                public UpdateServiceList setFields(String fields) {
                    return (UpdateServiceList)super.setFields(fields);
                }

                public UpdateServiceList setKey(String key) {
                    return (UpdateServiceList)super.setKey(key);
                }

                public UpdateServiceList setOauthToken(String oauthToken) {
                    return (UpdateServiceList)super.setOauthToken(oauthToken);
                }

                public UpdateServiceList setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateServiceList)super.setPrettyPrint(prettyPrint);
                }

                public UpdateServiceList setQuotaUser(String quotaUser) {
                    return (UpdateServiceList)super.setQuotaUser(quotaUser);
                }

                public UpdateServiceList setUploadType(String uploadType) {
                    return (UpdateServiceList)super.setUploadType(uploadType);
                }

                public UpdateServiceList setUploadProtocol(String uploadProtocol) {
                    return (UpdateServiceList)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateServiceList setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/serviceList$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateServiceList setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public UpdateServiceList set(String parameterName, Object value) {
                    return (UpdateServiceList)super.set(parameterName, value);
                }
            }

            public class UpdateLodging
            extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Lodging> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateLodging(String name, com.google.api.services.mybusiness.v4.model.Lodging content) {
                    super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, com.google.api.services.mybusiness.v4.model.Lodging.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/lodging$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/lodging$");
                    }
                }

                public UpdateLodging set$Xgafv(String $Xgafv) {
                    return (UpdateLodging)super.set$Xgafv($Xgafv);
                }

                public UpdateLodging setAccessToken(String accessToken) {
                    return (UpdateLodging)super.setAccessToken(accessToken);
                }

                public UpdateLodging setAlt(String alt) {
                    return (UpdateLodging)super.setAlt(alt);
                }

                public UpdateLodging setCallback(String callback) {
                    return (UpdateLodging)super.setCallback(callback);
                }

                public UpdateLodging setFields(String fields) {
                    return (UpdateLodging)super.setFields(fields);
                }

                public UpdateLodging setKey(String key) {
                    return (UpdateLodging)super.setKey(key);
                }

                public UpdateLodging setOauthToken(String oauthToken) {
                    return (UpdateLodging)super.setOauthToken(oauthToken);
                }

                public UpdateLodging setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateLodging)super.setPrettyPrint(prettyPrint);
                }

                public UpdateLodging setQuotaUser(String quotaUser) {
                    return (UpdateLodging)super.setQuotaUser(quotaUser);
                }

                public UpdateLodging setUploadType(String uploadType) {
                    return (UpdateLodging)super.setUploadType(uploadType);
                }

                public UpdateLodging setUploadProtocol(String uploadProtocol) {
                    return (UpdateLodging)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateLodging setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/lodging$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateLodging setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public UpdateLodging set(String parameterName, Object value) {
                    return (UpdateLodging)super.set(parameterName, value);
                }
            }

            public class UpdateHealthProviderAttributes
            extends MyBusinessRequest<HealthProviderAttributes> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateHealthProviderAttributes(String name, HealthProviderAttributes content) {
                    super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, HealthProviderAttributes.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
                    }
                }

                public UpdateHealthProviderAttributes set$Xgafv(String $Xgafv) {
                    return (UpdateHealthProviderAttributes)super.set$Xgafv($Xgafv);
                }

                public UpdateHealthProviderAttributes setAccessToken(String accessToken) {
                    return (UpdateHealthProviderAttributes)super.setAccessToken(accessToken);
                }

                public UpdateHealthProviderAttributes setAlt(String alt) {
                    return (UpdateHealthProviderAttributes)super.setAlt(alt);
                }

                public UpdateHealthProviderAttributes setCallback(String callback) {
                    return (UpdateHealthProviderAttributes)super.setCallback(callback);
                }

                public UpdateHealthProviderAttributes setFields(String fields) {
                    return (UpdateHealthProviderAttributes)super.setFields(fields);
                }

                public UpdateHealthProviderAttributes setKey(String key) {
                    return (UpdateHealthProviderAttributes)super.setKey(key);
                }

                public UpdateHealthProviderAttributes setOauthToken(String oauthToken) {
                    return (UpdateHealthProviderAttributes)super.setOauthToken(oauthToken);
                }

                public UpdateHealthProviderAttributes setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateHealthProviderAttributes)super.setPrettyPrint(prettyPrint);
                }

                public UpdateHealthProviderAttributes setQuotaUser(String quotaUser) {
                    return (UpdateHealthProviderAttributes)super.setQuotaUser(quotaUser);
                }

                public UpdateHealthProviderAttributes setUploadType(String uploadType) {
                    return (UpdateHealthProviderAttributes)super.setUploadType(uploadType);
                }

                public UpdateHealthProviderAttributes setUploadProtocol(String uploadProtocol) {
                    return (UpdateHealthProviderAttributes)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateHealthProviderAttributes setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateHealthProviderAttributes setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public UpdateHealthProviderAttributes set(String parameterName, Object value) {
                    return (UpdateHealthProviderAttributes)super.set(parameterName, value);
                }
            }

            public class UpdateFoodMenus
            extends MyBusinessRequest<FoodMenus> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected UpdateFoodMenus(String name, FoodMenus content) {
                    super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, FoodMenus.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/foodMenus$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/foodMenus$");
                    }
                }

                public UpdateFoodMenus set$Xgafv(String $Xgafv) {
                    return (UpdateFoodMenus)super.set$Xgafv($Xgafv);
                }

                public UpdateFoodMenus setAccessToken(String accessToken) {
                    return (UpdateFoodMenus)super.setAccessToken(accessToken);
                }

                public UpdateFoodMenus setAlt(String alt) {
                    return (UpdateFoodMenus)super.setAlt(alt);
                }

                public UpdateFoodMenus setCallback(String callback) {
                    return (UpdateFoodMenus)super.setCallback(callback);
                }

                public UpdateFoodMenus setFields(String fields) {
                    return (UpdateFoodMenus)super.setFields(fields);
                }

                public UpdateFoodMenus setKey(String key) {
                    return (UpdateFoodMenus)super.setKey(key);
                }

                public UpdateFoodMenus setOauthToken(String oauthToken) {
                    return (UpdateFoodMenus)super.setOauthToken(oauthToken);
                }

                public UpdateFoodMenus setPrettyPrint(Boolean prettyPrint) {
                    return (UpdateFoodMenus)super.setPrettyPrint(prettyPrint);
                }

                public UpdateFoodMenus setQuotaUser(String quotaUser) {
                    return (UpdateFoodMenus)super.setQuotaUser(quotaUser);
                }

                public UpdateFoodMenus setUploadType(String uploadType) {
                    return (UpdateFoodMenus)super.setUploadType(uploadType);
                }

                public UpdateFoodMenus setUploadProtocol(String uploadProtocol) {
                    return (UpdateFoodMenus)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public UpdateFoodMenus setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/foodMenus$");
                    }
                    this.name = name;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public UpdateFoodMenus setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public UpdateFoodMenus set(String parameterName, Object value) {
                    return (UpdateFoodMenus)super.set(parameterName, value);
                }
            }

            public class Transfer
            extends MyBusinessRequest<Location> {
                private static final String REST_PATH = "v4/{+name}:transfer";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Transfer(String name, TransferLocationRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public Transfer set$Xgafv(String $Xgafv) {
                    return (Transfer)super.set$Xgafv($Xgafv);
                }

                public Transfer setAccessToken(String accessToken) {
                    return (Transfer)super.setAccessToken(accessToken);
                }

                public Transfer setAlt(String alt) {
                    return (Transfer)super.setAlt(alt);
                }

                public Transfer setCallback(String callback) {
                    return (Transfer)super.setCallback(callback);
                }

                public Transfer setFields(String fields) {
                    return (Transfer)super.setFields(fields);
                }

                public Transfer setKey(String key) {
                    return (Transfer)super.setKey(key);
                }

                public Transfer setOauthToken(String oauthToken) {
                    return (Transfer)super.setOauthToken(oauthToken);
                }

                public Transfer setPrettyPrint(Boolean prettyPrint) {
                    return (Transfer)super.setPrettyPrint(prettyPrint);
                }

                public Transfer setQuotaUser(String quotaUser) {
                    return (Transfer)super.setQuotaUser(quotaUser);
                }

                public Transfer setUploadType(String uploadType) {
                    return (Transfer)super.setUploadType(uploadType);
                }

                public Transfer setUploadProtocol(String uploadProtocol) {
                    return (Transfer)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Transfer setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Transfer set(String parameterName, Object value) {
                    return (Transfer)super.set(parameterName, value);
                }
            }

            public class ReportInsights
            extends MyBusinessRequest<ReportLocationInsightsResponse> {
                private static final String REST_PATH = "v4/{+name}/locations:reportInsights";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected ReportInsights(String name, ReportLocationInsightsRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, ReportLocationInsightsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public ReportInsights set$Xgafv(String $Xgafv) {
                    return (ReportInsights)super.set$Xgafv($Xgafv);
                }

                public ReportInsights setAccessToken(String accessToken) {
                    return (ReportInsights)super.setAccessToken(accessToken);
                }

                public ReportInsights setAlt(String alt) {
                    return (ReportInsights)super.setAlt(alt);
                }

                public ReportInsights setCallback(String callback) {
                    return (ReportInsights)super.setCallback(callback);
                }

                public ReportInsights setFields(String fields) {
                    return (ReportInsights)super.setFields(fields);
                }

                public ReportInsights setKey(String key) {
                    return (ReportInsights)super.setKey(key);
                }

                public ReportInsights setOauthToken(String oauthToken) {
                    return (ReportInsights)super.setOauthToken(oauthToken);
                }

                public ReportInsights setPrettyPrint(Boolean prettyPrint) {
                    return (ReportInsights)super.setPrettyPrint(prettyPrint);
                }

                public ReportInsights setQuotaUser(String quotaUser) {
                    return (ReportInsights)super.setQuotaUser(quotaUser);
                }

                public ReportInsights setUploadType(String uploadType) {
                    return (ReportInsights)super.setUploadType(uploadType);
                }

                public ReportInsights setUploadProtocol(String uploadProtocol) {
                    return (ReportInsights)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public ReportInsights setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public ReportInsights set(String parameterName, Object value) {
                    return (ReportInsights)super.set(parameterName, value);
                }
            }

            public class Patch
            extends MyBusinessRequest<Location> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private Boolean validateOnly;
                @Key
                private String attributeMask;
                @Key
                private String updateMask;

                protected Patch(String name, Location content) {
                    super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                public Boolean getValidateOnly() {
                    return this.validateOnly;
                }

                public Patch setValidateOnly(Boolean validateOnly) {
                    this.validateOnly = validateOnly;
                    return this;
                }

                public String getAttributeMask() {
                    return this.attributeMask;
                }

                public Patch setAttributeMask(String attributeMask) {
                    this.attributeMask = attributeMask;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String updateMask) {
                    this.updateMask = updateMask;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MyBusinessRequest<ListLocationsResponse> {
                private static final String REST_PATH = "v4/{+parent}/locations";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String languageCode;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String filter;
                @Key
                private String orderBy;

                protected List(String parent) {
                    super(MyBusiness.this, "GET", REST_PATH, null, ListLocationsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getLanguageCode() {
                    return this.languageCode;
                }

                public List setLanguageCode(String languageCode) {
                    this.languageCode = languageCode;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getFilter() {
                    return this.filter;
                }

                public List setFilter(String filter) {
                    this.filter = filter;
                    return this;
                }

                public String getOrderBy() {
                    return this.orderBy;
                }

                public List setOrderBy(String orderBy) {
                    this.orderBy = orderBy;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class GetServiceList
            extends MyBusinessRequest<ServiceList> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetServiceList(String name) {
                    super(MyBusiness.this, "GET", REST_PATH, null, ServiceList.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/serviceList$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/serviceList$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetServiceList set$Xgafv(String $Xgafv) {
                    return (GetServiceList)super.set$Xgafv($Xgafv);
                }

                public GetServiceList setAccessToken(String accessToken) {
                    return (GetServiceList)super.setAccessToken(accessToken);
                }

                public GetServiceList setAlt(String alt) {
                    return (GetServiceList)super.setAlt(alt);
                }

                public GetServiceList setCallback(String callback) {
                    return (GetServiceList)super.setCallback(callback);
                }

                public GetServiceList setFields(String fields) {
                    return (GetServiceList)super.setFields(fields);
                }

                public GetServiceList setKey(String key) {
                    return (GetServiceList)super.setKey(key);
                }

                public GetServiceList setOauthToken(String oauthToken) {
                    return (GetServiceList)super.setOauthToken(oauthToken);
                }

                public GetServiceList setPrettyPrint(Boolean prettyPrint) {
                    return (GetServiceList)super.setPrettyPrint(prettyPrint);
                }

                public GetServiceList setQuotaUser(String quotaUser) {
                    return (GetServiceList)super.setQuotaUser(quotaUser);
                }

                public GetServiceList setUploadType(String uploadType) {
                    return (GetServiceList)super.setUploadType(uploadType);
                }

                public GetServiceList setUploadProtocol(String uploadProtocol) {
                    return (GetServiceList)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetServiceList setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/serviceList$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GetServiceList set(String parameterName, Object value) {
                    return (GetServiceList)super.set(parameterName, value);
                }
            }

            public class GetLodging
            extends MyBusinessRequest<com.google.api.services.mybusiness.v4.model.Lodging> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String readMask;

                protected GetLodging(String name) {
                    super(MyBusiness.this, "GET", REST_PATH, null, com.google.api.services.mybusiness.v4.model.Lodging.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/lodging$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/lodging$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetLodging set$Xgafv(String $Xgafv) {
                    return (GetLodging)super.set$Xgafv($Xgafv);
                }

                public GetLodging setAccessToken(String accessToken) {
                    return (GetLodging)super.setAccessToken(accessToken);
                }

                public GetLodging setAlt(String alt) {
                    return (GetLodging)super.setAlt(alt);
                }

                public GetLodging setCallback(String callback) {
                    return (GetLodging)super.setCallback(callback);
                }

                public GetLodging setFields(String fields) {
                    return (GetLodging)super.setFields(fields);
                }

                public GetLodging setKey(String key) {
                    return (GetLodging)super.setKey(key);
                }

                public GetLodging setOauthToken(String oauthToken) {
                    return (GetLodging)super.setOauthToken(oauthToken);
                }

                public GetLodging setPrettyPrint(Boolean prettyPrint) {
                    return (GetLodging)super.setPrettyPrint(prettyPrint);
                }

                public GetLodging setQuotaUser(String quotaUser) {
                    return (GetLodging)super.setQuotaUser(quotaUser);
                }

                public GetLodging setUploadType(String uploadType) {
                    return (GetLodging)super.setUploadType(uploadType);
                }

                public GetLodging setUploadProtocol(String uploadProtocol) {
                    return (GetLodging)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetLodging setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/lodging$");
                    }
                    this.name = name;
                    return this;
                }

                public String getReadMask() {
                    return this.readMask;
                }

                public GetLodging setReadMask(String readMask) {
                    this.readMask = readMask;
                    return this;
                }

                @Override
                public GetLodging set(String parameterName, Object value) {
                    return (GetLodging)super.set(parameterName, value);
                }
            }

            public class GetHealthProviderAttributes
            extends MyBusinessRequest<HealthProviderAttributes> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String languageCode;

                protected GetHealthProviderAttributes(String name) {
                    super(MyBusiness.this, "GET", REST_PATH, null, HealthProviderAttributes.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetHealthProviderAttributes set$Xgafv(String $Xgafv) {
                    return (GetHealthProviderAttributes)super.set$Xgafv($Xgafv);
                }

                public GetHealthProviderAttributes setAccessToken(String accessToken) {
                    return (GetHealthProviderAttributes)super.setAccessToken(accessToken);
                }

                public GetHealthProviderAttributes setAlt(String alt) {
                    return (GetHealthProviderAttributes)super.setAlt(alt);
                }

                public GetHealthProviderAttributes setCallback(String callback) {
                    return (GetHealthProviderAttributes)super.setCallback(callback);
                }

                public GetHealthProviderAttributes setFields(String fields) {
                    return (GetHealthProviderAttributes)super.setFields(fields);
                }

                public GetHealthProviderAttributes setKey(String key) {
                    return (GetHealthProviderAttributes)super.setKey(key);
                }

                public GetHealthProviderAttributes setOauthToken(String oauthToken) {
                    return (GetHealthProviderAttributes)super.setOauthToken(oauthToken);
                }

                public GetHealthProviderAttributes setPrettyPrint(Boolean prettyPrint) {
                    return (GetHealthProviderAttributes)super.setPrettyPrint(prettyPrint);
                }

                public GetHealthProviderAttributes setQuotaUser(String quotaUser) {
                    return (GetHealthProviderAttributes)super.setQuotaUser(quotaUser);
                }

                public GetHealthProviderAttributes setUploadType(String uploadType) {
                    return (GetHealthProviderAttributes)super.setUploadType(uploadType);
                }

                public GetHealthProviderAttributes setUploadProtocol(String uploadProtocol) {
                    return (GetHealthProviderAttributes)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetHealthProviderAttributes setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/healthProviderAttributes$");
                    }
                    this.name = name;
                    return this;
                }

                public String getLanguageCode() {
                    return this.languageCode;
                }

                public GetHealthProviderAttributes setLanguageCode(String languageCode) {
                    this.languageCode = languageCode;
                    return this;
                }

                @Override
                public GetHealthProviderAttributes set(String parameterName, Object value) {
                    return (GetHealthProviderAttributes)super.set(parameterName, value);
                }
            }

            public class GetGoogleUpdated
            extends MyBusinessRequest<GoogleUpdatedLocation> {
                private static final String REST_PATH = "v4/{+name}:googleUpdated";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected GetGoogleUpdated(String name) {
                    super(MyBusiness.this, "GET", REST_PATH, null, GoogleUpdatedLocation.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetGoogleUpdated set$Xgafv(String $Xgafv) {
                    return (GetGoogleUpdated)super.set$Xgafv($Xgafv);
                }

                public GetGoogleUpdated setAccessToken(String accessToken) {
                    return (GetGoogleUpdated)super.setAccessToken(accessToken);
                }

                public GetGoogleUpdated setAlt(String alt) {
                    return (GetGoogleUpdated)super.setAlt(alt);
                }

                public GetGoogleUpdated setCallback(String callback) {
                    return (GetGoogleUpdated)super.setCallback(callback);
                }

                public GetGoogleUpdated setFields(String fields) {
                    return (GetGoogleUpdated)super.setFields(fields);
                }

                public GetGoogleUpdated setKey(String key) {
                    return (GetGoogleUpdated)super.setKey(key);
                }

                public GetGoogleUpdated setOauthToken(String oauthToken) {
                    return (GetGoogleUpdated)super.setOauthToken(oauthToken);
                }

                public GetGoogleUpdated setPrettyPrint(Boolean prettyPrint) {
                    return (GetGoogleUpdated)super.setPrettyPrint(prettyPrint);
                }

                public GetGoogleUpdated setQuotaUser(String quotaUser) {
                    return (GetGoogleUpdated)super.setQuotaUser(quotaUser);
                }

                public GetGoogleUpdated setUploadType(String uploadType) {
                    return (GetGoogleUpdated)super.setUploadType(uploadType);
                }

                public GetGoogleUpdated setUploadProtocol(String uploadProtocol) {
                    return (GetGoogleUpdated)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetGoogleUpdated setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public GetGoogleUpdated set(String parameterName, Object value) {
                    return (GetGoogleUpdated)super.set(parameterName, value);
                }
            }

            public class GetFoodMenus
            extends MyBusinessRequest<FoodMenus> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String readMask;

                protected GetFoodMenus(String name) {
                    super(MyBusiness.this, "GET", REST_PATH, null, FoodMenus.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+/foodMenus$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/foodMenus$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public GetFoodMenus set$Xgafv(String $Xgafv) {
                    return (GetFoodMenus)super.set$Xgafv($Xgafv);
                }

                public GetFoodMenus setAccessToken(String accessToken) {
                    return (GetFoodMenus)super.setAccessToken(accessToken);
                }

                public GetFoodMenus setAlt(String alt) {
                    return (GetFoodMenus)super.setAlt(alt);
                }

                public GetFoodMenus setCallback(String callback) {
                    return (GetFoodMenus)super.setCallback(callback);
                }

                public GetFoodMenus setFields(String fields) {
                    return (GetFoodMenus)super.setFields(fields);
                }

                public GetFoodMenus setKey(String key) {
                    return (GetFoodMenus)super.setKey(key);
                }

                public GetFoodMenus setOauthToken(String oauthToken) {
                    return (GetFoodMenus)super.setOauthToken(oauthToken);
                }

                public GetFoodMenus setPrettyPrint(Boolean prettyPrint) {
                    return (GetFoodMenus)super.setPrettyPrint(prettyPrint);
                }

                public GetFoodMenus setQuotaUser(String quotaUser) {
                    return (GetFoodMenus)super.setQuotaUser(quotaUser);
                }

                public GetFoodMenus setUploadType(String uploadType) {
                    return (GetFoodMenus)super.setUploadType(uploadType);
                }

                public GetFoodMenus setUploadProtocol(String uploadProtocol) {
                    return (GetFoodMenus)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public GetFoodMenus setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+/foodMenus$");
                    }
                    this.name = name;
                    return this;
                }

                public String getReadMask() {
                    return this.readMask;
                }

                public GetFoodMenus setReadMask(String readMask) {
                    this.readMask = readMask;
                    return this;
                }

                @Override
                public GetFoodMenus set(String parameterName, Object value) {
                    return (GetFoodMenus)super.set(parameterName, value);
                }
            }

            public class Get
            extends MyBusinessRequest<Location> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String name) {
                    super(MyBusiness.this, "GET", REST_PATH, null, Location.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class FindMatches
            extends MyBusinessRequest<FindMatchingLocationsResponse> {
                private static final String REST_PATH = "v4/{+name}:findMatches";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected FindMatches(String name, FindMatchingLocationsRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, FindMatchingLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public FindMatches set$Xgafv(String $Xgafv) {
                    return (FindMatches)super.set$Xgafv($Xgafv);
                }

                public FindMatches setAccessToken(String accessToken) {
                    return (FindMatches)super.setAccessToken(accessToken);
                }

                public FindMatches setAlt(String alt) {
                    return (FindMatches)super.setAlt(alt);
                }

                public FindMatches setCallback(String callback) {
                    return (FindMatches)super.setCallback(callback);
                }

                public FindMatches setFields(String fields) {
                    return (FindMatches)super.setFields(fields);
                }

                public FindMatches setKey(String key) {
                    return (FindMatches)super.setKey(key);
                }

                public FindMatches setOauthToken(String oauthToken) {
                    return (FindMatches)super.setOauthToken(oauthToken);
                }

                public FindMatches setPrettyPrint(Boolean prettyPrint) {
                    return (FindMatches)super.setPrettyPrint(prettyPrint);
                }

                public FindMatches setQuotaUser(String quotaUser) {
                    return (FindMatches)super.setQuotaUser(quotaUser);
                }

                public FindMatches setUploadType(String uploadType) {
                    return (FindMatches)super.setUploadType(uploadType);
                }

                public FindMatches setUploadProtocol(String uploadProtocol) {
                    return (FindMatches)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public FindMatches setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public FindMatches set(String parameterName, Object value) {
                    return (FindMatches)super.set(parameterName, value);
                }
            }

            public class FetchVerificationOptions
            extends MyBusinessRequest<FetchVerificationOptionsResponse> {
                private static final String REST_PATH = "v4/{+name}:fetchVerificationOptions";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected FetchVerificationOptions(String name, FetchVerificationOptionsRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, FetchVerificationOptionsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public FetchVerificationOptions set$Xgafv(String $Xgafv) {
                    return (FetchVerificationOptions)super.set$Xgafv($Xgafv);
                }

                public FetchVerificationOptions setAccessToken(String accessToken) {
                    return (FetchVerificationOptions)super.setAccessToken(accessToken);
                }

                public FetchVerificationOptions setAlt(String alt) {
                    return (FetchVerificationOptions)super.setAlt(alt);
                }

                public FetchVerificationOptions setCallback(String callback) {
                    return (FetchVerificationOptions)super.setCallback(callback);
                }

                public FetchVerificationOptions setFields(String fields) {
                    return (FetchVerificationOptions)super.setFields(fields);
                }

                public FetchVerificationOptions setKey(String key) {
                    return (FetchVerificationOptions)super.setKey(key);
                }

                public FetchVerificationOptions setOauthToken(String oauthToken) {
                    return (FetchVerificationOptions)super.setOauthToken(oauthToken);
                }

                public FetchVerificationOptions setPrettyPrint(Boolean prettyPrint) {
                    return (FetchVerificationOptions)super.setPrettyPrint(prettyPrint);
                }

                public FetchVerificationOptions setQuotaUser(String quotaUser) {
                    return (FetchVerificationOptions)super.setQuotaUser(quotaUser);
                }

                public FetchVerificationOptions setUploadType(String uploadType) {
                    return (FetchVerificationOptions)super.setUploadType(uploadType);
                }

                public FetchVerificationOptions setUploadProtocol(String uploadProtocol) {
                    return (FetchVerificationOptions)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public FetchVerificationOptions setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public FetchVerificationOptions set(String parameterName, Object value) {
                    return (FetchVerificationOptions)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MyBusinessRequest<Empty> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MyBusinessRequest<Location> {
                private static final String REST_PATH = "v4/{+parent}/locations";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean validateOnly;
                @Key
                private String requestId;

                protected Create(String parent, Location content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Location.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public Boolean getValidateOnly() {
                    return this.validateOnly;
                }

                public Create setValidateOnly(Boolean validateOnly) {
                    this.validateOnly = validateOnly;
                    return this;
                }

                public String getRequestId() {
                    return this.requestId;
                }

                public Create setRequestId(String requestId) {
                    this.requestId = requestId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }

            public class ClearAssociation
            extends MyBusinessRequest<Empty> {
                private static final String REST_PATH = "v4/{+name}:clearAssociation";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected ClearAssociation(String name, ClearLocationAssociationRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public ClearAssociation set$Xgafv(String $Xgafv) {
                    return (ClearAssociation)super.set$Xgafv($Xgafv);
                }

                public ClearAssociation setAccessToken(String accessToken) {
                    return (ClearAssociation)super.setAccessToken(accessToken);
                }

                public ClearAssociation setAlt(String alt) {
                    return (ClearAssociation)super.setAlt(alt);
                }

                public ClearAssociation setCallback(String callback) {
                    return (ClearAssociation)super.setCallback(callback);
                }

                public ClearAssociation setFields(String fields) {
                    return (ClearAssociation)super.setFields(fields);
                }

                public ClearAssociation setKey(String key) {
                    return (ClearAssociation)super.setKey(key);
                }

                public ClearAssociation setOauthToken(String oauthToken) {
                    return (ClearAssociation)super.setOauthToken(oauthToken);
                }

                public ClearAssociation setPrettyPrint(Boolean prettyPrint) {
                    return (ClearAssociation)super.setPrettyPrint(prettyPrint);
                }

                public ClearAssociation setQuotaUser(String quotaUser) {
                    return (ClearAssociation)super.setQuotaUser(quotaUser);
                }

                public ClearAssociation setUploadType(String uploadType) {
                    return (ClearAssociation)super.setUploadType(uploadType);
                }

                public ClearAssociation setUploadProtocol(String uploadProtocol) {
                    return (ClearAssociation)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public ClearAssociation setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public ClearAssociation set(String parameterName, Object value) {
                    return (ClearAssociation)super.set(parameterName, value);
                }
            }

            public class BatchGetReviews
            extends MyBusinessRequest<BatchGetReviewsResponse> {
                private static final String REST_PATH = "v4/{+name}/locations:batchGetReviews";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected BatchGetReviews(String name, BatchGetReviewsRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, BatchGetReviewsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public BatchGetReviews set$Xgafv(String $Xgafv) {
                    return (BatchGetReviews)super.set$Xgafv($Xgafv);
                }

                public BatchGetReviews setAccessToken(String accessToken) {
                    return (BatchGetReviews)super.setAccessToken(accessToken);
                }

                public BatchGetReviews setAlt(String alt) {
                    return (BatchGetReviews)super.setAlt(alt);
                }

                public BatchGetReviews setCallback(String callback) {
                    return (BatchGetReviews)super.setCallback(callback);
                }

                public BatchGetReviews setFields(String fields) {
                    return (BatchGetReviews)super.setFields(fields);
                }

                public BatchGetReviews setKey(String key) {
                    return (BatchGetReviews)super.setKey(key);
                }

                public BatchGetReviews setOauthToken(String oauthToken) {
                    return (BatchGetReviews)super.setOauthToken(oauthToken);
                }

                public BatchGetReviews setPrettyPrint(Boolean prettyPrint) {
                    return (BatchGetReviews)super.setPrettyPrint(prettyPrint);
                }

                public BatchGetReviews setQuotaUser(String quotaUser) {
                    return (BatchGetReviews)super.setQuotaUser(quotaUser);
                }

                public BatchGetReviews setUploadType(String uploadType) {
                    return (BatchGetReviews)super.setUploadType(uploadType);
                }

                public BatchGetReviews setUploadProtocol(String uploadProtocol) {
                    return (BatchGetReviews)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public BatchGetReviews setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public BatchGetReviews set(String parameterName, Object value) {
                    return (BatchGetReviews)super.set(parameterName, value);
                }
            }

            public class BatchGet
            extends MyBusinessRequest<BatchGetLocationsResponse> {
                private static final String REST_PATH = "v4/{+name}/locations:batchGet";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected BatchGet(String name, BatchGetLocationsRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, BatchGetLocationsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public BatchGet set$Xgafv(String $Xgafv) {
                    return (BatchGet)super.set$Xgafv($Xgafv);
                }

                public BatchGet setAccessToken(String accessToken) {
                    return (BatchGet)super.setAccessToken(accessToken);
                }

                public BatchGet setAlt(String alt) {
                    return (BatchGet)super.setAlt(alt);
                }

                public BatchGet setCallback(String callback) {
                    return (BatchGet)super.setCallback(callback);
                }

                public BatchGet setFields(String fields) {
                    return (BatchGet)super.setFields(fields);
                }

                public BatchGet setKey(String key) {
                    return (BatchGet)super.setKey(key);
                }

                public BatchGet setOauthToken(String oauthToken) {
                    return (BatchGet)super.setOauthToken(oauthToken);
                }

                public BatchGet setPrettyPrint(Boolean prettyPrint) {
                    return (BatchGet)super.setPrettyPrint(prettyPrint);
                }

                public BatchGet setQuotaUser(String quotaUser) {
                    return (BatchGet)super.setQuotaUser(quotaUser);
                }

                public BatchGet setUploadType(String uploadType) {
                    return (BatchGet)super.setUploadType(uploadType);
                }

                public BatchGet setUploadProtocol(String uploadProtocol) {
                    return (BatchGet)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public BatchGet setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public BatchGet set(String parameterName, Object value) {
                    return (BatchGet)super.set(parameterName, value);
                }
            }

            public class Associate
            extends MyBusinessRequest<Empty> {
                private static final String REST_PATH = "v4/{+name}:associate";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Associate(String name, AssociateLocationRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/locations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                }

                public Associate set$Xgafv(String $Xgafv) {
                    return (Associate)super.set$Xgafv($Xgafv);
                }

                public Associate setAccessToken(String accessToken) {
                    return (Associate)super.setAccessToken(accessToken);
                }

                public Associate setAlt(String alt) {
                    return (Associate)super.setAlt(alt);
                }

                public Associate setCallback(String callback) {
                    return (Associate)super.setCallback(callback);
                }

                public Associate setFields(String fields) {
                    return (Associate)super.setFields(fields);
                }

                public Associate setKey(String key) {
                    return (Associate)super.setKey(key);
                }

                public Associate setOauthToken(String oauthToken) {
                    return (Associate)super.setOauthToken(oauthToken);
                }

                public Associate setPrettyPrint(Boolean prettyPrint) {
                    return (Associate)super.setPrettyPrint(prettyPrint);
                }

                public Associate setQuotaUser(String quotaUser) {
                    return (Associate)super.setQuotaUser(quotaUser);
                }

                public Associate setUploadType(String uploadType) {
                    return (Associate)super.setUploadType(uploadType);
                }

                public Associate setUploadProtocol(String uploadProtocol) {
                    return (Associate)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Associate setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/locations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Associate set(String parameterName, Object value) {
                    return (Associate)super.set(parameterName, value);
                }
            }
        }

        public class Invitations {
            public Accept accept(String name, AcceptInvitationRequest content) throws IOException {
                Accept result = new Accept(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Decline decline(String name, DeclineInvitationRequest content) throws IOException {
                Decline result = new Decline(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class List
            extends MyBusinessRequest<ListInvitationsResponse> {
                private static final String REST_PATH = "v4/{+parent}/invitations";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String targetType;

                protected List(String parent) {
                    super(MyBusiness.this, "GET", REST_PATH, null, ListInvitationsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                public String getTargetType() {
                    return this.targetType;
                }

                public List setTargetType(String targetType) {
                    this.targetType = targetType;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Decline
            extends MyBusinessRequest<Empty> {
                private static final String REST_PATH = "v4/{+name}:decline";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Decline(String name, DeclineInvitationRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/invitations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/invitations/[^/]+$");
                    }
                }

                public Decline set$Xgafv(String $Xgafv) {
                    return (Decline)super.set$Xgafv($Xgafv);
                }

                public Decline setAccessToken(String accessToken) {
                    return (Decline)super.setAccessToken(accessToken);
                }

                public Decline setAlt(String alt) {
                    return (Decline)super.setAlt(alt);
                }

                public Decline setCallback(String callback) {
                    return (Decline)super.setCallback(callback);
                }

                public Decline setFields(String fields) {
                    return (Decline)super.setFields(fields);
                }

                public Decline setKey(String key) {
                    return (Decline)super.setKey(key);
                }

                public Decline setOauthToken(String oauthToken) {
                    return (Decline)super.setOauthToken(oauthToken);
                }

                public Decline setPrettyPrint(Boolean prettyPrint) {
                    return (Decline)super.setPrettyPrint(prettyPrint);
                }

                public Decline setQuotaUser(String quotaUser) {
                    return (Decline)super.setQuotaUser(quotaUser);
                }

                public Decline setUploadType(String uploadType) {
                    return (Decline)super.setUploadType(uploadType);
                }

                public Decline setUploadProtocol(String uploadProtocol) {
                    return (Decline)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Decline setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/invitations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Decline set(String parameterName, Object value) {
                    return (Decline)super.set(parameterName, value);
                }
            }

            public class Accept
            extends MyBusinessRequest<Empty> {
                private static final String REST_PATH = "v4/{+name}:accept";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Accept(String name, AcceptInvitationRequest content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/invitations/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/invitations/[^/]+$");
                    }
                }

                public Accept set$Xgafv(String $Xgafv) {
                    return (Accept)super.set$Xgafv($Xgafv);
                }

                public Accept setAccessToken(String accessToken) {
                    return (Accept)super.setAccessToken(accessToken);
                }

                public Accept setAlt(String alt) {
                    return (Accept)super.setAlt(alt);
                }

                public Accept setCallback(String callback) {
                    return (Accept)super.setCallback(callback);
                }

                public Accept setFields(String fields) {
                    return (Accept)super.setFields(fields);
                }

                public Accept setKey(String key) {
                    return (Accept)super.setKey(key);
                }

                public Accept setOauthToken(String oauthToken) {
                    return (Accept)super.setOauthToken(oauthToken);
                }

                public Accept setPrettyPrint(Boolean prettyPrint) {
                    return (Accept)super.setPrettyPrint(prettyPrint);
                }

                public Accept setQuotaUser(String quotaUser) {
                    return (Accept)super.setQuotaUser(quotaUser);
                }

                public Accept setUploadType(String uploadType) {
                    return (Accept)super.setUploadType(uploadType);
                }

                public Accept setUploadProtocol(String uploadProtocol) {
                    return (Accept)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Accept setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/invitations/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Accept set(String parameterName, Object value) {
                    return (Accept)super.set(parameterName, value);
                }
            }
        }

        public class Admins {
            public Create create(String parent, Admin content) throws IOException {
                Create result = new Create(parent, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Delete delete(String name) throws IOException {
                Delete result = new Delete(name);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String parent) throws IOException {
                List result = new List(parent);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Patch patch(String name, Admin content) throws IOException {
                Patch result = new Patch(name, content);
                MyBusiness.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public class Patch
            extends MyBusinessRequest<Admin> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String name, Admin content) {
                    super(MyBusiness.this, "PATCH", REST_PATH, (Object)content, Admin.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/admins/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/admins/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String $Xgafv) {
                    return (Patch)super.set$Xgafv($Xgafv);
                }

                public Patch setAccessToken(String accessToken) {
                    return (Patch)super.setAccessToken(accessToken);
                }

                public Patch setAlt(String alt) {
                    return (Patch)super.setAlt(alt);
                }

                public Patch setCallback(String callback) {
                    return (Patch)super.setCallback(callback);
                }

                public Patch setFields(String fields) {
                    return (Patch)super.setFields(fields);
                }

                public Patch setKey(String key) {
                    return (Patch)super.setKey(key);
                }

                public Patch setOauthToken(String oauthToken) {
                    return (Patch)super.setOauthToken(oauthToken);
                }

                public Patch setPrettyPrint(Boolean prettyPrint) {
                    return (Patch)super.setPrettyPrint(prettyPrint);
                }

                public Patch setQuotaUser(String quotaUser) {
                    return (Patch)super.setQuotaUser(quotaUser);
                }

                public Patch setUploadType(String uploadType) {
                    return (Patch)super.setUploadType(uploadType);
                }

                public Patch setUploadProtocol(String uploadProtocol) {
                    return (Patch)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/admins/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Patch set(String parameterName, Object value) {
                    return (Patch)super.set(parameterName, value);
                }
            }

            public class List
            extends MyBusinessRequest<ListAccountAdminsResponse> {
                private static final String REST_PATH = "v4/{+parent}/admins";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected List(String parent) {
                    super(MyBusiness.this, "GET", REST_PATH, null, ListAccountAdminsResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String parent) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Delete
            extends MyBusinessRequest<Empty> {
                private static final String REST_PATH = "v4/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String name) {
                    super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/admins/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/admins/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String $Xgafv) {
                    return (Delete)super.set$Xgafv($Xgafv);
                }

                public Delete setAccessToken(String accessToken) {
                    return (Delete)super.setAccessToken(accessToken);
                }

                public Delete setAlt(String alt) {
                    return (Delete)super.setAlt(alt);
                }

                public Delete setCallback(String callback) {
                    return (Delete)super.setCallback(callback);
                }

                public Delete setFields(String fields) {
                    return (Delete)super.setFields(fields);
                }

                public Delete setKey(String key) {
                    return (Delete)super.setKey(key);
                }

                public Delete setOauthToken(String oauthToken) {
                    return (Delete)super.setOauthToken(oauthToken);
                }

                public Delete setPrettyPrint(Boolean prettyPrint) {
                    return (Delete)super.setPrettyPrint(prettyPrint);
                }

                public Delete setQuotaUser(String quotaUser) {
                    return (Delete)super.setQuotaUser(quotaUser);
                }

                public Delete setUploadType(String uploadType) {
                    return (Delete)super.setUploadType(uploadType);
                }

                public Delete setUploadProtocol(String uploadProtocol) {
                    return (Delete)super.setUploadProtocol(uploadProtocol);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String name) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/admins/[^/]+$");
                    }
                    this.name = name;
                    return this;
                }

                @Override
                public Delete set(String parameterName, Object value) {
                    return (Delete)super.set(parameterName, value);
                }
            }

            public class Create
            extends MyBusinessRequest<Admin> {
                private static final String REST_PATH = "v4/{+parent}/admins";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String parent, Admin content) {
                    super(MyBusiness.this, "POST", REST_PATH, (Object)content, Admin.class);
                    this.PARENT_PATTERN = Pattern.compile("^accounts/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)parent, (Object)"Required parameter parent must be specified.");
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String parent) {
                    if (!MyBusiness.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(parent).matches(), (Object)"Parameter parent must conform to the pattern ^accounts/[^/]+$");
                    }
                    this.parent = parent;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class UpdateNotifications
        extends MyBusinessRequest<Notifications> {
            private static final String REST_PATH = "v4/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected UpdateNotifications(String name, Notifications content) {
                super(MyBusiness.this, "PUT", REST_PATH, (Object)content, Notifications.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/notifications$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/notifications$");
                }
            }

            public UpdateNotifications set$Xgafv(String $Xgafv) {
                return (UpdateNotifications)super.set$Xgafv($Xgafv);
            }

            public UpdateNotifications setAccessToken(String accessToken) {
                return (UpdateNotifications)super.setAccessToken(accessToken);
            }

            public UpdateNotifications setAlt(String alt) {
                return (UpdateNotifications)super.setAlt(alt);
            }

            public UpdateNotifications setCallback(String callback) {
                return (UpdateNotifications)super.setCallback(callback);
            }

            public UpdateNotifications setFields(String fields) {
                return (UpdateNotifications)super.setFields(fields);
            }

            public UpdateNotifications setKey(String key) {
                return (UpdateNotifications)super.setKey(key);
            }

            public UpdateNotifications setOauthToken(String oauthToken) {
                return (UpdateNotifications)super.setOauthToken(oauthToken);
            }

            public UpdateNotifications setPrettyPrint(Boolean prettyPrint) {
                return (UpdateNotifications)super.setPrettyPrint(prettyPrint);
            }

            public UpdateNotifications setQuotaUser(String quotaUser) {
                return (UpdateNotifications)super.setQuotaUser(quotaUser);
            }

            public UpdateNotifications setUploadType(String uploadType) {
                return (UpdateNotifications)super.setUploadType(uploadType);
            }

            public UpdateNotifications setUploadProtocol(String uploadProtocol) {
                return (UpdateNotifications)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public UpdateNotifications setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/notifications$");
                }
                this.name = name;
                return this;
            }

            @Override
            public UpdateNotifications set(String parameterName, Object value) {
                return (UpdateNotifications)super.set(parameterName, value);
            }
        }

        public class Update
        extends MyBusinessRequest<Account> {
            private static final String REST_PATH = "v4/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private Boolean validateOnly;

            protected Update(String name, Account content) {
                super(MyBusiness.this, "PUT", REST_PATH, (Object)content, Account.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Update setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public Boolean getValidateOnly() {
                return this.validateOnly;
            }

            public Update setValidateOnly(Boolean validateOnly) {
                this.validateOnly = validateOnly;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class ListRecommendGoogleLocations
        extends MyBusinessRequest<ListRecommendedGoogleLocationsResponse> {
            private static final String REST_PATH = "v4/{+name}:recommendGoogleLocations";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected ListRecommendGoogleLocations(String name) {
                super(MyBusiness.this, "GET", REST_PATH, null, ListRecommendedGoogleLocationsResponse.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public ListRecommendGoogleLocations set$Xgafv(String $Xgafv) {
                return (ListRecommendGoogleLocations)super.set$Xgafv($Xgafv);
            }

            public ListRecommendGoogleLocations setAccessToken(String accessToken) {
                return (ListRecommendGoogleLocations)super.setAccessToken(accessToken);
            }

            public ListRecommendGoogleLocations setAlt(String alt) {
                return (ListRecommendGoogleLocations)super.setAlt(alt);
            }

            public ListRecommendGoogleLocations setCallback(String callback) {
                return (ListRecommendGoogleLocations)super.setCallback(callback);
            }

            public ListRecommendGoogleLocations setFields(String fields) {
                return (ListRecommendGoogleLocations)super.setFields(fields);
            }

            public ListRecommendGoogleLocations setKey(String key) {
                return (ListRecommendGoogleLocations)super.setKey(key);
            }

            public ListRecommendGoogleLocations setOauthToken(String oauthToken) {
                return (ListRecommendGoogleLocations)super.setOauthToken(oauthToken);
            }

            public ListRecommendGoogleLocations setPrettyPrint(Boolean prettyPrint) {
                return (ListRecommendGoogleLocations)super.setPrettyPrint(prettyPrint);
            }

            public ListRecommendGoogleLocations setQuotaUser(String quotaUser) {
                return (ListRecommendGoogleLocations)super.setQuotaUser(quotaUser);
            }

            public ListRecommendGoogleLocations setUploadType(String uploadType) {
                return (ListRecommendGoogleLocations)super.setUploadType(uploadType);
            }

            public ListRecommendGoogleLocations setUploadProtocol(String uploadProtocol) {
                return (ListRecommendGoogleLocations)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public ListRecommendGoogleLocations setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public ListRecommendGoogleLocations setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public ListRecommendGoogleLocations setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            @Override
            public ListRecommendGoogleLocations set(String parameterName, Object value) {
                return (ListRecommendGoogleLocations)super.set(parameterName, value);
            }
        }

        public class List
        extends MyBusinessRequest<ListAccountsResponse> {
            private static final String REST_PATH = "v4/accounts";
            @Key
            private String filter;
            @Key
            private String pageToken;
            @Key
            private String name;
            @Key
            private Integer pageSize;

            protected List(Accounts this$1) {
                super(this$1.MyBusiness.this, "GET", REST_PATH, null, ListAccountsResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getFilter() {
                return this.filter;
            }

            public List setFilter(String filter) {
                this.filter = filter;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public String getName() {
                return this.name;
            }

            public List setName(String name) {
                this.name = name;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer pageSize) {
                this.pageSize = pageSize;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class GetNotifications
        extends MyBusinessRequest<Notifications> {
            private static final String REST_PATH = "v4/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GetNotifications(String name) {
                super(MyBusiness.this, "GET", REST_PATH, null, Notifications.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/notifications$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/notifications$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetNotifications set$Xgafv(String $Xgafv) {
                return (GetNotifications)super.set$Xgafv($Xgafv);
            }

            public GetNotifications setAccessToken(String accessToken) {
                return (GetNotifications)super.setAccessToken(accessToken);
            }

            public GetNotifications setAlt(String alt) {
                return (GetNotifications)super.setAlt(alt);
            }

            public GetNotifications setCallback(String callback) {
                return (GetNotifications)super.setCallback(callback);
            }

            public GetNotifications setFields(String fields) {
                return (GetNotifications)super.setFields(fields);
            }

            public GetNotifications setKey(String key) {
                return (GetNotifications)super.setKey(key);
            }

            public GetNotifications setOauthToken(String oauthToken) {
                return (GetNotifications)super.setOauthToken(oauthToken);
            }

            public GetNotifications setPrettyPrint(Boolean prettyPrint) {
                return (GetNotifications)super.setPrettyPrint(prettyPrint);
            }

            public GetNotifications setQuotaUser(String quotaUser) {
                return (GetNotifications)super.setQuotaUser(quotaUser);
            }

            public GetNotifications setUploadType(String uploadType) {
                return (GetNotifications)super.setUploadType(uploadType);
            }

            public GetNotifications setUploadProtocol(String uploadProtocol) {
                return (GetNotifications)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GetNotifications setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/notifications$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GetNotifications set(String parameterName, Object value) {
                return (GetNotifications)super.set(parameterName, value);
            }
        }

        public class Get
        extends MyBusinessRequest<Account> {
            private static final String REST_PATH = "v4/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String name) {
                super(MyBusiness.this, "GET", REST_PATH, null, Account.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class GenerateAccountNumber
        extends MyBusinessRequest<Account> {
            private static final String REST_PATH = "v4/{+name}:generateAccountNumber";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected GenerateAccountNumber(String name, GenerateAccountNumberRequest content) {
                super(MyBusiness.this, "POST", REST_PATH, (Object)content, Account.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
            }

            public GenerateAccountNumber set$Xgafv(String $Xgafv) {
                return (GenerateAccountNumber)super.set$Xgafv($Xgafv);
            }

            public GenerateAccountNumber setAccessToken(String accessToken) {
                return (GenerateAccountNumber)super.setAccessToken(accessToken);
            }

            public GenerateAccountNumber setAlt(String alt) {
                return (GenerateAccountNumber)super.setAlt(alt);
            }

            public GenerateAccountNumber setCallback(String callback) {
                return (GenerateAccountNumber)super.setCallback(callback);
            }

            public GenerateAccountNumber setFields(String fields) {
                return (GenerateAccountNumber)super.setFields(fields);
            }

            public GenerateAccountNumber setKey(String key) {
                return (GenerateAccountNumber)super.setKey(key);
            }

            public GenerateAccountNumber setOauthToken(String oauthToken) {
                return (GenerateAccountNumber)super.setOauthToken(oauthToken);
            }

            public GenerateAccountNumber setPrettyPrint(Boolean prettyPrint) {
                return (GenerateAccountNumber)super.setPrettyPrint(prettyPrint);
            }

            public GenerateAccountNumber setQuotaUser(String quotaUser) {
                return (GenerateAccountNumber)super.setQuotaUser(quotaUser);
            }

            public GenerateAccountNumber setUploadType(String uploadType) {
                return (GenerateAccountNumber)super.setUploadType(uploadType);
            }

            public GenerateAccountNumber setUploadProtocol(String uploadProtocol) {
                return (GenerateAccountNumber)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public GenerateAccountNumber setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+$");
                }
                this.name = name;
                return this;
            }

            @Override
            public GenerateAccountNumber set(String parameterName, Object value) {
                return (GenerateAccountNumber)super.set(parameterName, value);
            }
        }

        public class DeleteNotifications
        extends MyBusinessRequest<Empty> {
            private static final String REST_PATH = "v4/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected DeleteNotifications(String name) {
                super(MyBusiness.this, "DELETE", REST_PATH, null, Empty.class);
                this.NAME_PATTERN = Pattern.compile("^accounts/[^/]+/notifications$");
                this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/notifications$");
                }
            }

            public DeleteNotifications set$Xgafv(String $Xgafv) {
                return (DeleteNotifications)super.set$Xgafv($Xgafv);
            }

            public DeleteNotifications setAccessToken(String accessToken) {
                return (DeleteNotifications)super.setAccessToken(accessToken);
            }

            public DeleteNotifications setAlt(String alt) {
                return (DeleteNotifications)super.setAlt(alt);
            }

            public DeleteNotifications setCallback(String callback) {
                return (DeleteNotifications)super.setCallback(callback);
            }

            public DeleteNotifications setFields(String fields) {
                return (DeleteNotifications)super.setFields(fields);
            }

            public DeleteNotifications setKey(String key) {
                return (DeleteNotifications)super.setKey(key);
            }

            public DeleteNotifications setOauthToken(String oauthToken) {
                return (DeleteNotifications)super.setOauthToken(oauthToken);
            }

            public DeleteNotifications setPrettyPrint(Boolean prettyPrint) {
                return (DeleteNotifications)super.setPrettyPrint(prettyPrint);
            }

            public DeleteNotifications setQuotaUser(String quotaUser) {
                return (DeleteNotifications)super.setQuotaUser(quotaUser);
            }

            public DeleteNotifications setUploadType(String uploadType) {
                return (DeleteNotifications)super.setUploadType(uploadType);
            }

            public DeleteNotifications setUploadProtocol(String uploadProtocol) {
                return (DeleteNotifications)super.setUploadProtocol(uploadProtocol);
            }

            public String getName() {
                return this.name;
            }

            public DeleteNotifications setName(String name) {
                if (!MyBusiness.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^accounts/[^/]+/notifications$");
                }
                this.name = name;
                return this;
            }

            @Override
            public DeleteNotifications set(String parameterName, Object value) {
                return (DeleteNotifications)super.set(parameterName, value);
            }
        }

        public class Create
        extends MyBusinessRequest<Account> {
            private static final String REST_PATH = "v4/accounts";
            @Key
            private String primaryOwner;

            protected Create(Accounts this$1, Account content) {
                super(this$1.MyBusiness.this, "POST", REST_PATH, (Object)content, Account.class);
            }

            public Create set$Xgafv(String $Xgafv) {
                return (Create)super.set$Xgafv($Xgafv);
            }

            public Create setAccessToken(String accessToken) {
                return (Create)super.setAccessToken(accessToken);
            }

            public Create setAlt(String alt) {
                return (Create)super.setAlt(alt);
            }

            public Create setCallback(String callback) {
                return (Create)super.setCallback(callback);
            }

            public Create setFields(String fields) {
                return (Create)super.setFields(fields);
            }

            public Create setKey(String key) {
                return (Create)super.setKey(key);
            }

            public Create setOauthToken(String oauthToken) {
                return (Create)super.setOauthToken(oauthToken);
            }

            public Create setPrettyPrint(Boolean prettyPrint) {
                return (Create)super.setPrettyPrint(prettyPrint);
            }

            public Create setQuotaUser(String quotaUser) {
                return (Create)super.setQuotaUser(quotaUser);
            }

            public Create setUploadType(String uploadType) {
                return (Create)super.setUploadType(uploadType);
            }

            public Create setUploadProtocol(String uploadProtocol) {
                return (Create)super.setUploadProtocol(uploadProtocol);
            }

            public String getPrimaryOwner() {
                return this.primaryOwner;
            }

            public Create setPrimaryOwner(String primaryOwner) {
                this.primaryOwner = primaryOwner;
                return this;
            }

            @Override
            public Create set(String parameterName, Object value) {
                return (Create)super.set(parameterName, value);
            }
        }
    }
}

