/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Request message for Verifications.FetchVerificationOptions.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FetchVerificationOptionsRequest extends com.google.api.client.json.GenericJson {

  /**
   * Extra context information for the verification of service businesses. Required for the
   * locations whose business type is CUSTOMER_LOCATION_ONLY. INVALID_ARGUMENT will be thrown if it
   * is set for other business types of locations.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ServiceBusinessContext context;

  /**
   * The BCP 47 language code representing the language that is to be used for the verification
   * process. Available options vary by language.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String languageCode;

  /**
   * Extra context information for the verification of service businesses. Required for the
   * locations whose business type is CUSTOMER_LOCATION_ONLY. INVALID_ARGUMENT will be thrown if it
   * is set for other business types of locations.
   * @return value or {@code null} for none
   */
  public ServiceBusinessContext getContext() {
    return context;
  }

  /**
   * Extra context information for the verification of service businesses. Required for the
   * locations whose business type is CUSTOMER_LOCATION_ONLY. INVALID_ARGUMENT will be thrown if it
   * is set for other business types of locations.
   * @param context context or {@code null} for none
   */
  public FetchVerificationOptionsRequest setContext(ServiceBusinessContext context) {
    this.context = context;
    return this;
  }

  /**
   * The BCP 47 language code representing the language that is to be used for the verification
   * process. Available options vary by language.
   * @return value or {@code null} for none
   */
  public java.lang.String getLanguageCode() {
    return languageCode;
  }

  /**
   * The BCP 47 language code representing the language that is to be used for the verification
   * process. Available options vary by language.
   * @param languageCode languageCode or {@code null} for none
   */
  public FetchVerificationOptionsRequest setLanguageCode(java.lang.String languageCode) {
    this.languageCode = languageCode;
    return this;
  }

  @Override
  public FetchVerificationOptionsRequest set(String fieldName, Object value) {
    return (FetchVerificationOptionsRequest) super.set(fieldName, value);
  }

  @Override
  public FetchVerificationOptionsRequest clone() {
    return (FetchVerificationOptionsRequest) super.clone();
  }

}
