/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Display data for verifications through postcard.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AddressVerificationData extends com.google.api.client.json.GenericJson {

  /**
   * Address that a postcard can be sent to.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PostalAddress address;

  /**
   * Merchant's business name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String businessName;

  /**
   * Address that a postcard can be sent to.
   * @return value or {@code null} for none
   */
  public PostalAddress getAddress() {
    return address;
  }

  /**
   * Address that a postcard can be sent to.
   * @param address address or {@code null} for none
   */
  public AddressVerificationData setAddress(PostalAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Merchant's business name.
   * @return value or {@code null} for none
   */
  public java.lang.String getBusinessName() {
    return businessName;
  }

  /**
   * Merchant's business name.
   * @param businessName businessName or {@code null} for none
   */
  public AddressVerificationData setBusinessName(java.lang.String businessName) {
    this.businessName = businessName;
    return this;
  }

  @Override
  public AddressVerificationData set(String fieldName, Object value) {
    return (AddressVerificationData) super.set(fieldName, value);
  }

  @Override
  public AddressVerificationData clone() {
    return (AddressVerificationData) super.clone();
  }

}
