/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Features and available amenities in the guest unit.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GuestUnitFeatures extends com.google.api.client.json.GenericJson {

  /**
   * Bungalow or villa. An independent structure that is part of a hotel or resort that is rented to
   * one party for a vacation stay. The hotel or resort may be completely comprised of bungalows or
   * villas, or they may be one of several guestroom options. Guests in the bungalows or villas most
   * often have the same, if not more, amenities and services offered to guests in other guestroom
   * types.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean bungalowOrVilla;

  /**
   * Bungalow or villa exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String bungalowOrVillaException;

  /**
   * Connecting unit available. A guestroom type that features access to an adjacent guestroom for
   * the purpose of booking both rooms. Most often used by families who need more than one room to
   * accommodate the number of people in their group.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean connectingUnitAvailable;

  /**
   * Connecting unit available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String connectingUnitAvailableException;

  /**
   * Executive floor. A floor of the hotel where the guestrooms are only bookable by members of the
   * hotel's frequent guest membership program. Benefits of this room class include access to a
   * designated lounge which may or may not feature free breakfast, cocktails or other perks
   * specific to members of the program.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean executiveFloor;

  /**
   * Executive floor exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String executiveFloorException;

  /**
   * Max adult occupants count. The total number of adult guests allowed to stay overnight in the
   * guestroom.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxAdultOccupantsCount;

  /**
   * Max adult occupants count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxAdultOccupantsCountException;

  /**
   * Max child occupants count. The total number of children allowed to stay overnight in the room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxChildOccupantsCount;

  /**
   * Max child occupants count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxChildOccupantsCountException;

  /**
   * Max occupants count. The total number of guests allowed to stay overnight in the guestroom.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxOccupantsCount;

  /**
   * Max occupants count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxOccupantsCountException;

  /**
   * Private home. A privately owned home (house, townhouse, apartment, cabin, bungalow etc) that
   * may or not serve as the owner's residence, but is rented out in its entirety or by the room(s)
   * to paying guest(s) for vacation stays. Not for lease-based, long-term residency.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean privateHome;

  /**
   * Private home exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privateHomeException;

  /**
   * Suite. A guestroom category that implies both a bedroom area and a separate living area. There
   * may or may not be full walls and doors separating the two areas, but regardless, they are very
   * distinct. Does not mean a couch or chair in a bedroom.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean suite;

  /**
   * Suite exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String suiteException;

  /**
   * Tier. Classification of the unit based on available features/amenities. A non-standard tier is
   * only permitted if at least one other unit type falls under the standard tier.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tier;

  /**
   * Tier exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String tierException;

  /**
   * Features available in the living areas in the guest unit.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private LivingArea totalLivingAreas;

  /**
   * Views available from the guest unit itself.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ViewsFromUnit views;

  /**
   * Bungalow or villa. An independent structure that is part of a hotel or resort that is rented to
   * one party for a vacation stay. The hotel or resort may be completely comprised of bungalows or
   * villas, or they may be one of several guestroom options. Guests in the bungalows or villas most
   * often have the same, if not more, amenities and services offered to guests in other guestroom
   * types.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBungalowOrVilla() {
    return bungalowOrVilla;
  }

  /**
   * Bungalow or villa. An independent structure that is part of a hotel or resort that is rented to
   * one party for a vacation stay. The hotel or resort may be completely comprised of bungalows or
   * villas, or they may be one of several guestroom options. Guests in the bungalows or villas most
   * often have the same, if not more, amenities and services offered to guests in other guestroom
   * types.
   * @param bungalowOrVilla bungalowOrVilla or {@code null} for none
   */
  public GuestUnitFeatures setBungalowOrVilla(java.lang.Boolean bungalowOrVilla) {
    this.bungalowOrVilla = bungalowOrVilla;
    return this;
  }

  /**
   * Bungalow or villa exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getBungalowOrVillaException() {
    return bungalowOrVillaException;
  }

  /**
   * Bungalow or villa exception.
   * @param bungalowOrVillaException bungalowOrVillaException or {@code null} for none
   */
  public GuestUnitFeatures setBungalowOrVillaException(java.lang.String bungalowOrVillaException) {
    this.bungalowOrVillaException = bungalowOrVillaException;
    return this;
  }

  /**
   * Connecting unit available. A guestroom type that features access to an adjacent guestroom for
   * the purpose of booking both rooms. Most often used by families who need more than one room to
   * accommodate the number of people in their group.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getConnectingUnitAvailable() {
    return connectingUnitAvailable;
  }

  /**
   * Connecting unit available. A guestroom type that features access to an adjacent guestroom for
   * the purpose of booking both rooms. Most often used by families who need more than one room to
   * accommodate the number of people in their group.
   * @param connectingUnitAvailable connectingUnitAvailable or {@code null} for none
   */
  public GuestUnitFeatures setConnectingUnitAvailable(java.lang.Boolean connectingUnitAvailable) {
    this.connectingUnitAvailable = connectingUnitAvailable;
    return this;
  }

  /**
   * Connecting unit available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getConnectingUnitAvailableException() {
    return connectingUnitAvailableException;
  }

  /**
   * Connecting unit available exception.
   * @param connectingUnitAvailableException connectingUnitAvailableException or {@code null} for none
   */
  public GuestUnitFeatures setConnectingUnitAvailableException(java.lang.String connectingUnitAvailableException) {
    this.connectingUnitAvailableException = connectingUnitAvailableException;
    return this;
  }

  /**
   * Executive floor. A floor of the hotel where the guestrooms are only bookable by members of the
   * hotel's frequent guest membership program. Benefits of this room class include access to a
   * designated lounge which may or may not feature free breakfast, cocktails or other perks
   * specific to members of the program.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getExecutiveFloor() {
    return executiveFloor;
  }

  /**
   * Executive floor. A floor of the hotel where the guestrooms are only bookable by members of the
   * hotel's frequent guest membership program. Benefits of this room class include access to a
   * designated lounge which may or may not feature free breakfast, cocktails or other perks
   * specific to members of the program.
   * @param executiveFloor executiveFloor or {@code null} for none
   */
  public GuestUnitFeatures setExecutiveFloor(java.lang.Boolean executiveFloor) {
    this.executiveFloor = executiveFloor;
    return this;
  }

  /**
   * Executive floor exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getExecutiveFloorException() {
    return executiveFloorException;
  }

  /**
   * Executive floor exception.
   * @param executiveFloorException executiveFloorException or {@code null} for none
   */
  public GuestUnitFeatures setExecutiveFloorException(java.lang.String executiveFloorException) {
    this.executiveFloorException = executiveFloorException;
    return this;
  }

  /**
   * Max adult occupants count. The total number of adult guests allowed to stay overnight in the
   * guestroom.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxAdultOccupantsCount() {
    return maxAdultOccupantsCount;
  }

  /**
   * Max adult occupants count. The total number of adult guests allowed to stay overnight in the
   * guestroom.
   * @param maxAdultOccupantsCount maxAdultOccupantsCount or {@code null} for none
   */
  public GuestUnitFeatures setMaxAdultOccupantsCount(java.lang.Integer maxAdultOccupantsCount) {
    this.maxAdultOccupantsCount = maxAdultOccupantsCount;
    return this;
  }

  /**
   * Max adult occupants count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxAdultOccupantsCountException() {
    return maxAdultOccupantsCountException;
  }

  /**
   * Max adult occupants count exception.
   * @param maxAdultOccupantsCountException maxAdultOccupantsCountException or {@code null} for none
   */
  public GuestUnitFeatures setMaxAdultOccupantsCountException(java.lang.String maxAdultOccupantsCountException) {
    this.maxAdultOccupantsCountException = maxAdultOccupantsCountException;
    return this;
  }

  /**
   * Max child occupants count. The total number of children allowed to stay overnight in the room.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxChildOccupantsCount() {
    return maxChildOccupantsCount;
  }

  /**
   * Max child occupants count. The total number of children allowed to stay overnight in the room.
   * @param maxChildOccupantsCount maxChildOccupantsCount or {@code null} for none
   */
  public GuestUnitFeatures setMaxChildOccupantsCount(java.lang.Integer maxChildOccupantsCount) {
    this.maxChildOccupantsCount = maxChildOccupantsCount;
    return this;
  }

  /**
   * Max child occupants count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxChildOccupantsCountException() {
    return maxChildOccupantsCountException;
  }

  /**
   * Max child occupants count exception.
   * @param maxChildOccupantsCountException maxChildOccupantsCountException or {@code null} for none
   */
  public GuestUnitFeatures setMaxChildOccupantsCountException(java.lang.String maxChildOccupantsCountException) {
    this.maxChildOccupantsCountException = maxChildOccupantsCountException;
    return this;
  }

  /**
   * Max occupants count. The total number of guests allowed to stay overnight in the guestroom.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxOccupantsCount() {
    return maxOccupantsCount;
  }

  /**
   * Max occupants count. The total number of guests allowed to stay overnight in the guestroom.
   * @param maxOccupantsCount maxOccupantsCount or {@code null} for none
   */
  public GuestUnitFeatures setMaxOccupantsCount(java.lang.Integer maxOccupantsCount) {
    this.maxOccupantsCount = maxOccupantsCount;
    return this;
  }

  /**
   * Max occupants count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxOccupantsCountException() {
    return maxOccupantsCountException;
  }

  /**
   * Max occupants count exception.
   * @param maxOccupantsCountException maxOccupantsCountException or {@code null} for none
   */
  public GuestUnitFeatures setMaxOccupantsCountException(java.lang.String maxOccupantsCountException) {
    this.maxOccupantsCountException = maxOccupantsCountException;
    return this;
  }

  /**
   * Private home. A privately owned home (house, townhouse, apartment, cabin, bungalow etc) that
   * may or not serve as the owner's residence, but is rented out in its entirety or by the room(s)
   * to paying guest(s) for vacation stays. Not for lease-based, long-term residency.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPrivateHome() {
    return privateHome;
  }

  /**
   * Private home. A privately owned home (house, townhouse, apartment, cabin, bungalow etc) that
   * may or not serve as the owner's residence, but is rented out in its entirety or by the room(s)
   * to paying guest(s) for vacation stays. Not for lease-based, long-term residency.
   * @param privateHome privateHome or {@code null} for none
   */
  public GuestUnitFeatures setPrivateHome(java.lang.Boolean privateHome) {
    this.privateHome = privateHome;
    return this;
  }

  /**
   * Private home exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivateHomeException() {
    return privateHomeException;
  }

  /**
   * Private home exception.
   * @param privateHomeException privateHomeException or {@code null} for none
   */
  public GuestUnitFeatures setPrivateHomeException(java.lang.String privateHomeException) {
    this.privateHomeException = privateHomeException;
    return this;
  }

  /**
   * Suite. A guestroom category that implies both a bedroom area and a separate living area. There
   * may or may not be full walls and doors separating the two areas, but regardless, they are very
   * distinct. Does not mean a couch or chair in a bedroom.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSuite() {
    return suite;
  }

  /**
   * Suite. A guestroom category that implies both a bedroom area and a separate living area. There
   * may or may not be full walls and doors separating the two areas, but regardless, they are very
   * distinct. Does not mean a couch or chair in a bedroom.
   * @param suite suite or {@code null} for none
   */
  public GuestUnitFeatures setSuite(java.lang.Boolean suite) {
    this.suite = suite;
    return this;
  }

  /**
   * Suite exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSuiteException() {
    return suiteException;
  }

  /**
   * Suite exception.
   * @param suiteException suiteException or {@code null} for none
   */
  public GuestUnitFeatures setSuiteException(java.lang.String suiteException) {
    this.suiteException = suiteException;
    return this;
  }

  /**
   * Tier. Classification of the unit based on available features/amenities. A non-standard tier is
   * only permitted if at least one other unit type falls under the standard tier.
   * @return value or {@code null} for none
   */
  public java.lang.String getTier() {
    return tier;
  }

  /**
   * Tier. Classification of the unit based on available features/amenities. A non-standard tier is
   * only permitted if at least one other unit type falls under the standard tier.
   * @param tier tier or {@code null} for none
   */
  public GuestUnitFeatures setTier(java.lang.String tier) {
    this.tier = tier;
    return this;
  }

  /**
   * Tier exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getTierException() {
    return tierException;
  }

  /**
   * Tier exception.
   * @param tierException tierException or {@code null} for none
   */
  public GuestUnitFeatures setTierException(java.lang.String tierException) {
    this.tierException = tierException;
    return this;
  }

  /**
   * Features available in the living areas in the guest unit.
   * @return value or {@code null} for none
   */
  public LivingArea getTotalLivingAreas() {
    return totalLivingAreas;
  }

  /**
   * Features available in the living areas in the guest unit.
   * @param totalLivingAreas totalLivingAreas or {@code null} for none
   */
  public GuestUnitFeatures setTotalLivingAreas(LivingArea totalLivingAreas) {
    this.totalLivingAreas = totalLivingAreas;
    return this;
  }

  /**
   * Views available from the guest unit itself.
   * @return value or {@code null} for none
   */
  public ViewsFromUnit getViews() {
    return views;
  }

  /**
   * Views available from the guest unit itself.
   * @param views views or {@code null} for none
   */
  public GuestUnitFeatures setViews(ViewsFromUnit views) {
    this.views = views;
    return this;
  }

  @Override
  public GuestUnitFeatures set(String fieldName, Object value) {
    return (GuestUnitFeatures) super.set(fieldName, value);
  }

  @Override
  public GuestUnitFeatures clone() {
    return (GuestUnitFeatures) super.clone();
  }

}
