/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for ListLocalPosts
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ListLocalPostsResponse extends com.google.api.client.json.GenericJson {

  /**
   * The returned list of local posts.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<LocalPost> localPosts;

  static {
    // hack to force ProGuard to consider LocalPost used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(LocalPost.class);
  }

  /**
   * If there are more local posts than the requested page size, then this field is populated with a
   * token to fetch the next page of local posts on a subsequent call to `ListLocalPosts`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String nextPageToken;

  /**
   * The returned list of local posts.
   * @return value or {@code null} for none
   */
  public java.util.List<LocalPost> getLocalPosts() {
    return localPosts;
  }

  /**
   * The returned list of local posts.
   * @param localPosts localPosts or {@code null} for none
   */
  public ListLocalPostsResponse setLocalPosts(java.util.List<LocalPost> localPosts) {
    this.localPosts = localPosts;
    return this;
  }

  /**
   * If there are more local posts than the requested page size, then this field is populated with a
   * token to fetch the next page of local posts on a subsequent call to `ListLocalPosts`.
   * @return value or {@code null} for none
   */
  public java.lang.String getNextPageToken() {
    return nextPageToken;
  }

  /**
   * If there are more local posts than the requested page size, then this field is populated with a
   * token to fetch the next page of local posts on a subsequent call to `ListLocalPosts`.
   * @param nextPageToken nextPageToken or {@code null} for none
   */
  public ListLocalPostsResponse setNextPageToken(java.lang.String nextPageToken) {
    this.nextPageToken = nextPageToken;
    return this;
  }

  @Override
  public ListLocalPostsResponse set(String fieldName, Object value) {
    return (ListLocalPostsResponse) super.set(fieldName, value);
  }

  @Override
  public ListLocalPostsResponse clone() {
    return (ListLocalPostsResponse) super.clone();
  }

}
