/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Enhanced cleaning measures implemented by the hotel during COVID-19.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EnhancedCleaning extends com.google.api.client.json.GenericJson {

  /**
   * Commercial-grade disinfectant used to clean the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean commercialGradeDisinfectantCleaning;

  /**
   * Commercial grade disinfectant cleaning exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commercialGradeDisinfectantCleaningException;

  /**
   * Enhanced cleaning of common areas.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean commonAreasEnhancedCleaning;

  /**
   * Common areas enhanced cleaning exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String commonAreasEnhancedCleaningException;

  /**
   * Employees trained in COVID-19 cleaning procedures.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean employeesTrainedCleaningProcedures;

  /**
   * Employees trained cleaning procedures exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String employeesTrainedCleaningProceduresException;

  /**
   * Employees trained in thorough hand-washing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean employeesTrainedThoroughHandWashing;

  /**
   * Employees trained thorough hand washing exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String employeesTrainedThoroughHandWashingException;

  /**
   * Employees wear masks, face shields, and/or gloves.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean employeesWearProtectiveEquipment;

  /**
   * Employees wear protective equipment exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String employeesWearProtectiveEquipmentException;

  /**
   * Enhanced cleaning of guest rooms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean guestRoomsEnhancedCleaning;

  /**
   * Guest rooms enhanced cleaning exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String guestRoomsEnhancedCleaningException;

  /**
   * Commercial-grade disinfectant used to clean the property.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCommercialGradeDisinfectantCleaning() {
    return commercialGradeDisinfectantCleaning;
  }

  /**
   * Commercial-grade disinfectant used to clean the property.
   * @param commercialGradeDisinfectantCleaning commercialGradeDisinfectantCleaning or {@code null} for none
   */
  public EnhancedCleaning setCommercialGradeDisinfectantCleaning(java.lang.Boolean commercialGradeDisinfectantCleaning) {
    this.commercialGradeDisinfectantCleaning = commercialGradeDisinfectantCleaning;
    return this;
  }

  /**
   * Commercial grade disinfectant cleaning exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommercialGradeDisinfectantCleaningException() {
    return commercialGradeDisinfectantCleaningException;
  }

  /**
   * Commercial grade disinfectant cleaning exception.
   * @param commercialGradeDisinfectantCleaningException commercialGradeDisinfectantCleaningException or {@code null} for none
   */
  public EnhancedCleaning setCommercialGradeDisinfectantCleaningException(java.lang.String commercialGradeDisinfectantCleaningException) {
    this.commercialGradeDisinfectantCleaningException = commercialGradeDisinfectantCleaningException;
    return this;
  }

  /**
   * Enhanced cleaning of common areas.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCommonAreasEnhancedCleaning() {
    return commonAreasEnhancedCleaning;
  }

  /**
   * Enhanced cleaning of common areas.
   * @param commonAreasEnhancedCleaning commonAreasEnhancedCleaning or {@code null} for none
   */
  public EnhancedCleaning setCommonAreasEnhancedCleaning(java.lang.Boolean commonAreasEnhancedCleaning) {
    this.commonAreasEnhancedCleaning = commonAreasEnhancedCleaning;
    return this;
  }

  /**
   * Common areas enhanced cleaning exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCommonAreasEnhancedCleaningException() {
    return commonAreasEnhancedCleaningException;
  }

  /**
   * Common areas enhanced cleaning exception.
   * @param commonAreasEnhancedCleaningException commonAreasEnhancedCleaningException or {@code null} for none
   */
  public EnhancedCleaning setCommonAreasEnhancedCleaningException(java.lang.String commonAreasEnhancedCleaningException) {
    this.commonAreasEnhancedCleaningException = commonAreasEnhancedCleaningException;
    return this;
  }

  /**
   * Employees trained in COVID-19 cleaning procedures.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmployeesTrainedCleaningProcedures() {
    return employeesTrainedCleaningProcedures;
  }

  /**
   * Employees trained in COVID-19 cleaning procedures.
   * @param employeesTrainedCleaningProcedures employeesTrainedCleaningProcedures or {@code null} for none
   */
  public EnhancedCleaning setEmployeesTrainedCleaningProcedures(java.lang.Boolean employeesTrainedCleaningProcedures) {
    this.employeesTrainedCleaningProcedures = employeesTrainedCleaningProcedures;
    return this;
  }

  /**
   * Employees trained cleaning procedures exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmployeesTrainedCleaningProceduresException() {
    return employeesTrainedCleaningProceduresException;
  }

  /**
   * Employees trained cleaning procedures exception.
   * @param employeesTrainedCleaningProceduresException employeesTrainedCleaningProceduresException or {@code null} for none
   */
  public EnhancedCleaning setEmployeesTrainedCleaningProceduresException(java.lang.String employeesTrainedCleaningProceduresException) {
    this.employeesTrainedCleaningProceduresException = employeesTrainedCleaningProceduresException;
    return this;
  }

  /**
   * Employees trained in thorough hand-washing.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmployeesTrainedThoroughHandWashing() {
    return employeesTrainedThoroughHandWashing;
  }

  /**
   * Employees trained in thorough hand-washing.
   * @param employeesTrainedThoroughHandWashing employeesTrainedThoroughHandWashing or {@code null} for none
   */
  public EnhancedCleaning setEmployeesTrainedThoroughHandWashing(java.lang.Boolean employeesTrainedThoroughHandWashing) {
    this.employeesTrainedThoroughHandWashing = employeesTrainedThoroughHandWashing;
    return this;
  }

  /**
   * Employees trained thorough hand washing exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmployeesTrainedThoroughHandWashingException() {
    return employeesTrainedThoroughHandWashingException;
  }

  /**
   * Employees trained thorough hand washing exception.
   * @param employeesTrainedThoroughHandWashingException employeesTrainedThoroughHandWashingException or {@code null} for none
   */
  public EnhancedCleaning setEmployeesTrainedThoroughHandWashingException(java.lang.String employeesTrainedThoroughHandWashingException) {
    this.employeesTrainedThoroughHandWashingException = employeesTrainedThoroughHandWashingException;
    return this;
  }

  /**
   * Employees wear masks, face shields, and/or gloves.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEmployeesWearProtectiveEquipment() {
    return employeesWearProtectiveEquipment;
  }

  /**
   * Employees wear masks, face shields, and/or gloves.
   * @param employeesWearProtectiveEquipment employeesWearProtectiveEquipment or {@code null} for none
   */
  public EnhancedCleaning setEmployeesWearProtectiveEquipment(java.lang.Boolean employeesWearProtectiveEquipment) {
    this.employeesWearProtectiveEquipment = employeesWearProtectiveEquipment;
    return this;
  }

  /**
   * Employees wear protective equipment exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getEmployeesWearProtectiveEquipmentException() {
    return employeesWearProtectiveEquipmentException;
  }

  /**
   * Employees wear protective equipment exception.
   * @param employeesWearProtectiveEquipmentException employeesWearProtectiveEquipmentException or {@code null} for none
   */
  public EnhancedCleaning setEmployeesWearProtectiveEquipmentException(java.lang.String employeesWearProtectiveEquipmentException) {
    this.employeesWearProtectiveEquipmentException = employeesWearProtectiveEquipmentException;
    return this;
  }

  /**
   * Enhanced cleaning of guest rooms.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getGuestRoomsEnhancedCleaning() {
    return guestRoomsEnhancedCleaning;
  }

  /**
   * Enhanced cleaning of guest rooms.
   * @param guestRoomsEnhancedCleaning guestRoomsEnhancedCleaning or {@code null} for none
   */
  public EnhancedCleaning setGuestRoomsEnhancedCleaning(java.lang.Boolean guestRoomsEnhancedCleaning) {
    this.guestRoomsEnhancedCleaning = guestRoomsEnhancedCleaning;
    return this;
  }

  /**
   * Guest rooms enhanced cleaning exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getGuestRoomsEnhancedCleaningException() {
    return guestRoomsEnhancedCleaningException;
  }

  /**
   * Guest rooms enhanced cleaning exception.
   * @param guestRoomsEnhancedCleaningException guestRoomsEnhancedCleaningException or {@code null} for none
   */
  public EnhancedCleaning setGuestRoomsEnhancedCleaningException(java.lang.String guestRoomsEnhancedCleaningException) {
    this.guestRoomsEnhancedCleaningException = guestRoomsEnhancedCleaningException;
    return this;
  }

  @Override
  public EnhancedCleaning set(String fieldName, Object value) {
    return (EnhancedCleaning) super.set(fieldName, value);
  }

  @Override
  public EnhancedCleaning clone() {
    return (EnhancedCleaning) super.clone();
  }

}
