/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Represents a free-form service offered by the merchant. These are services that are not exposed
 * as part of our structure service data. The merchant manually enters the names for of such
 * services via a geomerchant surface.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FreeFormServiceItem extends com.google.api.client.json.GenericJson {

  /**
   * Required. The `category_id` and `service_type_id` should match the possible combinations
   * provided in the `Category` message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String categoryId;

  /**
   * Required. Language-tagged labels for the item. We recommend that item names be 140 characters
   * or less, and descriptions 250 characters or less. This field should only be set if the input is
   * a custom service item. Standardized service types should be updated via service_type_id.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Label label;

  /**
   * Required. The `category_id` and `service_type_id` should match the possible combinations
   * provided in the `Category` message.
   * @return value or {@code null} for none
   */
  public java.lang.String getCategoryId() {
    return categoryId;
  }

  /**
   * Required. The `category_id` and `service_type_id` should match the possible combinations
   * provided in the `Category` message.
   * @param categoryId categoryId or {@code null} for none
   */
  public FreeFormServiceItem setCategoryId(java.lang.String categoryId) {
    this.categoryId = categoryId;
    return this;
  }

  /**
   * Required. Language-tagged labels for the item. We recommend that item names be 140 characters
   * or less, and descriptions 250 characters or less. This field should only be set if the input is
   * a custom service item. Standardized service types should be updated via service_type_id.
   * @return value or {@code null} for none
   */
  public Label getLabel() {
    return label;
  }

  /**
   * Required. Language-tagged labels for the item. We recommend that item names be 140 characters
   * or less, and descriptions 250 characters or less. This field should only be set if the input is
   * a custom service item. Standardized service types should be updated via service_type_id.
   * @param label label or {@code null} for none
   */
  public FreeFormServiceItem setLabel(Label label) {
    this.label = label;
    return this;
  }

  @Override
  public FreeFormServiceItem set(String fieldName, Object value) {
    return (FreeFormServiceItem) super.set(fieldName, value);
  }

  @Override
  public FreeFormServiceItem clone() {
    return (FreeFormServiceItem) super.clone();
  }

}
