/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Property rules that impact guests.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Policies extends com.google.api.client.json.GenericJson {

  /**
   * All inclusive available. The hotel offers a rate option that includes the cost of the room,
   * meals, activities, and other amenities that might otherwise be charged separately.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allInclusiveAvailable;

  /**
   * All inclusive available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allInclusiveAvailableException;

  /**
   * All inclusive only. The only rate option offered by the hotel is a rate that includes the cost
   * of the room, meals, activities and other amenities that might otherwise be charged separately.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean allInclusiveOnly;

  /**
   * All inclusive only exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String allInclusiveOnlyException;

  /**
   * Check-in time. The time of the day at which the hotel begins providing guests access to their
   * unit at the beginning of their stay.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay checkinTime;

  /**
   * Check-in time exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String checkinTimeException;

  /**
   * Check-out time. The time of the day on the last day of a guest's reserved stay at which the
   * guest must vacate their room and settle their bill. Some hotels may offer late or early check
   * out for a fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay checkoutTime;

  /**
   * Check-out time exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String checkoutTimeException;

  /**
   * Kids stay free. The children of guests are allowed to stay in the room/suite of a parent or
   * adult without an additional fee. The policy may or may not stipulate a limit of the child's age
   * or the overall number of children allowed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean kidsStayFree;

  /**
   * Kids stay free exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kidsStayFreeException;

  /**
   * Max child age. The hotel allows children up to a certain age to stay in the room/suite of a
   * parent or adult without an additional fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxChildAge;

  /**
   * Max child age exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxChildAgeException;

  /**
   * Max kids stay free count. The hotel allows a specific, defined number of children to stay in
   * the room/suite of a parent or adult without an additional fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxKidsStayFreeCount;

  /**
   * Max kids stay free count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String maxKidsStayFreeCountException;

  /**
   * Forms of payment accepted at the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PaymentOptions paymentOptions;

  /**
   * Smoke free property. Smoking is not allowed inside the building, on balconies, or in outside
   * spaces. Hotels that offer a designated area for guests to smoke are not considered smoke-free
   * properties.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean smokeFreeProperty;

  /**
   * Smoke free property exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String smokeFreePropertyException;

  /**
   * All inclusive available. The hotel offers a rate option that includes the cost of the room,
   * meals, activities, and other amenities that might otherwise be charged separately.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllInclusiveAvailable() {
    return allInclusiveAvailable;
  }

  /**
   * All inclusive available. The hotel offers a rate option that includes the cost of the room,
   * meals, activities, and other amenities that might otherwise be charged separately.
   * @param allInclusiveAvailable allInclusiveAvailable or {@code null} for none
   */
  public Policies setAllInclusiveAvailable(java.lang.Boolean allInclusiveAvailable) {
    this.allInclusiveAvailable = allInclusiveAvailable;
    return this;
  }

  /**
   * All inclusive available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllInclusiveAvailableException() {
    return allInclusiveAvailableException;
  }

  /**
   * All inclusive available exception.
   * @param allInclusiveAvailableException allInclusiveAvailableException or {@code null} for none
   */
  public Policies setAllInclusiveAvailableException(java.lang.String allInclusiveAvailableException) {
    this.allInclusiveAvailableException = allInclusiveAvailableException;
    return this;
  }

  /**
   * All inclusive only. The only rate option offered by the hotel is a rate that includes the cost
   * of the room, meals, activities and other amenities that might otherwise be charged separately.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getAllInclusiveOnly() {
    return allInclusiveOnly;
  }

  /**
   * All inclusive only. The only rate option offered by the hotel is a rate that includes the cost
   * of the room, meals, activities and other amenities that might otherwise be charged separately.
   * @param allInclusiveOnly allInclusiveOnly or {@code null} for none
   */
  public Policies setAllInclusiveOnly(java.lang.Boolean allInclusiveOnly) {
    this.allInclusiveOnly = allInclusiveOnly;
    return this;
  }

  /**
   * All inclusive only exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getAllInclusiveOnlyException() {
    return allInclusiveOnlyException;
  }

  /**
   * All inclusive only exception.
   * @param allInclusiveOnlyException allInclusiveOnlyException or {@code null} for none
   */
  public Policies setAllInclusiveOnlyException(java.lang.String allInclusiveOnlyException) {
    this.allInclusiveOnlyException = allInclusiveOnlyException;
    return this;
  }

  /**
   * Check-in time. The time of the day at which the hotel begins providing guests access to their
   * unit at the beginning of their stay.
   * @return value or {@code null} for none
   */
  public TimeOfDay getCheckinTime() {
    return checkinTime;
  }

  /**
   * Check-in time. The time of the day at which the hotel begins providing guests access to their
   * unit at the beginning of their stay.
   * @param checkinTime checkinTime or {@code null} for none
   */
  public Policies setCheckinTime(TimeOfDay checkinTime) {
    this.checkinTime = checkinTime;
    return this;
  }

  /**
   * Check-in time exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCheckinTimeException() {
    return checkinTimeException;
  }

  /**
   * Check-in time exception.
   * @param checkinTimeException checkinTimeException or {@code null} for none
   */
  public Policies setCheckinTimeException(java.lang.String checkinTimeException) {
    this.checkinTimeException = checkinTimeException;
    return this;
  }

  /**
   * Check-out time. The time of the day on the last day of a guest's reserved stay at which the
   * guest must vacate their room and settle their bill. Some hotels may offer late or early check
   * out for a fee.
   * @return value or {@code null} for none
   */
  public TimeOfDay getCheckoutTime() {
    return checkoutTime;
  }

  /**
   * Check-out time. The time of the day on the last day of a guest's reserved stay at which the
   * guest must vacate their room and settle their bill. Some hotels may offer late or early check
   * out for a fee.
   * @param checkoutTime checkoutTime or {@code null} for none
   */
  public Policies setCheckoutTime(TimeOfDay checkoutTime) {
    this.checkoutTime = checkoutTime;
    return this;
  }

  /**
   * Check-out time exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getCheckoutTimeException() {
    return checkoutTimeException;
  }

  /**
   * Check-out time exception.
   * @param checkoutTimeException checkoutTimeException or {@code null} for none
   */
  public Policies setCheckoutTimeException(java.lang.String checkoutTimeException) {
    this.checkoutTimeException = checkoutTimeException;
    return this;
  }

  /**
   * Kids stay free. The children of guests are allowed to stay in the room/suite of a parent or
   * adult without an additional fee. The policy may or may not stipulate a limit of the child's age
   * or the overall number of children allowed.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getKidsStayFree() {
    return kidsStayFree;
  }

  /**
   * Kids stay free. The children of guests are allowed to stay in the room/suite of a parent or
   * adult without an additional fee. The policy may or may not stipulate a limit of the child's age
   * or the overall number of children allowed.
   * @param kidsStayFree kidsStayFree or {@code null} for none
   */
  public Policies setKidsStayFree(java.lang.Boolean kidsStayFree) {
    this.kidsStayFree = kidsStayFree;
    return this;
  }

  /**
   * Kids stay free exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getKidsStayFreeException() {
    return kidsStayFreeException;
  }

  /**
   * Kids stay free exception.
   * @param kidsStayFreeException kidsStayFreeException or {@code null} for none
   */
  public Policies setKidsStayFreeException(java.lang.String kidsStayFreeException) {
    this.kidsStayFreeException = kidsStayFreeException;
    return this;
  }

  /**
   * Max child age. The hotel allows children up to a certain age to stay in the room/suite of a
   * parent or adult without an additional fee.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxChildAge() {
    return maxChildAge;
  }

  /**
   * Max child age. The hotel allows children up to a certain age to stay in the room/suite of a
   * parent or adult without an additional fee.
   * @param maxChildAge maxChildAge or {@code null} for none
   */
  public Policies setMaxChildAge(java.lang.Integer maxChildAge) {
    this.maxChildAge = maxChildAge;
    return this;
  }

  /**
   * Max child age exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxChildAgeException() {
    return maxChildAgeException;
  }

  /**
   * Max child age exception.
   * @param maxChildAgeException maxChildAgeException or {@code null} for none
   */
  public Policies setMaxChildAgeException(java.lang.String maxChildAgeException) {
    this.maxChildAgeException = maxChildAgeException;
    return this;
  }

  /**
   * Max kids stay free count. The hotel allows a specific, defined number of children to stay in
   * the room/suite of a parent or adult without an additional fee.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxKidsStayFreeCount() {
    return maxKidsStayFreeCount;
  }

  /**
   * Max kids stay free count. The hotel allows a specific, defined number of children to stay in
   * the room/suite of a parent or adult without an additional fee.
   * @param maxKidsStayFreeCount maxKidsStayFreeCount or {@code null} for none
   */
  public Policies setMaxKidsStayFreeCount(java.lang.Integer maxKidsStayFreeCount) {
    this.maxKidsStayFreeCount = maxKidsStayFreeCount;
    return this;
  }

  /**
   * Max kids stay free count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMaxKidsStayFreeCountException() {
    return maxKidsStayFreeCountException;
  }

  /**
   * Max kids stay free count exception.
   * @param maxKidsStayFreeCountException maxKidsStayFreeCountException or {@code null} for none
   */
  public Policies setMaxKidsStayFreeCountException(java.lang.String maxKidsStayFreeCountException) {
    this.maxKidsStayFreeCountException = maxKidsStayFreeCountException;
    return this;
  }

  /**
   * Forms of payment accepted at the property.
   * @return value or {@code null} for none
   */
  public PaymentOptions getPaymentOptions() {
    return paymentOptions;
  }

  /**
   * Forms of payment accepted at the property.
   * @param paymentOptions paymentOptions or {@code null} for none
   */
  public Policies setPaymentOptions(PaymentOptions paymentOptions) {
    this.paymentOptions = paymentOptions;
    return this;
  }

  /**
   * Smoke free property. Smoking is not allowed inside the building, on balconies, or in outside
   * spaces. Hotels that offer a designated area for guests to smoke are not considered smoke-free
   * properties.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSmokeFreeProperty() {
    return smokeFreeProperty;
  }

  /**
   * Smoke free property. Smoking is not allowed inside the building, on balconies, or in outside
   * spaces. Hotels that offer a designated area for guests to smoke are not considered smoke-free
   * properties.
   * @param smokeFreeProperty smokeFreeProperty or {@code null} for none
   */
  public Policies setSmokeFreeProperty(java.lang.Boolean smokeFreeProperty) {
    this.smokeFreeProperty = smokeFreeProperty;
    return this;
  }

  /**
   * Smoke free property exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSmokeFreePropertyException() {
    return smokeFreePropertyException;
  }

  /**
   * Smoke free property exception.
   * @param smokeFreePropertyException smokeFreePropertyException or {@code null} for none
   */
  public Policies setSmokeFreePropertyException(java.lang.String smokeFreePropertyException) {
    this.smokeFreePropertyException = smokeFreePropertyException;
    return this;
  }

  @Override
  public Policies set(String fieldName, Object value) {
    return (Policies) super.set(fieldName, value);
  }

  @Override
  public Policies clone() {
    return (Policies) super.clone();
  }

}
