/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A value for a single metric with a given time dimension.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DimensionalMetricValue extends com.google.api.client.json.GenericJson {

  /**
   * The option that requested this dimensional value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metricOption;

  /**
   * The dimension for the value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeDimension timeDimension;

  /**
   * The value. If no value is set, then the requested data is missing.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long value;

  /**
   * The option that requested this dimensional value.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetricOption() {
    return metricOption;
  }

  /**
   * The option that requested this dimensional value.
   * @param metricOption metricOption or {@code null} for none
   */
  public DimensionalMetricValue setMetricOption(java.lang.String metricOption) {
    this.metricOption = metricOption;
    return this;
  }

  /**
   * The dimension for the value.
   * @return value or {@code null} for none
   */
  public TimeDimension getTimeDimension() {
    return timeDimension;
  }

  /**
   * The dimension for the value.
   * @param timeDimension timeDimension or {@code null} for none
   */
  public DimensionalMetricValue setTimeDimension(TimeDimension timeDimension) {
    this.timeDimension = timeDimension;
    return this;
  }

  /**
   * The value. If no value is set, then the requested data is missing.
   * @return value or {@code null} for none
   */
  public java.lang.Long getValue() {
    return value;
  }

  /**
   * The value. If no value is set, then the requested data is missing.
   * @param value value or {@code null} for none
   */
  public DimensionalMetricValue setValue(java.lang.Long value) {
    this.value = value;
    return this;
  }

  @Override
  public DimensionalMetricValue set(String fieldName, Object value) {
    return (DimensionalMetricValue) super.set(fieldName, value);
  }

  @Override
  public DimensionalMetricValue clone() {
    return (DimensionalMetricValue) super.clone();
  }

}
