/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * The dimension for which data is divided over.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimeDimension extends com.google.api.client.json.GenericJson {

  /**
   * The day of the week ("MONDAY" to "SUNDAY") this value corresponds to. Set for
   * BREAKDOWN_DAY_OF_WEEK option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String dayOfWeek;

  /**
   * The hour of the day (0 to 23) this value corresponds to. Set for BREAKDOWN_HOUR_OF_DAY option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeOfDay timeOfDay;

  /**
   * The range of time this value covers. Set for AGGREGATED_TOTAL and AGGREGATED_DAILY options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TimeRange timeRange;

  /**
   * The day of the week ("MONDAY" to "SUNDAY") this value corresponds to. Set for
   * BREAKDOWN_DAY_OF_WEEK option.
   * @return value or {@code null} for none
   */
  public java.lang.String getDayOfWeek() {
    return dayOfWeek;
  }

  /**
   * The day of the week ("MONDAY" to "SUNDAY") this value corresponds to. Set for
   * BREAKDOWN_DAY_OF_WEEK option.
   * @param dayOfWeek dayOfWeek or {@code null} for none
   */
  public TimeDimension setDayOfWeek(java.lang.String dayOfWeek) {
    this.dayOfWeek = dayOfWeek;
    return this;
  }

  /**
   * The hour of the day (0 to 23) this value corresponds to. Set for BREAKDOWN_HOUR_OF_DAY option.
   * @return value or {@code null} for none
   */
  public TimeOfDay getTimeOfDay() {
    return timeOfDay;
  }

  /**
   * The hour of the day (0 to 23) this value corresponds to. Set for BREAKDOWN_HOUR_OF_DAY option.
   * @param timeOfDay timeOfDay or {@code null} for none
   */
  public TimeDimension setTimeOfDay(TimeOfDay timeOfDay) {
    this.timeOfDay = timeOfDay;
    return this;
  }

  /**
   * The range of time this value covers. Set for AGGREGATED_TOTAL and AGGREGATED_DAILY options.
   * @return value or {@code null} for none
   */
  public TimeRange getTimeRange() {
    return timeRange;
  }

  /**
   * The range of time this value covers. Set for AGGREGATED_TOTAL and AGGREGATED_DAILY options.
   * @param timeRange timeRange or {@code null} for none
   */
  public TimeDimension setTimeRange(TimeRange timeRange) {
    this.timeRange = timeRange;
    return this;
  }

  @Override
  public TimeDimension set(String fieldName, Object value) {
    return (TimeDimension) super.set(fieldName, value);
  }

  @Override
  public TimeDimension clone() {
    return (TimeDimension) super.clone();
  }

}
