/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Defines an area that's represented by a place ID.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PlaceInfo extends com.google.api.client.json.GenericJson {

  /**
   * The localized name of the place. For example, `Scottsdale, AZ`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The ID of the place. Must correspond to a [region.] (https://developers.google.com/places/web-
   * service/supported_types#table3)
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String placeId;

  /**
   * The localized name of the place. For example, `Scottsdale, AZ`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The localized name of the place. For example, `Scottsdale, AZ`.
   * @param name name or {@code null} for none
   */
  public PlaceInfo setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The ID of the place. Must correspond to a [region.] (https://developers.google.com/places/web-
   * service/supported_types#table3)
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaceId() {
    return placeId;
  }

  /**
   * The ID of the place. Must correspond to a [region.] (https://developers.google.com/places/web-
   * service/supported_types#table3)
   * @param placeId placeId or {@code null} for none
   */
  public PlaceInfo setPlaceId(java.lang.String placeId) {
    this.placeId = placeId;
    return this;
  }

  @Override
  public PlaceInfo set(String fieldName, Object value) {
    return (PlaceInfo) super.set(fieldName, value);
  }

  @Override
  public PlaceInfo clone() {
    return (PlaceInfo) super.clone();
  }

}
