/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Parking options at the property.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Parking extends com.google.api.client.json.GenericJson {

  /**
   * Electric car charging stations. Electric power stations, usually located outdoors, into which
   * guests plug their electric cars to receive a charge.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean electricCarChargingStations;

  /**
   * Electric car charging stations exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String electricCarChargingStationsException;

  /**
   * Free parking. The hotel allows the cars of guests to be parked for free. Parking facility may
   * be an outdoor lot or an indoor garage, but must be onsite. Nearby parking does not apply.
   * Parking may be performed by the guest or by hotel staff. Free parking must be available to all
   * guests (limited conditions does not apply).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeParking;

  /**
   * Free parking exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeParkingException;

  /**
   * Free self parking. Guests park their own cars for free. Parking facility may be an outdoor lot
   * or an indoor garage, but must be onsite. Nearby parking does not apply.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeSelfParking;

  /**
   * Free self parking exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeSelfParkingException;

  /**
   * Free valet parking. Hotel staff member parks the cars of guests. Parking with this service is
   * free.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeValetParking;

  /**
   * Free valet parking exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeValetParkingException;

  /**
   * Parking available. The hotel allows the cars of guests to be parked. Can be free or for a fee.
   * Parking facility may be an outdoor lot or an indoor garage, but must be onsite. Nearby parking
   * does not apply. Parking may be performed by the guest or by hotel staff.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean parkingAvailable;

  /**
   * Parking available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String parkingAvailableException;

  /**
   * Self parking available. Guests park their own cars. Parking facility may be an outdoor lot or
   * an indoor garage, but must be onsite. Nearby parking does not apply. Can be free or for a fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean selfParkingAvailable;

  /**
   * Self parking available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String selfParkingAvailableException;

  /**
   * Valet parking available. Hotel staff member parks the cars of guests. Parking with this service
   * can be free or for a fee.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean valetParkingAvailable;

  /**
   * Valet parking available exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String valetParkingAvailableException;

  /**
   * Electric car charging stations. Electric power stations, usually located outdoors, into which
   * guests plug their electric cars to receive a charge.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getElectricCarChargingStations() {
    return electricCarChargingStations;
  }

  /**
   * Electric car charging stations. Electric power stations, usually located outdoors, into which
   * guests plug their electric cars to receive a charge.
   * @param electricCarChargingStations electricCarChargingStations or {@code null} for none
   */
  public Parking setElectricCarChargingStations(java.lang.Boolean electricCarChargingStations) {
    this.electricCarChargingStations = electricCarChargingStations;
    return this;
  }

  /**
   * Electric car charging stations exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getElectricCarChargingStationsException() {
    return electricCarChargingStationsException;
  }

  /**
   * Electric car charging stations exception.
   * @param electricCarChargingStationsException electricCarChargingStationsException or {@code null} for none
   */
  public Parking setElectricCarChargingStationsException(java.lang.String electricCarChargingStationsException) {
    this.electricCarChargingStationsException = electricCarChargingStationsException;
    return this;
  }

  /**
   * Free parking. The hotel allows the cars of guests to be parked for free. Parking facility may
   * be an outdoor lot or an indoor garage, but must be onsite. Nearby parking does not apply.
   * Parking may be performed by the guest or by hotel staff. Free parking must be available to all
   * guests (limited conditions does not apply).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeParking() {
    return freeParking;
  }

  /**
   * Free parking. The hotel allows the cars of guests to be parked for free. Parking facility may
   * be an outdoor lot or an indoor garage, but must be onsite. Nearby parking does not apply.
   * Parking may be performed by the guest or by hotel staff. Free parking must be available to all
   * guests (limited conditions does not apply).
   * @param freeParking freeParking or {@code null} for none
   */
  public Parking setFreeParking(java.lang.Boolean freeParking) {
    this.freeParking = freeParking;
    return this;
  }

  /**
   * Free parking exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeParkingException() {
    return freeParkingException;
  }

  /**
   * Free parking exception.
   * @param freeParkingException freeParkingException or {@code null} for none
   */
  public Parking setFreeParkingException(java.lang.String freeParkingException) {
    this.freeParkingException = freeParkingException;
    return this;
  }

  /**
   * Free self parking. Guests park their own cars for free. Parking facility may be an outdoor lot
   * or an indoor garage, but must be onsite. Nearby parking does not apply.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeSelfParking() {
    return freeSelfParking;
  }

  /**
   * Free self parking. Guests park their own cars for free. Parking facility may be an outdoor lot
   * or an indoor garage, but must be onsite. Nearby parking does not apply.
   * @param freeSelfParking freeSelfParking or {@code null} for none
   */
  public Parking setFreeSelfParking(java.lang.Boolean freeSelfParking) {
    this.freeSelfParking = freeSelfParking;
    return this;
  }

  /**
   * Free self parking exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeSelfParkingException() {
    return freeSelfParkingException;
  }

  /**
   * Free self parking exception.
   * @param freeSelfParkingException freeSelfParkingException or {@code null} for none
   */
  public Parking setFreeSelfParkingException(java.lang.String freeSelfParkingException) {
    this.freeSelfParkingException = freeSelfParkingException;
    return this;
  }

  /**
   * Free valet parking. Hotel staff member parks the cars of guests. Parking with this service is
   * free.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeValetParking() {
    return freeValetParking;
  }

  /**
   * Free valet parking. Hotel staff member parks the cars of guests. Parking with this service is
   * free.
   * @param freeValetParking freeValetParking or {@code null} for none
   */
  public Parking setFreeValetParking(java.lang.Boolean freeValetParking) {
    this.freeValetParking = freeValetParking;
    return this;
  }

  /**
   * Free valet parking exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeValetParkingException() {
    return freeValetParkingException;
  }

  /**
   * Free valet parking exception.
   * @param freeValetParkingException freeValetParkingException or {@code null} for none
   */
  public Parking setFreeValetParkingException(java.lang.String freeValetParkingException) {
    this.freeValetParkingException = freeValetParkingException;
    return this;
  }

  /**
   * Parking available. The hotel allows the cars of guests to be parked. Can be free or for a fee.
   * Parking facility may be an outdoor lot or an indoor garage, but must be onsite. Nearby parking
   * does not apply. Parking may be performed by the guest or by hotel staff.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getParkingAvailable() {
    return parkingAvailable;
  }

  /**
   * Parking available. The hotel allows the cars of guests to be parked. Can be free or for a fee.
   * Parking facility may be an outdoor lot or an indoor garage, but must be onsite. Nearby parking
   * does not apply. Parking may be performed by the guest or by hotel staff.
   * @param parkingAvailable parkingAvailable or {@code null} for none
   */
  public Parking setParkingAvailable(java.lang.Boolean parkingAvailable) {
    this.parkingAvailable = parkingAvailable;
    return this;
  }

  /**
   * Parking available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getParkingAvailableException() {
    return parkingAvailableException;
  }

  /**
   * Parking available exception.
   * @param parkingAvailableException parkingAvailableException or {@code null} for none
   */
  public Parking setParkingAvailableException(java.lang.String parkingAvailableException) {
    this.parkingAvailableException = parkingAvailableException;
    return this;
  }

  /**
   * Self parking available. Guests park their own cars. Parking facility may be an outdoor lot or
   * an indoor garage, but must be onsite. Nearby parking does not apply. Can be free or for a fee.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSelfParkingAvailable() {
    return selfParkingAvailable;
  }

  /**
   * Self parking available. Guests park their own cars. Parking facility may be an outdoor lot or
   * an indoor garage, but must be onsite. Nearby parking does not apply. Can be free or for a fee.
   * @param selfParkingAvailable selfParkingAvailable or {@code null} for none
   */
  public Parking setSelfParkingAvailable(java.lang.Boolean selfParkingAvailable) {
    this.selfParkingAvailable = selfParkingAvailable;
    return this;
  }

  /**
   * Self parking available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSelfParkingAvailableException() {
    return selfParkingAvailableException;
  }

  /**
   * Self parking available exception.
   * @param selfParkingAvailableException selfParkingAvailableException or {@code null} for none
   */
  public Parking setSelfParkingAvailableException(java.lang.String selfParkingAvailableException) {
    this.selfParkingAvailableException = selfParkingAvailableException;
    return this;
  }

  /**
   * Valet parking available. Hotel staff member parks the cars of guests. Parking with this service
   * can be free or for a fee.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getValetParkingAvailable() {
    return valetParkingAvailable;
  }

  /**
   * Valet parking available. Hotel staff member parks the cars of guests. Parking with this service
   * can be free or for a fee.
   * @param valetParkingAvailable valetParkingAvailable or {@code null} for none
   */
  public Parking setValetParkingAvailable(java.lang.Boolean valetParkingAvailable) {
    this.valetParkingAvailable = valetParkingAvailable;
    return this;
  }

  /**
   * Valet parking available exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getValetParkingAvailableException() {
    return valetParkingAvailableException;
  }

  /**
   * Valet parking available exception.
   * @param valetParkingAvailableException valetParkingAvailableException or {@code null} for none
   */
  public Parking setValetParkingAvailableException(java.lang.String valetParkingAvailableException) {
    this.valetParkingAvailableException = valetParkingAvailableException;
    return this;
  }

  @Override
  public Parking set(String fieldName, Object value) {
    return (Parking) super.set(fieldName, value);
  }

  @Override
  public Parking clone() {
    return (Parking) super.clone();
  }

}
