/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Guest facilities at the property to promote or maintain health, beauty, and fitness.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Wellness extends com.google.api.client.json.GenericJson {

  /**
   * Doctor on call. The hotel has a contract with a medical professional who provides services to
   * hotel guests should they fall ill during their stay. The doctor may or may not have an on-site
   * office or be at the hotel at all times.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean doctorOnCall;

  /**
   * Doctor on call exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String doctorOnCallException;

  /**
   * Elliptical machine. An electric, stationary fitness machine with pedals that simulates
   * climbing, walking or running and provides a user-controlled range of speeds and tensions. May
   * not have arm-controlled levers to work out the upper body as well. Commonly found in a gym,
   * fitness room, health center, or health club.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean ellipticalMachine;

  /**
   * Elliptical machine exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String ellipticalMachineException;

  /**
   * Fitness center. A room or building at the hotel containing equipment to promote physical
   * activity, such as treadmills, elliptical machines, stationary bikes, weight machines, free
   * weights, and/or stretching mats. Use of the fitness center can be free or for a fee. May or may
   * not be staffed. May or may not offer instructor-led classes in various styles of physical
   * conditioning. May or may not be open 24/7. May or may not include locker rooms and showers.
   * Also known as health club, gym, fitness room, health center.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean fitnessCenter;

  /**
   * Fitness center exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String fitnessCenterException;

  /**
   * Free fitness center. Guests may use the fitness center for free.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeFitnessCenter;

  /**
   * Free fitness center exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeFitnessCenterException;

  /**
   * Free weights. Individual handheld fitness equipment of varied weights used for upper body
   * strength training or bodybuilding. Also known as barbells, dumbbells, or kettlebells. Often
   * stored on a rack with the weights arranged from light to heavy. Commonly found in a gym,
   * fitness room, health center, or health club.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean freeWeights;

  /**
   * Free weights exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String freeWeightsException;

  /**
   * Massage. A service provided by a trained massage therapist involving the physical manipulation
   * of a guest's muscles in order to achieve relaxation or pain relief.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean massage;

  /**
   * Massage exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String massageException;

  /**
   * Salon. A room at the hotel where professionals provide hair styling services such as
   * shampooing, blow drying, hair dos, hair cutting and hair coloring. Also known as hairdresser or
   * beauty salon.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean salon;

  /**
   * Salon exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String salonException;

  /**
   * Sauna. A wood-paneled room heated to a high temperature where guests sit on built-in wood
   * benches for the purpose of perspiring and relaxing their muscles. Can be dry or slightly wet
   * heat. Not a steam room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean sauna;

  /**
   * Sauna exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String saunaException;

  /**
   * Spa. A designated area, room or building at the hotel offering health and beauty treatment
   * through such means as steam baths, exercise equipment, and massage. May also offer facials,
   * nail care, and hair care. Services are usually available by appointment and for an additional
   * fee. Does not apply if hotel only offers a steam room; must offer other beauty and/or health
   * treatments as well.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean spa;

  /**
   * Spa exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spaException;

  /**
   * Treadmill. An electric stationary fitness machine that simulates a moving path to promote
   * walking or running within a range of user-controlled speeds and inclines. Also known as running
   * machine. Commonly found in a gym, fitness room, health center, or health club.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean treadmill;

  /**
   * Treadmill exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String treadmillException;

  /**
   * Weight machine. Non-electronic fitness equipment designed for the user to target the exertion
   * of different muscles. Usually incorporates a padded seat, a stack of flat weights and various
   * bars and pulleys. May be designed for toning a specific part of the body or may involve
   * different user-controlled settings, hardware and pulleys so as to provide an overall workout in
   * one machine. Commonly found in a gym, fitness center, fitness room, or health club.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean weightMachine;

  /**
   * Weight machine exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String weightMachineException;

  /**
   * Doctor on call. The hotel has a contract with a medical professional who provides services to
   * hotel guests should they fall ill during their stay. The doctor may or may not have an on-site
   * office or be at the hotel at all times.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getDoctorOnCall() {
    return doctorOnCall;
  }

  /**
   * Doctor on call. The hotel has a contract with a medical professional who provides services to
   * hotel guests should they fall ill during their stay. The doctor may or may not have an on-site
   * office or be at the hotel at all times.
   * @param doctorOnCall doctorOnCall or {@code null} for none
   */
  public Wellness setDoctorOnCall(java.lang.Boolean doctorOnCall) {
    this.doctorOnCall = doctorOnCall;
    return this;
  }

  /**
   * Doctor on call exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getDoctorOnCallException() {
    return doctorOnCallException;
  }

  /**
   * Doctor on call exception.
   * @param doctorOnCallException doctorOnCallException or {@code null} for none
   */
  public Wellness setDoctorOnCallException(java.lang.String doctorOnCallException) {
    this.doctorOnCallException = doctorOnCallException;
    return this;
  }

  /**
   * Elliptical machine. An electric, stationary fitness machine with pedals that simulates
   * climbing, walking or running and provides a user-controlled range of speeds and tensions. May
   * not have arm-controlled levers to work out the upper body as well. Commonly found in a gym,
   * fitness room, health center, or health club.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEllipticalMachine() {
    return ellipticalMachine;
  }

  /**
   * Elliptical machine. An electric, stationary fitness machine with pedals that simulates
   * climbing, walking or running and provides a user-controlled range of speeds and tensions. May
   * not have arm-controlled levers to work out the upper body as well. Commonly found in a gym,
   * fitness room, health center, or health club.
   * @param ellipticalMachine ellipticalMachine or {@code null} for none
   */
  public Wellness setEllipticalMachine(java.lang.Boolean ellipticalMachine) {
    this.ellipticalMachine = ellipticalMachine;
    return this;
  }

  /**
   * Elliptical machine exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getEllipticalMachineException() {
    return ellipticalMachineException;
  }

  /**
   * Elliptical machine exception.
   * @param ellipticalMachineException ellipticalMachineException or {@code null} for none
   */
  public Wellness setEllipticalMachineException(java.lang.String ellipticalMachineException) {
    this.ellipticalMachineException = ellipticalMachineException;
    return this;
  }

  /**
   * Fitness center. A room or building at the hotel containing equipment to promote physical
   * activity, such as treadmills, elliptical machines, stationary bikes, weight machines, free
   * weights, and/or stretching mats. Use of the fitness center can be free or for a fee. May or may
   * not be staffed. May or may not offer instructor-led classes in various styles of physical
   * conditioning. May or may not be open 24/7. May or may not include locker rooms and showers.
   * Also known as health club, gym, fitness room, health center.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFitnessCenter() {
    return fitnessCenter;
  }

  /**
   * Fitness center. A room or building at the hotel containing equipment to promote physical
   * activity, such as treadmills, elliptical machines, stationary bikes, weight machines, free
   * weights, and/or stretching mats. Use of the fitness center can be free or for a fee. May or may
   * not be staffed. May or may not offer instructor-led classes in various styles of physical
   * conditioning. May or may not be open 24/7. May or may not include locker rooms and showers.
   * Also known as health club, gym, fitness room, health center.
   * @param fitnessCenter fitnessCenter or {@code null} for none
   */
  public Wellness setFitnessCenter(java.lang.Boolean fitnessCenter) {
    this.fitnessCenter = fitnessCenter;
    return this;
  }

  /**
   * Fitness center exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFitnessCenterException() {
    return fitnessCenterException;
  }

  /**
   * Fitness center exception.
   * @param fitnessCenterException fitnessCenterException or {@code null} for none
   */
  public Wellness setFitnessCenterException(java.lang.String fitnessCenterException) {
    this.fitnessCenterException = fitnessCenterException;
    return this;
  }

  /**
   * Free fitness center. Guests may use the fitness center for free.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeFitnessCenter() {
    return freeFitnessCenter;
  }

  /**
   * Free fitness center. Guests may use the fitness center for free.
   * @param freeFitnessCenter freeFitnessCenter or {@code null} for none
   */
  public Wellness setFreeFitnessCenter(java.lang.Boolean freeFitnessCenter) {
    this.freeFitnessCenter = freeFitnessCenter;
    return this;
  }

  /**
   * Free fitness center exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeFitnessCenterException() {
    return freeFitnessCenterException;
  }

  /**
   * Free fitness center exception.
   * @param freeFitnessCenterException freeFitnessCenterException or {@code null} for none
   */
  public Wellness setFreeFitnessCenterException(java.lang.String freeFitnessCenterException) {
    this.freeFitnessCenterException = freeFitnessCenterException;
    return this;
  }

  /**
   * Free weights. Individual handheld fitness equipment of varied weights used for upper body
   * strength training or bodybuilding. Also known as barbells, dumbbells, or kettlebells. Often
   * stored on a rack with the weights arranged from light to heavy. Commonly found in a gym,
   * fitness room, health center, or health club.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getFreeWeights() {
    return freeWeights;
  }

  /**
   * Free weights. Individual handheld fitness equipment of varied weights used for upper body
   * strength training or bodybuilding. Also known as barbells, dumbbells, or kettlebells. Often
   * stored on a rack with the weights arranged from light to heavy. Commonly found in a gym,
   * fitness room, health center, or health club.
   * @param freeWeights freeWeights or {@code null} for none
   */
  public Wellness setFreeWeights(java.lang.Boolean freeWeights) {
    this.freeWeights = freeWeights;
    return this;
  }

  /**
   * Free weights exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFreeWeightsException() {
    return freeWeightsException;
  }

  /**
   * Free weights exception.
   * @param freeWeightsException freeWeightsException or {@code null} for none
   */
  public Wellness setFreeWeightsException(java.lang.String freeWeightsException) {
    this.freeWeightsException = freeWeightsException;
    return this;
  }

  /**
   * Massage. A service provided by a trained massage therapist involving the physical manipulation
   * of a guest's muscles in order to achieve relaxation or pain relief.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMassage() {
    return massage;
  }

  /**
   * Massage. A service provided by a trained massage therapist involving the physical manipulation
   * of a guest's muscles in order to achieve relaxation or pain relief.
   * @param massage massage or {@code null} for none
   */
  public Wellness setMassage(java.lang.Boolean massage) {
    this.massage = massage;
    return this;
  }

  /**
   * Massage exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMassageException() {
    return massageException;
  }

  /**
   * Massage exception.
   * @param massageException massageException or {@code null} for none
   */
  public Wellness setMassageException(java.lang.String massageException) {
    this.massageException = massageException;
    return this;
  }

  /**
   * Salon. A room at the hotel where professionals provide hair styling services such as
   * shampooing, blow drying, hair dos, hair cutting and hair coloring. Also known as hairdresser or
   * beauty salon.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSalon() {
    return salon;
  }

  /**
   * Salon. A room at the hotel where professionals provide hair styling services such as
   * shampooing, blow drying, hair dos, hair cutting and hair coloring. Also known as hairdresser or
   * beauty salon.
   * @param salon salon or {@code null} for none
   */
  public Wellness setSalon(java.lang.Boolean salon) {
    this.salon = salon;
    return this;
  }

  /**
   * Salon exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSalonException() {
    return salonException;
  }

  /**
   * Salon exception.
   * @param salonException salonException or {@code null} for none
   */
  public Wellness setSalonException(java.lang.String salonException) {
    this.salonException = salonException;
    return this;
  }

  /**
   * Sauna. A wood-paneled room heated to a high temperature where guests sit on built-in wood
   * benches for the purpose of perspiring and relaxing their muscles. Can be dry or slightly wet
   * heat. Not a steam room.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSauna() {
    return sauna;
  }

  /**
   * Sauna. A wood-paneled room heated to a high temperature where guests sit on built-in wood
   * benches for the purpose of perspiring and relaxing their muscles. Can be dry or slightly wet
   * heat. Not a steam room.
   * @param sauna sauna or {@code null} for none
   */
  public Wellness setSauna(java.lang.Boolean sauna) {
    this.sauna = sauna;
    return this;
  }

  /**
   * Sauna exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSaunaException() {
    return saunaException;
  }

  /**
   * Sauna exception.
   * @param saunaException saunaException or {@code null} for none
   */
  public Wellness setSaunaException(java.lang.String saunaException) {
    this.saunaException = saunaException;
    return this;
  }

  /**
   * Spa. A designated area, room or building at the hotel offering health and beauty treatment
   * through such means as steam baths, exercise equipment, and massage. May also offer facials,
   * nail care, and hair care. Services are usually available by appointment and for an additional
   * fee. Does not apply if hotel only offers a steam room; must offer other beauty and/or health
   * treatments as well.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSpa() {
    return spa;
  }

  /**
   * Spa. A designated area, room or building at the hotel offering health and beauty treatment
   * through such means as steam baths, exercise equipment, and massage. May also offer facials,
   * nail care, and hair care. Services are usually available by appointment and for an additional
   * fee. Does not apply if hotel only offers a steam room; must offer other beauty and/or health
   * treatments as well.
   * @param spa spa or {@code null} for none
   */
  public Wellness setSpa(java.lang.Boolean spa) {
    this.spa = spa;
    return this;
  }

  /**
   * Spa exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpaException() {
    return spaException;
  }

  /**
   * Spa exception.
   * @param spaException spaException or {@code null} for none
   */
  public Wellness setSpaException(java.lang.String spaException) {
    this.spaException = spaException;
    return this;
  }

  /**
   * Treadmill. An electric stationary fitness machine that simulates a moving path to promote
   * walking or running within a range of user-controlled speeds and inclines. Also known as running
   * machine. Commonly found in a gym, fitness room, health center, or health club.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getTreadmill() {
    return treadmill;
  }

  /**
   * Treadmill. An electric stationary fitness machine that simulates a moving path to promote
   * walking or running within a range of user-controlled speeds and inclines. Also known as running
   * machine. Commonly found in a gym, fitness room, health center, or health club.
   * @param treadmill treadmill or {@code null} for none
   */
  public Wellness setTreadmill(java.lang.Boolean treadmill) {
    this.treadmill = treadmill;
    return this;
  }

  /**
   * Treadmill exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getTreadmillException() {
    return treadmillException;
  }

  /**
   * Treadmill exception.
   * @param treadmillException treadmillException or {@code null} for none
   */
  public Wellness setTreadmillException(java.lang.String treadmillException) {
    this.treadmillException = treadmillException;
    return this;
  }

  /**
   * Weight machine. Non-electronic fitness equipment designed for the user to target the exertion
   * of different muscles. Usually incorporates a padded seat, a stack of flat weights and various
   * bars and pulleys. May be designed for toning a specific part of the body or may involve
   * different user-controlled settings, hardware and pulleys so as to provide an overall workout in
   * one machine. Commonly found in a gym, fitness center, fitness room, or health club.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getWeightMachine() {
    return weightMachine;
  }

  /**
   * Weight machine. Non-electronic fitness equipment designed for the user to target the exertion
   * of different muscles. Usually incorporates a padded seat, a stack of flat weights and various
   * bars and pulleys. May be designed for toning a specific part of the body or may involve
   * different user-controlled settings, hardware and pulleys so as to provide an overall workout in
   * one machine. Commonly found in a gym, fitness center, fitness room, or health club.
   * @param weightMachine weightMachine or {@code null} for none
   */
  public Wellness setWeightMachine(java.lang.Boolean weightMachine) {
    this.weightMachine = weightMachine;
    return this;
  }

  /**
   * Weight machine exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getWeightMachineException() {
    return weightMachineException;
  }

  /**
   * Weight machine exception.
   * @param weightMachineException weightMachineException or {@code null} for none
   */
  public Wellness setWeightMachineException(java.lang.String weightMachineException) {
    this.weightMachineException = weightMachineException;
    return this;
  }

  @Override
  public Wellness set(String fieldName, Object value) {
    return (Wellness) super.set(fieldName, value);
  }

  @Override
  public Wellness clone() {
    return (Wellness) super.clone();
  }

}
