/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A single list item. Each variation of an item in the price list should have its own Item with its
 * own price data.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Item extends com.google.api.client.json.GenericJson {

  /**
   * Required. ID for the item. Price list, section, and item IDs cannot be duplicated within this
   * Location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String itemId;

  /**
   * Required. Language-tagged labels for the item. We recommend that item names be 140 characters
   * or less, and descriptions 250 characters or less. At least one set of labels is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Label> labels;

  static {
    // hack to force ProGuard to consider Label used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Label.class);
  }

  /**
   * Optional. Price of the item.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money price;

  /**
   * Required. ID for the item. Price list, section, and item IDs cannot be duplicated within this
   * Location.
   * @return value or {@code null} for none
   */
  public java.lang.String getItemId() {
    return itemId;
  }

  /**
   * Required. ID for the item. Price list, section, and item IDs cannot be duplicated within this
   * Location.
   * @param itemId itemId or {@code null} for none
   */
  public Item setItemId(java.lang.String itemId) {
    this.itemId = itemId;
    return this;
  }

  /**
   * Required. Language-tagged labels for the item. We recommend that item names be 140 characters
   * or less, and descriptions 250 characters or less. At least one set of labels is required.
   * @return value or {@code null} for none
   */
  public java.util.List<Label> getLabels() {
    return labels;
  }

  /**
   * Required. Language-tagged labels for the item. We recommend that item names be 140 characters
   * or less, and descriptions 250 characters or less. At least one set of labels is required.
   * @param labels labels or {@code null} for none
   */
  public Item setLabels(java.util.List<Label> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Optional. Price of the item.
   * @return value or {@code null} for none
   */
  public Money getPrice() {
    return price;
  }

  /**
   * Optional. Price of the item.
   * @param price price or {@code null} for none
   */
  public Item setPrice(Money price) {
    this.price = price;
    return this;
  }

  @Override
  public Item set(String fieldName, Object value) {
    return (Item) super.set(fieldName, value);
  }

  @Override
  public Item clone() {
    return (Item) super.clone();
  }

}
