/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * A range of time. Data will be pulled over the range as a half-open inverval (that is,
 * [start_time, end_time)).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TimeRange extends com.google.api.client.json.GenericJson {

  /**
   * Epoch timestamp for the end of the range (exclusive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String endTime;

  /**
   * Epoch timestamp for the start of the range (inclusive).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String startTime;

  /**
   * Epoch timestamp for the end of the range (exclusive).
   * @return value or {@code null} for none
   */
  public String getEndTime() {
    return endTime;
  }

  /**
   * Epoch timestamp for the end of the range (exclusive).
   * @param endTime endTime or {@code null} for none
   */
  public TimeRange setEndTime(String endTime) {
    this.endTime = endTime;
    return this;
  }

  /**
   * Epoch timestamp for the start of the range (inclusive).
   * @return value or {@code null} for none
   */
  public String getStartTime() {
    return startTime;
  }

  /**
   * Epoch timestamp for the start of the range (inclusive).
   * @param startTime startTime or {@code null} for none
   */
  public TimeRange setStartTime(String startTime) {
    this.startTime = startTime;
    return this;
  }

  @Override
  public TimeRange set(String fieldName, Object value) {
    return (TimeRange) super.set(fieldName, value);
  }

  @Override
  public TimeRange clone() {
    return (TimeRange) super.clone();
  }

}
