/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Additional Info stored for an organization.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrganizationInfo extends com.google.api.client.json.GenericJson {

  /**
   * The contact number for the organization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * The postal address for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PostalAddress postalAddress;

  /**
   * The registered domain for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String registeredDomain;

  /**
   * The contact number for the organization.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * The contact number for the organization.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public OrganizationInfo setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * The postal address for the account.
   * @return value or {@code null} for none
   */
  public PostalAddress getPostalAddress() {
    return postalAddress;
  }

  /**
   * The postal address for the account.
   * @param postalAddress postalAddress or {@code null} for none
   */
  public OrganizationInfo setPostalAddress(PostalAddress postalAddress) {
    this.postalAddress = postalAddress;
    return this;
  }

  /**
   * The registered domain for the account.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegisteredDomain() {
    return registeredDomain;
  }

  /**
   * The registered domain for the account.
   * @param registeredDomain registeredDomain or {@code null} for none
   */
  public OrganizationInfo setRegisteredDomain(java.lang.String registeredDomain) {
    this.registeredDomain = registeredDomain;
    return this;
  }

  @Override
  public OrganizationInfo set(String fieldName, Object value) {
    return (OrganizationInfo) super.set(fieldName, value);
  }

  @Override
  public OrganizationInfo clone() {
    return (OrganizationInfo) super.clone();
  }

}
