/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Information related to the opening state of the business.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OpenInfo extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Indicates whether this business is eligible for re-open.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean canReopen;

  /**
   * The date on which the location first opened. If the exact day is not known, month and year only
   * can be provided. The date must be in the past or be no more than one year in the future.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Date openingDate;

  /**
   * Indicates whether or not the Location is currently open for business. All locations are open by
   * default, unless updated to be closed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String status;

  /**
   * Output only. Indicates whether this business is eligible for re-open.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getCanReopen() {
    return canReopen;
  }

  /**
   * Output only. Indicates whether this business is eligible for re-open.
   * @param canReopen canReopen or {@code null} for none
   */
  public OpenInfo setCanReopen(java.lang.Boolean canReopen) {
    this.canReopen = canReopen;
    return this;
  }

  /**
   * The date on which the location first opened. If the exact day is not known, month and year only
   * can be provided. The date must be in the past or be no more than one year in the future.
   * @return value or {@code null} for none
   */
  public Date getOpeningDate() {
    return openingDate;
  }

  /**
   * The date on which the location first opened. If the exact day is not known, month and year only
   * can be provided. The date must be in the past or be no more than one year in the future.
   * @param openingDate openingDate or {@code null} for none
   */
  public OpenInfo setOpeningDate(Date openingDate) {
    this.openingDate = openingDate;
    return this;
  }

  /**
   * Indicates whether or not the Location is currently open for business. All locations are open by
   * default, unless updated to be closed.
   * @return value or {@code null} for none
   */
  public java.lang.String getStatus() {
    return status;
  }

  /**
   * Indicates whether or not the Location is currently open for business. All locations are open by
   * default, unless updated to be closed.
   * @param status status or {@code null} for none
   */
  public OpenInfo setStatus(java.lang.String status) {
    this.status = status;
    return this;
  }

  @Override
  public OpenInfo set(String fieldName, Object value) {
    return (OpenInfo) super.set(fieldName, value);
  }

  @Override
  public OpenInfo clone() {
    return (OpenInfo) super.clone();
  }

}
