/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Display data for verifications through email.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class EmailVerificationData extends com.google.api.client.json.GenericJson {

  /**
   * Domain name in the email address. e.g. "gmail.com" in foo@gmail.com
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String domainName;

  /**
   * Whether client is allowed to provide a different user name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isUserNameEditable;

  /**
   * User name in the email address. e.g. "foo" in foo@gmail.com
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userName;

  /**
   * Domain name in the email address. e.g. "gmail.com" in foo@gmail.com
   * @return value or {@code null} for none
   */
  public java.lang.String getDomainName() {
    return domainName;
  }

  /**
   * Domain name in the email address. e.g. "gmail.com" in foo@gmail.com
   * @param domainName domainName or {@code null} for none
   */
  public EmailVerificationData setDomainName(java.lang.String domainName) {
    this.domainName = domainName;
    return this;
  }

  /**
   * Whether client is allowed to provide a different user name.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsUserNameEditable() {
    return isUserNameEditable;
  }

  /**
   * Whether client is allowed to provide a different user name.
   * @param isUserNameEditable isUserNameEditable or {@code null} for none
   */
  public EmailVerificationData setIsUserNameEditable(java.lang.Boolean isUserNameEditable) {
    this.isUserNameEditable = isUserNameEditable;
    return this;
  }

  /**
   * User name in the email address. e.g. "foo" in foo@gmail.com
   * @return value or {@code null} for none
   */
  public java.lang.String getUserName() {
    return userName;
  }

  /**
   * User name in the email address. e.g. "foo" in foo@gmail.com
   * @param userName userName or {@code null} for none
   */
  public EmailVerificationData setUserName(java.lang.String userName) {
    this.userName = userName;
    return this;
  }

  @Override
  public EmailVerificationData set(String fieldName, Object value) {
    return (EmailVerificationData) super.set(fieldName, value);
  }

  @Override
  public EmailVerificationData clone() {
    return (EmailVerificationData) super.clone();
  }

}
