/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Information about the location that this location duplicates.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Duplicate extends com.google.api.client.json.GenericJson {

  /**
   * Indicates whether the user has access to the location it duplicates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String access;

  /**
   * The resource name of the location that this duplicates. Only populated if the authenticated
   * user has access rights to that location and that location is not deleted.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String locationName;

  /**
   * The place ID of the location that this duplicates.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String placeId;

  /**
   * Indicates whether the user has access to the location it duplicates.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccess() {
    return access;
  }

  /**
   * Indicates whether the user has access to the location it duplicates.
   * @param access access or {@code null} for none
   */
  public Duplicate setAccess(java.lang.String access) {
    this.access = access;
    return this;
  }

  /**
   * The resource name of the location that this duplicates. Only populated if the authenticated
   * user has access rights to that location and that location is not deleted.
   * @return value or {@code null} for none
   */
  public java.lang.String getLocationName() {
    return locationName;
  }

  /**
   * The resource name of the location that this duplicates. Only populated if the authenticated
   * user has access rights to that location and that location is not deleted.
   * @param locationName locationName or {@code null} for none
   */
  public Duplicate setLocationName(java.lang.String locationName) {
    this.locationName = locationName;
    return this;
  }

  /**
   * The place ID of the location that this duplicates.
   * @return value or {@code null} for none
   */
  public java.lang.String getPlaceId() {
    return placeId;
  }

  /**
   * The place ID of the location that this duplicates.
   * @param placeId placeId or {@code null} for none
   */
  public Duplicate setPlaceId(java.lang.String placeId) {
    this.placeId = placeId;
    return this;
  }

  @Override
  public Duplicate set(String fieldName, Object value) {
    return (Duplicate) super.set(fieldName, value);
  }

  @Override
  public Duplicate clone() {
    return (Duplicate) super.clone();
  }

}
