/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Features of the property of specific interest to the business traveler.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Business extends com.google.api.client.json.GenericJson {

  /**
   * Business center. A designated room at the hotel with one or more desks and equipped with guest-
   * use computers, printers, fax machines and/or photocopiers. May or may not be open 24/7. May or
   * may not require a key to access. Not a meeting room or conference room.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean businessCenter;

  /**
   * Business center exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String businessCenterException;

  /**
   * Meeting rooms. Rooms at the hotel designated for business-related gatherings. Rooms are usually
   * equipped with tables or desks, office chairs and audio/visual facilities to allow for
   * presentations and conference calls. Also known as conference rooms.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean meetingRooms;

  /**
   * Meeting rooms count. The number of meeting rooms at the property.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer meetingRoomsCount;

  /**
   * Meeting rooms count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String meetingRoomsCountException;

  /**
   * Meeting rooms exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String meetingRoomsException;

  /**
   * Business center. A designated room at the hotel with one or more desks and equipped with guest-
   * use computers, printers, fax machines and/or photocopiers. May or may not be open 24/7. May or
   * may not require a key to access. Not a meeting room or conference room.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getBusinessCenter() {
    return businessCenter;
  }

  /**
   * Business center. A designated room at the hotel with one or more desks and equipped with guest-
   * use computers, printers, fax machines and/or photocopiers. May or may not be open 24/7. May or
   * may not require a key to access. Not a meeting room or conference room.
   * @param businessCenter businessCenter or {@code null} for none
   */
  public Business setBusinessCenter(java.lang.Boolean businessCenter) {
    this.businessCenter = businessCenter;
    return this;
  }

  /**
   * Business center exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getBusinessCenterException() {
    return businessCenterException;
  }

  /**
   * Business center exception.
   * @param businessCenterException businessCenterException or {@code null} for none
   */
  public Business setBusinessCenterException(java.lang.String businessCenterException) {
    this.businessCenterException = businessCenterException;
    return this;
  }

  /**
   * Meeting rooms. Rooms at the hotel designated for business-related gatherings. Rooms are usually
   * equipped with tables or desks, office chairs and audio/visual facilities to allow for
   * presentations and conference calls. Also known as conference rooms.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getMeetingRooms() {
    return meetingRooms;
  }

  /**
   * Meeting rooms. Rooms at the hotel designated for business-related gatherings. Rooms are usually
   * equipped with tables or desks, office chairs and audio/visual facilities to allow for
   * presentations and conference calls. Also known as conference rooms.
   * @param meetingRooms meetingRooms or {@code null} for none
   */
  public Business setMeetingRooms(java.lang.Boolean meetingRooms) {
    this.meetingRooms = meetingRooms;
    return this;
  }

  /**
   * Meeting rooms count. The number of meeting rooms at the property.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMeetingRoomsCount() {
    return meetingRoomsCount;
  }

  /**
   * Meeting rooms count. The number of meeting rooms at the property.
   * @param meetingRoomsCount meetingRoomsCount or {@code null} for none
   */
  public Business setMeetingRoomsCount(java.lang.Integer meetingRoomsCount) {
    this.meetingRoomsCount = meetingRoomsCount;
    return this;
  }

  /**
   * Meeting rooms count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeetingRoomsCountException() {
    return meetingRoomsCountException;
  }

  /**
   * Meeting rooms count exception.
   * @param meetingRoomsCountException meetingRoomsCountException or {@code null} for none
   */
  public Business setMeetingRoomsCountException(java.lang.String meetingRoomsCountException) {
    this.meetingRoomsCountException = meetingRoomsCountException;
    return this;
  }

  /**
   * Meeting rooms exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getMeetingRoomsException() {
    return meetingRoomsException;
  }

  /**
   * Meeting rooms exception.
   * @param meetingRoomsException meetingRoomsException or {@code null} for none
   */
  public Business setMeetingRoomsException(java.lang.String meetingRoomsException) {
    this.meetingRoomsException = meetingRoomsException;
    return this;
  }

  @Override
  public Business set(String fieldName, Object value) {
    return (Business) super.set(fieldName, value);
  }

  @Override
  public Business clone() {
    return (Business) super.clone();
  }

}
