/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * An account is a container for your business's locations. If you are the only user who manages
 * locations for your business, you can use your personal Google Account. To share management of
 * locations with multiple users, [create a business account]
 * (https://support.google.com/business/answer/6085339?ref_topic=6085325).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Account extends com.google.api.client.json.GenericJson {

  /**
   * The name of the account. *Note:* For an account with AccountType `PERSONAL`, this is the first
   * and last name of the user account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountName;

  /**
   * Account reference number if provisioned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountNumber;

  /**
   * The resource name, in the format `accounts/{account_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Additional info for an organization. This is populated only for an organization account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrganizationInfo organizationInfo;

  /**
   * Output only. Specifies the PermissionLevel the caller has for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permissionLevel;

  /**
   * Output only. Specifies the AccountRole the caller has for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Output only. Indicates the AccountState of this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AccountState state;

  /**
   * Output only. Specifies the AccountType of this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The name of the account. *Note:* For an account with AccountType `PERSONAL`, this is the first
   * and last name of the user account.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountName() {
    return accountName;
  }

  /**
   * The name of the account. *Note:* For an account with AccountType `PERSONAL`, this is the first
   * and last name of the user account.
   * @param accountName accountName or {@code null} for none
   */
  public Account setAccountName(java.lang.String accountName) {
    this.accountName = accountName;
    return this;
  }

  /**
   * Account reference number if provisioned.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountNumber() {
    return accountNumber;
  }

  /**
   * Account reference number if provisioned.
   * @param accountNumber accountNumber or {@code null} for none
   */
  public Account setAccountNumber(java.lang.String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * The resource name, in the format `accounts/{account_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The resource name, in the format `accounts/{account_id}`.
   * @param name name or {@code null} for none
   */
  public Account setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Additional info for an organization. This is populated only for an organization account.
   * @return value or {@code null} for none
   */
  public OrganizationInfo getOrganizationInfo() {
    return organizationInfo;
  }

  /**
   * Additional info for an organization. This is populated only for an organization account.
   * @param organizationInfo organizationInfo or {@code null} for none
   */
  public Account setOrganizationInfo(OrganizationInfo organizationInfo) {
    this.organizationInfo = organizationInfo;
    return this;
  }

  /**
   * Output only. Specifies the PermissionLevel the caller has for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermissionLevel() {
    return permissionLevel;
  }

  /**
   * Output only. Specifies the PermissionLevel the caller has for this account.
   * @param permissionLevel permissionLevel or {@code null} for none
   */
  public Account setPermissionLevel(java.lang.String permissionLevel) {
    this.permissionLevel = permissionLevel;
    return this;
  }

  /**
   * Output only. Specifies the AccountRole the caller has for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Output only. Specifies the AccountRole the caller has for this account.
   * @param role role or {@code null} for none
   */
  public Account setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Output only. Indicates the AccountState of this account.
   * @return value or {@code null} for none
   */
  public AccountState getState() {
    return state;
  }

  /**
   * Output only. Indicates the AccountState of this account.
   * @param state state or {@code null} for none
   */
  public Account setState(AccountState state) {
    this.state = state;
    return this;
  }

  /**
   * Output only. Specifies the AccountType of this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Output only. Specifies the AccountType of this account.
   * @param type type or {@code null} for none
   */
  public Account setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public Account set(String fieldName, Object value) {
    return (Account) super.set(fieldName, value);
  }

  @Override
  public Account clone() {
    return (Account) super.clone();
  }

}
