/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Metadata for an attribute. Contains display information for the attribute, including a localized
 * name and a heading for grouping related attributes together.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AttributeMetadata extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the attribute.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String attributeId;

  /**
   * The localized display name for the attribute, if available; otherwise, the English display
   * name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String displayName;

  /**
   * The localized display name of the group that contains this attribute, if available; otherwise,
   * the English group name. Related attributes are collected into a group and should be displayed
   * together under the heading given here.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String groupDisplayName;

  /**
   * If true, the attribute is deprecated and should no longer be used. If deprecated, updating this
   * attribute will not result in an error, but updates will not be saved. At some point after being
   * deprecated, the attribute will be removed entirely and it will become an error.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isDeprecated;

  /**
   * If true, the attribute supports multiple values. If false, only a single value should be
   * provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isRepeatable;

  /**
   * For some types of attributes (for example, enums), a list of supported values and corresponding
   * display names for those values is provided.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<AttributeValueMetadata> valueMetadata;

  static {
    // hack to force ProGuard to consider AttributeValueMetadata used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(AttributeValueMetadata.class);
  }

  /**
   * The value type for the attribute. Values set and retrieved should be expected to be of this
   * type.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String valueType;

  /**
   * The ID of the attribute.
   * @return value or {@code null} for none
   */
  public java.lang.String getAttributeId() {
    return attributeId;
  }

  /**
   * The ID of the attribute.
   * @param attributeId attributeId or {@code null} for none
   */
  public AttributeMetadata setAttributeId(java.lang.String attributeId) {
    this.attributeId = attributeId;
    return this;
  }

  /**
   * The localized display name for the attribute, if available; otherwise, the English display
   * name.
   * @return value or {@code null} for none
   */
  public java.lang.String getDisplayName() {
    return displayName;
  }

  /**
   * The localized display name for the attribute, if available; otherwise, the English display
   * name.
   * @param displayName displayName or {@code null} for none
   */
  public AttributeMetadata setDisplayName(java.lang.String displayName) {
    this.displayName = displayName;
    return this;
  }

  /**
   * The localized display name of the group that contains this attribute, if available; otherwise,
   * the English group name. Related attributes are collected into a group and should be displayed
   * together under the heading given here.
   * @return value or {@code null} for none
   */
  public java.lang.String getGroupDisplayName() {
    return groupDisplayName;
  }

  /**
   * The localized display name of the group that contains this attribute, if available; otherwise,
   * the English group name. Related attributes are collected into a group and should be displayed
   * together under the heading given here.
   * @param groupDisplayName groupDisplayName or {@code null} for none
   */
  public AttributeMetadata setGroupDisplayName(java.lang.String groupDisplayName) {
    this.groupDisplayName = groupDisplayName;
    return this;
  }

  /**
   * If true, the attribute is deprecated and should no longer be used. If deprecated, updating this
   * attribute will not result in an error, but updates will not be saved. At some point after being
   * deprecated, the attribute will be removed entirely and it will become an error.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsDeprecated() {
    return isDeprecated;
  }

  /**
   * If true, the attribute is deprecated and should no longer be used. If deprecated, updating this
   * attribute will not result in an error, but updates will not be saved. At some point after being
   * deprecated, the attribute will be removed entirely and it will become an error.
   * @param isDeprecated isDeprecated or {@code null} for none
   */
  public AttributeMetadata setIsDeprecated(java.lang.Boolean isDeprecated) {
    this.isDeprecated = isDeprecated;
    return this;
  }

  /**
   * If true, the attribute supports multiple values. If false, only a single value should be
   * provided.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsRepeatable() {
    return isRepeatable;
  }

  /**
   * If true, the attribute supports multiple values. If false, only a single value should be
   * provided.
   * @param isRepeatable isRepeatable or {@code null} for none
   */
  public AttributeMetadata setIsRepeatable(java.lang.Boolean isRepeatable) {
    this.isRepeatable = isRepeatable;
    return this;
  }

  /**
   * For some types of attributes (for example, enums), a list of supported values and corresponding
   * display names for those values is provided.
   * @return value or {@code null} for none
   */
  public java.util.List<AttributeValueMetadata> getValueMetadata() {
    return valueMetadata;
  }

  /**
   * For some types of attributes (for example, enums), a list of supported values and corresponding
   * display names for those values is provided.
   * @param valueMetadata valueMetadata or {@code null} for none
   */
  public AttributeMetadata setValueMetadata(java.util.List<AttributeValueMetadata> valueMetadata) {
    this.valueMetadata = valueMetadata;
    return this;
  }

  /**
   * The value type for the attribute. Values set and retrieved should be expected to be of this
   * type.
   * @return value or {@code null} for none
   */
  public java.lang.String getValueType() {
    return valueType;
  }

  /**
   * The value type for the attribute. Values set and retrieved should be expected to be of this
   * type.
   * @param valueType valueType or {@code null} for none
   */
  public AttributeMetadata setValueType(java.lang.String valueType) {
    this.valueType = valueType;
    return this;
  }

  @Override
  public AttributeMetadata set(String fieldName, Object value) {
    return (AttributeMetadata) super.set(fieldName, value);
  }

  @Override
  public AttributeMetadata clone() {
    return (AttributeMetadata) super.clone();
  }

}
