/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Response message for Locations.FindMatchingLocations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FindMatchingLocationsResponse extends com.google.api.client.json.GenericJson {

  /**
   * When the matching algorithm was last executed for this location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private String matchTime;

  /**
   * A collection of locations that are potential matches to the specified location, listed in order
   * from best to least match. If there is an exact match, it will be in the first position.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MatchedLocation> matchedLocations;

  static {
    // hack to force ProGuard to consider MatchedLocation used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MatchedLocation.class);
  }

  /**
   * When the matching algorithm was last executed for this location.
   * @return value or {@code null} for none
   */
  public String getMatchTime() {
    return matchTime;
  }

  /**
   * When the matching algorithm was last executed for this location.
   * @param matchTime matchTime or {@code null} for none
   */
  public FindMatchingLocationsResponse setMatchTime(String matchTime) {
    this.matchTime = matchTime;
    return this;
  }

  /**
   * A collection of locations that are potential matches to the specified location, listed in order
   * from best to least match. If there is an exact match, it will be in the first position.
   * @return value or {@code null} for none
   */
  public java.util.List<MatchedLocation> getMatchedLocations() {
    return matchedLocations;
  }

  /**
   * A collection of locations that are potential matches to the specified location, listed in order
   * from best to least match. If there is an exact match, it will be in the first position.
   * @param matchedLocations matchedLocations or {@code null} for none
   */
  public FindMatchingLocationsResponse setMatchedLocations(java.util.List<MatchedLocation> matchedLocations) {
    this.matchedLocations = matchedLocations;
    return this;
  }

  @Override
  public FindMatchingLocationsResponse set(String fieldName, Object value) {
    return (FindMatchingLocationsResponse) super.set(fieldName, value);
  }

  @Override
  public FindMatchingLocationsResponse clone() {
    return (FindMatchingLocationsResponse) super.clone();
  }

}
