/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Item of a Section. It can be the dish itself, or can contain multiple FoodMenuItemOption.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FoodMenuItem extends com.google.api.client.json.GenericJson {

  /**
   * Required. Detailed attributes of the item. When item options are specified, this is considered
   * as the base attributes and populate to each options.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private FoodMenuItemAttributes attributes;

  /**
   * Required. Language tagged labels for this menu item. Display names should be 140 characters or
   * less, with descriptions 1,000 characters or less. At least one set of labels is required.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MenuLabel> labels;

  /**
   * Optional. This is for an item that comes in multiple different options, and users are required
   * to make choices. E.g. "regular" vs. "large" pizza. When options are specified, labels and
   * attributes at item level will automatically become the first option's labels and attributes.
   * Clients only need to specify other additional food options in this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FoodMenuItemOption> options;

  /**
   * Required. Detailed attributes of the item. When item options are specified, this is considered
   * as the base attributes and populate to each options.
   * @return value or {@code null} for none
   */
  public FoodMenuItemAttributes getAttributes() {
    return attributes;
  }

  /**
   * Required. Detailed attributes of the item. When item options are specified, this is considered
   * as the base attributes and populate to each options.
   * @param attributes attributes or {@code null} for none
   */
  public FoodMenuItem setAttributes(FoodMenuItemAttributes attributes) {
    this.attributes = attributes;
    return this;
  }

  /**
   * Required. Language tagged labels for this menu item. Display names should be 140 characters or
   * less, with descriptions 1,000 characters or less. At least one set of labels is required.
   * @return value or {@code null} for none
   */
  public java.util.List<MenuLabel> getLabels() {
    return labels;
  }

  /**
   * Required. Language tagged labels for this menu item. Display names should be 140 characters or
   * less, with descriptions 1,000 characters or less. At least one set of labels is required.
   * @param labels labels or {@code null} for none
   */
  public FoodMenuItem setLabels(java.util.List<MenuLabel> labels) {
    this.labels = labels;
    return this;
  }

  /**
   * Optional. This is for an item that comes in multiple different options, and users are required
   * to make choices. E.g. "regular" vs. "large" pizza. When options are specified, labels and
   * attributes at item level will automatically become the first option's labels and attributes.
   * Clients only need to specify other additional food options in this field.
   * @return value or {@code null} for none
   */
  public java.util.List<FoodMenuItemOption> getOptions() {
    return options;
  }

  /**
   * Optional. This is for an item that comes in multiple different options, and users are required
   * to make choices. E.g. "regular" vs. "large" pizza. When options are specified, labels and
   * attributes at item level will automatically become the first option's labels and attributes.
   * Clients only need to specify other additional food options in this field.
   * @param options options or {@code null} for none
   */
  public FoodMenuItem setOptions(java.util.List<FoodMenuItemOption> options) {
    this.options = options;
    return this;
  }

  @Override
  public FoodMenuItem set(String fieldName, Object value) {
    return (FoodMenuItem) super.set(fieldName, value);
  }

  @Override
  public FoodMenuItem clone() {
    return (FoodMenuItem) super.clone();
  }

}
