/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Attributes of a food item/dish.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FoodMenuItemAttributes extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Allergens associated with the food dish. It is highly recommended to provide this
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> allergen;

  /**
   * Optional. Dietary information of the food dish. It is highly recommended to provide this field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> dietaryRestriction;

  /**
   * Optional. Ingredients of the food dish option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Ingredient> ingredients;

  /**
   * Optional. The media keys of the media associated with the dish. Only photo media is supported.
   * When there are multiple photos associated, the first photo is considered as the preferred
   * photo.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> mediaKeys;

  /**
   * Optional. Nutrition facts of the food dish option. It is highly recommended to provide this
   * field.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NutritionFacts nutritionFacts;

  /**
   * Optional. Size of the order, represented in units of items. (e.g. 4 "skewers", 6 "pieces")
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PortionSize portionSize;

  /**
   * Optional. Methods on how the food dish option is prepared.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> preparationMethods;

  /**
   * Required. Price of the food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Money price;

  /**
   * Optional. Number of people can be served by this food dish option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer servesNumPeople;

  /**
   * Optional. Spiciness level of the food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String spiciness;

  /**
   * Optional. Allergens associated with the food dish. It is highly recommended to provide this
   * field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getAllergen() {
    return allergen;
  }

  /**
   * Optional. Allergens associated with the food dish. It is highly recommended to provide this
   * field.
   * @param allergen allergen or {@code null} for none
   */
  public FoodMenuItemAttributes setAllergen(java.util.List<java.lang.String> allergen) {
    this.allergen = allergen;
    return this;
  }

  /**
   * Optional. Dietary information of the food dish. It is highly recommended to provide this field.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getDietaryRestriction() {
    return dietaryRestriction;
  }

  /**
   * Optional. Dietary information of the food dish. It is highly recommended to provide this field.
   * @param dietaryRestriction dietaryRestriction or {@code null} for none
   */
  public FoodMenuItemAttributes setDietaryRestriction(java.util.List<java.lang.String> dietaryRestriction) {
    this.dietaryRestriction = dietaryRestriction;
    return this;
  }

  /**
   * Optional. Ingredients of the food dish option.
   * @return value or {@code null} for none
   */
  public java.util.List<Ingredient> getIngredients() {
    return ingredients;
  }

  /**
   * Optional. Ingredients of the food dish option.
   * @param ingredients ingredients or {@code null} for none
   */
  public FoodMenuItemAttributes setIngredients(java.util.List<Ingredient> ingredients) {
    this.ingredients = ingredients;
    return this;
  }

  /**
   * Optional. The media keys of the media associated with the dish. Only photo media is supported.
   * When there are multiple photos associated, the first photo is considered as the preferred
   * photo.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getMediaKeys() {
    return mediaKeys;
  }

  /**
   * Optional. The media keys of the media associated with the dish. Only photo media is supported.
   * When there are multiple photos associated, the first photo is considered as the preferred
   * photo.
   * @param mediaKeys mediaKeys or {@code null} for none
   */
  public FoodMenuItemAttributes setMediaKeys(java.util.List<java.lang.String> mediaKeys) {
    this.mediaKeys = mediaKeys;
    return this;
  }

  /**
   * Optional. Nutrition facts of the food dish option. It is highly recommended to provide this
   * field.
   * @return value or {@code null} for none
   */
  public NutritionFacts getNutritionFacts() {
    return nutritionFacts;
  }

  /**
   * Optional. Nutrition facts of the food dish option. It is highly recommended to provide this
   * field.
   * @param nutritionFacts nutritionFacts or {@code null} for none
   */
  public FoodMenuItemAttributes setNutritionFacts(NutritionFacts nutritionFacts) {
    this.nutritionFacts = nutritionFacts;
    return this;
  }

  /**
   * Optional. Size of the order, represented in units of items. (e.g. 4 "skewers", 6 "pieces")
   * @return value or {@code null} for none
   */
  public PortionSize getPortionSize() {
    return portionSize;
  }

  /**
   * Optional. Size of the order, represented in units of items. (e.g. 4 "skewers", 6 "pieces")
   * @param portionSize portionSize or {@code null} for none
   */
  public FoodMenuItemAttributes setPortionSize(PortionSize portionSize) {
    this.portionSize = portionSize;
    return this;
  }

  /**
   * Optional. Methods on how the food dish option is prepared.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getPreparationMethods() {
    return preparationMethods;
  }

  /**
   * Optional. Methods on how the food dish option is prepared.
   * @param preparationMethods preparationMethods or {@code null} for none
   */
  public FoodMenuItemAttributes setPreparationMethods(java.util.List<java.lang.String> preparationMethods) {
    this.preparationMethods = preparationMethods;
    return this;
  }

  /**
   * Required. Price of the food dish.
   * @return value or {@code null} for none
   */
  public Money getPrice() {
    return price;
  }

  /**
   * Required. Price of the food dish.
   * @param price price or {@code null} for none
   */
  public FoodMenuItemAttributes setPrice(Money price) {
    this.price = price;
    return this;
  }

  /**
   * Optional. Number of people can be served by this food dish option.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getServesNumPeople() {
    return servesNumPeople;
  }

  /**
   * Optional. Number of people can be served by this food dish option.
   * @param servesNumPeople servesNumPeople or {@code null} for none
   */
  public FoodMenuItemAttributes setServesNumPeople(java.lang.Integer servesNumPeople) {
    this.servesNumPeople = servesNumPeople;
    return this;
  }

  /**
   * Optional. Spiciness level of the food dish.
   * @return value or {@code null} for none
   */
  public java.lang.String getSpiciness() {
    return spiciness;
  }

  /**
   * Optional. Spiciness level of the food dish.
   * @param spiciness spiciness or {@code null} for none
   */
  public FoodMenuItemAttributes setSpiciness(java.lang.String spiciness) {
    this.spiciness = spiciness;
    return this;
  }

  @Override
  public FoodMenuItemAttributes set(String fieldName, Object value) {
    return (FoodMenuItemAttributes) super.set(fieldName, value);
  }

  @Override
  public FoodMenuItemAttributes clone() {
    return (FoodMenuItemAttributes) super.clone();
  }

}
