/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * General factual information about the property's physical structure and important dates.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Property extends com.google.api.client.json.GenericJson {

  /**
   * Built year. The year that construction of the property was completed.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer builtYear;

  /**
   * Built year exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String builtYearException;

  /**
   * Floors count. The number of stories the building has from the ground floor to the top floor
   * that are accessible to guests.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer floorsCount;

  /**
   * Floors count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String floorsCountException;

  /**
   * Last renovated year. The year when the most recent renovation of the property was completed.
   * Renovation may include all or any combination of the following: the units, the public spaces,
   * the exterior, or the interior.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer lastRenovatedYear;

  /**
   * Last renovated year exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String lastRenovatedYearException;

  /**
   * Rooms count. The total number of rooms and suites bookable by guests for an overnight stay.
   * Does not include event space, public spaces, conference rooms, fitness rooms, business centers,
   * spa, salon, restaurants/bars, or shops.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer roomsCount;

  /**
   * Rooms count exception.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String roomsCountException;

  /**
   * Built year. The year that construction of the property was completed.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBuiltYear() {
    return builtYear;
  }

  /**
   * Built year. The year that construction of the property was completed.
   * @param builtYear builtYear or {@code null} for none
   */
  public Property setBuiltYear(java.lang.Integer builtYear) {
    this.builtYear = builtYear;
    return this;
  }

  /**
   * Built year exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getBuiltYearException() {
    return builtYearException;
  }

  /**
   * Built year exception.
   * @param builtYearException builtYearException or {@code null} for none
   */
  public Property setBuiltYearException(java.lang.String builtYearException) {
    this.builtYearException = builtYearException;
    return this;
  }

  /**
   * Floors count. The number of stories the building has from the ground floor to the top floor
   * that are accessible to guests.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getFloorsCount() {
    return floorsCount;
  }

  /**
   * Floors count. The number of stories the building has from the ground floor to the top floor
   * that are accessible to guests.
   * @param floorsCount floorsCount or {@code null} for none
   */
  public Property setFloorsCount(java.lang.Integer floorsCount) {
    this.floorsCount = floorsCount;
    return this;
  }

  /**
   * Floors count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getFloorsCountException() {
    return floorsCountException;
  }

  /**
   * Floors count exception.
   * @param floorsCountException floorsCountException or {@code null} for none
   */
  public Property setFloorsCountException(java.lang.String floorsCountException) {
    this.floorsCountException = floorsCountException;
    return this;
  }

  /**
   * Last renovated year. The year when the most recent renovation of the property was completed.
   * Renovation may include all or any combination of the following: the units, the public spaces,
   * the exterior, or the interior.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getLastRenovatedYear() {
    return lastRenovatedYear;
  }

  /**
   * Last renovated year. The year when the most recent renovation of the property was completed.
   * Renovation may include all or any combination of the following: the units, the public spaces,
   * the exterior, or the interior.
   * @param lastRenovatedYear lastRenovatedYear or {@code null} for none
   */
  public Property setLastRenovatedYear(java.lang.Integer lastRenovatedYear) {
    this.lastRenovatedYear = lastRenovatedYear;
    return this;
  }

  /**
   * Last renovated year exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getLastRenovatedYearException() {
    return lastRenovatedYearException;
  }

  /**
   * Last renovated year exception.
   * @param lastRenovatedYearException lastRenovatedYearException or {@code null} for none
   */
  public Property setLastRenovatedYearException(java.lang.String lastRenovatedYearException) {
    this.lastRenovatedYearException = lastRenovatedYearException;
    return this;
  }

  /**
   * Rooms count. The total number of rooms and suites bookable by guests for an overnight stay.
   * Does not include event space, public spaces, conference rooms, fitness rooms, business centers,
   * spa, salon, restaurants/bars, or shops.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getRoomsCount() {
    return roomsCount;
  }

  /**
   * Rooms count. The total number of rooms and suites bookable by guests for an overnight stay.
   * Does not include event space, public spaces, conference rooms, fitness rooms, business centers,
   * spa, salon, restaurants/bars, or shops.
   * @param roomsCount roomsCount or {@code null} for none
   */
  public Property setRoomsCount(java.lang.Integer roomsCount) {
    this.roomsCount = roomsCount;
    return this;
  }

  /**
   * Rooms count exception.
   * @return value or {@code null} for none
   */
  public java.lang.String getRoomsCountException() {
    return roomsCountException;
  }

  /**
   * Rooms count exception.
   * @param roomsCountException roomsCountException or {@code null} for none
   */
  public Property setRoomsCountException(java.lang.String roomsCountException) {
    this.roomsCountException = roomsCountException;
    return this;
  }

  @Override
  public Property set(String fieldName, Object value) {
    return (Property) super.set(fieldName, value);
  }

  @Override
  public Property clone() {
    return (Property) super.clone();
  }

}
