/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * The verification option represents how to verify the location (indicated by verification method)
 * and where the verification will be sent to (indicated by display data).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VerificationOption extends com.google.api.client.json.GenericJson {

  /**
   * Set only if the method is MAIL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AddressVerificationData addressData;

  /**
   * Set only if the method is EMAIL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private EmailVerificationData emailData;

  /**
   * Set only if the method is PHONE_CALL or SMS.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PhoneVerificationData phoneData;

  /**
   * Method to verify the location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verificationMethod;

  /**
   * Set only if the method is MAIL.
   * @return value or {@code null} for none
   */
  public AddressVerificationData getAddressData() {
    return addressData;
  }

  /**
   * Set only if the method is MAIL.
   * @param addressData addressData or {@code null} for none
   */
  public VerificationOption setAddressData(AddressVerificationData addressData) {
    this.addressData = addressData;
    return this;
  }

  /**
   * Set only if the method is EMAIL.
   * @return value or {@code null} for none
   */
  public EmailVerificationData getEmailData() {
    return emailData;
  }

  /**
   * Set only if the method is EMAIL.
   * @param emailData emailData or {@code null} for none
   */
  public VerificationOption setEmailData(EmailVerificationData emailData) {
    this.emailData = emailData;
    return this;
  }

  /**
   * Set only if the method is PHONE_CALL or SMS.
   * @return value or {@code null} for none
   */
  public PhoneVerificationData getPhoneData() {
    return phoneData;
  }

  /**
   * Set only if the method is PHONE_CALL or SMS.
   * @param phoneData phoneData or {@code null} for none
   */
  public VerificationOption setPhoneData(PhoneVerificationData phoneData) {
    this.phoneData = phoneData;
    return this;
  }

  /**
   * Method to verify the location.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerificationMethod() {
    return verificationMethod;
  }

  /**
   * Method to verify the location.
   * @param verificationMethod verificationMethod or {@code null} for none
   */
  public VerificationOption setVerificationMethod(java.lang.String verificationMethod) {
    this.verificationMethod = verificationMethod;
    return this;
  }

  @Override
  public VerificationOption set(String fieldName, Object value) {
    return (VerificationOption) super.set(fieldName, value);
  }

  @Override
  public VerificationOption clone() {
    return (VerificationOption) super.clone();
  }

}
