/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * This message represents nutrition facts for a food dish.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class NutritionFacts extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Calories of the dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private CaloriesFact calories;

  /**
   * Optional. Cholesterol information for a given food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NutritionFact cholesterol;

  /**
   * Optional. Protein information for a given food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NutritionFact protein;

  /**
   * Optional. Sodium information for a given food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NutritionFact sodium;

  /**
   * Optional. Carbohydrate information for a given food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NutritionFact totalCarbohydrate;

  /**
   * Optional. Fat information for a given food dish.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private NutritionFact totalFat;

  /**
   * Optional. Calories of the dish.
   * @return value or {@code null} for none
   */
  public CaloriesFact getCalories() {
    return calories;
  }

  /**
   * Optional. Calories of the dish.
   * @param calories calories or {@code null} for none
   */
  public NutritionFacts setCalories(CaloriesFact calories) {
    this.calories = calories;
    return this;
  }

  /**
   * Optional. Cholesterol information for a given food dish.
   * @return value or {@code null} for none
   */
  public NutritionFact getCholesterol() {
    return cholesterol;
  }

  /**
   * Optional. Cholesterol information for a given food dish.
   * @param cholesterol cholesterol or {@code null} for none
   */
  public NutritionFacts setCholesterol(NutritionFact cholesterol) {
    this.cholesterol = cholesterol;
    return this;
  }

  /**
   * Optional. Protein information for a given food dish.
   * @return value or {@code null} for none
   */
  public NutritionFact getProtein() {
    return protein;
  }

  /**
   * Optional. Protein information for a given food dish.
   * @param protein protein or {@code null} for none
   */
  public NutritionFacts setProtein(NutritionFact protein) {
    this.protein = protein;
    return this;
  }

  /**
   * Optional. Sodium information for a given food dish.
   * @return value or {@code null} for none
   */
  public NutritionFact getSodium() {
    return sodium;
  }

  /**
   * Optional. Sodium information for a given food dish.
   * @param sodium sodium or {@code null} for none
   */
  public NutritionFacts setSodium(NutritionFact sodium) {
    this.sodium = sodium;
    return this;
  }

  /**
   * Optional. Carbohydrate information for a given food dish.
   * @return value or {@code null} for none
   */
  public NutritionFact getTotalCarbohydrate() {
    return totalCarbohydrate;
  }

  /**
   * Optional. Carbohydrate information for a given food dish.
   * @param totalCarbohydrate totalCarbohydrate or {@code null} for none
   */
  public NutritionFacts setTotalCarbohydrate(NutritionFact totalCarbohydrate) {
    this.totalCarbohydrate = totalCarbohydrate;
    return this;
  }

  /**
   * Optional. Fat information for a given food dish.
   * @return value or {@code null} for none
   */
  public NutritionFact getTotalFat() {
    return totalFat;
  }

  /**
   * Optional. Fat information for a given food dish.
   * @param totalFat totalFat or {@code null} for none
   */
  public NutritionFacts setTotalFat(NutritionFact totalFat) {
    this.totalFat = totalFat;
    return this;
  }

  @Override
  public NutritionFacts set(String fieldName, Object value) {
    return (NutritionFacts) super.set(fieldName, value);
  }

  @Override
  public NutritionFacts clone() {
    return (NutritionFacts) super.clone();
  }

}
