/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/google/apis-client-generator/
 * (build: 1969-12-31 23:59:59 UTC)
 * on 2021-02-24 at 00:14:02 UTC 
 * Modify at your own risk.
 */

package com.google.api.services.mybusiness.v4.model;

/**
 * Menus of a business that serve food dishes.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google My Business API. For a detailed explanation
 * see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class FoodMenus extends com.google.api.client.json.GenericJson {

  /**
   * Optional. A collection of food menus.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<FoodMenu> menus;

  static {
    // hack to force ProGuard to consider FoodMenu used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(FoodMenu.class);
  }

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/foodMenus`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Optional. A collection of food menus.
   * @return value or {@code null} for none
   */
  public java.util.List<FoodMenu> getMenus() {
    return menus;
  }

  /**
   * Optional. A collection of food menus.
   * @param menus menus or {@code null} for none
   */
  public FoodMenus setMenus(java.util.List<FoodMenu> menus) {
    this.menus = menus;
    return this;
  }

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/foodMenus`
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. Google identifier for this location in the form:
   * `accounts/{account_id}/locations/{location_id}/foodMenus`
   * @param name name or {@code null} for none
   */
  public FoodMenus setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  @Override
  public FoodMenus set(String fieldName, Object value) {
    return (FoodMenus) super.set(fieldName, value);
  }

  @Override
  public FoodMenus clone() {
    return (FoodMenus) super.clone();
  }

}
